/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafplugin;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.UIManager;
import org.pushingpixels.lafplugin.XMLElement;

public class PluginManager {
    private String mainTag;
    private String pluginTag;
    private String xmlName;
    private Set plugins;

    public PluginManager(String xmlName, String mainTag, String pluginTag) {
        this.xmlName = xmlName;
        this.mainTag = mainTag;
        this.pluginTag = pluginTag;
        this.plugins = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getPluginsClass(URL pluginUrl) {
        ArrayList<String> arrayList;
        ArrayList<String> result = new ArrayList<String>();
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            XMLElement xml = new XMLElement();
            is = pluginUrl.openStream();
            isr = new InputStreamReader(is);
            xml.parseFromReader(isr);
            if (!this.mainTag.equals(xml.getName())) {
                List<String> list = null;
                return list;
            }
            Enumeration children = xml.enumerateChildren();
            while (children.hasMoreElements()) {
                XMLElement child = (XMLElement)children.nextElement();
                if (!this.pluginTag.equals(child.getName()) || child.countChildren() != 0) continue;
                result.add(child.getContent());
            }
            arrayList = result;
        }
        catch (Exception exc) {
            ArrayList<String> arrayList2 = result;
            return arrayList2;
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    protected List<Object> getPlugins(URL pluginUrl) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        ClassLoader classLoader = (ClassLoader)UIManager.get("ClassLoader");
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        for (String pluginClassName : this.getPluginsClass(pluginUrl)) {
            Object pluginInstance;
            Class<?> pluginClass = Class.forName(pluginClassName, true, classLoader);
            if (pluginClass == null || (pluginInstance = pluginClass.newInstance()) == null) continue;
            result.add(pluginInstance);
        }
        return result;
    }

    public Set getAvailablePlugins() {
        return this.getAvailablePlugins(false);
    }

    public Set getAvailablePlugins(boolean toReload) {
        if (!toReload && this.plugins != null) {
            return this.plugins;
        }
        this.plugins = new HashSet();
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        try {
            Enumeration<URL> urls = cl.getResources(this.xmlName);
            while (urls.hasMoreElements()) {
                URL pluginUrl = urls.nextElement();
                List<Object> pluginsInstance = this.getPlugins(pluginUrl);
                this.plugins.addAll(pluginsInstance);
            }
        }
        catch (Exception exc) {
            return null;
        }
        return this.plugins;
    }
}

