/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum Compression implements Enumeration
{
    ZLIB("zlib"),
    BZIP2("bzip2"),
    NONE("none");

    private final String value;

    private Compression(String value) {
        this.value = value;
    }

    public static Compression fromString(String value) throws EnumerationException {
        if ("zlib".equals(value)) {
            return ZLIB;
        }
        if ("bzip2".equals(value)) {
            return BZIP2;
        }
        if ("none".equals(value)) {
            return NONE;
        }
        String s2 = String.format("'%s' not a supported value of '%s'", value, Compression.class);
        throw new EnumerationException(s2);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

