/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.ImagePlus;
import ij.WindowManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.common.StatusEvent;
import loci.common.StatusListener;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.Modulo;
import loci.formats.gui.XMLWindow;
import loci.formats.services.OMEXMLService;
import loci.plugins.BF;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterMetadata;
import loci.plugins.in.ImporterOptions;
import loci.plugins.util.DataBrowser;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.ROIHandler;
import loci.plugins.util.SearchableWindow;
import loci.plugins.util.WindowTools;
import org.xml.sax.SAXException;

public class DisplayHandler
implements StatusListener {
    protected ImportProcess process;
    protected ImporterOptions options;
    protected XMLWindow xmlWindow;

    public DisplayHandler(ImportProcess process) {
        this.process = process;
        this.options = process.getOptions();
    }

    public SearchableWindow displayOriginalMetadata() {
        if (!this.options.isShowMetadata()) {
            return null;
        }
        String name = this.process.getIdName();
        ImporterMetadata meta = this.process.getOriginalMetadata();
        String metaString = meta.getMetadataString("\t");
        SearchableWindow metaWindow = new SearchableWindow("Original Metadata - " + name, "Key\tValue", metaString, 400, 400);
        metaWindow.setVisible(true);
        return metaWindow;
    }

    public XMLWindow displayOMEXML() throws FormatException, IOException {
        if (!this.options.isShowOMEXML()) {
            return null;
        }
        XMLWindow metaWindow = null;
        metaWindow = new XMLWindow("OME Metadata - " + this.process.getIdName());
        Exception exc = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            metaWindow.setXML(service.getOMEXML(this.process.getOMEMetadata()));
            WindowTools.placeWindow(metaWindow);
            metaWindow.setVisible(true);
        }
        catch (DependencyException e) {
            exc = e;
        }
        catch (ServiceException e) {
            exc = e;
        }
        catch (ParserConfigurationException e) {
            exc = e;
        }
        catch (SAXException e) {
            exc = e;
        }
        if (exc != null) {
            throw new FormatException(exc);
        }
        this.xmlWindow = metaWindow;
        return metaWindow;
    }

    public void displayImages(ImagePlus[] imps) {
        if (imps != null) {
            for (ImagePlus imp : imps) {
                this.displayImage(imp);
            }
        }
    }

    public void displayImage(ImagePlus imp) {
        if (this.options.isViewNone()) {
            return;
        }
        if (this.options.isViewStandard()) {
            this.displayNormal(imp);
        } else if (this.options.isViewHyperstack()) {
            this.displayNormal(imp);
        } else if (this.options.isViewBrowser()) {
            this.displayDataBrowser(imp);
        } else if (this.options.isViewImage5D()) {
            this.displayImage5D(imp);
        } else if (this.options.isViewView5D()) {
            this.displayView5D(imp);
        } else {
            throw new IllegalStateException("Unknown display mode");
        }
    }

    public void displayNormal(ImagePlus imp) {
        imp.show();
    }

    public void displayDataBrowser(ImagePlus imp) {
        String[] subCTypes;
        int[] subC;
        ImageProcessorReader r = this.process.getReader();
        Modulo moduloC = r.getModuloC();
        if (moduloC.length() > 1) {
            subC = new int[]{r.getSizeC() / moduloC.length(), moduloC.length()};
            subCTypes = new String[]{moduloC.parentType, moduloC.type};
        } else {
            subC = new int[]{r.getSizeC()};
            subCTypes = new String[]{"Channel"};
        }
        new DataBrowser(imp, null, subCTypes, subC, this.xmlWindow);
    }

    public void displayImage5D(ImagePlus imp) {
        WindowManager.setTempCurrentImage((ImagePlus)imp);
        ImageProcessorReader r = this.process.getReader();
        ReflectedUniverse ru = new ReflectedUniverse();
        try {
            ru.exec("import i5d.Image5D");
            ru.setVar("title", imp.getTitle());
            ru.setVar("stack", imp.getStack());
            ru.setVar("sizeC", imp.getNChannels());
            ru.setVar("sizeZ", imp.getNSlices());
            ru.setVar("sizeT", imp.getNFrames());
            ru.exec("i5d = new Image5D(title, stack, sizeC, sizeZ, sizeT)");
            ru.setVar("cal", imp.getCalibration());
            ru.setVar("fi", imp.getOriginalFileInfo());
            ru.exec("i5d.setCalibration(cal)");
            ru.exec("i5d.setFileInfo(fi)");
            ru.exec("i5d.show()");
        }
        catch (ReflectException exc) {
            WindowTools.reportException(exc, this.options.isQuiet(), "Sorry, there was a problem interfacing with Image5D");
        }
    }

    public void displayView5D(ImagePlus imp) {
        WindowManager.setTempCurrentImage((ImagePlus)imp);
        Exception exc = null;
        try {
            Class<?> c = Class.forName("view5d.View5D_");
            Constructor<?> con = c.getConstructor(new Class[0]);
            con.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            exc = e;
        }
        catch (SecurityException e) {
            exc = e;
        }
        catch (NoSuchMethodException e) {
            exc = e;
        }
        catch (IllegalArgumentException e) {
            exc = e;
        }
        catch (InstantiationException e) {
            exc = e;
        }
        catch (IllegalAccessException e) {
            exc = e;
        }
        catch (InvocationTargetException e) {
            exc = e;
        }
        if (exc != null) {
            WindowTools.reportException(exc, this.options.isQuiet(), "Sorry, there was a problem interfacing with View5D");
        }
    }

    public void displayROIs(ImagePlus[] imps) {
        if (!this.options.showROIs()) {
            return;
        }
        ROIHandler.openROIs(this.process.getOMEMetadata(), imps, this.options.isOMERO(), this.options.getROIsMode());
    }

    @Override
    public void statusUpdated(StatusEvent e) {
        String msg = e.getStatusMessage();
        if (msg != null) {
            BF.status(this.options.isQuiet(), msg);
        }
        int value = e.getProgressValue();
        int max = e.getProgressMaximum();
        if (value >= 0 && max >= 0) {
            BF.progress(this.options.isQuiet(), value, max);
        }
    }
}

