/*
 * Decompiled with CFR 0.152.
 */
package icy.system.audit;

import icy.file.FileUtil;
import icy.gui.frame.progress.CancelableProgressFrame;
import icy.gui.main.MainFrame;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.abstract_.Plugin;
import icy.preferences.ApplicationPreferences;
import icy.preferences.GeneralPreferences;
import icy.preferences.XMLPreferences;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.audit.AuditStorage;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Audit {
    static final String URL_REGISTER = "http://icy.bioimageanalysis.org/register/registerClient.php?";
    static final String URL_LINK_USER = "http://icy.bioimageanalysis.org/register/linkUser.php?";
    static final String URL_GET_USER_INFO = "http://icy.bioimageanalysis.org/register/getLinkedUserInfo.php?";
    static final String URL_AUDIT_VERSION = "http://icy.bioimageanalysis.org/register/auditVersion.php?";
    static final String URL_AUDIT_PLUGIN = "http://icy.bioimageanalysis.org/register/auditPlugin.php?";
    static final String ID_REQUEST = "requestId";
    static final String ID_ACTION = "action";
    static final String ID_ICY_ID = "IcyId";
    static final String ID_CLIENT_ARCH = "clientArch";
    static final String ID_CLIENT_ID = "clientId";
    static final String ID_CLIENT_VERSION = "clientVersion";
    static final String ID_CLIENT_CPUNUMBER = "clientCpuNumber";
    static final String ID_CLIENT_TOTAL_MEMORY = "clientTotalMemory";
    static final String ID_CLIENT_MAXJAVA_MEMORY = "clientMaxJavaMemory";
    static final String ID_JAVA_NAME = "javaName";
    static final String ID_JAVA_VERSION = "javaVersion";
    static final String ID_JAVA_ARCH = "javaArch";
    static final String ID_LAST_UPLOAD_DATE = "lastUploadDate";
    static final String XMLID_CLIENT_ID_REQUESTED = "client_id_requested";
    static final String XMLID_USER_LOGIN = "user_login";
    static final String XMLID_USER_NAME = "user_name";
    static XMLPreferences prefs;
    static AuditStorage storage;
    private static boolean initialized;
    private static boolean auditDone;

    static {
        initialized = false;
    }

    public static synchronized void prepare() {
        if (initialized) {
            return;
        }
        prefs = ApplicationPreferences.getPreferences();
        if (Audit.needToResetId()) {
            Audit.unlinkUser();
            ApplicationPreferences.setId(-1);
        }
        Audit.storeInfos();
        storage = new AuditStorage();
        final int id = ApplicationPreferences.getId();
        if (id != -1) {
            long currentTime = System.currentTimeMillis();
            long dayInterval = 86400000L;
            if (currentTime > prefs.getLong(ID_LAST_UPLOAD_DATE, 0L) + 86400000L) {
                prefs.putLong(ID_LAST_UPLOAD_DATE, System.currentTimeMillis());
                ThreadUtil.bgRun(new Runnable(){

                    @Override
                    public void run() {
                        storage.upload(id);
                    }
                });
            }
        }
        initialized = true;
        auditDone = false;
    }

    public static void onConnect() {
        Audit.prepare();
        if (!auditDone) {
            Audit.processIdAudit();
        }
        Audit.updateUserLink();
        MainFrame frame = Icy.getMainInterface().getMainFrame();
        if (frame != null) {
            frame.refreshTitle();
        }
    }

    public static void save() {
        if (initialized) {
            storage.save();
        }
    }

    public static void pluginLaunched(Plugin plugin) {
        if (!initialized) {
            return;
        }
        storage.pluginLaunched(plugin);
    }

    public static void pluginInstanced(Plugin plugin) {
        if (!initialized) {
            return;
        }
        storage.pluginInstanced(plugin);
    }

    private static boolean needToResetId() {
        if (!StringUtil.equals(ApplicationPreferences.getOs(), SystemUtil.getOSArchIdString())) {
            return true;
        }
        int cpu = prefs.getInt(ID_CLIENT_CPUNUMBER, 0);
        long mem = prefs.getLong(ID_CLIENT_TOTAL_MEMORY, 0L);
        String appFolder = ApplicationPreferences.getAppFolder();
        if (cpu != 0 && cpu != SystemUtil.getNumberOfCPUs()) {
            return true;
        }
        if (mem != 0L && mem != SystemUtil.getTotalMemory()) {
            return true;
        }
        return !StringUtil.isEmpty(appFolder) && !StringUtil.equals(appFolder, FileUtil.APPLICATION_DIRECTORY);
    }

    private static void storeInfos() {
        ApplicationPreferences.setOs(SystemUtil.getOSArchIdString());
        prefs.putInt(ID_CLIENT_CPUNUMBER, SystemUtil.getNumberOfCPUs());
        prefs.putLong(ID_CLIENT_TOTAL_MEMORY, SystemUtil.getTotalMemory());
        ApplicationPreferences.setAppFolder(FileUtil.APPLICATION_DIRECTORY);
    }

    private static void processIdAudit() {
        HashMap<String, String> values = new HashMap<String, String>();
        int id = ApplicationPreferences.getId();
        values.put(ID_CLIENT_ARCH, SystemUtil.getOSArchIdString());
        values.put(ID_CLIENT_VERSION, Icy.version.toString());
        if (id == -1) {
            Element root;
            int newId;
            values.put(ID_REQUEST, "1");
            Document doc = XMLUtil.loadDocument(URL_REGISTER + NetworkUtil.getContentString(values));
            if (doc != null && (newId = XMLUtil.getElementIntValue(root = XMLUtil.getRootElement(doc), XMLID_CLIENT_ID_REQUESTED, -1)) != -1) {
                ApplicationPreferences.setId(newId);
            }
        } else {
            values.put(ID_CLIENT_ID, Integer.toString(id));
            values.put(ID_CLIENT_CPUNUMBER, Integer.toString(SystemUtil.getNumberOfCPUs()));
            values.put(ID_CLIENT_TOTAL_MEMORY, Long.toString(SystemUtil.getTotalMemory() / 0xA00000L));
            values.put(ID_CLIENT_MAXJAVA_MEMORY, Long.toString(SystemUtil.getJavaMaxMemory() / 0xA00000L));
            values.put(ID_JAVA_NAME, SystemUtil.getJavaName());
            values.put(ID_JAVA_VERSION, SystemUtil.getJavaVersion());
            values.put(ID_JAVA_ARCH, Integer.toString(SystemUtil.getJavaArchDataModel()));
            try {
                NetworkUtil.postData(URL_AUDIT_VERSION, values);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        auditDone = true;
    }

    private static Map<String, String> getIdParam() {
        int id = ApplicationPreferences.getId();
        if (id != -1) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(ID_ICY_ID, Integer.toString(id));
            return values;
        }
        return null;
    }

    public static void updateUserLink() {
        Document doc;
        Map<String, String> params = Audit.getIdParam();
        if (params != null && (doc = XMLUtil.loadDocument(URL_GET_USER_INFO + NetworkUtil.getContentString(params))) != null) {
            Element root = XMLUtil.getRootElement(doc);
            GeneralPreferences.setUserLogin(XMLUtil.getElementValue(root, XMLID_USER_LOGIN, ""));
            GeneralPreferences.setUserName(XMLUtil.getElementValue(root, XMLID_USER_NAME, ""));
        }
    }

    public static boolean isUserLinked() {
        return !StringUtil.isEmpty(GeneralPreferences.getUserLogin());
    }

    public static void linkUser() {
        int id = ApplicationPreferences.getId();
        if (id != -1) {
            NetworkUtil.openBrowser("http://icy.bioimageanalysis.org/register/linkUser.php?IcyId=" + id + "&" + ID_ACTION + "=link");
            if (!Icy.getMainInterface().isHeadLess()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CancelableProgressFrame waitFrame = new CancelableProgressFrame("Waiting for user to link account...");
                        while (!Thread.interrupted() && !waitFrame.isCancelRequested()) {
                            try {
                                Thread.sleep(1000L);
                                Audit.updateUserLink();
                                if (!Audit.isUserLinked()) continue;
                                waitFrame.cancel();
                                MainFrame frame = Icy.getMainInterface().getMainFrame();
                                if (frame == null) continue;
                                frame.refreshTitle();
                            }
                            catch (InterruptedException e) {
                                waitFrame.cancel();
                            }
                        }
                        waitFrame.close();
                    }
                }).start();
            }
        }
    }

    public static void unlinkUser() {
        final Map<String, String> params = Audit.getIdParam();
        if (params != null) {
            ThreadUtil.bgRun(new Runnable(){

                @Override
                public void run() {
                    params.put(Audit.ID_ACTION, "unlink");
                    try {
                        NetworkUtil.postData(Audit.URL_LINK_USER, params);
                    }
                    catch (IOException e) {
                        System.err.print("Warning: cannot unlink online user infos.");
                        IcyExceptionHandler.showErrorMessage(e, false, false);
                    }
                }
            });
        }
        GeneralPreferences.setUserLogin("");
        GeneralPreferences.setUserName("");
    }
}

