/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MissingLibraryException;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.services.JHDFService;
import loci.formats.services.JHDFServiceImpl;
import ome.xml.model.enums.DimensionOrder;

public class CellH5Writer
extends FormatWriter {
    private transient JHDFService jhdf;
    private long bpp;
    private String outputPath;

    public CellH5Writer() {
        this("CellH5 File Format", new String[]{"ch5"});
    }

    public CellH5Writer(String format, String[] exts) {
        super(format, exts);
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        super.setId(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.jhdf = factory.getInstance(JHDFService.class);
            this.jhdf.setFileForWrite(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(JHDFServiceImpl.NO_JHDF_MSG, e);
        }
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        int sizeX = (Integer)retrieve.getPixelsSizeX(0).getValue();
        int sizeY = (Integer)retrieve.getPixelsSizeY(0).getValue();
        int sizeZ = (Integer)retrieve.getPixelsSizeZ(0).getValue();
        int sizeC = (Integer)retrieve.getPixelsSizeC(0).getValue();
        int sizeT = (Integer)retrieve.getPixelsSizeT(0).getValue();
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(0).toString());
        this.bpp = FormatTools.getBytesPerPixel(type);
        LOGGER.info("CellH5Writer: Found image with dimensions XYZCT {}x{}x{}x{}x{}, and bits per pixel {}", sizeX, sizeY, sizeZ, sizeC, sizeT, this.bpp);
        String plate = "PLATE_00";
        String well = "WELL_00";
        int site = 1;
        if (retrieve.getPlateCount() > 0) {
            plate = retrieve.getPlateName(0);
            well = retrieve.getWellExternalIdentifier(0, 0);
            site = (Integer)retrieve.getWellSampleIndex(0, 0, 0).getValue();
            LOGGER.info("CellH5Writer: Found plate information Plate / Well / Site {} / {} / {}", plate, well, site);
        } else {
            LOGGER.info("CellH5Writer: No plate information found. Using default values...");
        }
        this.jhdf.createGroup("/definition/object/");
        this.jhdf.createGroup("/definition/feature/");
        this.jhdf.createGroup("/definition/image/");
        this.outputPath = String.format("/sample/0/plate/%s/experiment/%s/position/%d/image/channel", plate, well, site);
        this.jhdf.initIntArray(this.outputPath, new long[]{sizeC, sizeT, sizeZ, sizeY, sizeX}, this.bpp);
    }

    @Override
    public void saveBytes(int no, byte[] buf) throws IOException, FormatException {
        int t;
        int z;
        int c;
        LOGGER.info("CellH5Writer: Save image to HDF5 path: " + this.outputPath);
        MetadataRetrieve r = this.getMetadataRetrieve();
        int sizeX = (Integer)r.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)r.getPixelsSizeY(this.series).getValue();
        int sizeC = (Integer)r.getPixelsSizeC(this.series).getValue();
        int sizeT = (Integer)r.getPixelsSizeT(this.series).getValue();
        int sizeZ = (Integer)r.getPixelsSizeZ(this.series).getValue();
        DimensionOrder dimo = r.getPixelsDimensionOrder(0);
        if (dimo.equals(DimensionOrder.XYCZT)) {
            c = no % sizeC;
            z = (no - c) / sizeC % sizeZ;
            t = (no - c) / sizeC / sizeZ;
        } else if (dimo.equals(DimensionOrder.XYCTZ)) {
            c = no % sizeC;
            t = (no - c) / sizeC % sizeT;
            z = (no - c) / sizeC / sizeT;
        } else if (dimo.equals(DimensionOrder.XYZTC)) {
            z = no % sizeZ;
            t = (no - z) / sizeZ % sizeT;
            c = (no - z) / sizeZ / sizeT;
        } else {
            throw new FormatException("CellH5Writer: Dimension order not understood: " + dimo.getValue());
        }
        LOGGER.info("CellH5Writer.saveBytes(): Current c, t, z == {} {} {}", c, t, z);
        LOGGER.info("CellH5Writer.saveBytes(): bpp {} byte buffer len {}", (Object)this.bpp, (Object)buf.length);
        if (this.bpp == 1L) {
            MDByteArray image = new MDByteArray(new int[]{1, 1, 1, sizeY, sizeX});
            for (int x_i = 0; x_i < sizeX; ++x_i) {
                int y_i = 0;
                while (y_i < sizeY) {
                    byte value = buf[y_i * sizeX + x_i];
                    image.set(value, 0, 0, 0, y_i++, x_i);
                }
            }
            this.jhdf.writeArraySlice(this.outputPath, image, new long[]{c, t, z, 0L, 0L});
        } else if (this.bpp == 2L) {
            ByteBuffer bb = ByteBuffer.wrap(buf);
            ShortBuffer sb = bb.asShortBuffer();
            MDShortArray image = new MDShortArray(new int[]{1, 1, 1, sizeY, sizeX});
            for (int x_i = 0; x_i < sizeX; ++x_i) {
                int y_i = 0;
                while (y_i < sizeY) {
                    short value = sb.get(y_i * sizeX + x_i);
                    image.set(value, 0, 0, 0, y_i++, x_i);
                }
            }
            this.jhdf.writeArraySlice(this.outputPath, image, new long[]{c, t, z, 0L, 0L});
        } else if (this.bpp == 4L) {
            ByteBuffer bb = ByteBuffer.wrap(buf);
            IntBuffer ib = bb.asIntBuffer();
            MDIntArray image = new MDIntArray(new int[]{1, 1, 1, sizeY, sizeX});
            for (int x_i = 0; x_i < sizeX; ++x_i) {
                int y_i = 0;
                while (y_i < sizeY) {
                    int value = ib.get(y_i * sizeX + x_i);
                    image.set(value, 0, 0, 0, y_i++, x_i);
                }
            }
            this.jhdf.writeArraySlice(this.outputPath, image, new long[]{c, t, z, 0L, 0L});
        } else {
            throw new FormatException("CellH5Writer: Pixel type not supported");
        }
    }

    @Override
    public void close() throws IOException {
        this.jhdf.close();
        super.close();
    }

    @Override
    public int getPlaneCount() {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        int c = this.getSamplesPerPixel();
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString());
        int bytesPerPixel = FormatTools.getBytesPerPixel(type);
        if (bytesPerPixel > 1 && c != 1 && c != 3) {
            return super.getPlaneCount() * c;
        }
        return super.getPlaneCount();
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        this.saveBytes(no, buf);
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return new int[]{1, 3, 4};
    }
}

