/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.Earth;

public class PolyconicProjection
extends AbstractCoordTransBuilder {
    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        ucar.unidata.geoloc.projection.proj4.PolyconicProjection proj;
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_central_meridian", Double.NaN);
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin", Double.NaN);
        double semi_major_axis = this.readAttributeDouble(ctv, "semi_major_axis", Double.NaN);
        double semi_minor_axis = this.readAttributeDouble(ctv, "semi_minor_axis", Double.NaN);
        double inverse_flattening = this.readAttributeDouble(ctv, "inverse_flattening", 0.0);
        if (!(Double.isNaN(semi_major_axis) || Double.isNaN(semi_minor_axis) && inverse_flattening == 0.0)) {
            Earth earth = new Earth(semi_major_axis, semi_minor_axis, inverse_flattening);
            proj = new ucar.unidata.geoloc.projection.proj4.PolyconicProjection(lat0, lon0, earth);
        } else {
            proj = new ucar.unidata.geoloc.projection.proj4.PolyconicProjection(lat0, lon0);
        }
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }

    @Override
    public String getTransformName() {
        return "polyconic";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }
}

