/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.core;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.util.GuiUtil;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.util.ReflectionUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.api.ScriptInterface;
import org.micromanager.api.SequenceSettings;
import org.micromanager.dialogs.AcqControlDlg;
import org.micromanager.utils.MDUtils;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.event.AcquisitionListener;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;
import plugins.tprovoost.Microscopy.MicroManager.tools.FrameUtils;

public class AcquisitionHandler
implements AcquisitionListener {
    AcqControlDlg advAcqDialog;
    IcyFrame advAcqFrame;
    JLabel progressLabel;
    JProgressBar progressBar;
    JButton startButton;
    int progressIndex;
    boolean liveModeWasRunning;

    public AcquisitionHandler(MMMainFrame mainFrame) {
        this.initDialog(mainFrame);
        MicroManager.addAcquisitionListener(this);
    }

    private void initDialog(MMMainFrame mainFrame) {
        JButton closeButton;
        MMStudio mmstudio = mainFrame.getMMStudio();
        try {
            this.advAcqDialog = (AcqControlDlg)ReflectionUtil.getFieldObject((Object)mmstudio, (String)"acqControlWin_", (boolean)true);
        }
        catch (Exception ex) {
            System.err.println("Warning: cannot retrieve AcqControlDlg from Micro-Manager.");
        }
        if (this.advAcqDialog == null) {
            this.advAcqDialog = new AcqControlDlg((AcquisitionEngine)mmstudio.getAcquisitionEngine(), mainFrame.getMainPreferences(), (ScriptInterface)mmstudio, mainFrame.getOptions());
        }
        WindowListener[] winListeners = this.advAcqDialog.getWindowListeners();
        for (int i = 1; i < winListeners.length; ++i) {
            this.advAcqDialog.removeWindowListener(winListeners[i]);
        }
        this.advAcqFrame = GuiUtil.createIcyFrameFromWindow((Window)this.advAcqDialog);
        this.advAcqFrame.setDefaultCloseOperation(1);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSize(450, 30);
        this.progressLabel = new JLabel("No acquisition started : ");
        JPanel southPanel = new JPanel();
        southPanel.add(this.progressLabel);
        southPanel.add(this.progressBar);
        this.advAcqFrame.add((Component)southPanel, (Object)"South");
        this.advAcqFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

            public void icyFrameClosing(IcyFrameEvent e) {
                try {
                    if (MicroManager.isInitialized()) {
                        MicroManager.stopAcquisition();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.startButton = FrameUtils.findButtonComponents(this.advAcqDialog.getContentPane(), "Acquire!");
        if (this.startButton != null) {
            ActionListener[] listeners;
            for (ActionListener l : listeners = this.startButton.getActionListeners()) {
                this.startButton.removeActionListener(l);
            }
            this.startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AcquisitionHandler.this.advancedAcquisitionStartPressed();
                    for (ActionListener l : listeners) {
                        l.actionPerformed(arg0);
                    }
                }
            });
        }
        if ((closeButton = FrameUtils.findButtonComponents(this.advAcqDialog.getContentPane(), "Close")) != null) {
            for (ActionListener l : closeButton.getActionListeners()) {
                closeButton.removeActionListener(l);
            }
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        if (MicroManager.isInitialized()) {
                            MicroManager.stopAcquisition();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    AcquisitionHandler.this.advAcqFrame.setVisible(false);
                }
            });
        }
        this.advAcqFrame.getIcyInternalFrame().setSize(524, 716);
        this.advAcqFrame.getIcyExternalFrame().setSize(524, 716);
        this.advAcqFrame.addToDesktopPane();
    }

    public void shutdown() {
        MicroManager.removeAcquisitionListener(this);
    }

    void advancedAcquisitionStartPressed() {
        try {
            this.liveModeWasRunning = MicroManager.isLiveRunning();
            if (this.liveModeWasRunning) {
                MicroManager.stopLiveMode();
            }
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
        }
    }

    public AcqControlDlg getMMAcquisitionDialog() {
        return this.advAcqDialog;
    }

    public IcyFrame getAcquisitionFrame() {
        return this.advAcqFrame;
    }

    @Override
    public void acquisitionStarted(SequenceSettings settings, JSONObject metadata) {
        try {
            final int numImage = MDUtils.getNumPositions((JSONObject)metadata) * MDUtils.getNumFrames((JSONObject)metadata) * MDUtils.getNumSlices((JSONObject)metadata) * MDUtils.getNumChannels((JSONObject)metadata);
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AcquisitionHandler.this.progressIndex = 0;
                    AcquisitionHandler.this.progressLabel.setText("Acquisition running : ");
                    AcquisitionHandler.this.progressBar.setMinimum(0);
                    AcquisitionHandler.this.progressBar.setMaximum(numImage);
                    if (AcquisitionHandler.this.startButton != null) {
                        AcquisitionHandler.this.startButton.setEnabled(false);
                    }
                }
            });
        }
        catch (JSONException e) {
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
        }
    }

    @Override
    public void acqImgReveived(TaggedImage newImg) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AcquisitionHandler.this.progressBar.setValue(AcquisitionHandler.this.progressIndex++);
            }
        });
    }

    @Override
    public void acquisitionFinished(List<Sequence> result) {
        if (this.liveModeWasRunning) {
            try {
                MicroManager.startLiveMode();
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
            }
            this.liveModeWasRunning = false;
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AcquisitionHandler.this.progressBar.setValue(0);
                AcquisitionHandler.this.progressLabel.setText("Acquisition completed : ");
                if (AcquisitionHandler.this.startButton != null) {
                    AcquisitionHandler.this.startButton.setEnabled(true);
                }
            }
        });
    }
}

