/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.gui;

import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolEventType;
import icy.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.nchenouard.particletracking.DetectionChooser;
import plugins.nchenouard.particletracking.MHTparameterSet;
import plugins.nchenouard.spot.DetectionResult;

public class DetectionInputPanel
extends JPanel {
    private static final long serialVersionUID = 2186083246350778294L;
    final DefaultMutableTreeNode node = new DefaultMutableTreeNode("Detection source");
    public final DetectionChooser detectionChooser = new DetectionChooser();
    public final JSpinner numberFalseDetectionsSpinner = new JSpinner();
    public final JSpinner rateDetectionSpinner = new JSpinner();

    public DetectionInputPanel() {
        this.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        pane.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel detectionChooserPanel = new JPanel();
        detectionChooserPanel.setLayout(new GridLayout(2, 1, 0, 0));
        detectionChooserPanel.add(new JLabel("Select the input for detections in the Swimming Pool"));
        detectionChooserPanel.add(this.detectionChooser);
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)detectionChooserPanel, c);
        this.numberFalseDetectionsSpinner.setModel(new SpinnerNumberModel(new Integer(20), new Integer(0), null, new Integer(1)));
        JPanel spinnerPanel = new JPanel();
        spinnerPanel.setLayout(new GridLayout(2, 1));
        spinnerPanel.add(new JLabel("Expected number of false detections per frame"));
        spinnerPanel.add(this.numberFalseDetectionsSpinner);
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)spinnerPanel, c);
        this.rateDetectionSpinner.setModel(new SpinnerNumberModel(new Double(0.9), new Double(0.01), new Double(1.0), new Double(0.01)));
        JPanel spinnerDetectionPanel = new JPanel();
        spinnerDetectionPanel.setLayout(new GridLayout(2, 1));
        spinnerDetectionPanel.add(new JLabel("Probability of detection for each particle"));
        spinnerDetectionPanel.add(this.rateDetectionSpinner);
        c.gridx = 0;
        c.gridy = 2;
        pane.add((Component)spinnerDetectionPanel, c);
        this.detectionChooser.swimmingPoolChangeEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_REMOVED, new SwimmingObject(null)));
        this.add((Component)pane, "North");
    }

    public int getNumberOfFalseDetections() {
        return ((SpinnerNumberModel)this.numberFalseDetectionsSpinner.getModel()).getNumber().intValue();
    }

    public double getDetectionRate() {
        return ((SpinnerNumberModel)this.rateDetectionSpinner.getModel()).getNumber().doubleValue();
    }

    public void saveToXML(Node node) {
        Element nodeDetection = XMLUtil.setElement((Node)node, (String)"detectionInput");
        if (nodeDetection != null) {
            DetectionResult dr = this.detectionChooser.getSelectedDetectionResult();
            if (dr != null) {
                XMLUtil.setAttributeValue((Element)nodeDetection, (String)"detectionSource", (String)dr.toString());
            } else {
                XMLUtil.setAttributeValue((Element)nodeDetection, (String)"detectionSource", (String)"noSource");
            }
            XMLUtil.setAttributeIntValue((Element)nodeDetection, (String)"numberFalseDetection", (int)this.getNumberOfFalseDetections());
            XMLUtil.setAttributeDoubleValue((Element)nodeDetection, (String)"detectionRate", (double)this.getDetectionRate());
        }
    }

    public void loadFromFromXML(Node node) {
        Element nodeDetection = XMLUtil.getElement((Node)node, (String)"detectionInput");
        if (nodeDetection != null) {
            ((SpinnerNumberModel)this.numberFalseDetectionsSpinner.getModel()).setValue(XMLUtil.getAttributeIntValue((Element)nodeDetection, (String)"numberFalseDetection", (int)this.getNumberOfFalseDetections()));
            ((SpinnerNumberModel)this.rateDetectionSpinner.getModel()).setValue(XMLUtil.getAttributeDoubleValue((Element)nodeDetection, (String)"detectionRate", (double)this.getDetectionRate()));
        }
    }

    public void fillParameterSet(MHTparameterSet parameterSet) {
        parameterSet.numberOfFalseDetections = this.getNumberOfFalseDetections();
        parameterSet.detectionRate = this.getDetectionRate();
        parameterSet.detectionResults = this.detectionChooser.getSelectedDetectionResult();
    }

    public void setParameters(MHTparameterSet parameterSet) {
        this.detectionChooser.setSelectedItem(parameterSet.detectionResults);
        ((SpinnerNumberModel)this.numberFalseDetectionsSpinner.getModel()).setValue(parameterSet.numberOfFalseDetections);
        ((SpinnerNumberModel)this.rateDetectionSpinner.getModel()).setValue(parameterSet.detectionRate);
    }
}

