/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.viewer;

import icy.gui.component.IcySlider;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TNavigationPanel
extends JPanel {
    private static final long serialVersionUID = 9123780562399386045L;
    private static final int DEFAULT_FRAME_RATE = 15;
    final JSlider slider;
    final JLabel leftLabel;
    final JLabel rightLabel;
    final IcyToggleButton play;
    final IcyToggleButton loop;
    final JSpinner frameRate;
    final Timer timer;
    private List<ActionListener> loopingStateChangeListeners = Collections.synchronizedList(new ArrayList());

    public TNavigationPanel() {
        super(true);
        this.slider = new IcySlider(0);
        this.slider.setFocusable(false);
        this.slider.setMaximum(0);
        this.slider.setMinimum(0);
        this.slider.setToolTipText("Move cursor or use left/right key to navigate in T dimension");
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TNavigationPanel.this.rightLabel.setText(Integer.toString(TNavigationPanel.this.slider.getMaximum()));
                TNavigationPanel.this.leftLabel.setText(Integer.toString(TNavigationPanel.this.slider.getValue()));
                TNavigationPanel.this.validate();
            }
        });
        ComponentUtil.setFixedHeight((Component)this.slider, (int)22);
        this.timer = new Timer(66, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TNavigationPanel.this.slider.getValueIsAdjusting()) {
                    int oldT = TNavigationPanel.this.getTPosition();
                    TNavigationPanel.this.incTPosition();
                    if (oldT == TNavigationPanel.this.getTPosition()) {
                        if (TNavigationPanel.this.isRepeat()) {
                            TNavigationPanel.this.setTPosition(0);
                        } else {
                            TNavigationPanel.this.stopPlay();
                            TNavigationPanel.this.setTPosition(0);
                        }
                    }
                }
            }
        });
        this.play = new IcyToggleButton(new IcyIcon(ResourceUtil.ICON_PLAY));
        this.play.setFlat(true);
        this.play.setToolTipText("play");
        this.play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TNavigationPanel.this.isPlaying()) {
                    TNavigationPanel.this.stopPlay();
                } else {
                    TNavigationPanel.this.startPlay();
                }
            }
        });
        this.loop = new IcyToggleButton(new IcyIcon(ResourceUtil.ICON_ARROW_RIGHT, 16));
        this.loop.setFlat(true);
        this.loop.setToolTipText("Enable loop playback");
        this.loop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TNavigationPanel.this.setRepeat(!TNavigationPanel.this.isRepeat());
            }
        });
        this.setRepeat(true);
        this.frameRate = new JSpinner(new SpinnerNumberModel(15, 1, 60, 1));
        this.frameRate.setFocusable(false);
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.frameRate.getEditor()).getTextField();
        tf.setEditable(false);
        tf.setFocusable(false);
        this.frameRate.setToolTipText("Change playback frame rate");
        this.frameRate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int f = (Integer)TNavigationPanel.this.frameRate.getValue();
                TNavigationPanel.this.setTimerDelay(1000 / f);
            }
        });
        ComponentUtil.setFixedSize((Component)this.frameRate, (Dimension)new Dimension(50, 22));
        this.leftLabel = new JLabel("0");
        this.leftLabel.setToolTipText("T position");
        this.rightLabel = new JLabel("0");
        this.rightLabel.setToolTipText("T sequence size");
        final JPanel leftPanel = GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalStrut(8), GuiUtil.createBoldLabel((String)"T"), Box.createHorizontalStrut(10), this.leftLabel});
        this.rightLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ComponentUtil.setFixedWidth((Component)TNavigationPanel.this.leftLabel, (int)TNavigationPanel.this.rightLabel.getWidth());
                leftPanel.revalidate();
            }
        });
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 2));
        JLabel frameRateLabel = new JLabel("FPS");
        frameRateLabel.setToolTipText("Frames Per Second");
        rightPanel.add(this.rightLabel);
        rightPanel.add(Box.createHorizontalStrut(12));
        rightPanel.add((Component)this.play);
        rightPanel.add((Component)this.loop);
        rightPanel.add(Box.createHorizontalStrut(8));
        rightPanel.add(this.frameRate);
        rightPanel.add(Box.createHorizontalStrut(4));
        rightPanel.add(frameRateLabel);
        rightPanel.add(Box.createHorizontalStrut(4));
        this.setBorder(BorderFactory.createTitledBorder("").getBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)leftPanel, "West");
        this.add((Component)this.slider, "Center");
        this.add((Component)rightPanel, "East");
        this.validate();
    }

    protected void incTPosition() {
        this.setTPosition(this.getTPosition() + 1);
    }

    protected void decTPosition() {
        this.setTPosition(Math.max(0, this.getTPosition() - 1));
    }

    protected void setTimerDelay(int delay) {
        this.timer.setDelay(delay);
    }

    protected int getTPosition() {
        return this.slider.getValue();
    }

    protected void setTPosition(final int t) {
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                TNavigationPanel.this.slider.setValue(t);
            }
        });
    }

    public int getFrameRate() {
        return (Integer)this.frameRate.getValue();
    }

    public void setFrameRate(int fps) {
        this.frameRate.setValue(fps);
    }

    public boolean isRepeat() {
        return this.loop.getToolTipText().startsWith("Disable");
    }

    public void setRepeat(boolean value) {
        if (value) {
            this.loop.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_RELOAD, 16));
            this.loop.setSelected(true);
            this.loop.setToolTipText("Disable loop playback");
        } else {
            this.loop.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_ARROW_RIGHT, 16));
            this.loop.setSelected(false);
            this.loop.setToolTipText("Enable loop playback");
        }
        this.fireLoopingStateChange();
    }

    public void addLoopingStateChangeListener(ActionListener actionListener) {
        this.loopingStateChangeListeners.add(actionListener);
    }

    public void removeLoopingStateChangeListener(ActionListener actionListener) {
        this.loopingStateChangeListeners.remove(actionListener);
    }

    protected void fireLoopingStateChange() {
        for (ActionListener l : this.loopingStateChangeListeners) {
            l.actionPerformed(null);
        }
    }

    public boolean isPlaying() {
        return this.timer.isRunning();
    }

    public void startPlay() {
        this.timer.start();
        this.play.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_PAUSE));
        this.play.setSelected(true);
        this.play.setToolTipText("pause");
    }

    public void stopPlay() {
        this.timer.stop();
        this.play.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_PLAY));
        this.play.setSelected(false);
        this.play.setToolTipText("play");
    }

    public void setPaintLabels(boolean b) {
        this.slider.setPaintLabels(b);
    }

    public void setPaintTicks(boolean b) {
        this.slider.setPaintTicks(b);
    }

    public void addChangeListener(ChangeListener l) {
        this.slider.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.slider.removeChangeListener(l);
    }

    public void removeAllChangeListener() {
        for (ChangeListener l : (ChangeListener[])this.slider.getListeners(ChangeListener.class)) {
            this.slider.removeChangeListener(l);
        }
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int n) {
        this.slider.setValue(n);
    }

    public int getMinimum() {
        return this.slider.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.slider.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.slider.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.slider.setMaximum(maximum);
    }

    public boolean getPaintTicks() {
        return this.slider.getPaintTicks();
    }

    public boolean getPaintTrack() {
        return this.slider.getPaintTrack();
    }

    public void setPaintTrack(boolean b) {
        this.slider.setPaintTrack(b);
    }

    public boolean getPaintLabels() {
        return this.slider.getPaintLabels();
    }
}

