/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.Family;
import plugins.nchenouard.particletracking.MHTracker.GlobalHypothesis;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.MHTracker.Hypothesis;
import plugins.nchenouard.particletracking.MHTracker.MHTrack2s;
import plugins.nchenouard.particletracking.MHTracker.ValidatedTrack;

public class Cluster {
    HashSet<Association> realAssociations = new HashSet();
    HashMap<Integer, ArrayList<Family>> concurrentFamilies = new HashMap();
    final int firstTime;
    final int lastTime;
    int[] realSpotsNum;
    int K;
    HMMMHTracker tracker;
    boolean parallelComputing = false;
    final LinkedList<Thread> buildGHthreadList = new LinkedList();
    BestHypSynchronization bestHypSafe = new BestHypSynchronization();
    boolean verbose = false;

    public Cluster(HMMMHTracker tracker, int firstT, int lastT, int K) {
        this.firstTime = firstT;
        this.lastTime = lastT;
        this.K = K;
        this.realSpotsNum = new int[this.lastTime - this.firstTime + 1];
        this.tracker = tracker;
    }

    public void initRealSpotsNum() {
        for (Association a : this.realAssociations) {
            if (a.t < this.firstTime || a.t > this.lastTime) continue;
            this.realSpotsNum[a.t - this.firstTime] = this.realSpotsNum[a.t - this.firstTime] + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAndApplyBestHypTree(final int t) {
        int firstTtemp = -1;
        boolean buildAndApplyBestHyp = false;
        for (Integer n : this.concurrentFamilies.keySet()) {
            if (firstTtemp >= 0 && n >= firstTtemp) continue;
            firstTtemp = n;
        }
        final int firstT = firstTtemp;
        this.buildGHthreadList.clear();
        boolean bl = buildAndApplyBestHyp = firstT >= 0 && firstT <= t - this.K;
        if (buildAndApplyBestHyp) {
            Thread thr;
            Hypothesis hyp;
            Iterator iterator;
            boolean lastFamily;
            Family f;
            this.println("-----build best Hyp");
            this.println("different root time for families " + this.concurrentFamilies.size());
            this.println("firstT " + firstT + " first time " + firstT + "  time " + t);
            for (Map.Entry<Integer, ArrayList<Family>> entry : this.concurrentFamilies.entrySet()) {
                this.println("time " + entry.getKey() + "numFamily " + entry.getValue().size());
            }
            final int n = firstT;
            ArrayList<Family> arrayList = this.concurrentFamilies.get(new Integer(n));
            final ArrayList<Family> mandatoryFamilies = new ArrayList<Family>();
            final ArrayList<Family> optionalFamilies = new ArrayList<Family>();
            for (Family f2 : arrayList) {
                if (f2.rootTrack == null) {
                    optionalFamilies.add(f2);
                    continue;
                }
                mandatoryFamilies.add(f2);
                this.println("mandatory family : begin = " + f2.rootTrack.associations.getFirst().t + " root time " + f2.rootTime);
            }
            this.println("mFamilies " + mandatoryFamilies.size() + " oFamilies " + optionalFamilies.size());
            if (mandatoryFamilies.size() > 0) {
                boolean familyIdx = false;
                f = (Family)mandatoryFamilies.get(0);
                lastFamily = 0 == mandatoryFamilies.size() - 1;
                iterator = f.hypotheses.iterator();
                while (iterator.hasNext()) {
                    Hypothesis htemp;
                    hyp = htemp = (Hypothesis)iterator.next();
                    thr = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            GlobalHypothesis gh = new GlobalHypothesis(firstT, t, Cluster.this.tracker);
                            gh.addHypothesis(hyp);
                            boolean feasible = false;
                            BestHypSynchronization bestHypSynchronization = Cluster.this.bestHypSafe;
                            synchronized (bestHypSynchronization) {
                                feasible = Cluster.this.bestHypSafe.bestHyp == null || gh.score > Cluster.this.bestHypSafe.bestHyp.score;
                            }
                            if (feasible) {
                                if (lastFamily) {
                                    GlobalHypothesis ghCopy = gh.copy();
                                    for (int time = n; time <= t; ++time) {
                                        Cluster.this.penalizeFD(ghCopy, time);
                                        Cluster.this.penalizeNT(ghCopy, time);
                                    }
                                    BestHypSynchronization time = Cluster.this.bestHypSafe;
                                    synchronized (time) {
                                        if (Cluster.this.bestHypSafe.bestHyp == null || ghCopy.score > Cluster.this.bestHypSafe.bestHyp.score) {
                                            Cluster.this.bestHypSafe.bestHyp = ghCopy;
                                        }
                                    }
                                    if (gh.realAssociations.size() < Cluster.this.realAssociations.size()) {
                                        int currentTimeFD = Cluster.this.getRealSpotsNum(n) - gh.getRealSpotsNumAtT(n);
                                        if (currentTimeFD > 0 && optionalFamilies.size() > 0) {
                                            Cluster.this.recursBuildBestGlobalHypTree(gh, 0, n, t, optionalFamilies);
                                        } else if (n < t) {
                                            Cluster.this.penalizeFD(gh, currentTimeFD, n);
                                            Cluster.this.penalizeNT(gh, n);
                                            boolean feasible2 = false;
                                            BestHypSynchronization bestHypSynchronization2 = Cluster.this.bestHypSafe;
                                            synchronized (bestHypSynchronization2) {
                                                feasible2 = Cluster.this.bestHypSafe.bestHyp == null || gh.score > Cluster.this.bestHypSafe.bestHyp.score;
                                            }
                                            if (feasible2) {
                                                Cluster.this.recursBuildBestGlobalHypTree(gh, 0, n + 1, t, Cluster.this.concurrentFamilies.get(new Integer(n + 1)));
                                            }
                                        }
                                    }
                                } else {
                                    Cluster.this.recursBuildBestGlobalHypWithMandatoryFamiliesTree(gh, 1, n, t, mandatoryFamilies, optionalFamilies);
                                }
                            }
                        }
                    };
                    LinkedList<Thread> linkedList = this.buildGHthreadList;
                    synchronized (linkedList) {
                        this.buildGHthreadList.add(thr);
                    }
                    thr.start();
                    if (this.parallelComputing) continue;
                    try {
                        thr.join();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (optionalFamilies.size() > 0) {
                boolean familyIdx = false;
                f = (Family)optionalFamilies.get(0);
                lastFamily = 0 == optionalFamilies.size() - 1;
                iterator = f.hypotheses.iterator();
                while (iterator.hasNext()) {
                    Hypothesis htemp;
                    hyp = htemp = (Hypothesis)iterator.next();
                    thr = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            GlobalHypothesis gh = new GlobalHypothesis(firstT, t, Cluster.this.tracker);
                            gh.addHypothesis(hyp);
                            GlobalHypothesis ghCopy = gh.copy();
                            for (int time = n; time <= t; ++time) {
                                Cluster.this.penalizeFD(ghCopy, time);
                                Cluster.this.penalizeNT(ghCopy, time);
                            }
                            BestHypSynchronization time = Cluster.this.bestHypSafe;
                            synchronized (time) {
                                if (Cluster.this.bestHypSafe.bestHyp == null || ghCopy.score > Cluster.this.bestHypSafe.bestHyp.score) {
                                    Cluster.this.bestHypSafe.bestHyp = ghCopy;
                                }
                            }
                            if (gh.realAssociations.size() < Cluster.this.realAssociations.size()) {
                                int currentTimeFD = Cluster.this.getRealSpotsNum(n) - gh.getRealSpotsNumAtT(n);
                                if (!lastFamily && currentTimeFD > 0) {
                                    Cluster.this.recursBuildBestGlobalHypTree(gh, 1, n, t, optionalFamilies);
                                } else if (n < t) {
                                    Cluster.this.penalizeFD(gh, currentTimeFD, n);
                                    Cluster.this.penalizeNT(gh, n);
                                    boolean feasible = false;
                                    BestHypSynchronization bestHypSynchronization = Cluster.this.bestHypSafe;
                                    synchronized (bestHypSynchronization) {
                                        feasible = Cluster.this.bestHypSafe.bestHyp == null || gh.score > Cluster.this.bestHypSafe.bestHyp.score;
                                    }
                                    if (feasible) {
                                        Cluster.this.recursBuildBestGlobalHypTree(gh, 0, n + 1, t, Cluster.this.concurrentFamilies.get(new Integer(n + 1)));
                                    }
                                }
                            }
                        }
                    };
                    LinkedList<Thread> e1 = this.buildGHthreadList;
                    synchronized (e1) {
                        this.buildGHthreadList.add(thr);
                    }
                    thr.start();
                    if (this.parallelComputing) continue;
                    try {
                        thr.join();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
                GlobalHypothesis gh = new GlobalHypothesis(firstT, t, this.tracker);
                if (lastFamily) {
                    if (n < t) {
                        this.penalizeFD(gh, n);
                        this.penalizeNT(gh, n);
                        boolean feasible = false;
                        BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
                        synchronized (bestHypSynchronization) {
                            feasible = this.bestHypSafe.bestHyp == null || gh.score > this.bestHypSafe.bestHyp.score;
                        }
                        if (feasible) {
                            this.recursBuildBestGlobalHypTree(gh, 0, n + 1, t, this.concurrentFamilies.get(new Integer(n + 1)));
                        }
                    }
                } else {
                    this.recursBuildBestGlobalHypTree(gh, 1, n, t, arrayList);
                }
            }
        } else {
            this.println("no need to build hyp");
        }
        while (true) {
            boolean bl2 = false;
            LinkedList<Thread> linkedList = this.buildGHthreadList;
            synchronized (linkedList) {
                while (!this.buildGHthreadList.isEmpty()) {
                    Thread thr = this.buildGHthreadList.getFirst();
                    if (thr.isAlive()) {
                        bl2 = true;
                        break;
                    }
                    this.buildGHthreadList.poll();
                }
            }
            if (!bl2) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.applyBestHyp(t);
        for (Collection collection : this.concurrentFamilies.values()) {
            for (Family f : collection) {
                f.hypotheses.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAndApplyBestHyp(int t) {
        int firstT = -1;
        boolean buildAndApplyBestHyp = false;
        for (Integer n : this.concurrentFamilies.keySet()) {
            if (firstT >= 0 && n >= firstT) continue;
            firstT = n;
        }
        boolean bl = buildAndApplyBestHyp = firstT >= 0 && firstT <= t - this.K;
        if (buildAndApplyBestHyp) {
            GlobalHypothesis gh;
            boolean lastFamily;
            Family f;
            this.println("-----build best Hyp");
            this.println("different root time for families " + this.concurrentFamilies.size());
            this.println("firstT " + firstT);
            for (Map.Entry entry : this.concurrentFamilies.entrySet()) {
                this.println("time " + (Integer)entry.getKey() + "numFamily " + ((ArrayList)entry.getValue()).size());
            }
            int currentT = firstT;
            ArrayList<Family> arrayList = this.concurrentFamilies.get(new Integer(currentT));
            ArrayList<Family> mandatoryFamilies = new ArrayList<Family>();
            ArrayList<Family> optionalFamilies = new ArrayList<Family>();
            for (Family f2 : arrayList) {
                if (f2.rootTrack == null) {
                    optionalFamilies.add(f2);
                    continue;
                }
                mandatoryFamilies.add(f2);
                this.println("mandatory family : begin = " + f2.rootTrack.associations.getFirst().t + " root time " + f2.rootTime);
            }
            this.println("mFamilies " + mandatoryFamilies.size() + " oFamilies " + optionalFamilies.size());
            if (mandatoryFamilies.size() > 0) {
                int familyIdx = 0;
                f = (Family)mandatoryFamilies.get(familyIdx);
                lastFamily = familyIdx == mandatoryFamilies.size() - 1;
                for (Hypothesis hyp : f.hypotheses) {
                    gh = new GlobalHypothesis(firstT, t, this.tracker);
                    gh.addHypothesis(hyp);
                    boolean feasible = false;
                    BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
                    synchronized (bestHypSynchronization) {
                        feasible = this.bestHypSafe.bestHyp == null || gh.score > this.bestHypSafe.bestHyp.score;
                    }
                    if (!feasible) continue;
                    if (lastFamily) {
                        GlobalHypothesis ghCopy = gh.copy();
                        for (int time = currentT; time <= t; ++time) {
                            this.penalizeFD(ghCopy, time);
                            this.penalizeNT(ghCopy, time);
                        }
                        BestHypSynchronization time = this.bestHypSafe;
                        synchronized (time) {
                            if (this.bestHypSafe.bestHyp == null || ghCopy.score > this.bestHypSafe.bestHyp.score) {
                                this.bestHypSafe.bestHyp = ghCopy;
                            }
                        }
                        if (gh.realAssociations.size() >= this.realAssociations.size()) continue;
                        int currentTimeFD = this.getRealSpotsNum(currentT) - gh.getRealSpotsNumAtT(currentT);
                        if (currentTimeFD > 0 && optionalFamilies.size() > 0) {
                            this.recursBuildBestGlobalHyp(gh, 0, currentT, t, optionalFamilies);
                            continue;
                        }
                        if (currentT >= t) continue;
                        this.penalizeFD(gh, currentTimeFD, currentT);
                        this.penalizeNT(gh, currentT);
                        boolean feasible2 = false;
                        BestHypSynchronization bestHypSynchronization2 = this.bestHypSafe;
                        synchronized (bestHypSynchronization2) {
                            feasible2 = this.bestHypSafe.bestHyp == null || gh.score > this.bestHypSafe.bestHyp.score;
                        }
                        if (!feasible2) continue;
                        this.recursBuildBestGlobalHyp(gh, 0, currentT + 1, t, this.concurrentFamilies.get(new Integer(currentT + 1)));
                        continue;
                    }
                    this.recursBuildBestGlobalHypWithMandatoryFamilies(gh, familyIdx + 1, currentT, t, mandatoryFamilies, optionalFamilies);
                }
            } else if (optionalFamilies.size() > 0) {
                int familyIdx = 0;
                f = (Family)optionalFamilies.get(familyIdx);
                lastFamily = familyIdx == optionalFamilies.size() - 1;
                for (Hypothesis hyp : f.hypotheses) {
                    gh = new GlobalHypothesis(firstT, t, this.tracker);
                    gh.addHypothesis(hyp);
                    GlobalHypothesis ghCopy = gh.copy();
                    for (int time = currentT; time <= t; ++time) {
                        this.penalizeFD(ghCopy, time);
                        this.penalizeNT(ghCopy, time);
                    }
                    BestHypSynchronization time = this.bestHypSafe;
                    synchronized (time) {
                        if (this.bestHypSafe.bestHyp == null || ghCopy.score > this.bestHypSafe.bestHyp.score) {
                            this.bestHypSafe.bestHyp = ghCopy;
                        }
                    }
                    if (gh.realAssociations.size() >= this.realAssociations.size()) continue;
                    int currentTimeFD = this.getRealSpotsNum(currentT) - gh.getRealSpotsNumAtT(currentT);
                    if (!lastFamily && currentTimeFD > 0) {
                        this.recursBuildBestGlobalHyp(gh, familyIdx + 1, currentT, t, optionalFamilies);
                        continue;
                    }
                    if (currentT >= t) continue;
                    this.penalizeFD(gh, currentTimeFD, currentT);
                    this.penalizeNT(gh, currentT);
                    boolean feasible = false;
                    BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
                    synchronized (bestHypSynchronization) {
                        feasible = this.bestHypSafe.bestHyp == null || gh.score > this.bestHypSafe.bestHyp.score;
                    }
                    if (!feasible) continue;
                    this.recursBuildBestGlobalHyp(gh, 0, currentT + 1, t, this.concurrentFamilies.get(new Integer(currentT + 1)));
                }
                GlobalHypothesis gh2 = new GlobalHypothesis(firstT, t, this.tracker);
                if (lastFamily) {
                    if (currentT < t) {
                        this.penalizeFD(gh2, currentT);
                        this.penalizeNT(gh2, currentT);
                        boolean feasible = false;
                        BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
                        synchronized (bestHypSynchronization) {
                            feasible = this.bestHypSafe.bestHyp == null || gh2.score > this.bestHypSafe.bestHyp.score;
                        }
                        if (feasible) {
                            this.recursBuildBestGlobalHyp(gh2, 0, currentT + 1, t, this.concurrentFamilies.get(new Integer(currentT + 1)));
                        }
                    }
                } else {
                    this.recursBuildBestGlobalHyp(gh2, familyIdx + 1, currentT, t, arrayList);
                }
            }
            if (this.bestHypSafe.bestHyp != null) {
                this.println("num leafs for best hyp = " + this.bestHypSafe.bestHyp.hyps.size());
                this.println("num spots for best hyp = " + this.bestHypSafe.bestHyp.usedAssociations.size());
                this.println("num real spots for best hyp = " + this.bestHypSafe.bestHyp.realAssociations.size());
                this.println("score " + this.bestHypSafe.bestHyp.score);
            } else {
                System.err.print("error bestHyp null");
            }
        } else {
            this.println("no need to build hyp");
        }
        this.applyBestHyp(t);
        for (Collection collection : this.concurrentFamilies.values()) {
            for (Family f : collection) {
                f.hypotheses.clear();
            }
        }
    }

    protected int getRealSpotsNum(int t) {
        if (t >= this.firstTime && t <= this.lastTime) {
            return this.realSpotsNum[t - this.firstTime];
        }
        return 0;
    }

    protected void penalizeFD(GlobalHypothesis gh, int t) {
        gh.penalizeFD(t, this.tracker.pFA, this.realAssociations);
    }

    protected void penalizeNT(GlobalHypothesis gh, int t) {
    }

    protected void penalizeFD(GlobalHypothesis gh, int numFD, int t) {
        gh.penalizeFD(t, this.tracker.pFA, this.realAssociations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recursBuildBestGlobalHypTree(final GlobalHypothesis ghPrev, final int familyIdx, final int currentT, final int t, final ArrayList<Family> fList) {
        if (fList != null && !fList.isEmpty()) {
            Family f = fList.get(familyIdx);
            final boolean lastFamily = familyIdx == fList.size() - 1;
            Vector<Hypothesis> compatibleHypothesis = f.getCompatibleHypothesis(ghPrev);
            Iterator<Hypothesis> iterator = compatibleHypothesis.iterator();
            while (iterator.hasNext()) {
                Hypothesis htemp;
                final Hypothesis hyp = htemp = iterator.next();
                Thread thr = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        GlobalHypothesis gh = ghPrev.copy();
                        gh.addHypothesis(hyp);
                        boolean feasible = false;
                        BestHypSynchronization bestHypSynchronization = Cluster.this.bestHypSafe;
                        synchronized (bestHypSynchronization) {
                            feasible = Cluster.this.bestHypSafe.bestHyp == null || gh.score > Cluster.this.bestHypSafe.bestHyp.score;
                        }
                        if (feasible) {
                            GlobalHypothesis ghCopy = gh.copy();
                            for (int time = currentT; time <= t; ++time) {
                                Cluster.this.penalizeFD(ghCopy, time);
                                Cluster.this.penalizeNT(ghCopy, time);
                            }
                            BestHypSynchronization time = Cluster.this.bestHypSafe;
                            synchronized (time) {
                                if (Cluster.this.bestHypSafe.bestHyp == null || ghCopy.score > Cluster.this.bestHypSafe.bestHyp.score) {
                                    Cluster.this.bestHypSafe.bestHyp = ghCopy;
                                }
                            }
                            if (gh.realAssociations.size() < Cluster.this.realAssociations.size()) {
                                int currentTimeFD = Cluster.this.getRealSpotsNum(currentT) - gh.getRealSpotsNumAtT(currentT);
                                if (!lastFamily && currentTimeFD > 0) {
                                    Cluster.this.recursBuildBestGlobalHypTree(gh, familyIdx + 1, currentT, t, fList);
                                } else if (currentT < t) {
                                    Cluster.this.penalizeFD(gh, currentTimeFD, currentT);
                                    Cluster.this.penalizeNT(gh, currentT);
                                    boolean feasible2 = false;
                                    BestHypSynchronization bestHypSynchronization2 = Cluster.this.bestHypSafe;
                                    synchronized (bestHypSynchronization2) {
                                        feasible2 = Cluster.this.bestHypSafe.bestHyp == null || gh.score > Cluster.this.bestHypSafe.bestHyp.score;
                                    }
                                    if (feasible2) {
                                        Cluster.this.recursBuildBestGlobalHypTree(gh, 0, currentT + 1, t, Cluster.this.concurrentFamilies.get(new Integer(currentT + 1)));
                                    }
                                }
                            }
                        }
                    }
                };
                LinkedList<Thread> linkedList = this.buildGHthreadList;
                synchronized (linkedList) {
                    this.buildGHthreadList.add(thr);
                }
                thr.start();
                if (this.parallelComputing) continue;
                try {
                    thr.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else if (currentT < t) {
            GlobalHypothesis ghCopy = ghPrev.copy();
            this.penalizeFD(ghCopy, currentT);
            this.penalizeNT(ghCopy, currentT);
            boolean feasible = false;
            BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
            synchronized (bestHypSynchronization) {
                feasible = this.bestHypSafe.bestHyp == null || ghCopy.score > this.bestHypSafe.bestHyp.score;
            }
            if (feasible) {
                this.recursBuildBestGlobalHypTree(ghCopy, 0, currentT + 1, t, this.concurrentFamilies.get(new Integer(currentT + 1)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recursBuildBestGlobalHyp(GlobalHypothesis ghPrev, int familyIdx, int currentT, int t, ArrayList<Family> fList) {
        if (fList != null && !fList.isEmpty()) {
            Family f = fList.get(familyIdx);
            boolean lastFamily = familyIdx == fList.size() - 1;
            for (Hypothesis hyp : f.hypotheses) {
                boolean compatible = this.areCompatible(ghPrev, hyp);
                if (!compatible) continue;
                GlobalHypothesis gh = ghPrev.copy();
                gh.addHypothesis(hyp);
                boolean feasible = false;
                BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
                synchronized (bestHypSynchronization) {
                    feasible = this.bestHypSafe.bestHyp == null || gh.score > this.bestHypSafe.bestHyp.score;
                }
                if (!feasible) continue;
                GlobalHypothesis ghCopy = gh.copy();
                for (int time = currentT; time <= t; ++time) {
                    this.penalizeFD(ghCopy, time);
                    this.penalizeNT(ghCopy, time);
                }
                GlobalHypothesis time = this.bestHypSafe.bestHyp;
                synchronized (time) {
                    if (this.bestHypSafe.bestHyp == null || ghCopy.score > this.bestHypSafe.bestHyp.score) {
                        this.bestHypSafe.bestHyp = ghCopy;
                    }
                }
                if (gh.realAssociations.size() >= this.realAssociations.size()) continue;
                int currentTimeFD = this.getRealSpotsNum(currentT) - gh.getRealSpotsNumAtT(currentT);
                if (!lastFamily && currentTimeFD > 0) {
                    this.recursBuildBestGlobalHyp(gh, familyIdx + 1, currentT, t, fList);
                    continue;
                }
                if (currentT >= t) continue;
                this.penalizeFD(gh, currentTimeFD, currentT);
                this.penalizeNT(gh, currentT);
                boolean feasible2 = false;
                BestHypSynchronization bestHypSynchronization2 = this.bestHypSafe;
                synchronized (bestHypSynchronization2) {
                    feasible2 = this.bestHypSafe.bestHyp == null || gh.score > this.bestHypSafe.bestHyp.score;
                }
                if (!feasible2) continue;
                this.recursBuildBestGlobalHyp(gh, 0, currentT + 1, t, this.concurrentFamilies.get(new Integer(currentT + 1)));
            }
            if (lastFamily) {
                GlobalHypothesis ghCopy = ghPrev.copy();
                for (int time = currentT; time <= t; ++time) {
                    this.penalizeFD(ghCopy, time);
                    this.penalizeNT(ghCopy, time);
                }
                BestHypSynchronization time = this.bestHypSafe;
                synchronized (time) {
                    if (this.bestHypSafe.bestHyp == null || ghCopy.score > this.bestHypSafe.bestHyp.score) {
                        this.bestHypSafe.bestHyp = ghCopy;
                    }
                }
                if (currentT < t) {
                    ghCopy = ghPrev.copy();
                    this.penalizeFD(ghCopy, currentT);
                    this.penalizeNT(ghCopy, currentT);
                    boolean feasible = false;
                    BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
                    synchronized (bestHypSynchronization) {
                        feasible = this.bestHypSafe.bestHyp == null || ghCopy.score > this.bestHypSafe.bestHyp.score;
                    }
                    if (feasible) {
                        this.recursBuildBestGlobalHyp(ghCopy, 0, currentT + 1, t, this.concurrentFamilies.get(new Integer(currentT + 1)));
                    }
                }
            } else {
                this.recursBuildBestGlobalHyp(ghPrev, familyIdx + 1, currentT, t, fList);
            }
        } else if (currentT < t) {
            GlobalHypothesis ghCopy = ghPrev.copy();
            this.penalizeFD(ghCopy, currentT);
            this.penalizeNT(ghCopy, currentT);
            boolean feasible = false;
            BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
            synchronized (bestHypSynchronization) {
                feasible = this.bestHypSafe.bestHyp == null || ghCopy.score > this.bestHypSafe.bestHyp.score;
            }
            if (feasible) {
                this.recursBuildBestGlobalHyp(ghCopy, 0, currentT + 1, t, this.concurrentFamilies.get(new Integer(currentT + 1)));
            }
        }
    }

    protected boolean areCompatible(GlobalHypothesis gh, Hypothesis h) {
        long t1 = System.currentTimeMillis();
        boolean compatible = true;
        for (Association s : h.usedAssociations) {
            if (!gh.usedAssociations.contains(s)) continue;
            compatible = false;
            break;
        }
        long t2 = System.currentTimeMillis();
        HMMMHTracker.compatibleElapseTime += t2 - t1;
        return compatible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recursBuildBestGlobalHypWithMandatoryFamiliesTree(final GlobalHypothesis ghPrev, final int familyIdx, final int currentT, final int t, final ArrayList<Family> mFamilies, final ArrayList<Family> oFamilies) {
        Family f = mFamilies.get(familyIdx);
        final boolean lastFamily = familyIdx == mFamilies.size() - 1;
        Vector<Hypothesis> compatibleHypothesis = f.getCompatibleHypothesis(ghPrev);
        Iterator<Hypothesis> iterator = compatibleHypothesis.iterator();
        while (iterator.hasNext()) {
            Hypothesis htemp;
            final Hypothesis hyp = htemp = iterator.next();
            Thread thr = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GlobalHypothesis gh = ghPrev.copy();
                    gh.addHypothesis(hyp);
                    boolean feasible = false;
                    BestHypSynchronization bestHypSynchronization = Cluster.this.bestHypSafe;
                    synchronized (bestHypSynchronization) {
                        feasible = Cluster.this.bestHypSafe.bestHyp == null || gh.score > Cluster.this.bestHypSafe.bestHyp.score;
                    }
                    if (feasible) {
                        if (lastFamily) {
                            GlobalHypothesis ghCopy = gh.copy();
                            for (int time = currentT; time <= t; ++time) {
                                Cluster.this.penalizeFD(ghCopy, time);
                                Cluster.this.penalizeNT(ghCopy, time);
                            }
                            BestHypSynchronization time = Cluster.this.bestHypSafe;
                            synchronized (time) {
                                if (Cluster.this.bestHypSafe.bestHyp == null || ghCopy.score > Cluster.this.bestHypSafe.bestHyp.score) {
                                    Cluster.this.bestHypSafe.bestHyp = ghCopy;
                                }
                            }
                            if (gh.realAssociations.size() < Cluster.this.realAssociations.size()) {
                                int currentTimeFD = Cluster.this.getRealSpotsNum(currentT) - gh.getRealSpotsNumAtT(currentT);
                                if (currentTimeFD > 0 && oFamilies.size() > 0) {
                                    Cluster.this.recursBuildBestGlobalHypTree(gh, 0, currentT, t, oFamilies);
                                } else if (currentT < t) {
                                    Cluster.this.penalizeFD(gh, currentTimeFD, currentT);
                                    Cluster.this.penalizeNT(gh, currentT);
                                    boolean feasible2 = false;
                                    BestHypSynchronization bestHypSynchronization2 = Cluster.this.bestHypSafe;
                                    synchronized (bestHypSynchronization2) {
                                        feasible2 = Cluster.this.bestHypSafe.bestHyp == null || gh.score > Cluster.this.bestHypSafe.bestHyp.score;
                                    }
                                    if (feasible2) {
                                        Cluster.this.recursBuildBestGlobalHypTree(gh, 0, currentT + 1, t, Cluster.this.concurrentFamilies.get(new Integer(currentT + 1)));
                                    }
                                }
                            }
                        } else {
                            Cluster.this.recursBuildBestGlobalHypWithMandatoryFamiliesTree(gh, familyIdx + 1, currentT, t, mFamilies, oFamilies);
                        }
                    }
                }
            };
            LinkedList<Thread> linkedList = this.buildGHthreadList;
            synchronized (linkedList) {
                this.buildGHthreadList.add(thr);
            }
            thr.start();
            if (this.parallelComputing) continue;
            try {
                thr.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recursBuildBestGlobalHypWithMandatoryFamilies(GlobalHypothesis ghPrev, int familyIdx, int currentT, int t, ArrayList<Family> mFamilies, ArrayList<Family> oFamilies) {
        Family f = mFamilies.get(familyIdx);
        boolean lastFamily = familyIdx == mFamilies.size() - 1;
        for (Hypothesis hyp : f.hypotheses) {
            boolean compatible = this.areCompatible(ghPrev, hyp);
            if (!compatible) continue;
            GlobalHypothesis gh = ghPrev.copy();
            gh.addHypothesis(hyp);
            boolean feasible = false;
            BestHypSynchronization bestHypSynchronization = this.bestHypSafe;
            synchronized (bestHypSynchronization) {
                feasible = this.bestHypSafe.bestHyp == null || gh.score > this.bestHypSafe.bestHyp.score;
            }
            if (!feasible) continue;
            if (lastFamily) {
                GlobalHypothesis ghCopy = gh.copy();
                for (int time = currentT; time <= t; ++time) {
                    this.penalizeFD(ghCopy, time);
                    this.penalizeNT(ghCopy, time);
                }
                BestHypSynchronization time = this.bestHypSafe;
                synchronized (time) {
                    if (this.bestHypSafe.bestHyp == null || ghCopy.score > this.bestHypSafe.bestHyp.score) {
                        this.bestHypSafe.bestHyp = ghCopy;
                    }
                }
                if (gh.realAssociations.size() >= this.realAssociations.size()) continue;
                int currentTimeFD = this.getRealSpotsNum(currentT) - gh.getRealSpotsNumAtT(currentT);
                if (currentTimeFD > 0 && oFamilies.size() > 0) {
                    this.recursBuildBestGlobalHyp(gh, 0, currentT, t, oFamilies);
                    continue;
                }
                if (currentT >= t) continue;
                this.penalizeFD(gh, currentTimeFD, currentT);
                this.penalizeNT(gh, currentT);
                boolean feasible2 = false;
                BestHypSynchronization bestHypSynchronization2 = this.bestHypSafe;
                synchronized (bestHypSynchronization2) {
                    feasible2 = this.bestHypSafe.bestHyp == null || gh.score > this.bestHypSafe.bestHyp.score;
                }
                if (!feasible2) continue;
                this.recursBuildBestGlobalHyp(gh, 0, currentT + 1, t, this.concurrentFamilies.get(new Integer(currentT + 1)));
                continue;
            }
            this.recursBuildBestGlobalHypWithMandatoryFamilies(gh, familyIdx + 1, currentT, t, mFamilies, oFamilies);
        }
    }

    public void recursPrintPerceiv(MHTrack2s trk) {
        if (trk.precedingSegment != null) {
            this.recursPrintPerceiv(trk.precedingSegment);
        }
    }

    public void applyBestHyp(int t) {
        long l1 = System.currentTimeMillis();
        if (this.bestHypSafe.bestHyp != null) {
            this.println("**************************************************************");
            this.println("applyBesthyp at t = " + t);
            int newRootTime = t - this.K + 1;
            LinkedList linkedList = new LinkedList();
            for (Hypothesis hypothesis : this.bestHypSafe.bestHyp.hyps) {
                Family family = hypothesis.leaf.family;
                family.lastSelectedLeaf = hypothesis.leaf;
                MHTrack2s oldRoot = family.rootNode;
                this.println("leaf time " + t + " new root time" + newRootTime + " old root time " + oldRoot.association.t);
                if (oldRoot.association.t < newRootTime) {
                    boolean stop = false;
                    MHTrack2s temp = hypothesis.leaf;
                    this.println("hleaf time " + hypothesis.leaf.association.t);
                    boolean bl = stop = temp == null || temp.association.t == newRootTime;
                    while (!stop) {
                        temp = temp.precedingSegment;
                        if (temp != null) {
                            this.println("temp time " + temp.association.t);
                        }
                        stop = temp == null || temp.association.t == newRootTime;
                    }
                    MHTrack2s newRoot = null;
                    if (temp != null && temp.association.t == newRootTime) {
                        newRoot = temp;
                    } else {
                        this.println("new root null");
                    }
                    ValidatedTrack vtrack = null;
                    if (family.rootTrack == null) {
                        vtrack = new ValidatedTrack(family);
                        this.tracker.addValidatedTrack(vtrack);
                    } else {
                        vtrack = family.rootTrack;
                    }
                    oldRoot.followingSegments.clear();
                    if (newRoot != null) {
                        oldRoot.followingSegments.add(newRoot);
                        family.updateFamily(newRoot, vtrack, t);
                        this.println("new family: " + family.rootTime + " " + (family.rootTrack == null) + " " + family.leafs.size());
                        vtrack.update(family);
                        this.tracker.addFamily(family);
                    } else {
                        this.println("no new root");
                    }
                }
                long l2 = System.currentTimeMillis();
                HMMMHTracker.applyHypTime += l2 - l1;
            }
            for (Map.Entry entry : this.concurrentFamilies.entrySet()) {
                int rootTime = (Integer)entry.getKey();
                if (rootTime > newRootTime) {
                    this.tracker.addFamilies((ArrayList)entry.getValue());
                    continue;
                }
                if (rootTime != newRootTime) continue;
                for (Family f : (ArrayList)entry.getValue()) {
                    if (f.rootNode.association.isPrediction) continue;
                    boolean feasible = true;
                    for (Family vf : linkedList) {
                        if (vf.rootNode.association.isPrediction || vf.rootNode.association.spot != f.rootNode.association.spot) continue;
                        feasible = false;
                        break;
                    }
                    if (!feasible) continue;
                    this.tracker.addFamily(f);
                }
            }
            this.println("**************************************************************");
        } else {
            for (Collection collection : this.concurrentFamilies.values()) {
                this.tracker.addFamilies(collection);
            }
        }
    }

    protected void println(String text) {
        if (this.verbose) {
            System.out.println(text);
        }
    }

    protected void finalize() throws Throwable {
        this.realAssociations = null;
        this.concurrentFamilies = null;
        this.bestHypSafe.bestHyp = null;
        this.realSpotsNum = null;
        this.tracker = null;
        super.finalize();
    }

    public GlobalHypothesis getMLHypothesis(int firstT, int lastT, HMMMHTracker tracker, ArrayList<Family> mandatoryFamilies, ArrayList<Family> optionalFamilies) {
        GlobalHypothesis gh = new GlobalHypothesis(firstT, lastT, tracker);
        if (mandatoryFamilies.size() > 0) {
            ArrayList<Family> lFamilies = new ArrayList<Family>(mandatoryFamilies);
            HashMap feasibleHypothesis = new HashMap();
            for (Family f : lFamilies) {
                feasibleHypothesis.put(f, new LinkedList<Hypothesis>(f.hypotheses));
            }
            while (!lFamilies.isEmpty()) {
                Family selectedFamily = null;
                Object bestH = null;
                for (Family f : lFamilies) {
                    LinkedList lh = (LinkedList)feasibleHypothesis.get(f);
                    LinkedList<Hypothesis> updatelh = new LinkedList<Hypothesis>();
                    for (Hypothesis h : lh) {
                        boolean compatible = this.areCompatible(gh, h);
                        if (!compatible) continue;
                        updatelh.add(h);
                        if (bestH != null && !(h.leaf.score > ((Hypothesis)bestH).leaf.score)) continue;
                        selectedFamily = f;
                        bestH = h;
                    }
                    feasibleHypothesis.put(f, updatelh);
                }
                if (bestH == null) break;
                gh.addHypothesis((Hypothesis)bestH);
                lFamilies.remove(selectedFamily);
                feasibleHypothesis.remove(selectedFamily);
            }
        }
        for (int t = firstT; t <= lastT; ++t) {
            ArrayList<Family> lFamilies = t == firstT ? optionalFamilies : this.concurrentFamilies.get(new Integer(t));
            if (lFamilies != null && lFamilies.size() > 0) {
                lFamilies = new ArrayList<Family>(lFamilies);
                HashMap feasibleHypothesis = new HashMap();
                for (Family f : lFamilies) {
                    feasibleHypothesis.put(f, new LinkedList<Hypothesis>(f.hypotheses));
                }
                while (!lFamilies.isEmpty()) {
                    Family selectedFamily = null;
                    Hypothesis bestH = null;
                    for (Family f : lFamilies) {
                        LinkedList lh = (LinkedList)feasibleHypothesis.get(f);
                        LinkedList<Hypothesis> updatelh = new LinkedList<Hypothesis>();
                        for (Hypothesis h : lh) {
                            boolean compatible = this.areCompatible(gh, h);
                            if (!compatible) continue;
                            updatelh.add(h);
                            if (bestH != null && !(h.leaf.score > bestH.leaf.score)) continue;
                            selectedFamily = f;
                            bestH = h;
                        }
                        feasibleHypothesis.put(f, updatelh);
                    }
                    if (bestH == null) break;
                    gh.addHypothesis(bestH);
                    lFamilies.remove(selectedFamily);
                    feasibleHypothesis.remove(selectedFamily);
                }
            }
            this.penalizeFD(gh, t);
            this.penalizeNT(gh, t);
        }
        return gh;
    }

    class BestHypSynchronization {
        GlobalHypothesis bestHyp = null;

        BestHypSynchronization() {
        }
    }
}

