/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin;

import icy.common.listener.ProgressListener;
import icy.file.FileUtil;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.CancelableProgressFrame;
import icy.gui.frame.progress.DownloadFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.SuccessfullAnnounceFrame;
import icy.gui.frame.progress.TaskFrame;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.preferences.RepositoryPreferences;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.update.Updater;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import icy.util.ZipUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class PluginInstaller
implements Runnable {
    private static final String ERROR_DOWNLOAD = "Error while downloading ";
    private static final String ERROR_SAVE = "Error while saving";
    private static final PluginInstaller instance = new PluginInstaller();
    private final List<PluginInstallInfo> installFIFO = new ArrayList<PluginInstallInfo>();
    private final List<PluginInstallInfo> removeFIFO = new ArrayList<PluginInstallInfo>();
    private final EventListenerList listeners = new EventListenerList();
    private final List<PluginDescriptor> installingPlugins = new ArrayList<PluginDescriptor>();
    private final List<PluginDescriptor> desinstallingPlugin = new ArrayList<PluginDescriptor>();

    private PluginInstaller() {
        new Thread((Runnable)this, "Plugin installer").start();
    }

    private static boolean isEnabled() {
        return !PluginLoader.isJCLDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(PluginDescriptor plugin, boolean showProgress) {
        if (plugin != null && PluginInstaller.isEnabled()) {
            if (!NetworkUtil.hasInternetAccess()) {
                String text = "Cannot install '" + plugin.getName() + "' plugin : you are not connected to Internet.";
                if (Icy.getMainInterface().isHeadLess()) {
                    System.err.println(text);
                } else {
                    new FailedAnnounceFrame(text, 10);
                }
                return;
            }
            List<PluginInstallInfo> list = PluginInstaller.instance.installFIFO;
            synchronized (list) {
                PluginInstaller.instance.installFIFO.add(new PluginInstallInfo(plugin, showProgress));
            }
        }
    }

    public static boolean isProcessing() {
        return PluginInstaller.isInstalling() || PluginInstaller.isDesinstalling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PluginInstallInfo> getInstallFIFO() {
        List<PluginInstallInfo> list = PluginInstaller.instance.installFIFO;
        synchronized (list) {
            return new ArrayList<PluginInstallInfo>(PluginInstaller.instance.installFIFO);
        }
    }

    public static void waitInstall() {
        while (PluginInstaller.isInstalling()) {
            ThreadUtil.sleep(100);
        }
    }

    public static boolean isInstalling() {
        return !PluginInstaller.instance.installFIFO.isEmpty() || !PluginInstaller.instance.installingPlugins.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWaitingForInstall(PluginDescriptor plugin) {
        List<PluginInstallInfo> list = PluginInstaller.instance.installFIFO;
        synchronized (list) {
            PluginInstallInfo info;
            Iterator<PluginInstallInfo> iterator = PluginInstaller.instance.installFIFO.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                info = iterator.next();
            } while (plugin != info.plugin);
            return true;
        }
    }

    public static boolean isInstallingPlugin(PluginDescriptor plugin) {
        return PluginInstaller.instance.installingPlugins.indexOf(plugin) != -1 || PluginInstaller.isWaitingForInstall(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void desinstall(PluginDescriptor plugin, boolean showConfirm, boolean showProgress) {
        if (plugin != null && PluginInstaller.isEnabled()) {
            if (showConfirm) {
                List<PluginDescriptor> dependants = PluginInstaller.getLocalDependenciesFrom(plugin);
                String message = "<html>";
                if (!dependants.isEmpty()) {
                    message = String.valueOf(message) + "The following plugin(s) won't work anymore :<br>";
                    for (PluginDescriptor depPlug : dependants) {
                        message = String.valueOf(message) + depPlug.getName() + " " + depPlug.getVersion() + "<br>";
                    }
                    message = String.valueOf(message) + "<br>";
                }
                if (ConfirmDialog.confirm(message = String.valueOf(message) + "Are you sure you want to remove '" + plugin.getName() + " " + plugin.getVersion() + "' ?</html>")) {
                    List<PluginInstallInfo> list = PluginInstaller.instance.removeFIFO;
                    synchronized (list) {
                        PluginInstaller.instance.removeFIFO.add(new PluginInstallInfo(plugin, showConfirm));
                    }
                }
            } else {
                List<PluginInstallInfo> list = PluginInstaller.instance.removeFIFO;
                synchronized (list) {
                    PluginInstaller.instance.removeFIFO.add(new PluginInstallInfo(plugin, showProgress));
                }
            }
        }
    }

    @Deprecated
    public static void desinstall(PluginDescriptor plugin, boolean showConfirm) {
        PluginInstaller.desinstall(plugin, showConfirm, showConfirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PluginInstallInfo> getRemoveFIFO() {
        List<PluginInstallInfo> list = PluginInstaller.instance.removeFIFO;
        synchronized (list) {
            return new ArrayList<PluginInstallInfo>(PluginInstaller.instance.removeFIFO);
        }
    }

    public static void waitDesinstall() {
        while (PluginInstaller.isDesinstalling()) {
            ThreadUtil.sleep(100);
        }
    }

    public static boolean isDesinstalling() {
        return !PluginInstaller.instance.removeFIFO.isEmpty() || !PluginInstaller.instance.desinstallingPlugin.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWaitingForDesinstall(PluginDescriptor plugin) {
        List<PluginInstallInfo> list = PluginInstaller.instance.removeFIFO;
        synchronized (list) {
            PluginInstallInfo info;
            Iterator<PluginInstallInfo> iterator = PluginInstaller.instance.removeFIFO.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                info = iterator.next();
            } while (plugin != info.plugin);
            return true;
        }
    }

    public static boolean isDesinstallingPlugin(PluginDescriptor plugin) {
        return PluginInstaller.instance.desinstallingPlugin.indexOf(plugin) != -1 || PluginInstaller.isWaitingForDesinstall(plugin);
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            if (!this.installFIFO.isEmpty()) {
                ThreadUtil.sleep(200);
                do {
                    this.installInternal();
                } while (!this.installFIFO.isEmpty());
            }
            while (!this.removeFIFO.isEmpty()) {
                ThreadUtil.sleep(200);
                do {
                    this.desinstallInternal();
                } while (!this.removeFIFO.isEmpty());
            }
            ThreadUtil.sleep(100);
        }
    }

    private static String backup(PluginDescriptor plugin) {
        boolean ok;
        boolean bl = ok = Updater.backup(plugin.getJarFilename()) && Updater.backup(plugin.getXMLFilename()) && Updater.backup(plugin.getIconFilename()) && Updater.backup(plugin.getImageFilename());
        if (!ok) {
            return "Can't backup plugin '" + plugin.getName() + "'";
        }
        return "";
    }

    private static String downloadAndSavePlugin(PluginDescriptor plugin, DownloadFrame taskFrame) {
        String pass;
        String login;
        if (taskFrame != null) {
            taskFrame.setMessage("Downloading " + plugin);
        }
        plugin.loadDescriptor();
        RepositoryPreferences.RepositoryInfo repos = plugin.getRepository();
        if (repos.isAuthenticationEnabled()) {
            login = repos.getLogin();
            pass = repos.getPassword();
        } else {
            login = null;
            pass = null;
        }
        String basePath = FileUtil.getDirectory(repos.getLocation());
        URL url = URLUtil.buildURL(basePath, plugin.getJarUrl());
        String result = PluginInstaller.downloadAndSave(url, plugin.getJarFilename(), login, pass, true, taskFrame);
        if (!StringUtil.isEmpty(result)) {
            return result;
        }
        if (!ZipUtil.isValid(plugin.getJarFilename(), false)) {
            return "Downloaded JAR file '" + plugin.getJarFilename() + "' is corrupted !";
        }
        url = URLUtil.buildURL(basePath, plugin.getUrl());
        result = PluginInstaller.downloadAndSave(url, plugin.getXMLFilename(), login, pass, true, taskFrame);
        if (!StringUtil.isEmpty(result)) {
            return result;
        }
        if (XMLUtil.loadDocument(plugin.getXMLFilename()) == null) {
            return "Downloaded XML file '" + plugin.getXMLFilename() + "' is corrupted !";
        }
        if (!StringUtil.isEmpty(plugin.getIconUrl())) {
            url = URLUtil.buildURL(basePath, plugin.getIconUrl());
            PluginInstaller.downloadAndSave(url, plugin.getIconFilename(), login, pass, false, taskFrame);
        }
        if (!StringUtil.isEmpty(plugin.getImageUrl())) {
            url = URLUtil.buildURL(basePath, plugin.getImageUrl());
            PluginInstaller.downloadAndSave(url, plugin.getImageFilename(), login, pass, false, taskFrame);
        }
        return "";
    }

    private static String downloadAndSave(URL downloadPath, String savePath, String login, String pass, boolean displayError, DownloadFrame downloadFrame) {
        byte[] data;
        if (downloadFrame != null) {
            downloadFrame.setPath(FileUtil.getFileName(savePath));
        }
        if ((data = NetworkUtil.download(downloadPath, login, pass, (ProgressListener)downloadFrame, displayError)) == null) {
            return ERROR_DOWNLOAD + downloadPath.toString();
        }
        if (!FileUtil.save(savePath, data, displayError)) {
            System.err.println("Can't write '" + savePath + "' !");
            System.err.println("File may be locked or you don't own the rights to write files here.");
            return ERROR_SAVE + savePath;
        }
        return null;
    }

    private static boolean deletePlugin(PluginDescriptor plugin) {
        if (!FileUtil.delete(plugin.getJarFilename(), false)) {
            System.err.println("Can't delete '" + plugin.getJarFilename() + "' file !");
            return false;
        }
        if (FileUtil.exists(plugin.getXMLFilename()) && !FileUtil.delete(plugin.getXMLFilename(), false)) {
            System.err.println("Can't delete '" + plugin.getXMLFilename() + "' file !");
        }
        FileUtil.delete(plugin.getImageFilename(), false);
        FileUtil.delete(plugin.getIconFilename(), false);
        return true;
    }

    public static void getLocalDependenciesOf(List<PluginDescriptor> result, PluginDescriptor plugin) {
        plugin.loadDescriptor();
        for (PluginDescriptor.PluginIdent ident : plugin.getRequired()) {
            PluginDescriptor dep;
            if (PluginDescriptor.getPlugin(result, ident, true) != null || (dep = PluginLoader.getPlugin(ident, true)) == null) continue;
            PluginDescriptor.addToList(result, dep);
            PluginInstaller.getLocalDependenciesOf(result, dep);
        }
    }

    public static List<PluginDescriptor> getLocalDependenciesFrom(List<PluginDescriptor> plugins) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        for (PluginDescriptor plugin : plugins) {
            PluginInstaller.getLocalDependenciesFrom(plugin, result);
        }
        return result;
    }

    public static List<PluginDescriptor> getLocalDependenciesFrom(PluginDescriptor plugin) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        PluginInstaller.getLocalDependenciesFrom(plugin, result);
        return result;
    }

    private static void getLocalDependenciesFrom(PluginDescriptor plugin, List<PluginDescriptor> result) {
        for (PluginDescriptor curPlug : PluginLoader.getPlugins(false)) {
            if (!curPlug.requires(plugin)) continue;
            PluginDescriptor.addToList(result, curPlug);
        }
    }

    private static void getLocalDependenciesOf(List<PluginDescriptor> result, List<PluginDescriptor> sources, PluginDescriptor plugin) {
        plugin.loadDescriptor();
        for (PluginDescriptor.PluginIdent ident : plugin.getRequired()) {
            PluginDescriptor dep;
            if (ident == null || PluginDescriptor.getPlugin(result, ident, true) != null || (dep = PluginDescriptor.getPlugin(sources, ident, true)) == null) continue;
            PluginDescriptor.addToList(result, dep);
            PluginInstaller.getLocalDependenciesOf(result, sources, dep);
        }
    }

    public static List<PluginDescriptor> orderDependencies(List<PluginDescriptor> plugins) {
        ArrayList<PluginDescriptor> sources = new ArrayList<PluginDescriptor>(plugins);
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        while (sources.size() > 0) {
            ArrayList deps = new ArrayList();
            PluginInstaller.getLocalDependenciesOf(result, sources, (PluginDescriptor)sources.get(0));
            int i = deps.size() - 1;
            while (i >= 0) {
                PluginDescriptor.addToList(result, (PluginDescriptor)deps.get(i));
                --i;
            }
            PluginDescriptor.addToList(result, (PluginDescriptor)sources.get(0));
            sources.removeAll(result);
        }
        return result;
    }

    public static boolean getDependencies(PluginDescriptor plugin, List<PluginDescriptor> pluginsToInstall, CancelableProgressFrame taskFrame, boolean showError) {
        plugin.loadDescriptor();
        for (PluginDescriptor.PluginIdent ident : plugin.getRequired()) {
            if (taskFrame != null && taskFrame.isCancelRequested()) {
                return false;
            }
            if (ident == null || PluginDescriptor.getPlugin(pluginsToInstall, ident, true) != null) continue;
            String className = ident.getClassName();
            PluginDescriptor localPlugin = PluginLoader.getPlugin(className);
            PluginDescriptor onlinePlugin = PluginRepositoryLoader.getPlugin(className);
            if (localPlugin == null || ident.getVersion().isGreater(localPlugin.getVersion())) {
                if (onlinePlugin == null) {
                    if (showError) {
                        System.err.println("Can't resolve dependencies for plugin '" + plugin.getName() + "' :");
                        if (localPlugin == null) {
                            System.err.println("Plugin class '" + ident.getClassName() + " not found !");
                        } else {
                            System.err.println(String.valueOf(localPlugin.getName()) + " " + localPlugin.getVersion() + " installed");
                            System.err.println("but version " + ident.getVersion() + " or greater needed.");
                        }
                    }
                    return false;
                }
                if (ident.getVersion().isGreater(onlinePlugin.getVersion())) {
                    if (showError) {
                        System.err.println("Can't resolve dependencies for plugin '" + plugin.getName() + "' :");
                        System.err.println(String.valueOf(onlinePlugin.getName()) + " " + onlinePlugin.getVersion() + " found in repository");
                        System.err.println("but version " + ident.getVersion() + " or greater needed.");
                    }
                    return false;
                }
                PluginDescriptor.addToList(pluginsToInstall, onlinePlugin);
                if (PluginInstaller.getDependencies(onlinePlugin, pluginsToInstall, taskFrame, showError)) continue;
                return false;
            }
            if (onlinePlugin == null || !localPlugin.getVersion().isLower(onlinePlugin.getVersion())) continue;
            PluginDescriptor.addToList(pluginsToInstall, onlinePlugin);
            if (PluginInstaller.getDependencies(onlinePlugin, pluginsToInstall, taskFrame, showError)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installInternal() {
        TaskFrame taskFrame = null;
        try {
            boolean showProgress;
            List<PluginInstallInfo> list = this.installFIFO;
            synchronized (list) {
                ArrayList<PluginInstallInfo> infos = new ArrayList<PluginInstallInfo>(this.installFIFO);
                showProgress = false;
                int i = infos.size() - 1;
                while (i >= 0) {
                    PluginInstallInfo info = (PluginInstallInfo)infos.get(i);
                    PluginDescriptor.addToList(this.installingPlugins, info.plugin);
                    showProgress |= info.showProgress;
                    --i;
                }
                this.installFIFO.clear();
            }
            if (showProgress && !Icy.getMainInterface().isHeadLess()) {
                taskFrame = new DownloadFrame();
                ((ProgressFrame)taskFrame).setMessage("Initializing...");
            }
            List<PluginDescriptor> dependencies = new ArrayList<PluginDescriptor>();
            HashSet<PluginDescriptor> pluginsOk = new HashSet<PluginDescriptor>();
            HashSet<PluginDescriptor> pluginsNOk = new HashSet<PluginDescriptor>();
            HashSet<PluginDescriptor> pluginsNewJava = new HashSet<PluginDescriptor>();
            int i = this.installingPlugins.size() - 1;
            while (i >= 0) {
                PluginDescriptor pluginDescriptor = this.installingPlugins.get(i);
                String plugDesc = String.valueOf(pluginDescriptor.getName()) + " " + pluginDescriptor.getVersion();
                if (taskFrame != null) {
                    if (((CancelableProgressFrame)taskFrame).isCancelRequested()) {
                        return;
                    }
                    ((ProgressFrame)taskFrame).setMessage("Checking dependencies for '" + plugDesc + "' ...");
                }
                if (!PluginInstaller.getDependencies(pluginDescriptor, dependencies, (CancelableProgressFrame)taskFrame, true)) {
                    pluginsNOk.add(pluginDescriptor);
                    this.installingPlugins.remove(i);
                }
                --i;
            }
            if (this.installingPlugins.isEmpty()) {
                return;
            }
            dependencies = PluginInstaller.orderDependencies(dependencies);
            for (PluginDescriptor plugin : dependencies) {
                PluginDescriptor.addToList(this.installingPlugins, plugin, 0);
            }
            String error = "";
            FileUtil.delete(Updater.BACKUP_DIRECTORY, true);
            for (PluginDescriptor pluginDescriptor : this.installingPlugins) {
                for (PluginDescriptor.PluginIdent ident : pluginDescriptor.getRequired()) {
                    if (!PluginDescriptor.existInList(pluginsNOk, ident)) continue;
                    pluginsNOk.add(pluginDescriptor);
                }
                String plugDesc = String.valueOf(pluginDescriptor.getName()) + " " + pluginDescriptor.getVersion();
                if (taskFrame != null) {
                    if (((CancelableProgressFrame)taskFrame).isCancelRequested()) break;
                    ((ProgressFrame)taskFrame).setMessage("Installing " + plugDesc + "...");
                }
                try {
                    error = PluginInstaller.backup(pluginDescriptor);
                    if (StringUtil.isEmpty(error) && !StringUtil.isEmpty(error = PluginInstaller.downloadAndSavePlugin(pluginDescriptor, (DownloadFrame)taskFrame))) {
                        Updater.restore();
                    }
                }
                finally {
                    FileUtil.delete(Updater.BACKUP_DIRECTORY, true);
                }
                if (StringUtil.isEmpty(error)) {
                    pluginsOk.add(pluginDescriptor);
                    continue;
                }
                pluginsNOk.add(pluginDescriptor);
                System.err.println(error);
            }
            if (taskFrame != null) {
                ((ProgressFrame)taskFrame).setMessage("Verifying plugins...");
            }
            PluginLoader.reload();
            for (PluginDescriptor pluginDescriptor : pluginsOk) {
                error = PluginLoader.verifyPlugin(pluginDescriptor);
                if (StringUtil.isEmpty(error)) continue;
                String mess = "Fatal error while loading '" + pluginDescriptor.getClassName() + "' class from " + pluginDescriptor.getJarFilename() + " :\n" + error;
                if (error.contains("Newer java version required")) {
                    System.err.println(mess);
                    pluginsNewJava.add(pluginDescriptor);
                    continue;
                }
                IcyExceptionHandler.report(pluginDescriptor, "An error occured while installing the plugin :\n" + error);
                System.err.println(mess);
                pluginsNOk.add(pluginDescriptor);
            }
            pluginsOk.removeAll(pluginsNOk);
            pluginsOk.removeAll(pluginsNewJava);
            if (!pluginsNOk.isEmpty()) {
                System.err.println();
                System.err.println("Installation of the following plugin(s) failed:");
                for (PluginDescriptor pluginDescriptor : pluginsNOk) {
                    System.err.println(String.valueOf(pluginDescriptor.getName()) + " " + pluginDescriptor.getVersion());
                    this.fireInstalledEvent(pluginDescriptor, false);
                }
                System.err.println();
            }
            if (!pluginsOk.isEmpty()) {
                System.out.println();
                System.out.println("The following plugin(s) has been correctly installed:");
                for (PluginDescriptor pluginDescriptor : pluginsOk) {
                    System.out.println(String.valueOf(pluginDescriptor.getName()) + " " + pluginDescriptor.getVersion());
                    this.fireInstalledEvent(pluginDescriptor, true);
                }
                System.out.println();
            }
            if (!pluginsNewJava.isEmpty()) {
                System.err.println();
                System.err.println("The following plugin(s) require a newer version of java:");
                for (PluginDescriptor pluginDescriptor : pluginsNewJava) {
                    System.err.println(String.valueOf(pluginDescriptor.getName()) + " " + pluginDescriptor.getVersion());
                    this.fireInstalledEvent(pluginDescriptor, false);
                }
                System.err.println();
            }
            if (showProgress && !Icy.getMainInterface().isHeadLess()) {
                if (pluginsOk.isEmpty()) {
                    new FailedAnnounceFrame("Plugin(s) installation failed !", 10);
                } else if (pluginsNOk.isEmpty() && pluginsNewJava.isEmpty()) {
                    new SuccessfullAnnounceFrame("Plugin(s) installation was successful !", 10);
                } else if (!pluginsNOk.isEmpty()) {
                    new FailedAnnounceFrame("Some plugin(s) installation failed (looks at the output console for detail) !", 10);
                }
                for (PluginDescriptor pluginDescriptor : pluginsNewJava) {
                    new AnnounceFrame("Plugin '" + pluginDescriptor.getName() + " requires a new version of Java !", 10);
                }
            }
        }
        finally {
            this.installingPlugins.clear();
            if (taskFrame != null) {
                taskFrame.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void desinstallInternal() {
        TaskFrame taskFrame = null;
        try {
            boolean showProgress;
            List<PluginInstallInfo> list = this.removeFIFO;
            synchronized (list) {
                ArrayList<PluginInstallInfo> infos = new ArrayList<PluginInstallInfo>(this.removeFIFO);
                showProgress = false;
                int i = infos.size() - 1;
                while (i >= 0) {
                    PluginInstallInfo info = (PluginInstallInfo)infos.get(i);
                    this.desinstallingPlugin.add(info.plugin);
                    showProgress |= info.showProgress;
                    --i;
                }
                this.removeFIFO.clear();
            }
            if (showProgress && !Icy.getMainInterface().isHeadLess()) {
                taskFrame = new CancelableProgressFrame("Initializing...");
            }
            for (PluginDescriptor plugin : this.desinstallingPlugin) {
                String plugDesc = String.valueOf(plugin.getName()) + " " + plugin.getVersion();
                if (taskFrame != null) {
                    if (((CancelableProgressFrame)taskFrame).isCancelRequested()) {
                        return;
                    }
                    ((ProgressFrame)taskFrame).setMessage("Removing plugin '" + plugDesc + "'...");
                }
                boolean result = PluginInstaller.deletePlugin(plugin);
                this.fireRemovedEvent(plugin, result);
                if (showProgress && !Icy.getMainInterface().isHeadLess() && !result) {
                    new FailedAnnounceFrame("Plugin '" + plugDesc + "' delete operation failed !");
                }
                if (result) {
                    System.out.println("Plugin '" + plugDesc + "' correctly removed.");
                    continue;
                }
                System.err.println("Plugin '" + plugDesc + "' delete operation failed !");
            }
        }
        finally {
            if (taskFrame != null) {
                taskFrame.close();
            }
            this.desinstallingPlugin.clear();
        }
        PluginLoader.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(PluginInstallerListener listener) {
        EventListenerList eventListenerList = PluginInstaller.instance.listeners;
        synchronized (eventListenerList) {
            PluginInstaller.instance.listeners.add(PluginInstallerListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(PluginInstallerListener listener) {
        EventListenerList eventListenerList = PluginInstaller.instance.listeners;
        synchronized (eventListenerList) {
            PluginInstaller.instance.listeners.remove(PluginInstallerListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInstalledEvent(PluginDescriptor plugin, boolean success) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            PluginInstallerListener[] pluginInstallerListenerArray = (PluginInstallerListener[])this.listeners.getListeners(PluginInstallerListener.class);
            int n = pluginInstallerListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginInstallerListener listener = pluginInstallerListenerArray[n2];
                listener.pluginInstalled(plugin, success);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemovedEvent(PluginDescriptor plugin, boolean success) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            PluginInstallerListener[] pluginInstallerListenerArray = (PluginInstallerListener[])this.listeners.getListeners(PluginInstallerListener.class);
            int n = pluginInstallerListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginInstallerListener listener = pluginInstallerListenerArray[n2];
                listener.pluginRemoved(plugin, success);
                ++n2;
            }
        }
    }

    private static class PluginInstallInfo {
        final PluginDescriptor plugin;
        final boolean showProgress;

        public PluginInstallInfo(PluginDescriptor plugin, boolean showProgress) {
            this.plugin = plugin;
            this.showProgress = showProgress;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PluginInstallInfo) {
                return ((PluginInstallInfo)obj).plugin.equals(this.plugin);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.plugin.hashCode();
        }
    }

    public static interface PluginInstallerListener
    extends EventListener {
        public void pluginInstalled(PluginDescriptor var1, boolean var2);

        public void pluginRemoved(PluginDescriptor var1, boolean var2);
    }
}

