/*
 * Decompiled with CFR 0.152.
 */
package icy.workspace;

import icy.file.FileUtil;
import icy.system.thread.SingleProcessor;
import icy.system.thread.ThreadUtil;
import icy.workspace.Workspace;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class WorkspaceLoader {
    public static final String WORKSPACE_PATH = "workspace";
    public static final String EXT = ".xml";
    private static final WorkspaceLoader instance = new WorkspaceLoader();
    private ArrayList<Workspace> workspaces = new ArrayList();
    private final EventListenerList listeners = new EventListenerList();
    private final Runnable reloader = new Runnable(){

        @Override
        public void run() {
            WorkspaceLoader.this.reloadInternal();
        }
    };
    final SingleProcessor processor = new SingleProcessor(true, "Local Workspace Loader");
    private boolean initialized = false;

    private WorkspaceLoader() {
    }

    public static void prepare() {
        if (!WorkspaceLoader.instance.initialized) {
            if (WorkspaceLoader.isLoading()) {
                WorkspaceLoader.waitWhileLoading();
            } else {
                WorkspaceLoader.reload();
            }
        }
    }

    public static void reloadAsynch() {
        WorkspaceLoader.instance.processor.submit(WorkspaceLoader.instance.reloader);
    }

    @Deprecated
    public static void reload_asynch() {
        WorkspaceLoader.reloadAsynch();
    }

    public static void reload() {
        WorkspaceLoader.reloadAsynch();
        WorkspaceLoader.waitWhileLoading();
    }

    void reloadInternal() {
        File[] files;
        ArrayList<Workspace> newWorkspaces = new ArrayList<Workspace>();
        File[] fileArray = files = FileUtil.getFiles(new File(FileUtil.getGenericPath(WORKSPACE_PATH)), new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileUtil.getFileExtension(file.getPath(), true).toLowerCase().equals(WorkspaceLoader.EXT);
            }
        }, true, false, false);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Workspace workspace = new Workspace(file);
            if (!workspace.getName().equals("sys")) {
                if (workspace.isEmpty()) {
                    System.err.println("Empty workspace '" + workspace.getName() + "' is not loaded");
                } else {
                    newWorkspaces.add(workspace);
                }
            }
            ++n2;
        }
        Collections.sort(newWorkspaces);
        this.workspaces = newWorkspaces;
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Workspace> getWorkspaces() {
        WorkspaceLoader.prepare();
        ArrayList<Workspace> arrayList = WorkspaceLoader.instance.workspaces;
        synchronized (arrayList) {
            return new ArrayList<Workspace>(WorkspaceLoader.instance.workspaces);
        }
    }

    public static boolean isLoading() {
        return WorkspaceLoader.instance.processor.isProcessing();
    }

    public static void waitWhileLoading() {
        while (WorkspaceLoader.isLoading()) {
            ThreadUtil.sleep(10);
        }
    }

    public static boolean isLoaded(Workspace workspace) {
        return WorkspaceLoader.getWorkspace(workspace.getName()) != null;
    }

    public static Workspace getWorkspace(String name) {
        WorkspaceLoader.prepare();
        return Workspace.getWorkspace(WorkspaceLoader.getWorkspaces(), name);
    }

    private void changed() {
        this.initialized = true;
        this.fireEvent(new WorkspaceLoaderEvent(WorkspaceLoaderEvent.WorkspaceLoaderEventType.RELOADED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(WorkspaceLoaderListener listener) {
        EventListenerList eventListenerList = WorkspaceLoader.instance.listeners;
        synchronized (eventListenerList) {
            WorkspaceLoader.instance.listeners.add(WorkspaceLoaderListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(WorkspaceLoaderListener listener) {
        EventListenerList eventListenerList = WorkspaceLoader.instance.listeners;
        synchronized (eventListenerList) {
            WorkspaceLoader.instance.listeners.remove(WorkspaceLoaderListener.class, listener);
        }
    }

    private void fireEvent(WorkspaceLoaderEvent e) {
        WorkspaceLoaderListener[] workspaceLoaderListenerArray = (WorkspaceLoaderListener[])this.listeners.getListeners(WorkspaceLoaderListener.class);
        int n = workspaceLoaderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceLoaderListener listener = workspaceLoaderListenerArray[n2];
            listener.workspaceLoaderChanged(e);
            ++n2;
        }
    }

    public static class WorkspaceLoaderEvent {
        private final WorkspaceLoaderEventType type;

        public WorkspaceLoaderEvent(WorkspaceLoaderEventType type) {
            this.type = type;
        }

        public WorkspaceLoaderEventType getType() {
            return this.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof WorkspaceLoaderEvent) {
                WorkspaceLoaderEvent e = (WorkspaceLoaderEvent)obj;
                return this.type == e.getType();
            }
            return super.equals(obj);
        }

        public static enum WorkspaceLoaderEventType {
            RELOADED;

        }
    }

    public static interface WorkspaceLoaderListener
    extends EventListener {
        public void workspaceLoaderChanged(WorkspaceLoaderEvent var1);
    }
}

