/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology.watershed;

import icy.sequence.Sequence;
import icy.sequence.VolumetricImageCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import plugins.kernel.roi.morphology.watershed.LabeledPixel;
import plugins.kernel.roi.morphology.watershed.Point3D;

public class FloodingStructure {
    private Sequence distanceMap;
    private Sequence labelSequence;
    private int frame;
    private List<LabeledPixel> labeledPixels;
    private Set<Double> heights;
    private List<LabeledPixel> finalFloodingPixels;
    private Set<Double> finalHeights;

    private FloodingStructure() {
    }

    public void setDistanceMap(Sequence distanceMap) {
        this.distanceMap = distanceMap;
    }

    public void setLabelSequence(Sequence labelSequence) {
        this.labelSequence = labelSequence;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void compute() {
        this.finalFloodingPixels = null;
        this.finalHeights = null;
        VolumetricImageCursor distanceMapCursor = new VolumetricImageCursor(this.distanceMap, this.frame);
        VolumetricImageCursor labelSequenceCursor = new VolumetricImageCursor(this.labelSequence, this.frame);
        int rowSize = this.distanceMap.getSizeX();
        int planeSize = rowSize * this.distanceMap.getSizeY();
        int volumeSize = planeSize * this.distanceMap.getSizeZ();
        this.labeledPixels = new ArrayList<LabeledPixel>(volumeSize);
        this.heights = new TreeSet<Double>();
        ArrayList<LabeledPixel> seedPixels = new ArrayList<LabeledPixel>();
        double maxHeight = -1.7976931348623157E308;
        int k = 0;
        while (k < this.distanceMap.getSizeZ()) {
            int kOffset = k * planeSize;
            int j = 0;
            while (j < this.distanceMap.getSizeY()) {
                int jOffset = j * rowSize;
                int i = 0;
                while (i < this.distanceMap.getSizeX()) {
                    double height = distanceMapCursor.get(i, j, k, 0);
                    if (height == 0.0) {
                        this.labeledPixels.add(null);
                    } else {
                        int label;
                        LabeledPixel currentPixel = new LabeledPixel(new Point3D(i, j, k), height);
                        this.labeledPixels.add(currentPixel);
                        this.heights.add(height);
                        if (maxHeight < height) {
                            maxHeight = height;
                        }
                        if ((label = (int)labelSequenceCursor.get(i, j, k, 0)) > 0) {
                            currentPixel.setLabel(label);
                            seedPixels.add(currentPixel);
                        }
                        if (k - 1 > 0) {
                            this.setNeighborhood(currentPixel, kOffset - planeSize + jOffset + i);
                        }
                        if (j - 1 > 0) {
                            this.setNeighborhood(currentPixel, kOffset + (jOffset - rowSize) + i);
                        }
                        if (i - 1 > 0) {
                            this.setNeighborhood(currentPixel, kOffset + jOffset + (i - 1));
                        }
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        if (!seedPixels.isEmpty()) {
            this.heights.add(maxHeight + 1.0);
            for (LabeledPixel p2 : seedPixels) {
                p2.setHeight(maxHeight + 1.0);
            }
        }
        Comparator.comparingDouble(LabeledPixel::getHeight);
        this.labeledPixels = this.labeledPixels.stream().filter(p -> p != null).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    private void setNeighborhood(LabeledPixel pixel, int neighborPosition) {
        LabeledPixel neighborPixel = this.labeledPixels.get(neighborPosition);
        if (neighborPixel != null) {
            pixel.addNeighbor(neighborPixel);
            neighborPixel.addNeighbor(pixel);
        }
    }

    public List<LabeledPixel> getFloodingPixels() {
        if (this.finalFloodingPixels == null) {
            this.finalFloodingPixels = Collections.unmodifiableList(this.labeledPixels);
        }
        return this.finalFloodingPixels;
    }

    public Set<Double> getHeights() {
        if (this.finalHeights == null) {
            this.finalHeights = Collections.unmodifiableSet(this.heights);
        }
        return this.finalHeights;
    }

    /* synthetic */ FloodingStructure(FloodingStructure floodingStructure) {
        this();
    }

    public static class Builder {
        private Sequence distanceMap;
        private Sequence labelSequence;
        private int frame;

        public Builder(Sequence distanceMap, Sequence labelSequence) {
            this.distanceMap = distanceMap;
            this.labelSequence = labelSequence;
        }

        public Builder setFrame(int frame) {
            this.frame = frame;
            return this;
        }

        public FloodingStructure build() {
            FloodingStructure structure = new FloodingStructure(null);
            structure.setDistanceMap(this.distanceMap);
            structure.setLabelSequence(this.labelSequence);
            structure.setFrame(this.frame);
            structure.compute();
            return structure;
        }
    }
}

