/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.plugin.filter.Convolver;
import ij.process.ByteProcessor;
import ij.process.DownsizeTable;
import ij.process.FloatBlitter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.util.Random;

public class FloatProcessor
extends ImageProcessor {
    private float min;
    private float max;
    private float snapshotMin;
    private float snapshotMax;
    private float[] pixels;
    protected byte[] pixels8;
    private float[] snapshotPixels = null;
    private float fillColor = Float.MAX_VALUE;
    private boolean fixedScale = false;
    private float bgValue;

    public FloatProcessor(int width, int height, float[] pixels) {
        this(width, height, pixels, null);
    }

    public FloatProcessor(int width, int height, float[] pixels, ColorModel cm) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.cm = cm;
        this.resetRoi();
    }

    public FloatProcessor(int width, int height) {
        this(width, height, new float[width * height], null);
    }

    public FloatProcessor(int width, int height, int[] pixels) {
        this(width, height);
        for (int i = 0; i < pixels.length; ++i) {
            this.pixels[i] = pixels[i];
        }
    }

    public FloatProcessor(int width, int height, double[] pixels) {
        this(width, height);
        for (int i = 0; i < pixels.length; ++i) {
            this.pixels[i] = (float)pixels[i];
        }
    }

    public FloatProcessor(float[][] array) {
        this.width = array.length;
        this.height = array[0].length;
        this.pixels = new float[this.width * this.height];
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.pixels[i++] = array[x][y];
            }
        }
        this.resetRoi();
    }

    public FloatProcessor(int[][] array) {
        this.width = array.length;
        this.height = array[0].length;
        this.pixels = new float[this.width * this.height];
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.pixels[i++] = array[x][y];
            }
        }
        this.resetRoi();
    }

    public void findMinAndMax() {
        if (this.fixedScale) {
            return;
        }
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        for (int i = 0; i < this.width * this.height; ++i) {
            float value = this.pixels[i];
            if (Float.isInfinite(value)) continue;
            if (value < this.min) {
                this.min = value;
            }
            if (!(value > this.max)) continue;
            this.max = value;
        }
        this.minMaxSet = true;
    }

    @Override
    public void setMinAndMax(double minimum, double maximum) {
        if (minimum == 0.0 && maximum == 0.0) {
            this.resetMinAndMax();
            return;
        }
        this.min = (float)minimum;
        this.max = (float)maximum;
        this.fixedScale = true;
        this.minMaxSet = true;
        this.resetThreshold();
    }

    @Override
    public void resetMinAndMax() {
        this.fixedScale = false;
        this.findMinAndMax();
        this.resetThreshold();
    }

    @Override
    public double getMin() {
        if (!this.minMaxSet) {
            this.findMinAndMax();
        }
        return this.min;
    }

    @Override
    public double getMax() {
        if (!this.minMaxSet) {
            this.findMinAndMax();
        }
        return this.max;
    }

    @Override
    public Image createImage() {
        block6: {
            boolean thresholding;
            boolean firstTime = this.pixels8 == null;
            boolean bl = thresholding = this.minThreshold != -808080.0 && this.lutUpdateMode < 2;
            if (firstTime || !this.lutAnimation) {
                this.create8BitImage(thresholding && this.lutUpdateMode == 0);
            }
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            if (!thresholding) break block6;
            int size = this.width * this.height;
            if (this.lutUpdateMode == 1) {
                for (int i = 0; i < size; ++i) {
                    double value = this.pixels[i];
                    this.pixels8[i] = value >= this.minThreshold && value <= this.maxThreshold ? -1 : 0;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    double value = this.pixels[i];
                    if (!(value >= this.minThreshold) || !(value <= this.maxThreshold)) continue;
                    this.pixels8[i] = -1;
                }
            }
        }
        return this.createBufferedImage();
    }

    private byte[] create8BitImage(boolean thresholding) {
        int size = this.width * this.height;
        if (this.pixels8 == null) {
            this.pixels8 = new byte[size];
        }
        double min2 = this.getMin();
        double max2 = this.getMax();
        double scale = 255.0 / (max2 - min2);
        int maxValue = thresholding ? 254 : 255;
        for (int i = 0; i < size; ++i) {
            int ivalue;
            double value = (double)this.pixels[i] - min2;
            if (value < 0.0) {
                value = 0.0;
            }
            if ((ivalue = (int)(value * scale + 0.5)) > maxValue) {
                ivalue = maxValue;
            }
            this.pixels8[i] = (byte)ivalue;
        }
        return this.pixels8;
    }

    @Override
    byte[] create8BitImage() {
        return this.create8BitImage(false);
    }

    Image createBufferedImage() {
        if (this.raster == null) {
            SampleModel sm = this.getIndexSampleModel();
            DataBufferByte db = new DataBufferByte(this.pixels8, this.width * this.height, 0);
            this.raster = Raster.createWritableRaster(sm, db, null);
        }
        if (this.image == null || this.cm != this.cm2) {
            if (this.cm == null) {
                this.cm = this.getDefaultColorModel();
            }
            this.image = new BufferedImage(this.cm, this.raster, false, null);
            this.cm2 = this.cm;
        }
        this.lutAnimation = false;
        return this.image;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.convertToByte(true).getBufferedImage();
    }

    @Override
    public ImageProcessor createProcessor(int width, int height) {
        FloatProcessor ip2 = new FloatProcessor(width, height, new float[width * height], this.getColorModel());
        ((ImageProcessor)ip2).setMinAndMax(this.getMin(), this.getMax());
        ip2.setInterpolationMethod(this.interpolationMethod);
        return ip2;
    }

    @Override
    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        this.snapshotMin = (float)this.getMin();
        this.snapshotMax = (float)this.getMax();
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new float[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
    }

    @Override
    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        this.min = this.snapshotMin;
        this.max = this.snapshotMax;
        this.minMaxSet = true;
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
    }

    @Override
    public void reset(ImageProcessor mask) {
        if (mask == null || this.snapshotPixels == null) {
            return;
        }
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                if (mpixels[mi++] == 0) {
                    this.pixels[i] = this.snapshotPixels[i];
                }
                ++i;
            }
            ++y;
            ++my;
        }
    }

    @Override
    public void swapPixelArrays() {
        if (this.snapshotPixels == null) {
            return;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            float pixel = this.pixels[i];
            this.pixels[i] = this.snapshotPixels[i];
            this.snapshotPixels[i] = pixel;
        }
    }

    @Override
    public void setSnapshotPixels(Object pixels) {
        this.snapshotPixels = (float[])pixels;
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
    }

    @Override
    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    @Override
    public int getPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return Float.floatToIntBits(this.pixels[y * this.width + x]);
        }
        return 0;
    }

    @Override
    public final int get(int x, int y) {
        return Float.floatToIntBits(this.pixels[y * this.width + x]);
    }

    @Override
    public final void set(int x, int y, int value) {
        this.pixels[y * this.width + x] = Float.intBitsToFloat(value);
    }

    @Override
    public final int get(int index) {
        return Float.floatToIntBits(this.pixels[index]);
    }

    @Override
    public final void set(int index, int value) {
        this.pixels[index] = Float.intBitsToFloat(value);
    }

    @Override
    public final float getf(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    @Override
    public final void setf(int x, int y, float value) {
        this.pixels[y * this.width + x] = value;
    }

    @Override
    public final float getf(int index) {
        return this.pixels[index];
    }

    @Override
    public final void setf(int index, float value) {
        this.pixels[index] = value;
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray) {
        if (iArray == null) {
            iArray = new int[]{(int)this.getPixelValue(x, y)};
        }
        return iArray;
    }

    @Override
    public final void putPixel(int x, int y, int[] iArray) {
        this.putPixelValue(x, y, iArray[0]);
    }

    @Override
    public double getInterpolatedPixel(double x, double y) {
        if (this.interpolationMethod == 2) {
            return this.getBicubicInterpolatedPixel(x, y, this);
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (x >= (double)this.width - 1.0) {
            x = (double)this.width - 1.001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y >= (double)this.height - 1.0) {
            y = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(x, y, this.pixels);
    }

    @Override
    public final int getPixelInterpolated(double x, double y) {
        if (this.interpolationMethod == 1) {
            if (x < 0.0 || y < 0.0 || x >= (double)(this.width - 1) || y >= (double)(this.height - 1)) {
                return 0;
            }
            return Float.floatToIntBits((float)this.getInterpolatedPixel(x, y, this.pixels));
        }
        if (this.interpolationMethod == 2) {
            return Float.floatToIntBits((float)this.getBicubicInterpolatedPixel(x, y, this));
        }
        return this.getPixel((int)(x + 0.5), (int)(y + 0.5));
    }

    @Override
    public final void putPixel(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = Float.intBitsToFloat(value);
        }
    }

    @Override
    public void putPixelValue(int x, int y, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = (float)value;
        }
    }

    @Override
    public float getPixelValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x];
        }
        return Float.NaN;
    }

    @Override
    public void drawPixel(int x, int y) {
        if (x >= this.clipXMin && x <= this.clipXMax && y >= this.clipYMin && y <= this.clipYMax) {
            this.putPixel(x, y, Float.floatToIntBits(this.fillColor));
        }
    }

    @Override
    public Object getPixels() {
        return this.pixels;
    }

    @Override
    public Object getPixelsCopy() {
        if (this.snapshotCopyMode && this.snapshotPixels != null) {
            this.snapshotCopyMode = false;
            return this.snapshotPixels;
        }
        float[] pixels2 = new float[this.width * this.height];
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return pixels2;
    }

    @Override
    public void setPixels(Object pixels) {
        this.pixels = (float[])pixels;
        this.resetPixels(pixels);
        if (pixels == null) {
            this.snapshotPixels = null;
        }
        if (pixels == null) {
            this.pixels8 = null;
        }
    }

    @Override
    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        ip = ip.convertToFloat();
        new FloatBlitter(this).copyBits(ip, xloc, yloc, mode);
    }

    @Override
    public void applyTable(int[] lut) {
    }

    private void process(int op, double value) {
        float c = (float)value;
        float min2 = 0.0f;
        float max2 = 0.0f;
        if (op == 0) {
            min2 = (float)this.getMin();
            max2 = (float)this.getMax();
        }
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                float v2;
                float v1 = this.pixels[i];
                switch (op) {
                    case 0: {
                        v2 = max2 - (v1 - min2);
                        break;
                    }
                    case 1: {
                        v2 = this.fillColor;
                        break;
                    }
                    case 15: {
                        v2 = c;
                        break;
                    }
                    case 2: {
                        v2 = v1 + c;
                        break;
                    }
                    case 3: {
                        v2 = v1 * c;
                        break;
                    }
                    case 7: {
                        if (v1 <= 0.0f) {
                            v2 = 0.0f;
                            break;
                        }
                        v2 = (float)Math.exp((double)c * Math.log(v1));
                        break;
                    }
                    case 8: {
                        v2 = (float)Math.log(v1);
                        break;
                    }
                    case 13: {
                        v2 = (float)Math.exp(v1);
                        break;
                    }
                    case 11: {
                        v2 = v1 * v1;
                        break;
                    }
                    case 12: {
                        if (v1 <= 0.0f) {
                            v2 = 0.0f;
                            break;
                        }
                        v2 = (float)Math.sqrt(v1);
                        break;
                    }
                    case 14: {
                        v2 = Math.abs(v1);
                        break;
                    }
                    case 9: {
                        if ((double)v1 < value) {
                            v2 = (float)value;
                            break;
                        }
                        v2 = v1;
                        break;
                    }
                    case 10: {
                        if ((double)v1 > value) {
                            v2 = (float)value;
                            break;
                        }
                        v2 = v1;
                        break;
                    }
                    default: {
                        v2 = v1;
                    }
                }
                this.pixels[i++] = v2;
            }
        }
    }

    @Override
    public void invert() {
        this.process(0, 0.0);
    }

    @Override
    public void add(int value) {
        this.process(2, value);
    }

    @Override
    public void add(double value) {
        this.process(2, value);
    }

    @Override
    public void set(double value) {
        this.process(15, value);
    }

    @Override
    public void multiply(double value) {
        this.process(3, value);
    }

    @Override
    public void and(int value) {
    }

    @Override
    public void or(int value) {
    }

    @Override
    public void xor(int value) {
    }

    @Override
    public void gamma(double value) {
        this.process(7, value);
    }

    @Override
    public void log() {
        this.process(8, 0.0);
    }

    @Override
    public void exp() {
        this.process(13, 0.0);
    }

    @Override
    public void sqr() {
        this.process(11, 0.0);
    }

    @Override
    public void sqrt() {
        this.process(12, 0.0);
    }

    @Override
    public void abs() {
        this.process(14, 0.0);
    }

    @Override
    public void min(double value) {
        this.process(9, value);
    }

    @Override
    public void max(double value) {
        this.process(10, value);
    }

    @Override
    public void fill() {
        this.process(1, 0.0);
    }

    @Override
    public void fill(ImageProcessor mask) {
        if (mask == null) {
            this.fill();
            return;
        }
        int roiWidth = this.roiWidth;
        int roiHeight = this.roiHeight;
        int roiX = this.roiX;
        int roiY = this.roiY;
        if (mask.getWidth() != roiWidth || mask.getHeight() != roiHeight) {
            return;
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = roiY;
        int my = 0;
        while (y < roiY + roiHeight) {
            int i = y * this.width + roiX;
            int mi = my * roiWidth;
            for (int x = roiX; x < roiX + roiWidth; ++x) {
                if (mpixels[mi++] != 0) {
                    this.pixels[i] = this.fillColor;
                }
                ++i;
            }
            ++y;
            ++my;
        }
    }

    @Override
    public void convolve3x3(int[] kernel) {
        this.filter3x3(5, kernel);
    }

    @Override
    public void filter(int type) {
        this.filter3x3(type, null);
    }

    void filter3x3(int type, int[] kernel) {
        float k1 = 0.0f;
        float k2 = 0.0f;
        float k3 = 0.0f;
        float k4 = 0.0f;
        float k5 = 0.0f;
        float k6 = 0.0f;
        float k7 = 0.0f;
        float k8 = 0.0f;
        float k9 = 0.0f;
        float scale = 0.0f;
        if (type == 5) {
            k1 = kernel[0];
            k2 = kernel[1];
            k3 = kernel[2];
            k4 = kernel[3];
            k5 = kernel[4];
            k6 = kernel[5];
            k7 = kernel[6];
            k8 = kernel[7];
            k9 = kernel[8];
            for (int i = 0; i < kernel.length; ++i) {
                scale += (float)kernel[i];
            }
            if (scale == 0.0f) {
                scale = 1.0f;
            }
            scale = 1.0f / scale;
        }
        float[] pixels2 = (float[])this.getPixelsCopy();
        int xEnd = this.roiX + this.roiWidth;
        int yEnd = this.roiY + this.roiHeight;
        block6: for (int y = this.roiY; y < yEnd; ++y) {
            int p = this.roiX + y * this.width;
            int p6 = p - (this.roiX > 0 ? 1 : 0);
            int p3 = p6 - (y > 0 ? this.width : 0);
            int p9 = p6 + (y < this.height - 1 ? this.width : 0);
            float v2 = pixels2[p3];
            float v5 = pixels2[p6];
            float v8 = pixels2[p9];
            if (this.roiX > 0) {
                ++p3;
                ++p6;
                ++p9;
            }
            float v3 = pixels2[p3];
            float v6 = pixels2[p6];
            float v9 = pixels2[p9];
            switch (type) {
                case 0: {
                    float v7;
                    float v4;
                    float v1;
                    int x = this.roiX;
                    while (x < xEnd) {
                        if (x < this.width - 1) {
                            ++p3;
                            ++p6;
                            ++p9;
                        }
                        v1 = v2;
                        v2 = v3;
                        v3 = pixels2[p3];
                        v4 = v5;
                        v5 = v6;
                        v6 = pixels2[p6];
                        v7 = v8;
                        v8 = v9;
                        v9 = pixels2[p9];
                        this.pixels[p] = (v1 + v2 + v3 + v4 + v5 + v6 + v7 + v8 + v9) * 0.11111111f;
                        ++x;
                        ++p;
                    }
                    continue block6;
                }
                case 1: {
                    float v7;
                    float v4;
                    float v1;
                    int x = this.roiX;
                    while (x < xEnd) {
                        if (x < this.width - 1) {
                            ++p3;
                            ++p6;
                            ++p9;
                        }
                        v1 = v2;
                        v2 = v3;
                        v3 = pixels2[p3];
                        v4 = v5;
                        v5 = v6;
                        v6 = pixels2[p6];
                        v7 = v8;
                        v8 = v9;
                        v9 = pixels2[p9];
                        float sum1 = v1 + 2.0f * v2 + v3 - v7 - 2.0f * v8 - v9;
                        float sum2 = v1 + 2.0f * v4 + v7 - v3 - 2.0f * v6 - v9;
                        this.pixels[p] = (float)Math.sqrt(sum1 * sum1 + sum2 * sum2);
                        ++x;
                        ++p;
                    }
                    continue block6;
                }
                case 5: {
                    float v7;
                    float v4;
                    float v1;
                    int x = this.roiX;
                    while (x < xEnd) {
                        if (x < this.width - 1) {
                            ++p3;
                            ++p6;
                            ++p9;
                        }
                        v1 = v2;
                        v2 = v3;
                        v3 = pixels2[p3];
                        v4 = v5;
                        v5 = v6;
                        v6 = pixels2[p6];
                        v7 = v8;
                        v8 = v9;
                        v9 = pixels2[p9];
                        float sum = k1 * v1 + k2 * v2 + k3 * v3 + k4 * v4 + k5 * v5 + k6 * v6 + k7 * v7 + k8 * v8 + k9 * v9;
                        this.pixels[p] = sum *= scale;
                        ++x;
                        ++p;
                    }
                    continue block6;
                }
            }
        }
    }

    @Override
    public void rotate(double angle) {
        float[] pixels2 = (float[])this.getPixelsCopy();
        FloatProcessor ip2 = null;
        if (this.interpolationMethod == 2) {
            ip2 = new FloatProcessor(this.getWidth(), this.getHeight(), pixels2, null);
        }
        double centerX = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double centerY = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int xMax = this.roiX + this.roiWidth - 1;
        double angleRadians = -angle / 57.29577951308232;
        double ca = Math.cos(angleRadians);
        double sa = Math.sin(angleRadians);
        double tmp1 = centerY * sa - centerX * ca;
        double tmp2 = -centerX * sa - centerY * ca;
        if (this.interpolationMethod == 2) {
            for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
                int index = y * this.width + this.roiX;
                double tmp3 = tmp1 - (double)y * sa + centerX;
                double tmp4 = tmp2 + (double)y * ca + centerY;
                for (int x = this.roiX; x <= xMax; ++x) {
                    double xs = (double)x * ca + tmp3;
                    double ys = (double)x * sa + tmp4;
                    this.pixels[index++] = (float)this.getBicubicInterpolatedPixel(xs, ys, ip2);
                }
            }
        } else {
            double dwidth = this.width;
            double dheight = this.height;
            double xlimit = (double)this.width - 1.0;
            double xlimit2 = (double)this.width - 1.001;
            double ylimit = (double)this.height - 1.0;
            double ylimit2 = (double)this.height - 1.001;
            for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
                int index = y * this.width + this.roiX;
                double tmp3 = tmp1 - (double)y * sa + centerX;
                double tmp4 = tmp2 + (double)y * ca + centerY;
                for (int x = this.roiX; x <= xMax; ++x) {
                    double xs = (double)x * ca + tmp3;
                    double ys = (double)x * sa + tmp4;
                    if (xs >= -0.01 && xs < dwidth && ys >= -0.01 && ys < dheight) {
                        if (this.interpolationMethod == 1) {
                            if (xs < 0.0) {
                                xs = 0.0;
                            }
                            if (xs >= xlimit) {
                                xs = xlimit2;
                            }
                            if (ys < 0.0) {
                                ys = 0.0;
                            }
                            if (ys >= ylimit) {
                                ys = ylimit2;
                            }
                            this.pixels[index++] = (float)this.getInterpolatedPixel(xs, ys, pixels2);
                            continue;
                        }
                        int ixs = (int)(xs + 0.5);
                        int iys = (int)(ys + 0.5);
                        if (ixs >= this.width) {
                            ixs = this.width - 1;
                        }
                        if (iys >= this.height) {
                            iys = this.height - 1;
                        }
                        this.pixels[index++] = pixels2[this.width * iys + ixs];
                        continue;
                    }
                    this.pixels[index++] = this.bgValue;
                }
            }
        }
    }

    @Override
    public void flipVertical() {
        for (int y = 0; y < this.roiHeight / 2; ++y) {
            int index1 = (this.roiY + y) * this.width + this.roiX;
            int index2 = (this.roiY + this.roiHeight - 1 - y) * this.width + this.roiX;
            for (int i = 0; i < this.roiWidth; ++i) {
                float tmp = this.pixels[index1];
                this.pixels[index1++] = this.pixels[index2];
                this.pixels[index2++] = tmp;
            }
        }
    }

    @Override
    public void noise(double standardDeviation) {
        if (rnd == null) {
            rnd = new Random();
        }
        if (!Double.isNaN(seed)) {
            rnd.setSeed((int)seed);
        }
        seed = Double.NaN;
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                float RandomBrightness = (float)(rnd.nextGaussian() * standardDeviation);
                this.pixels[i] = this.pixels[i] + RandomBrightness;
                ++i;
            }
        }
        this.resetMinAndMax();
    }

    @Override
    public ImageProcessor crop() {
        ImageProcessor ip2 = this.createProcessor(this.roiWidth, this.roiHeight);
        float[] pixels2 = (float[])ip2.getPixels();
        for (int ys = this.roiY; ys < this.roiY + this.roiHeight; ++ys) {
            int offset1 = (ys - this.roiY) * this.roiWidth;
            int offset2 = ys * this.width + this.roiX;
            for (int xs = 0; xs < this.roiWidth; ++xs) {
                pixels2[offset1++] = this.pixels[offset2++];
            }
        }
        return ip2;
    }

    @Override
    public ImageProcessor duplicate() {
        ImageProcessor ip2 = this.createProcessor(this.width, this.height);
        float[] pixels2 = (float[])ip2.getPixels();
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return ip2;
    }

    @Override
    public void scale(double xScale, double yScale) {
        boolean checkCoordinates;
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        double xCenter = (double)this.roiX + (double)this.roiWidth / 2.0;
        double yCenter = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (xScale > 1.0 && yScale > 1.0) {
            xmin = (int)(xCenter - (xCenter - (double)this.roiX) * xScale);
            if (xmin < 0) {
                xmin = 0;
            }
            if ((xmax = xmin + (int)((double)this.roiWidth * xScale) - 1) >= this.width) {
                xmax = this.width - 1;
            }
            if ((ymin = (int)(yCenter - (yCenter - (double)this.roiY) * yScale)) < 0) {
                ymin = 0;
            }
            if ((ymax = ymin + (int)((double)this.roiHeight * yScale) - 1) >= this.height) {
                ymax = this.height - 1;
            }
        } else {
            xmin = this.roiX;
            xmax = this.roiX + this.roiWidth - 1;
            ymin = this.roiY;
            ymax = this.roiY + this.roiHeight - 1;
        }
        float[] pixels2 = (float[])this.getPixelsCopy();
        FloatProcessor ip2 = null;
        if (this.interpolationMethod == 2) {
            ip2 = new FloatProcessor(this.getWidth(), this.getHeight(), pixels2, null);
        }
        boolean bl = checkCoordinates = xScale < 1.0 || yScale < 1.0;
        if (this.interpolationMethod == 2) {
            for (int y = ymin; y <= ymax; ++y) {
                double ys = ((double)y - yCenter) / yScale + yCenter;
                int index1 = y * this.width + xmin;
                for (int x = xmin; x <= xmax; ++x) {
                    double xs = ((double)x - xCenter) / xScale + xCenter;
                    this.pixels[index1++] = (float)this.getBicubicInterpolatedPixel(xs, ys, ip2);
                }
            }
        } else {
            double xlimit = (double)this.width - 1.0;
            double xlimit2 = (double)this.width - 1.001;
            double ylimit = (double)this.height - 1.0;
            double ylimit2 = (double)this.height - 1.001;
            for (int y = ymin; y <= ymax; ++y) {
                double ys = ((double)y - yCenter) / yScale + yCenter;
                int ysi = (int)ys;
                if (ys < 0.0) {
                    ys = 0.0;
                }
                if (ys >= ylimit) {
                    ys = ylimit2;
                }
                int index1 = y * this.width + xmin;
                int index2 = this.width * (int)ys;
                for (int x = xmin; x <= xmax; ++x) {
                    double xs = ((double)x - xCenter) / xScale + xCenter;
                    int xsi = (int)xs;
                    if (checkCoordinates && (xsi < xmin || xsi > xmax || ysi < ymin || ysi > ymax)) {
                        this.pixels[index1++] = (float)this.getMin();
                        continue;
                    }
                    if (this.interpolationMethod == 1) {
                        if (xs < 0.0) {
                            xs = 0.0;
                        }
                        if (xs >= xlimit) {
                            xs = xlimit2;
                        }
                        this.pixels[index1++] = (float)this.getInterpolatedPixel(xs, ys, pixels2);
                        continue;
                    }
                    this.pixels[index1++] = pixels2[index2 + xsi];
                }
            }
        }
    }

    private final double getInterpolatedPixel(double x, double y, float[] pixels) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        double lowerLeft = pixels[offset];
        double lowerRight = pixels[offset + 1];
        double upperRight = pixels[offset + this.width + 1];
        double upperLeft = pixels[offset + this.width];
        double upperAverage = Double.isNaN(upperLeft) && xFraction >= 0.5 ? upperRight : (Double.isNaN(upperRight) && xFraction < 0.5 ? upperLeft : upperLeft + xFraction * (upperRight - upperLeft));
        double lowerAverage = Double.isNaN(lowerLeft) && xFraction >= 0.5 ? lowerRight : (Double.isNaN(lowerRight) && xFraction < 0.5 ? lowerLeft : lowerLeft + xFraction * (lowerRight - lowerLeft));
        if (Double.isNaN(lowerAverage) && yFraction >= 0.5) {
            return upperAverage;
        }
        if (Double.isNaN(upperAverage) && yFraction < 0.5) {
            return lowerAverage;
        }
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    @Override
    public ImageProcessor resize(int dstWidth, int dstHeight) {
        if (this.roiWidth == dstWidth && this.roiHeight == dstHeight) {
            return this.crop();
        }
        if ((this.width == 1 || this.height == 1) && this.interpolationMethod != 0) {
            return this.resizeLinearly(dstWidth, dstHeight);
        }
        double srcCenterX = (double)this.roiX + (double)this.roiWidth / 2.0;
        double srcCenterY = (double)this.roiY + (double)this.roiHeight / 2.0;
        double dstCenterX = (double)dstWidth / 2.0;
        double dstCenterY = (double)dstHeight / 2.0;
        double xScale = (double)dstWidth / (double)this.roiWidth;
        double yScale = (double)dstHeight / (double)this.roiHeight;
        if (this.interpolationMethod != 0) {
            if (dstWidth != this.width) {
                dstCenterX += xScale / 4.0;
            }
            if (dstHeight != this.height) {
                dstCenterY += yScale / 4.0;
            }
        }
        int inc = this.getProgressIncrement(dstWidth, dstHeight);
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        float[] pixels2 = (float[])ip2.getPixels();
        if (this.interpolationMethod == 2) {
            for (int y = 0; y <= dstHeight - 1; ++y) {
                if (inc > 0 && y % inc == 0) {
                    this.showProgress((double)y / (double)dstHeight);
                }
                double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
                int index = y * dstWidth;
                for (int x = 0; x <= dstWidth - 1; ++x) {
                    double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                    pixels2[index++] = (float)this.getBicubicInterpolatedPixel(xs, ys, this);
                }
            }
        } else {
            double xlimit = (double)this.width - 1.0;
            double xlimit2 = (double)this.width - 1.001;
            double ylimit = (double)this.height - 1.0;
            double ylimit2 = (double)this.height - 1.001;
            for (int y = 0; y <= dstHeight - 1; ++y) {
                if (inc > 0 && y % inc == 0) {
                    this.showProgress((double)y / (double)dstHeight);
                }
                double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
                if (this.interpolationMethod == 1) {
                    if (ys < 0.0) {
                        ys = 0.0;
                    }
                    if (ys >= ylimit) {
                        ys = ylimit2;
                    }
                }
                int index1 = this.width * (int)ys;
                int index2 = y * dstWidth;
                for (int x = 0; x <= dstWidth - 1; ++x) {
                    double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                    if (this.interpolationMethod == 1) {
                        if (xs < 0.0) {
                            xs = 0.0;
                        }
                        if (xs >= xlimit) {
                            xs = xlimit2;
                        }
                        pixels2[index2++] = (float)this.getInterpolatedPixel(xs, ys, this.pixels);
                        continue;
                    }
                    pixels2[index2++] = this.pixels[index1 + (int)xs];
                }
            }
        }
        if (inc > 0) {
            this.showProgress(1.0);
        }
        return ip2;
    }

    FloatProcessor downsize(int dstWidth, int dstHeight, String msg) {
        FloatProcessor ip2 = this;
        if (msg != null) {
            IJ.showStatus("downsizing in x" + msg);
        }
        if (dstWidth < this.roiWidth) {
            ip2 = ip2.downsize1D(dstWidth, this.roiHeight, true);
            ip2.setRoi(0, 0, dstWidth, this.roiHeight);
        }
        if (msg != null) {
            IJ.showStatus("downsizing in y" + msg);
        }
        if (dstHeight < this.roiHeight) {
            ip2 = ip2.downsize1D(ip2.getRoi().width, dstHeight, false);
        }
        if (ip2.getWidth() != dstWidth || ip2.getHeight() != dstHeight) {
            ip2 = (FloatProcessor)ip2.resize(dstWidth, dstHeight);
        }
        return ip2;
    }

    private FloatProcessor downsize1D(int dstWidth, int dstHeight, boolean xDirection) {
        int srcPointInc = xDirection ? 1 : this.width;
        int srcLineInc = xDirection ? this.width : 1;
        int dstPointInc = xDirection ? 1 : dstWidth;
        int dstLineInc = xDirection ? dstWidth : 1;
        int srcLine0 = xDirection ? this.roiY : this.roiX;
        int dstLines = xDirection ? dstHeight : dstWidth;
        DownsizeTable dt = xDirection ? new DownsizeTable(this.getWidth(), this.roiX, this.roiWidth, dstWidth, this.interpolationMethod) : new DownsizeTable(this.getHeight(), this.roiY, this.roiHeight, dstHeight, this.interpolationMethod);
        FloatProcessor ip2 = (FloatProcessor)this.createProcessor(dstWidth, dstHeight);
        float[] pixels = (float[])this.getPixels();
        float[] pixels2 = (float[])ip2.getPixels();
        int srcLine = srcLine0;
        for (int dstLine = 0; dstLine < dstLines; ++dstLine) {
            int dstLineOffset = dstLine * dstLineInc;
            int tablePointer = 0;
            int srcPoint = dt.srcStart;
            int p = srcPoint * srcPointInc + srcLine * srcLineInc;
            while (srcPoint <= dt.srcEnd) {
                float v = pixels[p];
                int i = 0;
                while (i < dt.kernelSize) {
                    int n = dstLineOffset + dt.indices[tablePointer] * dstPointInc;
                    pixels2[n] = pixels2[n] + v * dt.weights[tablePointer];
                    ++i;
                    ++tablePointer;
                }
                ++srcPoint;
                p += srcPointInc;
            }
            ++srcLine;
        }
        return ip2;
    }

    @Override
    public double getBicubicInterpolatedPixel(double x0, double y0, ImageProcessor ip2) {
        int u0 = (int)Math.floor(x0);
        int v0 = (int)Math.floor(y0);
        if (u0 <= 0 || u0 >= this.width - 2 || v0 <= 0 || v0 >= this.height - 2) {
            return ip2.getBilinearInterpolatedPixel(x0, y0);
        }
        double q = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = v0 - 1 + j;
            double p = 0.0;
            for (int i = 0; i <= 3; ++i) {
                int u = u0 - 1 + i;
                p += (double)ip2.getf(u, v) * FloatProcessor.cubic(x0 - (double)u);
            }
            q += p * FloatProcessor.cubic(y0 - (double)v);
        }
        return q;
    }

    @Override
    public void setColor(Color color) {
        this.drawingColor = color;
        int bestIndex = this.getBestIndex(color);
        if (bestIndex > 0 && this.getMin() == 0.0 && this.getMax() == 0.0) {
            this.fillColor = bestIndex;
            this.setMinAndMax(0.0, 255.0);
        } else {
            this.fillColor = bestIndex == 0 && this.getMin() > 0.0 && (color.getRGB() & 0xFFFFFF) == 0 ? 0.0f : (float)(this.getMin() + (this.getMax() - this.getMin()) * ((double)bestIndex / 255.0));
        }
    }

    @Override
    public void setValue(double value) {
        this.fillColor = (float)value;
        this.fillValueSet = true;
    }

    @Override
    public void setBackgroundValue(double value) {
        this.bgValue = (float)value;
    }

    @Override
    public double getBackgroundValue() {
        return this.bgValue;
    }

    @Override
    public void setLutAnimation(boolean lutAnimation) {
        this.lutAnimation = false;
    }

    @Override
    public void setThreshold(double minThreshold, double maxThreshold, int lutUpdate) {
        if (minThreshold == -808080.0) {
            this.resetThreshold();
            return;
        }
        if (this.getMax() > this.getMin()) {
            if (lutUpdate == 3) {
                double minT = (minThreshold - this.getMin()) / (this.getMax() - this.getMin()) * 255.0;
                double maxT = (maxThreshold - this.getMin()) / (this.getMax() - this.getMin()) * 255.0;
                super.setThreshold(minT, maxT, lutUpdate);
            } else {
                this.lutUpdateMode = lutUpdate;
                if (this.rLUT1 == null) {
                    if (this.cm == null) {
                        this.makeDefaultColorModel();
                    }
                    this.baseCM = this.cm;
                    IndexColorModel m = (IndexColorModel)this.cm;
                    this.rLUT1 = new byte[256];
                    this.gLUT1 = new byte[256];
                    this.bLUT1 = new byte[256];
                    m.getReds(this.rLUT1);
                    m.getGreens(this.gLUT1);
                    m.getBlues(this.bLUT1);
                    this.rLUT2 = new byte[256];
                    this.gLUT2 = new byte[256];
                    this.bLUT2 = new byte[256];
                }
                this.cm = this.lutUpdateMode == 0 ? this.getThresholdColorModel() : this.getDefaultColorModel();
            }
        } else {
            super.resetThreshold();
        }
        this.minThreshold = minThreshold;
        this.maxThreshold = maxThreshold;
    }

    @Override
    public void convolve(float[] kernel, int kernelWidth, int kernelHeight) {
        this.snapshot();
        new Convolver().convolve(this, kernel, kernelWidth, kernelHeight);
    }

    @Override
    public int[] getHistogram() {
        return this.getStatistics().histogram;
    }

    @Override
    public void threshold(int level) {
    }

    @Override
    public void autoThreshold() {
    }

    @Override
    public void medianFilter() {
    }

    @Override
    public void erode() {
    }

    @Override
    public void dilate() {
    }

    @Override
    public FloatProcessor toFloat(int channelNumber, FloatProcessor fp) {
        return this;
    }

    @Override
    public void setPixels(int channelNumber, FloatProcessor fp) {
        if (fp.getPixels() != this.getPixels()) {
            this.setPixels(fp.getPixels());
        }
        this.setMinAndMax(fp.getMin(), fp.getMax());
    }

    @Override
    public double minValue() {
        return 1.4E-45f;
    }

    @Override
    public double maxValue() {
        return 3.4028234663852886E38;
    }

    @Override
    public int getBitDepth() {
        return 32;
    }

    @Override
    public ByteProcessor createMask() {
        if (this.getMinThreshold() == -808080.0) {
            return null;
        }
        float minThreshold = (float)this.getMinThreshold();
        float maxThreshold = (float)this.getMaxThreshold();
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        byte[] mpixels = (byte[])mask.getPixels();
        for (int i = 0; i < this.pixels.length; ++i) {
            if (!(this.pixels[i] >= minThreshold) || !(this.pixels[i] <= maxThreshold)) continue;
            mpixels[i] = -1;
        }
        return mask;
    }
}

