/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.component.IcyTextField;
import icy.gui.dialog.ActionDialog;
import icy.gui.util.ComponentUtil;
import icy.preferences.RepositoryPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditRepositoryDialog
extends ActionDialog {
    private static final long serialVersionUID = 893945926064333575L;
    IcyTextField nameField;
    IcyTextField locationField;
    JCheckBox supportParamCheckBox;
    JCheckBox authCheckBox;
    IcyTextField loginField;
    JPasswordField passwordField;
    JLabel nameLabel;
    JLabel locationLabel;
    JLabel supportParamLabel;
    JLabel authLabel;
    JLabel loginLabel;
    JLabel passwordLabel;
    final RepositoryPreferences.RepositoryInfo reposInf;

    public EditRepositoryDialog(String title, RepositoryPreferences.RepositoryInfo reposInf) {
        super(title);
        this.reposInf = reposInf;
        this.initialize();
        this.updateAuthFields();
        this.pack();
        ComponentUtil.center(this);
        this.setVisible(true);
    }

    private void initialize() {
        this.setMinimumSize(new Dimension(400, 200));
        this.setBounds(100, 100, 450, 300);
        this.nameField = new IcyTextField();
        this.nameField.setText(this.reposInf.getName());
        ComponentUtil.setFixedHeight(this.nameField, 24);
        this.locationField = new IcyTextField();
        this.locationField.setText(this.reposInf.getLocation());
        ComponentUtil.setFixedHeight(this.locationField, 24);
        this.authCheckBox = new JCheckBox("", this.reposInf.isAuthenticationEnabled());
        ComponentUtil.setFixedHeight(this.authCheckBox, 24);
        this.loginField = new IcyTextField((Object)this.reposInf.getLogin());
        this.loginField.setText(this.reposInf.getLogin());
        ComponentUtil.setFixedHeight(this.loginField, 24);
        this.passwordField = new JPasswordField(this.reposInf.getPassword());
        ComponentUtil.setFixedHeight(this.passwordField, 24);
        this.supportParamCheckBox = new JCheckBox("", this.reposInf.getSupportParam());
        ComponentUtil.setFixedHeight(this.supportParamCheckBox, 24);
        this.authCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditRepositoryDialog.this.updateAuthFields();
            }
        });
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditRepositoryDialog.this.reposInf.setName(EditRepositoryDialog.this.nameField.getText());
                EditRepositoryDialog.this.reposInf.setLocation(EditRepositoryDialog.this.locationField.getText());
                EditRepositoryDialog.this.reposInf.setSupportParam(EditRepositoryDialog.this.supportParamCheckBox.isSelected());
                EditRepositoryDialog.this.reposInf.setAuthenticationEnabled(EditRepositoryDialog.this.authCheckBox.isSelected());
                EditRepositoryDialog.this.reposInf.setLogin(EditRepositoryDialog.this.loginField.getText());
                EditRepositoryDialog.this.reposInf.setPassword(new String(EditRepositoryDialog.this.passwordField.getPassword()));
            }
        });
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.mainPanel.setLayout(new BorderLayout(8, 8));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 3));
        this.nameLabel = new JLabel("Name");
        this.nameLabel.setToolTipText("Repository name");
        ComponentUtil.setFixedHeight(this.nameLabel, 24);
        this.locationLabel = new JLabel("Location");
        this.locationLabel.setToolTipText("Repository address");
        ComponentUtil.setFixedHeight(this.locationLabel, 24);
        this.supportParamLabel = new JLabel("Enable extra parameters");
        this.supportParamLabel.setToolTipText("Enable extra parameters when querying the XML file (only for online repository)");
        ComponentUtil.setFixedHeight(this.supportParamLabel, 24);
        this.authLabel = new JLabel("Use authentication");
        this.authLabel.setToolTipText("Enable authentication to access the repository");
        ComponentUtil.setFixedHeight(this.authLabel, 24);
        this.loginLabel = new JLabel("Login");
        ComponentUtil.setFixedHeight(this.loginLabel, 24);
        this.passwordLabel = new JLabel("Password");
        ComponentUtil.setFixedHeight(this.passwordLabel, 24);
        labelPanel.add(this.nameLabel);
        labelPanel.add(Box.createVerticalStrut(4));
        labelPanel.add(this.locationLabel);
        labelPanel.add(Box.createVerticalStrut(4));
        labelPanel.add(this.supportParamLabel);
        labelPanel.add(Box.createVerticalStrut(4));
        labelPanel.add(this.authLabel);
        labelPanel.add(Box.createVerticalStrut(4));
        labelPanel.add(this.loginLabel);
        labelPanel.add(Box.createVerticalStrut(4));
        labelPanel.add(this.passwordLabel);
        labelPanel.add(Box.createVerticalGlue());
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 3));
        fieldPanel.add(this.nameField);
        fieldPanel.add(Box.createVerticalStrut(4));
        fieldPanel.add(this.locationField);
        fieldPanel.add(Box.createVerticalStrut(4));
        fieldPanel.add(this.supportParamCheckBox);
        fieldPanel.add(Box.createVerticalStrut(4));
        fieldPanel.add(this.authCheckBox);
        fieldPanel.add(Box.createVerticalStrut(4));
        fieldPanel.add(this.loginField);
        fieldPanel.add(Box.createVerticalStrut(4));
        fieldPanel.add(this.passwordField);
        fieldPanel.add(Box.createVerticalGlue());
        this.mainPanel.add((Component)labelPanel, "West");
        this.mainPanel.add((Component)fieldPanel, "Center");
    }

    void updateAuthFields() {
        boolean enabled = this.authCheckBox.isSelected();
        this.loginLabel.setEnabled(enabled);
        this.loginField.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
    }
}

