/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbTableOrView;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class DbSchema {
    static final int MAX_TABLES_LIST_INDEXES = 100;
    static final int MAX_TABLES_LIST_COLUMNS = 500;
    final DbContents contents;
    final String name;
    final boolean isDefault;
    final boolean isSystem;
    final String quotedName;
    DbTableOrView[] tables;

    DbSchema(DbContents dbContents, String string, boolean bl) {
        this.contents = dbContents;
        this.name = string;
        this.quotedName = dbContents.quoteIdentifier(string);
        this.isDefault = bl;
        this.isSystem = StringUtils.toUpperEnglish(string).startsWith("INFO") ? true : (dbContents.isPostgreSQL && StringUtils.toUpperEnglish(string).startsWith("PG_") ? true : dbContents.isDerby && string.startsWith("SYS"));
    }

    void readTables(DatabaseMetaData databaseMetaData, String[] stringArray) throws SQLException {
        ResultSet resultSet = databaseMetaData.getTables(null, this.name, null, stringArray);
        ArrayList<DbTableOrView> arrayList = New.arrayList();
        while (resultSet.next()) {
            DbTableOrView[] dbTableOrViewArray = new DbTableOrView(this, resultSet);
            if (this.contents.isOracle && dbTableOrViewArray.name.indexOf(36) > 0) continue;
            arrayList.add((DbTableOrView)dbTableOrViewArray);
        }
        resultSet.close();
        this.tables = new DbTableOrView[arrayList.size()];
        arrayList.toArray(this.tables);
        if (this.tables.length < 500) {
            for (DbTableOrView dbTableOrView : this.tables) {
                dbTableOrView.readColumns(databaseMetaData);
            }
        }
    }
}

