/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence;

import icy.gui.dialog.ActionDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.sequence.SequencePropertiesPanel;
import icy.main.Icy;
import icy.math.UnitUtil;
import icy.sequence.Sequence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SequencePropertiesDialog
extends ActionDialog {
    private static final long serialVersionUID = 5696186054980120411L;
    SequencePropertiesPanel panel;

    public SequencePropertiesDialog(final Sequence sequence) {
        super("Sequence Properties");
        this.initialize();
        this.panel.setSequence(sequence);
        this.setCloseAfterAction(false);
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double sx = SequencePropertiesDialog.this.panel.getPixelSizeXFieldValue();
                double sy = SequencePropertiesDialog.this.panel.getPixelSizeYFieldValue();
                double sz = SequencePropertiesDialog.this.panel.getPixelSizeZFieldValue();
                double st = SequencePropertiesDialog.this.panel.getTimeIntervalFieldValue();
                if (sx <= 0.0 || sy <= 0.0 || sz <= 0.0) {
                    MessageDialog.showDialog("Pixel size values should be > 0 !", 2);
                    return;
                }
                sequence.setName(SequencePropertiesDialog.this.panel.getNameFieldValue());
                sequence.setPixelSizeX(UnitUtil.getValueInUnit(sx, SequencePropertiesDialog.this.panel.getPixelSizeXUnit(), UnitUtil.UnitPrefix.MICRO));
                sequence.setPixelSizeY(UnitUtil.getValueInUnit(sy, SequencePropertiesDialog.this.panel.getPixelSizeYUnit(), UnitUtil.UnitPrefix.MICRO));
                sequence.setPixelSizeZ(UnitUtil.getValueInUnit(sz, SequencePropertiesDialog.this.panel.getPixelSizeZUnit(), UnitUtil.UnitPrefix.MICRO));
                double valueInSec = st;
                switch (SequencePropertiesDialog.this.panel.getTimeIntervalUnit()) {
                    case 0: {
                        valueInSec *= 60.0;
                    }
                    case 1: {
                        valueInSec *= 60.0;
                        break;
                    }
                    case 3: {
                        valueInSec /= 1000.0;
                    }
                }
                sequence.setTimeInterval(valueInSec);
                sequence.setPositionX(UnitUtil.getValueInUnit(SequencePropertiesDialog.this.panel.getPositionXValue(), SequencePropertiesDialog.this.panel.getPositionXUnit(), UnitUtil.UnitPrefix.MICRO));
                sequence.setPositionY(UnitUtil.getValueInUnit(SequencePropertiesDialog.this.panel.getPositionYValue(), SequencePropertiesDialog.this.panel.getPositionYUnit(), UnitUtil.UnitPrefix.MICRO));
                sequence.setPositionZ(UnitUtil.getValueInUnit(SequencePropertiesDialog.this.panel.getPositionZValue(), SequencePropertiesDialog.this.panel.getPositionZUnit(), UnitUtil.UnitPrefix.MICRO));
                int c = 0;
                while (c < sequence.getSizeC()) {
                    sequence.setChannelName(c, SequencePropertiesDialog.this.panel.getChannelNameFieldValue(c));
                    ++c;
                }
                SequencePropertiesDialog.this.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo((Component)((Object)Icy.getMainInterface().getMainFrame()));
        this.setVisible(true);
    }

    private void initialize() {
        this.panel = new SequencePropertiesPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.panel, "Center");
        this.mainPanel.validate();
    }
}

