/*
 * Decompiled with CFR 0.152.
 */
package icy.type.point;

import icy.type.point.Point3D;
import icy.type.point.Point4D;
import java.awt.Point;
import java.awt.geom.Point2D;

public abstract class Point5D
implements Cloneable {
    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getT();

    public abstract double getC();

    public abstract void setX(double var1);

    public abstract void setY(double var1);

    public abstract void setZ(double var1);

    public abstract void setT(double var1);

    public abstract void setC(double var1);

    public void setLocation(double x, double y, double z, double t, double c) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setT(t);
        this.setC(c);
    }

    public void setLocation(Point5D p) {
        this.setLocation(p.getX(), p.getY(), p.getZ(), p.getT(), p.getC());
    }

    public abstract Point2D toPoint2D();

    public abstract Point3D toPoint3D();

    public abstract Point4D toPoint4D();

    public boolean equals(Object obj) {
        if (obj instanceof Point5D) {
            Point5D pt = (Point5D)obj;
            return this.getX() == pt.getX() && this.getY() == pt.getY() && this.getZ() == pt.getZ() && this.getT() == pt.getT() && this.getC() == pt.getC();
        }
        return super.equals(obj);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getX() + "," + this.getY() + "," + this.getZ() + ", " + this.getT() + "," + this.getC() + "]";
    }

    public static class Double
    extends Point5D {
        public double x;
        public double y;
        public double z;
        public double t;
        public double c;

        public static Double[] toPoint5D(double[] input) {
            Double[] result = new Double[input.length / 5];
            int pt = 0;
            int i = 0;
            while (i < input.length) {
                result[pt++] = new Double(input[i + 0], input[i + 1], input[i + 2], input[i + 3], input[i + 4]);
                i += 5;
            }
            return result;
        }

        public static double[] toDoubleArray(Double[] input) {
            double[] result = new double[input.length * 5];
            int off = 0;
            Double[] doubleArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                Double pt = doubleArray[n2];
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
                result[off++] = pt.t;
                result[off++] = pt.c;
                ++n2;
            }
            return result;
        }

        public Double(double x, double y, double z, double t, double c) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.c = c;
        }

        public Double(double[] xyztc) {
            int len = xyztc.length;
            if (len > 0) {
                this.x = xyztc[0];
            }
            if (len > 1) {
                this.y = xyztc[1];
            }
            if (len > 2) {
                this.z = xyztc[2];
            }
            if (len > 3) {
                this.t = xyztc[3];
            }
            if (len > 4) {
                this.c = xyztc[4];
            }
        }

        public Double() {
            this(0.0, 0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = y;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = z;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public void setT(double t) {
            this.t = t;
        }

        @Override
        public double getC() {
            return this.c;
        }

        @Override
        public void setC(double c) {
            this.c = c;
        }

        @Override
        public void setLocation(double x, double y, double z, double t, double c) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.c = c;
        }

        @Override
        public Point2D toPoint2D() {
            return new Point2D.Double(this.x, this.y);
        }

        @Override
        public Point3D toPoint3D() {
            return new Point3D.Double(this.x, this.y, this.z);
        }

        @Override
        public Point4D toPoint4D() {
            return new Point4D.Double(this.x, this.y, this.z, this.t);
        }
    }

    public static class Float
    extends Point5D {
        public float x;
        public float y;
        public float z;
        public float t;
        public float c;

        public static Float[] toPoint5D(float[] input) {
            Float[] result = new Float[input.length / 5];
            int pt = 0;
            int i = 0;
            while (i < input.length) {
                result[pt++] = new Float(input[i + 0], input[i + 1], input[i + 2], input[i + 3], input[i + 4]);
                i += 5;
            }
            return result;
        }

        public static float[] toFloatArray(Float[] input) {
            float[] result = new float[input.length * 5];
            int off = 0;
            Float[] floatArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                Float pt = floatArray[n2];
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
                result[off++] = pt.t;
                result[off++] = pt.c;
                ++n2;
            }
            return result;
        }

        public Float(float x, float y, float z, float t, float c) {
            this.x = x;
            this.y = y;
            this.c = c;
            this.z = z;
            this.t = t;
        }

        public Float(float[] xyztc) {
            int len = xyztc.length;
            if (len > 0) {
                this.x = xyztc[0];
            }
            if (len > 1) {
                this.y = xyztc[1];
            }
            if (len > 2) {
                this.z = xyztc[2];
            }
            if (len > 3) {
                this.t = xyztc[3];
            }
            if (len > 4) {
                this.c = xyztc[4];
            }
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = (float)x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = (float)y;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = (float)z;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public void setT(double t) {
            this.t = (float)t;
        }

        @Override
        public double getC() {
            return this.c;
        }

        @Override
        public void setC(double c) {
            this.c = (float)c;
        }

        @Override
        public void setLocation(double x, double y, double z, double t, double c) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            this.t = (float)t;
            this.c = (float)c;
        }

        @Override
        public Point2D toPoint2D() {
            return new Point2D.Float(this.x, this.y);
        }

        @Override
        public Point3D toPoint3D() {
            return new Point3D.Float(this.x, this.y, this.z);
        }

        @Override
        public Point4D toPoint4D() {
            return new Point4D.Float(this.x, this.y, this.z, this.t);
        }
    }

    public static class Integer
    extends Point5D {
        public int x;
        public int y;
        public int z;
        public int t;
        public int c;

        public static Integer[] toPoint5D(int[] input) {
            Integer[] result = new Integer[input.length / 5];
            int pt = 0;
            int i = 0;
            while (i < input.length) {
                result[pt++] = new Integer(input[i + 0], input[i + 1], input[i + 2], input[i + 3], input[i + 4]);
                i += 5;
            }
            return result;
        }

        public static int[] toIntegerArray(Integer[] input) {
            int[] result = new int[input.length * 5];
            int off = 0;
            Integer[] integerArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                Integer pt = integerArray[n2];
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
                result[off++] = pt.t;
                result[off++] = pt.c;
                ++n2;
            }
            return result;
        }

        public Integer(int x, int y, int z, int t, int c) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.c = c;
        }

        public Integer(int[] xyztc) {
            int len = xyztc.length;
            if (len > 0) {
                this.x = xyztc[0];
            }
            if (len > 1) {
                this.y = xyztc[1];
            }
            if (len > 2) {
                this.z = xyztc[2];
            }
            if (len > 3) {
                this.t = xyztc[3];
            }
            if (len > 4) {
                this.c = xyztc[4];
            }
        }

        public Integer() {
            this(0, 0, 0, 0, 0);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = (int)x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = (int)y;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = (int)z;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public void setT(double t) {
            this.t = (int)t;
        }

        @Override
        public double getC() {
            return this.c;
        }

        @Override
        public void setC(double c) {
            this.c = (int)c;
        }

        @Override
        public void setLocation(double x, double y, double z, double t, double c) {
            this.x = (int)x;
            this.y = (int)y;
            this.z = (int)z;
            this.t = (int)t;
            this.c = (int)c;
        }

        @Override
        public Point2D toPoint2D() {
            return new Point(this.x, this.y);
        }

        @Override
        public Point3D toPoint3D() {
            return new Point3D.Integer(this.x, this.y, this.z);
        }

        @Override
        public Point4D toPoint4D() {
            return new Point4D.Integer(this.x, this.y, this.z, this.t);
        }
    }
}

