/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.image.filtering.convolution;

import icy.sequence.Sequence;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import plugins.kernel.image.filtering.convolution.Axis;
import plugins.kernel.image.filtering.convolution.ConvolutionException;

public class Convolution1D {
    public static void convolve(Sequence sequence, double[] kernelX, double[] kernelY, double[] kernelZ) throws IllegalArgumentException, ConvolutionException, InterruptedException {
        if (kernelX == null && kernelY == null && kernelZ == null) {
            throw new IllegalArgumentException("Invalid argument: provide at least one non-null kernel");
        }
        if (kernelX != null && kernelX.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along X has even size");
        }
        if (kernelY != null && kernelY.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along Y has even size");
        }
        if (kernelZ != null && kernelZ.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along Z has even size");
        }
        DataType type = sequence.getDataType_();
        double[][] z_xy = new double[sequence.getSizeZ()][sequence.getSizeX() * sequence.getSizeY()];
        sequence.beginUpdate();
        try {
            int t = 0;
            while (t < sequence.getSizeT()) {
                int c = 0;
                while (c < sequence.getSizeC()) {
                    int z = 0;
                    while (z < sequence.getSizeZ()) {
                        Array1DUtil.arrayToDoubleArray(sequence.getDataXY(t, z, c), z_xy[z], type.isSigned());
                        ++z;
                    }
                    Convolution1D.convolve(z_xy, sequence.getSizeX(), sequence.getSizeY(), kernelX, kernelY, kernelZ);
                    z = 0;
                    while (z < sequence.getSizeZ()) {
                        Object dest = sequence.getDataXY(t, z, c);
                        Array1DUtil.doubleArrayToSafeArray(z_xy[z], dest, type.isSigned());
                        sequence.setDataXY(t, z, c, dest);
                        ++z;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    ++c;
                }
                ++t;
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    public static void convolve(double[][] array, int imageWidth, int imageHeight, double[] kernelX, double[] kernelY, double[] kernelZ) throws ConvolutionException {
        Processor service = new Processor(Runtime.getRuntime().availableProcessors() * 2);
        int sliceSize = array[0].length;
        double[][] temp = new double[array.length][sliceSize];
        try {
            try {
                if (array.length == 1) {
                    if (kernelX == null) {
                        Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelY, Axis.Y);
                        int z = 0;
                        while (z < array.length) {
                            System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                            ++z;
                        }
                    } else if (kernelY == null) {
                        Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                        int z = 0;
                        while (z < array.length) {
                            System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                            ++z;
                        }
                    } else {
                        Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                        Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelY, Axis.Y);
                    }
                } else if (kernelX == null) {
                    if (kernelY == null) {
                        Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelZ, Axis.Z);
                        int z = 0;
                        while (z < array.length) {
                            System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                            ++z;
                        }
                    } else if (kernelZ == null) {
                        Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelY, Axis.Y);
                        int z = 0;
                        while (z < array.length) {
                            System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                            ++z;
                        }
                    } else {
                        Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelY, Axis.Y);
                        Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelZ, Axis.Z);
                    }
                } else if (kernelY == null) {
                    if (kernelZ == null) {
                        Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                        int z = 0;
                        while (z < array.length) {
                            System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                            ++z;
                        }
                    } else {
                        Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                        Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelZ, Axis.Z);
                    }
                } else if (kernelZ == null) {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                    Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelY, Axis.Y);
                } else {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                    Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelY, Axis.Y);
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelZ, Axis.Z);
                    int z = 0;
                    while (z < array.length) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                        ++z;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                service.shutdown();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                service.shutdown();
            }
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void convolve1D(ExecutorService service, final double[][] input, double[][] output, final int width, final int height, final double[] kernel, Axis axis) throws ConvolutionException, InterruptedException, ExecutionException {
        try {
            int sliceSize = input[0].length;
            final int kRadius = (kernel.length - 1) / 2;
            switch (axis) {
                case X: {
                    void var10_15;
                    ArrayList tasks = new ArrayList(input.length);
                    boolean bl = false;
                    while (var10_15 < input.length) {
                        final double[] dArray = input[var10_15];
                        final double[] outSlice = output[var10_15];
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                int y = 0;
                                while (y < height) {
                                    int kOffset;
                                    int kIndex;
                                    double value;
                                    int x = 0;
                                    int xStartOffset = xy;
                                    int xEndOffset = xy + width - 1;
                                    while (x < kRadius) {
                                        double value2 = 0.0;
                                        int kIndex2 = 0;
                                        int kOffset2 = -kRadius;
                                        while (kOffset2 <= kRadius) {
                                            int inOffset = xy + kOffset2;
                                            if (inOffset < xStartOffset) {
                                                inOffset = xStartOffset + (xStartOffset - inOffset);
                                            }
                                            value2 += dArray[inOffset] * kernel[kIndex2];
                                            ++kOffset2;
                                            ++kIndex2;
                                        }
                                        outSlice[xy] = value2;
                                        ++x;
                                        ++xy;
                                    }
                                    int eastBorder = width - kRadius;
                                    while (x < eastBorder) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            value += dArray[xy + kOffset] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        outSlice[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    while (x < width) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inOffset = xy + kOffset;
                                            if (inOffset >= xEndOffset) {
                                                inOffset = xEndOffset - (inOffset - xEndOffset);
                                            }
                                            value += dArray[inOffset] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        outSlice[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                            }
                        }));
                        ++var10_15;
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                    break;
                }
                case Y: {
                    void var11_25;
                    final int kRadiusY = kRadius * width;
                    ArrayList arrayList = new ArrayList(input.length);
                    boolean bl = false;
                    while (var11_25 < input.length) {
                        Object in = input[var11_25];
                        double[] dArray = output[var11_25];
                        arrayList.add(service.submit(new Runnable((double[])in, kernel, dArray, height, sliceSize){
                            private final /* synthetic */ double[] val$in;
                            private final /* synthetic */ double[] val$kernel;
                            private final /* synthetic */ double[] val$out;
                            private final /* synthetic */ int val$height;
                            private final /* synthetic */ int val$sliceSize;
                            {
                                this.val$in = dArray;
                                this.val$kernel = dArray2;
                                this.val$out = dArray3;
                                this.val$height = n4;
                                this.val$sliceSize = n5;
                            }

                            @Override
                            public void run() {
                                int x;
                                int kOffset;
                                int kIndex;
                                double value;
                                int xy = 0;
                                int y = 0;
                                while (y < kRadius) {
                                    int x2 = 0;
                                    while (x2 < width) {
                                        int yStartOffset = x2;
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadiusY;
                                        while (kOffset <= kRadiusY) {
                                            int inOffset = xy + kOffset;
                                            if (inOffset < 0) {
                                                inOffset = yStartOffset - inOffset;
                                            }
                                            value += this.val$in[inOffset] * this.val$kernel[kIndex];
                                            kOffset += width;
                                            ++kIndex;
                                        }
                                        this.val$out[xy] = value;
                                        ++x2;
                                        ++xy;
                                    }
                                    ++y;
                                }
                                int southBorder = this.val$height - kRadius;
                                while (y < southBorder) {
                                    x = 0;
                                    while (x < width) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadiusY;
                                        while (kOffset <= kRadiusY) {
                                            value += this.val$in[xy + kOffset] * this.val$kernel[kIndex];
                                            kOffset += width;
                                            ++kIndex;
                                        }
                                        this.val$out[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                                while (y < this.val$height) {
                                    x = 0;
                                    while (x < width) {
                                        int yEndOffset = this.val$sliceSize - width + x;
                                        double value2 = 0.0;
                                        int kIndex2 = 0;
                                        int kOffset2 = -kRadiusY;
                                        while (kOffset2 <= kRadiusY) {
                                            int inOffset = xy + kOffset2;
                                            if (inOffset >= this.val$sliceSize) {
                                                inOffset = yEndOffset - (inOffset - yEndOffset);
                                            }
                                            value2 += this.val$in[inOffset] * this.val$kernel[kIndex2];
                                            kOffset2 += width;
                                            ++kIndex2;
                                        }
                                        this.val$out[xy] = value2;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                            }
                        }));
                        ++var11_25;
                    }
                    for (Future future : arrayList) {
                        future.get();
                    }
                    break;
                }
                case Z: {
                    void var10_21;
                    void var10_20;
                    void var10_19;
                    ArrayList tasks = new ArrayList(input.length);
                    boolean bl = false;
                    while (var10_19 < kRadius) {
                        double[] dArray = output[var10_19];
                        void slice = var10_19++;
                        tasks.add(service.submit(new Runnable((int)slice, input, kernel, dArray){
                            private final /* synthetic */ int val$slice;
                            private final /* synthetic */ double[][] val$input;
                            private final /* synthetic */ double[] val$kernel;
                            private final /* synthetic */ double[] val$out;
                            {
                                this.val$slice = n4;
                                this.val$input = dArray;
                                this.val$kernel = dArray2;
                                this.val$out = dArray3;
                            }

                            @Override
                            public void run() {
                                int xy = 0;
                                int y = 0;
                                while (y < height) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inSlice = this.val$slice + kOffset;
                                            if (inSlice < 0) {
                                                inSlice = -inSlice;
                                            }
                                            value += this.val$input[inSlice][xy] * this.val$kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        this.val$out[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                            }
                        }));
                    }
                    int n = input.length - kRadius;
                    while (var10_20 < n) {
                        double[] out = output[var10_20];
                        void var13_35 = var10_20++;
                        tasks.add(service.submit(new Runnable((int)var13_35, kernel, out){
                            private final /* synthetic */ int val$slice;
                            private final /* synthetic */ double[] val$kernel;
                            private final /* synthetic */ double[] val$out;
                            {
                                this.val$slice = n4;
                                this.val$kernel = dArray2;
                                this.val$out = dArray3;
                            }

                            @Override
                            public void run() {
                                int xy = 0;
                                int y = 0;
                                while (y < height) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            value += input[this.val$slice + kOffset][xy] * this.val$kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        this.val$out[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                            }
                        }));
                    }
                    int zEndOffset = input.length - 1;
                    while (var10_21 < input.length) {
                        double[] dArray = output[var10_21];
                        void slice = var10_21++;
                        tasks.add(service.submit(new Runnable((int)slice, input, zEndOffset, kernel, dArray){
                            private final /* synthetic */ int val$slice;
                            private final /* synthetic */ double[][] val$input;
                            private final /* synthetic */ int val$zEndOffset;
                            private final /* synthetic */ double[] val$kernel;
                            private final /* synthetic */ double[] val$out;
                            {
                                this.val$slice = n4;
                                this.val$input = dArray;
                                this.val$zEndOffset = n5;
                                this.val$kernel = dArray2;
                                this.val$out = dArray3;
                            }

                            @Override
                            public void run() {
                                int xy = 0;
                                int y = 0;
                                while (y < height) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inSlice = this.val$slice + kOffset;
                                            if (inSlice >= this.val$input.length) {
                                                inSlice = this.val$zEndOffset - (inSlice - this.val$zEndOffset);
                                            }
                                            value += this.val$input[inSlice][xy] * this.val$kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        this.val$out[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                            }
                        }));
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConvolutionException("Filter size is too large along " + axis.name(), e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

