/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.component.sequence.SequencePreviewPanel;
import icy.image.IcyBufferedImage;
import icy.sequence.AbstractSequenceModel;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SequenceDimensionConvertPanel
extends JPanel {
    private static final long serialVersionUID = -6906749224563258829L;
    private JRadioButton ztRadioButton;
    private JRadioButton tzRadioButton;
    JSlider sizeZSlider;
    JSlider sizeTSlider;
    JSpinner sizeZSpinner;
    JSpinner sizeTSpinner;
    SequencePreviewPanel previewPane;
    private ButtonGroup dimensionGroup;
    final Sequence sequence;
    boolean changingZ;
    boolean changingT;

    public SequenceDimensionConvertPanel(Sequence sequence) {
        this.sequence = sequence;
        this.changingZ = false;
        this.changingT = false;
        this.initialize();
        this.dimensionGroup = new ButtonGroup();
        this.dimensionGroup.add(this.tzRadioButton);
        this.dimensionGroup.add(this.ztRadioButton);
        this.dimensionGroup.setSelected(this.ztRadioButton.getModel(), true);
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        int sizeZT = sizeZ * sizeT;
        this.sizeZSlider.setModel(new DefaultBoundedRangeModel(sizeZ, 0, 1, sizeZT));
        this.sizeZSpinner.setModel(new SpinnerNumberModel(sizeZ, 1, sizeZT, 1));
        this.sizeTSlider.setModel(new DefaultBoundedRangeModel(sizeT, 0, 1, sizeZT));
        this.sizeTSpinner.setModel(new SpinnerNumberModel(sizeT, 1, sizeZT, 1));
        this.tzRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceDimensionConvertPanel.this.previewPane.imageChanged();
            }
        });
        this.ztRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceDimensionConvertPanel.this.previewPane.imageChanged();
            }
        });
        this.sizeZSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SequenceDimensionConvertPanel.this.changingT) {
                    return;
                }
                int newSize = SequenceDimensionConvertPanel.this.sizeZSlider.getValue();
                SequenceDimensionConvertPanel.this.sizeZSpinner.setValue(newSize);
                SequenceDimensionConvertPanel.this.sizeZChanged();
            }
        });
        this.sizeZSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SequenceDimensionConvertPanel.this.changingT) {
                    return;
                }
                int newSize = (Integer)SequenceDimensionConvertPanel.this.sizeZSpinner.getValue();
                SequenceDimensionConvertPanel.this.sizeZSlider.setValue(newSize);
                SequenceDimensionConvertPanel.this.sizeZChanged();
            }
        });
        this.sizeTSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SequenceDimensionConvertPanel.this.changingZ) {
                    return;
                }
                int newSize = SequenceDimensionConvertPanel.this.sizeTSlider.getValue();
                SequenceDimensionConvertPanel.this.sizeTSpinner.setValue(newSize);
                SequenceDimensionConvertPanel.this.sizeTChanged();
            }
        });
        this.sizeTSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SequenceDimensionConvertPanel.this.changingZ) {
                    return;
                }
                int newSize = (Integer)SequenceDimensionConvertPanel.this.sizeTSpinner.getValue();
                SequenceDimensionConvertPanel.this.sizeTSlider.setValue(newSize);
                SequenceDimensionConvertPanel.this.sizeTChanged();
            }
        });
        this.previewPane.setModel(new SequenceDimensionConvertPanelModel());
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[9];
        nArray[0] = 20;
        nArray[2] = 20;
        nArray[6] = 80;
        nArray[7] = 20;
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = new int[5];
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblNewLabel = new JLabel("Dimension order");
        lblNewLabel.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.fill = 1;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 1;
        gbc_lblNewLabel.gridy = 0;
        this.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.ztRadioButton = new JRadioButton("Z - T");
        GridBagConstraints gbc_ztRadioButton = new GridBagConstraints();
        gbc_ztRadioButton.fill = 1;
        gbc_ztRadioButton.insets = new Insets(0, 0, 5, 5);
        gbc_ztRadioButton.gridx = 3;
        gbc_ztRadioButton.gridy = 0;
        this.add((Component)this.ztRadioButton, gbc_ztRadioButton);
        this.tzRadioButton = new JRadioButton("T - Z");
        GridBagConstraints gbc_tzRadioButton = new GridBagConstraints();
        gbc_tzRadioButton.gridwidth = 2;
        gbc_tzRadioButton.fill = 1;
        gbc_tzRadioButton.insets = new Insets(0, 0, 5, 5);
        gbc_tzRadioButton.gridx = 4;
        gbc_tzRadioButton.gridy = 0;
        this.add((Component)this.tzRadioButton, gbc_tzRadioButton);
        JLabel lblNewLabel_1 = new JLabel("Size Z");
        lblNewLabel_1.setHorizontalAlignment(11);
        lblNewLabel_1.setToolTipText("Size of Z dimension");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.fill = 1;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_1.gridx = 1;
        gbc_lblNewLabel_1.gridy = 1;
        this.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        this.sizeZSpinner = new JSpinner();
        this.sizeZSpinner.setToolTipText("Size of Z dimension");
        GridBagConstraints gbc_zSpinner = new GridBagConstraints();
        gbc_zSpinner.gridwidth = 2;
        gbc_zSpinner.fill = 1;
        gbc_zSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_zSpinner.gridx = 3;
        gbc_zSpinner.gridy = 1;
        this.add((Component)this.sizeZSpinner, gbc_zSpinner);
        this.sizeZSlider = new JSlider();
        GridBagConstraints gbc_zSlider = new GridBagConstraints();
        gbc_zSlider.gridwidth = 2;
        gbc_zSlider.fill = 1;
        gbc_zSlider.insets = new Insets(0, 0, 5, 5);
        gbc_zSlider.gridx = 5;
        gbc_zSlider.gridy = 1;
        this.add((Component)this.sizeZSlider, gbc_zSlider);
        JLabel lblNewLabel_2 = new JLabel("Size T");
        lblNewLabel_2.setHorizontalAlignment(11);
        lblNewLabel_2.setToolTipText("Size of T dimension");
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.fill = 1;
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_2.gridx = 1;
        gbc_lblNewLabel_2.gridy = 2;
        this.add((Component)lblNewLabel_2, gbc_lblNewLabel_2);
        this.sizeTSpinner = new JSpinner();
        this.sizeTSpinner.setToolTipText("Size of T dimension");
        GridBagConstraints gbc_tSpinner = new GridBagConstraints();
        gbc_tSpinner.gridwidth = 2;
        gbc_tSpinner.fill = 1;
        gbc_tSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_tSpinner.gridx = 3;
        gbc_tSpinner.gridy = 2;
        this.add((Component)this.sizeTSpinner, gbc_tSpinner);
        this.sizeTSlider = new JSlider();
        GridBagConstraints gbc_tSlider = new GridBagConstraints();
        gbc_tSlider.gridwidth = 2;
        gbc_tSlider.insets = new Insets(0, 0, 5, 5);
        gbc_tSlider.fill = 1;
        gbc_tSlider.gridx = 5;
        gbc_tSlider.gridy = 2;
        this.add((Component)this.sizeTSlider, gbc_tSlider);
        this.previewPane = new SequencePreviewPanel(true);
        this.previewPane.setBorder(new TitledBorder(null, "Preview", 4, 2, null, null));
        GridBagConstraints gbc_previewPane = new GridBagConstraints();
        gbc_previewPane.gridwidth = 8;
        gbc_previewPane.insets = new Insets(0, 0, 0, 5);
        gbc_previewPane.fill = 1;
        gbc_previewPane.gridx = 0;
        gbc_previewPane.gridy = 3;
        this.add((Component)this.previewPane, gbc_previewPane);
    }

    void sizeZChanged() {
        int sizeZT = this.sequence.getSizeZ() * this.sequence.getSizeT();
        int newSizeZ = this.getNewSizeZ();
        int newSizeT = sizeZT / newSizeZ;
        if (sizeZT % newSizeZ != 0) {
            ++newSizeT;
        }
        this.changingZ = true;
        try {
            this.sizeTSpinner.setValue(newSizeT);
            this.sizeTSlider.setValue(newSizeT);
            this.previewPane.dimensionChanged();
        }
        finally {
            this.changingZ = false;
        }
    }

    void sizeTChanged() {
        int sizeZT = this.sequence.getSizeZ() * this.sequence.getSizeT();
        int newSizeT = this.getNewSizeT();
        int newSizeZ = sizeZT / newSizeT;
        if (sizeZT % newSizeT != 0) {
            ++newSizeZ;
        }
        this.changingT = true;
        try {
            this.sizeZSpinner.setValue(newSizeZ);
            this.sizeZSlider.setValue(newSizeZ);
            this.previewPane.dimensionChanged();
        }
        finally {
            this.changingT = false;
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public boolean isOrderReversed() {
        return this.dimensionGroup.getSelection() == this.tzRadioButton.getModel();
    }

    public int getNewSizeZ() {
        return (Integer)this.sizeZSpinner.getValue();
    }

    public int getNewSizeT() {
        return (Integer)this.sizeTSpinner.getValue();
    }

    private class SequenceDimensionConvertPanelModel
    extends AbstractSequenceModel {
        @Override
        public BufferedImage getImage(int t, int z) {
            return SequenceUtil.AdjustZTHelper.getImage(SequenceDimensionConvertPanel.this.sequence, t, z, SequenceDimensionConvertPanel.this.getNewSizeZ(), SequenceDimensionConvertPanel.this.getNewSizeT(), SequenceDimensionConvertPanel.this.isOrderReversed());
        }

        @Override
        public int getSizeX() {
            return SequenceDimensionConvertPanel.this.sequence.getSizeX();
        }

        @Override
        public int getSizeY() {
            return SequenceDimensionConvertPanel.this.sequence.getSizeY();
        }

        @Override
        public int getSizeZ() {
            return SequenceDimensionConvertPanel.this.getNewSizeZ();
        }

        @Override
        public int getSizeT() {
            return SequenceDimensionConvertPanel.this.getNewSizeT();
        }

        @Override
        public int getSizeC() {
            return SequenceDimensionConvertPanel.this.sequence.getSizeC();
        }

        @Override
        public BufferedImage getImage(int t, int z, int c) {
            return ((IcyBufferedImage)this.getImage(t, z)).getImage(c);
        }
    }
}

