package plugins.ylemontag.sequencecomparator.blocks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComponent;

import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.ylemontag.sequencecomparator.LocalComparatorFactory;
import plugins.ylemontag.sequencecomparator.gui.LocalComparatorComponent;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Wrap a local comparator factory
 */
public class VarLocalComparator extends Var<LocalComparatorFactory>
{
	/**
	 * Editor
	 */
	private static class Editor extends SwingVarEditor<LocalComparatorFactory>
	{
		private boolean _enableListeners;
		private LocalComparatorComponent _component;
		
		public Editor(Var<LocalComparatorFactory> variable)
		{
			super(variable);
		}
		
		@Override
		protected JComponent createEditorComponent()
		{
			_enableListeners = true;
			_component = new LocalComparatorComponent();
			_component.addActionListener(new ActionListener()
			{
				@Override
				public void actionPerformed(ActionEvent e) {
					if(_enableListeners) {
						variable.setValue(_component.getSelectedObject());
					}
				}
			});
			return _component;
		}
		
		@Override
		protected void activateListeners()
		{
			_enableListeners = true;
		}
		
		@Override
		protected void deactivateListeners()
		{
			_enableListeners = false;
		}
		
		@Override
		protected void updateInterfaceValue()
		{
			LocalComparatorFactory value = variable.getValue();
			if(value==null) {
				return;
			}
			_component.setSelectedObject(value);
		}
	}
	
	public VarLocalComparator(String name, LocalComparatorFactory defaultValue)
	{
		super(name, LocalComparatorFactory.class, defaultValue);
	}
	
	@Override
	public VarEditor<LocalComparatorFactory> createVarEditor()
	{
		return new Editor(this);
	}
	
	@Override
	public LocalComparatorFactory parse(String text)
	{
		return Enum.valueOf(LocalComparatorFactory.class, text);
	}
}
