/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.variants;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.image.BufferedImage;
import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.variants.DimensionSequence;
import plugins.ylemontag.mathoperations.variants.SequenceIterators;

public class VariantSequence
extends Variant {
    private Sequence _value;
    private int _sizeX;
    private int _sizeY;
    private int _sizeZ;
    private int _sizeT;
    private int _sizeC;
    private ImagePrecursor[] _precursors;
    private boolean _dynamicAllocation;

    public VariantSequence(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC) {
        super(Variant.Type.SEQUENCE);
        this._value = new Sequence();
        this._sizeX = sizeX;
        this._sizeY = sizeY;
        this._sizeZ = sizeZ;
        this._sizeT = sizeT;
        this._sizeC = sizeC;
        this._dynamicAllocation = true;
    }

    public VariantSequence(Sequence value) {
        super(Variant.Type.SEQUENCE);
        if (value == null) {
            throw new IllegalArgumentException("Cannot wrap a null sequence in a Variant object.");
        }
        this._value = value;
        this._sizeX = this._value.getSizeX();
        this._sizeY = this._value.getSizeY();
        this._sizeZ = this._value.getSizeZ();
        this._sizeT = this._value.getSizeT();
        this._sizeC = this._value.getSizeC();
        this._dynamicAllocation = false;
    }

    @Override
    public Sequence getAsSequence() {
        return this._value;
    }

    @Override
    public String getRepresentation(boolean addParenthesisIfFragile) {
        String retVal = this._value.getName();
        if (addParenthesisIfFragile && VariantSequence.isFragileString(retVal)) {
            retVal = "(" + retVal + ")";
        }
        return retVal;
    }

    @Override
    public Variant.Dimension getDimension() {
        return new DimensionSequence(this._sizeX, this._sizeY, this._sizeZ, this._sizeT, this._sizeC);
    }

    @Override
    public boolean isReadable() {
        return !this._dynamicAllocation;
    }

    @Override
    public boolean isWritable() {
        DataType datatype = this._value.getDataType_();
        return datatype == DataType.DOUBLE || datatype == DataType.UNDEFINED;
    }

    @Override
    protected Variant.ReadIterator implGetReadIterator() {
        if (this._value.getDataType_() == DataType.DOUBLE) {
            return new DoubleValuedSequenceIterator(this._value);
        }
        return new ConvertOnFlySequenceIterator(this._value);
    }

    @Override
    protected Variant.WriteIterator implGetWriteIterator() {
        if (this._dynamicAllocation) {
            return new DynamicSequenceIterator(this);
        }
        return new PreAllocatedSequenceIterator(this);
    }

    @Override
    protected void implBeginUpdate() {
        this._value.beginUpdate();
        if (this._dynamicAllocation) {
            this._value.removeAllImages();
            this._precursors = new ImagePrecursor[this._sizeZ * this._sizeT];
            for (int k = 0; k < this._precursors.length; ++k) {
                this._precursors[k] = new ImagePrecursor(this);
            }
        }
    }

    @Override
    protected void implEndUpdate() {
        this._precursors = null;
        if (this._dynamicAllocation && this._sizeX == this._value.getSizeX() && this._sizeY == this._value.getSizeY() && this._sizeZ == this._value.getSizeZ() && this._sizeT == this._value.getSizeT() && this._sizeC == this._value.getSizeC()) {
            this._dynamicAllocation = false;
        }
        this._value.endUpdate();
    }

    private static class ImagePrecursor {
        private VariantSequence _target;
        private Object[] _data;
        private boolean _done;

        public ImagePrecursor(VariantSequence target) {
            this._target = target;
            this._data = (Object[])new double[this._target._sizeC][];
            this._done = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendData(int t, int z, int c, double[] dataXY) {
            this._data[c] = dataXY;
            for (Object o : this._data) {
                if (o != null) continue;
                return;
            }
            ImagePrecursor imagePrecursor = this;
            synchronized (imagePrecursor) {
                if (this._done) {
                    return;
                }
                IcyBufferedImage image = new IcyBufferedImage(this._target._sizeX, this._target._sizeY, this._data);
                Sequence sequence = this._target._value;
                synchronized (sequence) {
                    this._target._value.setImage(t, z, (BufferedImage)image);
                }
                this._done = true;
            }
        }
    }

    private static class DynamicSequenceIterator
    extends SequenceIterators.Write {
        private VariantSequence _target;
        private ImagePrecursor _precursor;
        private int _previousT;
        private int _previousZ;
        private int _previousC;

        public DynamicSequenceIterator(VariantSequence target) {
            super(target._sizeX, target._sizeY, target._sizeZ, target._sizeT, target._sizeC);
            this._target = target;
        }

        @Override
        protected void refreshBuffer() {
            this.saveCurrentBuffer();
            this._precursor = this._target._precursors[this._z + this._sizeZ * this._t];
            this._previousT = this._t;
            this._previousZ = this._z;
            this._previousC = this._c;
            this._buffer = new double[this._sizeXY];
        }

        @Override
        protected void invalidateBuffer() {
            this.saveCurrentBuffer();
            super.invalidateBuffer();
        }

        private void saveCurrentBuffer() {
            if (this._precursor != null) {
                this._precursor.appendData(this._previousT, this._previousZ, this._previousC, this._buffer);
            }
        }
    }

    private static class PreAllocatedSequenceIterator
    extends SequenceIterators.Write {
        private VariantSequence _target;

        public PreAllocatedSequenceIterator(VariantSequence target) {
            super(target._sizeX, target._sizeY, target._sizeZ, target._sizeT, target._sizeC);
            this._target = target;
        }

        @Override
        protected void refreshBuffer() {
            this._buffer = this._target.getAsSequence().getDataXYAsDouble(this._t, this._z, this._c);
        }
    }

    private static class ConvertOnFlySequenceIterator
    extends SequenceIterators.Read {
        private Sequence _source;
        private boolean _isSigned;

        public ConvertOnFlySequenceIterator(Sequence source) {
            super(source.getSizeX(), source.getSizeY(), source.getSizeZ(), source.getSizeT(), source.getSizeC());
            this._source = source;
            this._isSigned = this._source.getDataType_().isSigned();
            this._buffer = new double[this._sizeXY];
        }

        @Override
        protected void refreshBuffer() {
            Array1DUtil.arrayToDoubleArray((Object)this._source.getDataXY(this._t, this._z, this._c), (double[])this._buffer, (boolean)this._isSigned);
        }
    }

    private static class DoubleValuedSequenceIterator
    extends SequenceIterators.Read {
        private Sequence _source;

        public DoubleValuedSequenceIterator(Sequence source) {
            super(source.getSizeX(), source.getSizeY(), source.getSizeZ(), source.getSizeT(), source.getSizeC());
            this._source = source;
        }

        @Override
        protected void refreshBuffer() {
            this._buffer = this._source.getDataXYAsDouble(this._t, this._z, this._c);
        }
    }
}

