/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.overlay;

import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class GlobalVisibleOverlay
extends Overlay
implements Layer.LayerListener {
    public static final String ID = "GlobalVisibleOverlay";
    public static final String ID_OVERLAY = "overlay";
    public static final String ID_CLASSNAME = "classname";
    public static final String ID_ID = "id";
    public static final String ID_NAME = "name";
    public static final String ID_PRIORITY = "priority";
    public static final String ID_READONLY = "readOnly";
    public static final String ID_CANBEREMOVED = "canBeRemoved";
    public static final String ID_RECEIVEKEYEVENTONHIDDEN = "receiveKeyEventOnHidden";
    public static final String ID_RECEIVEMOUSEEVENTONHIDDEN = "receiveMouseEventOnHidden";
    public static final String ID_ROIS = "rois";
    public static final String ID_ROI = "roi";
    public static final String ID_ROI_ID = "roiId";
    protected final Set<Overlay> overlays;
    protected final Map<Layer, IcyCanvas> layerMap;

    public GlobalVisibleOverlay(String name, List<Overlay> overlays) {
        super(name);
        this.overlays = overlays != null ? new HashSet<Overlay>(overlays) : new HashSet();
        this.layerMap = new HashMap<Layer, IcyCanvas>();
    }

    public GlobalVisibleOverlay(List<Overlay> overlays) {
        this("Global visible", overlays);
    }

    public GlobalVisibleOverlay() {
        this("Global visible", null);
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        Layer layer = canvas.getLayer((Overlay)this);
        if (!this.layerMap.containsKey(layer)) {
            this.layerMap.put(layer, canvas);
            this.layerChanged(layer, "visible");
            layer.addListener((Layer.LayerListener)this);
            this.saveToXML(sequence, sequence.getNode(ID));
        }
    }

    public void layerChanged(Layer source, String propertyName) {
        IcyCanvas canvas;
        if (StringUtil.equals((String)propertyName, (String)"visible") && (canvas = this.layerMap.get(source)) != null) {
            boolean visible = source.isVisible();
            for (Overlay overlay : this.overlays) {
                Layer layer = canvas.getLayer(overlay);
                if (layer == null) continue;
                layer.setVisible(visible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFromXML(Sequence sequence, Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            this.setName(XMLUtil.getElementValue((Node)node, (String)ID_NAME, (String)""));
            this.setPriority(Overlay.OverlayPriority.values()[XMLUtil.getElementIntValue((Node)node, (String)ID_PRIORITY, (int)Overlay.OverlayPriority.SHAPE_NORMAL.ordinal())]);
            this.setReadOnly(XMLUtil.getElementBooleanValue((Node)node, (String)ID_READONLY, (boolean)false));
            this.setReceiveKeyEventOnHidden(XMLUtil.getElementBooleanValue((Node)node, (String)ID_RECEIVEKEYEVENTONHIDDEN, (boolean)false));
            this.setReceiveMouseEventOnHidden(XMLUtil.getElementBooleanValue((Node)node, (String)ID_RECEIVEMOUSEEVENTONHIDDEN, (boolean)false));
            this.overlays.clear();
            List rois = sequence.getROIs(true);
            SearchROI searchRoi = new SearchROI();
            ArrayList nodesId = XMLUtil.getChildren((Node)XMLUtil.getElement((Node)node, (String)ID_ROIS), (String)ID_ROI);
            if (nodesId != null) {
                for (Node n : nodesId) {
                    int ind;
                    searchRoi.setId(XMLUtil.getElementIntValue((Node)n, (String)ID_ROI_ID, (int)-1));
                    if (searchRoi.getId() == -1 || (ind = Collections.binarySearch(rois, searchRoi, ROI.idComparator)) < 0) continue;
                    this.overlays.add((Overlay)((ROI)rois.get(ind)).getOverlay());
                }
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    public boolean saveToXML(Sequence sequence, Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.removeAllChildren((Node)node);
        XMLUtil.setElementValue((Node)node, (String)ID_CLASSNAME, (String)((Object)((Object)this)).getClass().getName());
        XMLUtil.setElementIntValue((Node)node, (String)ID_ID, (int)this.id);
        XMLUtil.setElementValue((Node)node, (String)ID_NAME, (String)this.getName());
        XMLUtil.setElementIntValue((Node)node, (String)ID_PRIORITY, (int)this.getPriority().ordinal());
        XMLUtil.setElementBooleanValue((Node)node, (String)ID_READONLY, (boolean)this.isReadOnly());
        XMLUtil.setElementBooleanValue((Node)node, (String)ID_RECEIVEKEYEVENTONHIDDEN, (boolean)this.getReceiveKeyEventOnHidden());
        XMLUtil.setElementBooleanValue((Node)node, (String)ID_RECEIVEMOUSEEVENTONHIDDEN, (boolean)this.getReceiveMouseEventOnHidden());
        ArrayList rois = sequence.getROIs();
        for (int i = rois.size() - 1; i >= 0; --i) {
            ROI roi = (ROI)rois.get(i);
            if (this.overlays.contains(roi.getOverlay())) continue;
            rois.remove(i);
        }
        Element nodeRois = XMLUtil.setElement((Node)node, (String)ID_ROIS);
        for (ROI roi : rois) {
            Element nodeRoi = XMLUtil.addElement((Node)nodeRois, (String)ID_ROI);
            XMLUtil.setElementIntValue((Node)nodeRoi, (String)ID_ROI_ID, (int)roi.getId());
        }
        return true;
    }

    private class SearchROI
    extends ROI2DPoint {
        public void setId(int value) {
            this.id = value;
        }
    }
}

