/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array4D;
import mitiv.array.Byte4D;
import mitiv.array.Double4D;
import mitiv.array.Float4D;
import mitiv.array.Int1D;
import mitiv.array.Int3D;
import mitiv.array.IntArray;
import mitiv.array.Long4D;
import mitiv.array.ShapedArray;
import mitiv.array.Short4D;
import mitiv.array.impl.FlatInt4D;
import mitiv.array.impl.StriddenInt4D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int4D
extends Array4D
implements IntArray {
    protected Int4D(int dim1, int dim2, int dim3, int dim4) {
        super(dim1, dim2, dim3, dim4);
    }

    protected Int4D(int[] dims) {
        super(dims);
    }

    protected Int4D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2, int var3, int var4);

    public abstract void set(int var1, int var2, int var3, int var4, int var5);

    @Override
    public void fill(int value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, value);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, value);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(int value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) + value);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) + value);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(int value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) - value);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) - value);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(int value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) * value);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) * value);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(IntFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, function.apply(this.get(i1, i2, i3, i4)));
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, function.apply(this.get(i1, i2, i3, i4)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, generator.nextInt());
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, generator.nextInt());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            if (initialized) {
                                scanner.update(this.get(i1, i2, i3, i4));
                                continue;
                            }
                            scanner.initialize(this.get(i1, i2, i3, i4));
                            initialized = true;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            if (initialized) {
                                scanner.update(this.get(i1, i2, i3, i4));
                                continue;
                            }
                            scanner.initialize(this.get(i1, i2, i3, i4));
                            initialized = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            int value = this.get(i1, i2, i3, i4);
                            if (value >= minValue) continue;
                            minValue = value;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            int value = this.get(i1, i2, i3, i4);
                            if (value >= minValue) continue;
                            minValue = value;
                        }
                    }
                }
            }
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            int value = this.get(i1, i2, i3, i4);
                            if (value <= maxValue) continue;
                            maxValue = value;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            int value = this.get(i1, i2, i3, i4);
                            if (value <= maxValue) continue;
                            maxValue = value;
                        }
                    }
                }
            }
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            int value = this.get(i1, i2, i3, i4);
                            if (value < minValue) {
                                minValue = value;
                            }
                            if (value <= maxValue) continue;
                            maxValue = value;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            int value = this.get(i1, i2, i3, i4);
                            if (value < minValue) {
                                minValue = value;
                            }
                            if (value <= maxValue) continue;
                            maxValue = value;
                        }
                    }
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            totalValue += this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            totalValue += this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte4D toByte() {
        byte[] out = new byte[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (byte)inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = (byte)this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Byte4D.wrap(out, this.getShape());
    }

    @Override
    public Short4D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = (short)this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Short4D.wrap(out, this.getShape());
    }

    @Override
    public Int4D toInt() {
        return this;
    }

    @Override
    public Long4D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Long4D.wrap(out, this.getShape());
    }

    @Override
    public Float4D toFloat() {
        float[] out = new float[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Float4D.wrap(out, this.getShape());
    }

    @Override
    public Double4D toDouble() {
        double[] out = new double[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Double4D.wrap(out, this.getShape());
    }

    @Override
    public Int4D copy() {
        return new FlatInt4D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Int4D src = arr.getType() == 2 ? (Int4D)arr : (Int4D)arr.toInt();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, src.get(i1, i2, i3, i4));
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, src.get(i1, i2, i3, i4));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, (int)src.get(++i));
                        }
                    }
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, (int)src.get(++i));
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int4D create() {
        return new FlatInt4D(this.getShape());
    }

    public static Int4D create(int dim1, int dim2, int dim3, int dim4) {
        return new FlatInt4D(dim1, dim2, dim3, dim4);
    }

    public static Int4D create(int[] dims) {
        return new FlatInt4D(dims);
    }

    public static Int4D create(Shape shape) {
        return new FlatInt4D(shape);
    }

    public static Int4D wrap(int[] data, int dim1, int dim2, int dim3, int dim4) {
        return new FlatInt4D(data, dim1, dim2, dim3, dim4);
    }

    public static Int4D wrap(int[] data, int[] dims) {
        return new FlatInt4D(data, dims);
    }

    public static Int4D wrap(int[] data, Shape shape) {
        return new FlatInt4D(data, shape);
    }

    public static Int4D wrap(int[] data, int offset, int stride1, int stride2, int stride3, int stride4, int dim1, int dim2, int dim3, int dim4) {
        return new StriddenInt4D(data, offset, stride1, stride2, stride3, stride4, dim1, dim2, dim3, dim4);
    }

    @Override
    public abstract Int3D slice(int var1);

    @Override
    public abstract Int3D slice(int var1, int var2);

    @Override
    public abstract Int4D view(Range var1, Range var2, Range var3, Range var4);

    @Override
    public abstract Int4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Int1D as1D();
}

