/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.painter.Anchor3D;
import icy.roi.ROI3D;
import icy.roi.edit.AbstractPoint3DROIEdit;
import icy.type.point.Point3D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class Point3DMovedROIEdit
extends AbstractPoint3DROIEdit {
    protected Point3D prevPos;
    protected Point3D currentPos;

    public Point3DMovedROIEdit(ROI3D roi, Anchor3D point, Point3D prevPos) {
        super(roi, point, "ROI point moved");
        this.prevPos = prevPos;
        this.currentPos = point.getPosition();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.point.setPosition(this.prevPos);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.point.setPosition(this.currentPos);
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        Point3DMovedROIEdit posEdit;
        if (!this.isMergeable()) {
            return false;
        }
        if (edit instanceof Point3DMovedROIEdit && (posEdit = (Point3DMovedROIEdit)edit).getROI() == this.getROI() && posEdit.getPoint() == this.getPoint()) {
            this.currentPos = posEdit.currentPos;
            return true;
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.prevPos = null;
        this.currentPos = null;
    }
}

