/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.painter.Anchor2D;
import icy.roi.edit.AbstractPoint2DROIEdit;
import java.awt.geom.Point2D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Point2DMovedROIEdit
extends AbstractPoint2DROIEdit {
    protected Point2D prevPos;
    protected Point2D currentPos;

    public Point2DMovedROIEdit(ROI2DShape roi, Anchor2D point, Point2D prevPos) {
        super(roi, point, "ROI point moved");
        this.prevPos = prevPos;
        this.currentPos = point.getPosition();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.point.setPosition(this.prevPos);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.point.setPosition(this.currentPos);
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        Point2DMovedROIEdit posEdit;
        if (!this.isMergeable()) {
            return false;
        }
        if (edit instanceof Point2DMovedROIEdit && (posEdit = (Point2DMovedROIEdit)edit).getROI() == this.getROI() && posEdit.getPoint() == this.getPoint()) {
            this.currentPos = posEdit.currentPos;
            return true;
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.prevPos = null;
        this.currentPos = null;
    }
}

