/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.io;

import icy.file.FileUtil;
import icy.plugin.abstract_.Plugin;
import icy.system.IcyHandledException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import plugins.adufour.blocks.tools.io.FileToWorkbook;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.workbooks.Workbooks;

public class WorkbookToFile
extends Plugin
implements IOBlock {
    VarWorkbook workbook = new VarWorkbook("workbook", (Workbook)null);
    VarFile file = new VarFile("output file", null);
    VarEnum<WorkbookFormat> format = new VarEnum("file format", (Enum)WorkbookFormat.Spreadsheet);
    VarEnum<MergePolicy> append = new VarEnum("If file exists", (Enum)MergePolicy.Overwrite);

    public void run() {
        switch ((WorkbookFormat)((Object)this.format.getValue())) {
            case Spreadsheet: {
                WorkbookToFile.saveAsSpreadSheet((Workbook)this.workbook.getValue(true), ((File)this.file.getValue(true)).getAbsolutePath(), (MergePolicy)((Object)this.append.getValue()));
                break;
            }
            case Text: {
                WorkbookToFile.saveAsText((Workbook)this.workbook.getValue(true), ((File)this.file.getValue(true)).getAbsolutePath(), (MergePolicy)((Object)this.append.getValue()));
            }
        }
        if (this.append.getValue() != MergePolicy.Overwrite) {
            this.workbook.valueChanged(this.workbook, null, this.workbook.getValue());
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("workbook", (Var)this.workbook);
        inputMap.add("file format", this.format);
        inputMap.add("output file", (Var)this.file);
        inputMap.add("If file exists", this.append);
    }

    public void declareOutput(VarList outputMap) {
    }

    @Deprecated
    public static void saveAsSpreadSheet(Workbook workbook, String fileName) {
        WorkbookToFile.saveAsSpreadSheet(workbook, fileName, MergePolicy.Overwrite);
    }

    public static void saveAsSpreadSheet(Workbook workbook, String fileName, MergePolicy mergePolicy) {
        File file = new File(fileName);
        if (file.isDirectory()) {
            throw new IcyHandledException("Cannot save workbook: the specified file is a folder");
        }
        String extension = Workbooks.getFormat(workbook).getExtension();
        if (!file.exists() && !fileName.toLowerCase().endsWith(extension)) {
            file = new File(FileUtil.setExtension((String)file.getPath(), (String)extension));
        }
        if (file.exists() && mergePolicy != MergePolicy.Overwrite) {
            try {
                WorkbookToFile.mergeWorkbooks(FileToWorkbook.readWorkbook(file), workbook, mergePolicy);
            }
            catch (IllegalArgumentException e) {
                String message = "Unable to merge (target file has not the same format)";
                throw new IcyHandledException(message);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            File tmp = File.createTempFile("icy_tmp_workbook", extension);
            FileOutputStream stream = new FileOutputStream(tmp);
            workbook.write((OutputStream)stream);
            stream.close();
            FileUtil.rename((File)tmp, (File)file, (boolean)true);
        }
        catch (FileNotFoundException e) {
            String error = "Cannot create file " + fileName + "\n";
            error = error + "Reason: " + e.getMessage() + "\n\n";
            error = error + "Please ensure that:\n";
            error = error + " - You have permission to write to this folder\n";
            error = error + " - The file name does not contains any special characters";
            throw new IcyHandledException(error);
        }
        catch (IOException e) {
            String error = "Cannot write file " + fileName + "\n";
            error = error + "Reason: " + e.getMessage() + "\n\n";
            error = error + "Please ensure that the file is not opened with another application.";
            throw new IcyHandledException(error);
        }
    }

    @Deprecated
    public static void saveAsText(Workbook workbook, String fileName) {
        WorkbookToFile.saveAsText(workbook, fileName, MergePolicy.Overwrite);
    }

    public static void saveAsText(Workbook workbook, String fileName, MergePolicy mergePolicy) {
        File file = new File(fileName);
        if (file.isDirectory()) {
            throw new IcyHandledException("Cannot save workbook: the specified file is a folder");
        }
        if (!file.exists() && !fileName.toLowerCase().endsWith(".txt")) {
            file = new File(fileName + ".txt");
        }
        if (file.exists() && mergePolicy != MergePolicy.Overwrite) {
            try {
                WorkbookToFile.mergeWorkbooks(FileToWorkbook.readWorkbook(file), workbook, mergePolicy);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            FileWriter fw = new FileWriter(file);
            int n = workbook.getNumberOfSheets();
            for (int i = 0; i < n; ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                fw.write("== " + sheet.getSheetName() + " ==\n");
                for (int r = sheet.getFirstRowNum(); r <= sheet.getLastRowNum(); ++r) {
                    Row row = sheet.getRow(r);
                    if (row != null) {
                        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
                            Cell cell = row.getCell(c, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                            if (cell != null) {
                                fw.write(cell.toString());
                            }
                            fw.write("\t");
                        }
                    }
                    fw.write("\n");
                }
                fw.write("\n");
            }
            fw.flush();
            fw.close();
        }
        catch (FileNotFoundException e) {
            String error = "Cannot create file " + fileName + "\n";
            error = error + "Reason: " + e.getMessage() + "\n\n";
            error = error + "Please ensure that:\n";
            error = error + " - You have permission to write to this folder\n";
            error = error + " - The file name does not contains any special characters";
            throw new IcyHandledException(error);
        }
        catch (IOException e) {
            String error = "Cannot write file " + fileName + "\n";
            error = error + "Reason: " + e.getMessage() + "\n\n";
            error = error + "Please ensure that the file is not opened with another application.";
            throw new IcyHandledException(error);
        }
    }

    private static void mergeWorkbooks(Workbook source, Workbook target, MergePolicy policy) {
        if (policy == MergePolicy.Overwrite) {
            return;
        }
        HashMap<Integer, CellStyle> styles = new HashMap<Integer, CellStyle>();
        for (int i = 0; i < source.getNumberOfSheets(); ++i) {
            Sheet sourceSheet = source.getSheetAt(i);
            String sourceSheetName = sourceSheet.getSheetName();
            Sheet targetSheet = target.getSheet(sourceSheetName);
            int sourceRowNum = 0;
            if (targetSheet == null) {
                targetSheet = target.createSheet(sourceSheetName);
            } else if (policy == MergePolicy.Merge_sheets___excluding_first_row) {
                // empty if block
            }
            int targetRowNum = targetSheet.getLastRowNum() + 1;
            int r = ++sourceRowNum;
            while (r <= sourceSheet.getLastRowNum()) {
                Row sourceRow = sourceSheet.getRow(r);
                if (sourceRow != null) {
                    Row targetRow = targetSheet.createRow(targetRowNum);
                    for (Cell sourceCell : sourceRow) {
                        Cell targetCell = targetRow.createCell(sourceCell.getColumnIndex());
                        int hashCode = sourceCell.getCellStyle().hashCode();
                        if (!styles.containsKey(hashCode)) {
                            CellStyle targetStyle = target.createCellStyle();
                            Workbooks.copyStyle(sourceCell.getCellStyle(), targetStyle);
                            styles.put(hashCode, targetStyle);
                        }
                        targetCell.setCellStyle((CellStyle)styles.get(hashCode));
                        Workbooks.copyCell(sourceCell, targetCell);
                    }
                }
                ++r;
                ++targetRowNum;
            }
        }
    }

    public static enum MergePolicy {
        Overwrite,
        Merge_sheets,
        Merge_sheets___excluding_first_row;


        public String toString() {
            return super.toString().replace("__", ",").replace("_", " ");
        }
    }

    public static enum WorkbookFormat {
        Spreadsheet,
        Text;

    }
}

