/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.intensity;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import plugins.kernel.roi.descriptor.intensity.ROIIntensityDescriptorsPlugin;

public class ROIMinIntensityDescriptor
extends ROIDescriptor {
    public static final String ID = "Min intensity";

    public ROIMinIntensityDescriptor() {
        super(ID, "Min Intensity", Double.class);
    }

    @Override
    public String getDescription() {
        return "Minimum intensity";
    }

    @Override
    public boolean separateChannel() {
        return true;
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        return change.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return ROIMinIntensityDescriptor.computeMinIntensity(roi, sequence);
    }

    public static double computeMinIntensity(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        try {
            return ROIIntensityDescriptorsPlugin.computeIntensityDescriptors((ROI)roi, (Sequence)sequence, (boolean)false).min;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.valueOf(ROIMinIntensityDescriptor.class.getSimpleName()) + ": cannot compute descriptors for '" + roi.getName() + "'", e);
        }
    }
}

