/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.searchprovider;

import icy.gui.plugin.PluginDetailPanel;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.search.OnlineSearchResultProducer;
import icy.search.SearchEngine;
import icy.search.SearchResult;
import icy.search.SearchResultConsumer;
import icy.search.SearchResultProducer;
import icy.system.thread.ThreadUtil;
import icy.util.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import plugins.kernel.searchprovider.LocalPluginSearchResultProducer;
import plugins.kernel.searchprovider.PluginSearchResult;

public class OnlinePluginSearchResultProducer
extends OnlineSearchResultProducer {
    private static final String ID_SEARCH_RESULT = "searchresult";
    private static final String ID_PLUGIN = "plugin";
    private static final String ID_CLASSNAME = "classname";
    private static final String ID_TEXT = "string";

    @Override
    public int getOrder() {
        return 6;
    }

    @Override
    public String getName() {
        return "Online plugins";
    }

    @Override
    public String getTooltipText() {
        return "Result(s) from online plugin";
    }

    @Override
    public void doSearch(Document doc, String text, SearchResultConsumer consumer) {
        if (!OnlinePluginSearchResultProducer.ensureOnlineLoaderLoaded()) {
            return;
        }
        if (this.hasWaitingSearch()) {
            return;
        }
        List<SearchResultProducer.SearchWord> words = OnlinePluginSearchResultProducer.getSearchWords(text);
        if (words.isEmpty()) {
            return;
        }
        ArrayList<PluginDescriptor> onlinePlugins = PluginRepositoryLoader.getPlugins();
        Element resultElement = XMLUtil.getElement(doc.getDocumentElement(), ID_SEARCH_RESULT);
        if (resultElement == null) {
            return;
        }
        SearchEngine se = Icy.getMainInterface().getSearchEngine();
        LocalPluginSearchResultProducer lpsrp = null;
        if (se != null) {
            for (SearchResultProducer srp : se.getSearchResultProducers()) {
                if (!(srp instanceof LocalPluginSearchResultProducer)) continue;
                lpsrp = (LocalPluginSearchResultProducer)srp;
            }
        }
        ArrayList<OnlinePluginResult> tmpResults = new ArrayList<OnlinePluginResult>();
        boolean startWithOnly = OnlinePluginSearchResultProducer.getShortSearch(words);
        for (Element element : XMLUtil.getElements(resultElement, ID_PLUGIN)) {
            if (this.hasWaitingSearch()) {
                return;
            }
            OnlinePluginResult result = this.getResult(consumer, onlinePlugins, element, words, startWithOnly, lpsrp);
            if (result == null) continue;
            tmpResults.add(result);
        }
        this.results = new ArrayList(tmpResults);
        consumer.resultsChanged(this);
        for (SearchResult searchResult : tmpResults) {
            if (this.hasWaitingSearch()) {
                return;
            }
            ((OnlinePluginResult)searchResult).getPlugin().loadDescriptor();
            consumer.resultChanged(this, searchResult);
        }
        for (SearchResult searchResult : tmpResults) {
            if (this.hasWaitingSearch()) {
                return;
            }
            ((OnlinePluginResult)searchResult).getPlugin().loadImages();
            consumer.resultChanged(this, searchResult);
        }
    }

    private static boolean ensureOnlineLoaderLoaded() {
        PluginRepositoryLoader.waitLoaded();
        if (PluginRepositoryLoader.failed() && NetworkUtil.hasInternetAccess()) {
            PluginRepositoryLoader.reload();
            PluginRepositoryLoader.waitLoaded();
        }
        return !PluginRepositoryLoader.failed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OnlinePluginResult getResult(SearchResultConsumer consumer, List<PluginDescriptor> onlinePlugins, Element pluginNode, List<SearchResultProducer.SearchWord> words, boolean startWithOnly, LocalPluginSearchResultProducer lpsrp) {
        String className = XMLUtil.getElementValue(pluginNode, ID_CLASSNAME, "");
        String text = XMLUtil.getElementValue(pluginNode, ID_TEXT, "");
        PluginDescriptor localPlugin = PluginLoader.getPlugin(className);
        if (localPlugin != null) {
            if (lpsrp != null) {
                List<SearchResult> localResults = lpsrp.getResults();
                boolean alreadyExists = false;
                List<SearchResult> list = localResults;
                synchronized (list) {
                    for (SearchResult result : localResults) {
                        if (((LocalPluginSearchResultProducer.LocalPluginResult)result).getPlugin() != localPlugin) continue;
                        alreadyExists = true;
                        break;
                    }
                }
                if (!alreadyExists) {
                    int priority = LocalPluginSearchResultProducer.searchInPlugin(localPlugin, words, startWithOnly);
                    if (priority == 0) {
                        priority = 1;
                    }
                    lpsrp.addResult(new LocalPluginSearchResultProducer.LocalPluginResult(lpsrp, localPlugin, text, words, priority), consumer);
                }
            }
            return null;
        }
        PluginDescriptor onlinePlugin = PluginDescriptor.getPlugin(onlinePlugins, className);
        if (onlinePlugin == null) {
            return null;
        }
        onlinePlugin.loadDescriptor();
        int priority = LocalPluginSearchResultProducer.searchInPlugin(onlinePlugin, words, startWithOnly);
        if (priority <= 5) {
            priority = 1;
        }
        return new OnlinePluginResult(this, onlinePlugin, text, words, priority);
    }

    public static class OnlinePluginResult
    extends PluginSearchResult {
        public OnlinePluginResult(SearchResultProducer provider, PluginDescriptor plugin, String text, List<SearchResultProducer.SearchWord> searchWords, int priority) {
            super(provider, plugin, text, searchWords, priority);
        }

        @Override
        public String getTooltip() {
            return "Left click: Install and Run   -   Right click: Online documentation";
        }

        @Override
        public void execute() {
            ThreadUtil.bgRun(new Runnable(){

                @Override
                public void run() {
                    if (PluginLoader.isLoaded(plugin.getClassName())) {
                        if (plugin.isActionable()) {
                            PluginLauncher.start(plugin);
                        } else {
                            ThreadUtil.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    new PluginDetailPanel(plugin);
                                }
                            });
                        }
                    } else {
                        PluginInstaller.install(plugin, true);
                        PluginInstaller.waitInstall();
                        final PluginDescriptor localPlugin = PluginLoader.getPlugin(plugin.getClassName());
                        if (localPlugin != null) {
                            if (localPlugin.isActionable()) {
                                PluginLauncher.start(localPlugin);
                            } else {
                                ThreadUtil.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        new PluginDetailPanel(localPlugin);
                                    }
                                });
                            }
                        }
                    }
                }
            });
        }
    }
}

