/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.AxisGuesser;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.LeicaHandler;
import loci.formats.in.MetadataLevel;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import ome.units.quantity.Length;
import org.xml.sax.helpers.DefaultHandler;

public class TCSReader
extends FormatReader {
    public static final String DATE_FORMAT = "yyyy:MM:dd HH:mm:ss";
    public static final String PREFIX = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>";
    public static final String SUFFIX = "</LEICA>";
    public static final String[] XML_SUFFIX = new String[]{"xml"};
    private List<String> tiffs;
    private TiffReader[] tiffReaders;
    private TiffParser tiffParser;
    private int lastPlane = 0;
    private long datestamp;
    private String xmlFile;
    private double voxelX;
    private double voxelY;
    private double voxelZ;

    public TCSReader() {
        super("Leica TCS TIFF", new String[]{"tif", "tiff", "xml"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        String[] list;
        if (TCSReader.checkSuffix(id, "xml")) {
            return false;
        }
        Location file2 = new Location(id);
        for (String f : list = file2.getParentFile().list()) {
            if (!TCSReader.checkSuffix(f, "xml") || !DataTools.samePrefix(file2.getName(), f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        boolean bl;
        Location lei;
        if (!open) {
            return false;
        }
        String prefix = name;
        if (prefix.indexOf(46) != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (!(lei = new Location(prefix + ".lei")).exists()) {
            lei = new Location(prefix + ".LEI");
            while (!lei.exists() && prefix.indexOf(95) != -1) {
                lei = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".lei");
                if (lei.exists()) continue;
                lei = new Location(prefix + ".LEI");
            }
        }
        if (lei.exists()) {
            return false;
        }
        RandomAccessInputStream s2 = new RandomAccessInputStream(name);
        try {
            bl = this.isThisType(s2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    s2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.debug("", e);
                return false;
            }
        }
        s2.close();
        return bl;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        String software;
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            stream.seek(0L);
            return stream.readString(6).equals("<Data>");
        }
        String document = ifd.getIFDTextValue(269);
        if (document == null) {
            document = "";
        }
        if ((software = ifd.getIFDTextValue(305)) == null) {
            software = "";
        }
        software = software.trim();
        return document.startsWith("CHANNEL") || software.startsWith("TCS");
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReaders[this.lastPlane].get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReaders[this.lastPlane].get16BitLookupTable();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int n = no;
        for (int i = 0; i < this.getSeries(); ++i) {
            n += ((CoreMetadata)this.core.get((int)i)).imageCount;
        }
        if (this.tiffReaders.length == 1) {
            return this.tiffReaders[0].openBytes(n, buf, x, y, w, h2);
        }
        int plane = 0;
        if (this.tiffReaders[0].getImageCount() > 1) {
            plane = (n /= this.tiffReaders.length) % this.tiffReaders.length;
        }
        if (this.lastPlane != 0) {
            this.tiffReaders[this.lastPlane].close();
        }
        this.lastPlane = n;
        this.tiffReaders[n].setId(this.tiffs.get(n));
        return this.tiffReaders[n].openBytes(plane, buf, x, y, w, h2);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            String[] stringArray;
            if (this.xmlFile == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.xmlFile;
            }
            return stringArray;
        }
        ArrayList<String> v = new ArrayList<String>();
        v.addAll(this.tiffs);
        if (this.xmlFile != null) {
            v.add(this.xmlFile);
        }
        return v.toArray(new String[v.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tiffs = null;
            if (this.tiffReaders != null) {
                for (TiffReader r : this.tiffReaders) {
                    if (r == null) continue;
                    r.close();
                }
            }
            this.tiffReaders = null;
            this.tiffParser = null;
            this.datestamp = 0L;
            this.xmlFile = null;
            this.lastPlane = 0;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Location l = new Location(id).getAbsoluteFile();
        Location parent = l.getParentFile();
        Object[] list = parent.list();
        Arrays.sort(list);
        boolean isXML = TCSReader.checkSuffix(id, XML_SUFFIX);
        if (list != null) {
            for (Object file2 : list) {
                if (TCSReader.checkSuffix((String)file2, XML_SUFFIX) && !isXML && this.isGroupFiles()) {
                    this.xmlFile = new Location(parent, (String)file2).getAbsolutePath();
                    break;
                }
                if (!TCSReader.checkSuffix((String)file2, TiffReader.TIFF_SUFFIXES) || !isXML) continue;
                this.initFile(new Location(parent, (String)file2).getAbsolutePath());
                return;
            }
        }
        if (isXML) {
            this.xmlFile = l.getAbsolutePath();
        }
        super.initFile(id);
        MetadataStore store = this.makeFilterMetadata();
        this.in = new RandomAccessInputStream(id, 16);
        this.tiffParser = new TiffParser(this.in);
        this.tiffs = new ArrayList<String>();
        IFDList ifds = this.tiffParser.getMainIFDs();
        String date = ((IFD)ifds.get(0)).getIFDStringValue(306);
        if (date != null) {
            this.datestamp = DateTools.getTime(date, DATE_FORMAT);
        }
        this.groupFiles();
        this.addGlobalMeta("Number of image files", this.tiffs.size());
        this.tiffReaders = new TiffReader[this.tiffs.size()];
        for (int i2 = 0; i2 < this.tiffReaders.length; ++i2) {
            this.tiffReaders[i2] = new TiffReader();
        }
        this.tiffReaders[0].setId(this.tiffs.get(0));
        int[] ch = new int[ifds.size()];
        int[] idx = new int[ifds.size()];
        long[] stamp = new long[ifds.size()];
        int channelCount = 0;
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        ms0.sizeZ = 1;
        ms0.sizeC = this.tiffReaders[0].getSizeC();
        String string = ms0.dimensionOrder = this.isRGB() ? "XYC" : "XY";
        if (this.isGroupFiles()) {
            try {
                FilePattern fp = new FilePattern(new Location(this.currentId).getAbsoluteFile());
                AxisGuesser guesser = new AxisGuesser(fp, "XYTZC", 1, ifds.size(), 1, true);
                int[] axisTypes = guesser.getAxisTypes();
                int[] count = fp.getCount();
                for (i = axisTypes.length - 1; i >= 0; --i) {
                    if (axisTypes[i] == 1) {
                        if (this.getDimensionOrder().indexOf(90) == -1) {
                            ms0.dimensionOrder = ms0.dimensionOrder + 'Z';
                        }
                        ms0.sizeZ *= count[i];
                        continue;
                    }
                    if (axisTypes[i] != 3) continue;
                    if (this.getDimensionOrder().indexOf(67) == -1) {
                        ms0.dimensionOrder = ms0.dimensionOrder + 'C';
                    }
                    ms0.sizeC *= count[i];
                }
            }
            catch (NullPointerException fp) {
                // empty catch block
            }
        }
        for (int i3 = 0; i3 < ifds.size(); ++i3) {
            int space;
            String document = ((IFD)ifds.get(i3)).getIFDStringValue(269);
            if (document == null) continue;
            int index = document.indexOf("INDEX");
            String[] s2 = document.substring(8, index).trim();
            ch[i3] = Integer.parseInt((String)s2);
            if (ch[i3] > channelCount) {
                channelCount = ch[i3];
            }
            if ((space = document.indexOf(" ", index + 6)) < 0) continue;
            String n = document.substring(index + 6, space).trim();
            idx[i3] = Integer.parseInt(n);
            date = document.substring(space, document.indexOf("FORMAT")).trim();
            stamp[i3] = DateTools.getTime(date, DATE_FORMAT, ".");
            this.addGlobalMetaList("Timestamp for plane", stamp[i3]);
        }
        ms0.sizeT = 0;
        boolean unique = true;
        for (int i4 = 0; i4 < stamp.length; ++i4) {
            for (int j = i4 + 1; j < stamp.length; ++j) {
                if (stamp[j] != stamp[i4]) continue;
                unique = false;
                break;
            }
            if (unique) {
                ++ms0.sizeT;
                if (this.getDimensionOrder().indexOf(84) < 0) {
                    ms0.dimensionOrder = ms0.dimensionOrder + 'T';
                }
            } else if (i4 > 0) {
                if (ch[i4] != ch[i4 - 1] && this.getDimensionOrder().indexOf(67) < 0) {
                    ms0.dimensionOrder = ms0.dimensionOrder + 'C';
                } else if (this.getDimensionOrder().indexOf(90) < 0) {
                    ms0.dimensionOrder = ms0.dimensionOrder + 'Z';
                }
            }
            unique = true;
        }
        if (this.getDimensionOrder().indexOf(90) < 0) {
            ms0.dimensionOrder = ms0.dimensionOrder + 'Z';
        }
        if (this.getDimensionOrder().indexOf(67) < 0) {
            ms0.dimensionOrder = ms0.dimensionOrder + 'C';
        }
        if (this.getDimensionOrder().indexOf(84) < 0) {
            ms0.dimensionOrder = ms0.dimensionOrder + 'T';
        }
        if (this.getSizeC() == 0) {
            ms0.sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            ms0.sizeT = 1;
        }
        if (channelCount == 0) {
            channelCount = 1;
        }
        if (this.getSizeZ() <= 1) {
            ms0.sizeZ = ifds.size() / (this.getSizeT() * channelCount);
        }
        ms0.sizeC *= channelCount;
        ms0.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        String comment = ((IFD)ifds.get(0)).getComment();
        if (comment != null && comment.startsWith("[") && this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String[] lines;
            for (String line : lines = comment.split("\n")) {
                int eq;
                if (line.startsWith("[") || (eq = line.indexOf(61)) < 0) continue;
                String key = line.substring(0, eq).trim();
                String value = line.substring(eq + 1).trim();
                if (key.equals("VoxelSizeX")) {
                    try {
                        this.voxelX = Double.parseDouble(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (key.equals("VoxelSizeY")) {
                    try {
                        this.voxelY = Double.parseDouble(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (key.equals("VoxelSizeZ")) {
                    try {
                        this.voxelZ = Double.parseDouble(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.addGlobalMeta(key, value);
            }
            this.metadata.remove("Comment");
        }
        ms0.sizeX = this.tiffReaders[0].getSizeX();
        ms0.sizeY = this.tiffReaders[0].getSizeY();
        ms0.rgb = this.tiffReaders[0].isRGB();
        ms0.pixelType = this.tiffReaders[0].getPixelType();
        ms0.littleEndian = this.tiffReaders[0].isLittleEndian();
        ms0.interleaved = this.tiffReaders[0].isInterleaved();
        ms0.falseColor = true;
        ms0.indexed = this.tiffReaders[0].isIndexed();
        if (this.isRGB()) {
            ms0.imageCount /= this.getSizeC() / channelCount;
        }
        if (this.getSizeZ() * this.getSizeT() * this.getEffectiveSizeC() != ifds.size() * this.tiffReaders.length) {
            int c = this.getEffectiveSizeC();
            if (c == 0) {
                c = 1;
            }
            ms0.sizeT = ifds.size() * this.tiffReaders.length / (c * this.getSizeZ());
            ms0.imageCount = this.getSizeT() * c * this.getSizeZ();
            if (this.getSizeT() == 0) {
                ms0.sizeT = 1;
                ms0.imageCount = ifds.size() * this.tiffReaders.length;
            }
        }
        if (this.getImageCount() == ifds.size() * this.getSizeZ() * this.getSizeT() && ifds.size() > 1) {
            if (this.getSizeZ() == 1) {
                ms0.sizeZ = ifds.size();
            } else if (this.getSizeT() == 1) {
                ms0.sizeT = ifds.size();
            } else {
                ms0.sizeZ *= ifds.size();
            }
        }
        if (this.xmlFile != null) {
            String xml = DataTools.readFile(this.xmlFile);
            xml = XMLTools.sanitizeXML(PREFIX + xml + SUFFIX);
            LeicaHandler handler = new LeicaHandler(store, this.getMetadataOptions().getMetadataLevel());
            XMLTools.parseXML(xml, (DefaultHandler)handler);
            this.metadata = handler.getGlobalMetadata();
            MetadataTools.merge(handler.getGlobalMetadata(), this.metadata, "");
            this.core = handler.getCoreMetadataList();
            for (i = 0; i < this.getSeriesCount(); ++i) {
                CoreMetadata ms = (CoreMetadata)this.core.get(i);
                if (this.tiffs.size() < ms.imageCount) {
                    int div = ms.imageCount / ms.sizeC;
                    ms.imageCount = this.tiffs.size();
                    if (div >= ms.sizeZ) {
                        ms.sizeZ /= div;
                    } else if (div >= ms.sizeT) {
                        ms.sizeT /= div;
                    }
                }
                ms.dimensionOrder = this.getSizeZ() > this.getSizeT() ? "XYCZT" : "XYCTZ";
                ms.rgb = false;
                ms.interleaved = false;
                ms.indexed = this.tiffReaders[0].isIndexed();
            }
        }
        MetadataTools.populatePixels(store, this, true);
        Length sizeX = FormatTools.getPhysicalSizeX(this.voxelX);
        Length sizeY = FormatTools.getPhysicalSizeY(this.voxelY);
        Length sizeZ = FormatTools.getPhysicalSizeZ(this.voxelZ);
        if (sizeX != null) {
            store.setPixelsPhysicalSizeX(sizeX, 0);
        }
        if (sizeY != null) {
            store.setPixelsPhysicalSizeY(sizeY, 0);
        }
        if (sizeZ != null) {
            store.setPixelsPhysicalSizeZ(sizeZ, 0);
        }
    }

    private void groupFiles() throws FormatException, IOException {
        Location current = new Location(this.currentId).getAbsoluteFile();
        if (!TCSReader.checkSuffix(this.currentId, XML_SUFFIX)) {
            this.tiffs.add(current.getAbsolutePath());
        }
        if (!this.isGroupFiles()) {
            return;
        }
        Location parent = current.getParentFile();
        Object[] list = parent.list();
        Arrays.sort(list);
        HashMap<Object, Long> timestamps = new HashMap<Object, Long>();
        IFD ifd = null;
        int expectedIFDCount = 0;
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(current.getAbsolutePath(), 16);){
            TiffParser p = new TiffParser(s2);
            ifd = (IFD)p.getMainIFDs().get(0);
            expectedIFDCount = p.getMainIFDs().size();
        }
        long width = ifd.getImageWidth();
        long height = ifd.getImageLength();
        int samples = ifd.getSamplesPerPixel();
        for (Object file2 : list) {
            if (((String)(file2 = new Location(parent, (String)file2).getAbsolutePath())).length() != current.getAbsolutePath().length()) continue;
            try (RandomAccessInputStream rais = new RandomAccessInputStream((String)file2, 16);){
                String date;
                TiffParser tp = new TiffParser(rais);
                if (!tp.isValidHeader()) continue;
                ifd = (IFD)tp.getMainIFDs().get(0);
                if (tp.getMainIFDs().size() != expectedIFDCount || ifd.getImageWidth() != width || ifd.getImageLength() != height || ifd.getSamplesPerPixel() != samples || (date = ifd.getIFDStringValue(306)) == null) continue;
                long stamp = DateTools.getTime(date, DATE_FORMAT);
                String software = ifd.getIFDStringValue(305);
                if (software == null || !software.trim().startsWith("TCS")) continue;
                timestamps.put(file2, new Long(stamp));
            }
        }
        Object[] files = timestamps.keySet().toArray(new String[timestamps.size()]);
        Arrays.sort(files);
        for (Object file3 : files) {
            long thisStamp = (Long)timestamps.get(file3);
            boolean match = false;
            for (String tiff : this.tiffs) {
                try (RandomAccessInputStream s3 = new RandomAccessInputStream(tiff, 16);){
                    TiffParser parser = new TiffParser(s3);
                    ifd = (IFD)parser.getMainIFDs().get(0);
                }
                String date = ifd.getIFDStringValue(306);
                long nextStamp = DateTools.getTime(date, DATE_FORMAT);
                if (Math.abs(thisStamp - nextStamp) >= 600000L) continue;
                match = true;
                break;
            }
            if (!match || this.tiffs.contains(file3)) continue;
            this.tiffs.add((String)file3);
        }
    }
}

