/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormap;

import icy.image.colormap.IcyColorMap;
import icy.util.ColorUtil;
import java.awt.Color;

public class LinearColorMap
extends IcyColorMap {
    public static final LinearColorMap black_ = new LinearColorMap("Black", Color.black, IcyColorMap.IcyColorMapType.GRAY);
    public static final LinearColorMap gray_;
    public static final LinearColorMap white_;
    public static final LinearColorMap gray_inv_;
    public static final LinearColorMap white_inv_;
    public static final LinearColorMap red_;
    public static final LinearColorMap blue_;
    public static final LinearColorMap pink_;
    public static final LinearColorMap cyan_;
    public static final LinearColorMap orange_;
    public static final LinearColorMap yellow_;
    public static final LinearColorMap green_;
    public static final LinearColorMap magenta_;
    public static final LinearColorMap alpha_;

    static {
        white_ = gray_ = new LinearColorMap("Gray", Color.white, IcyColorMap.IcyColorMapType.GRAY);
        white_inv_ = gray_inv_ = new LinearColorMap("Gray inverse", Color.white, Color.black, IcyColorMap.IcyColorMapType.GRAY);
        red_ = new LinearColorMap("Red", Color.red);
        blue_ = new LinearColorMap("Blue", Color.blue);
        pink_ = new LinearColorMap("Pink", Color.pink);
        cyan_ = new LinearColorMap("Cyan", Color.cyan);
        orange_ = new LinearColorMap("Orange", Color.orange);
        yellow_ = new LinearColorMap("Yellow", Color.yellow);
        green_ = new LinearColorMap("Green", Color.green);
        magenta_ = new LinearColorMap("Magenta", Color.magenta);
        alpha_ = new LinearColorMap("Alpha", new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), IcyColorMap.IcyColorMapType.ALPHA);
    }

    public LinearColorMap(String mapName, Color color) {
        this(mapName, Color.black, color, IcyColorMap.IcyColorMapType.RGB);
    }

    public LinearColorMap(String mapName, Color color, IcyColorMap.IcyColorMapType type) {
        this(mapName, Color.black, color, type);
    }

    public LinearColorMap(String mapName, Color colorFrom, Color colorTo) {
        this(mapName, colorFrom, colorTo, IcyColorMap.IcyColorMapType.RGB);
    }

    public LinearColorMap(String mapName, Color colorFrom, Color colorTo, IcyColorMap.IcyColorMapType type) {
        super(mapName, type);
        this.beginUpdate();
        try {
            this.red.setControlPoint(0, colorFrom.getRed());
            this.green.setControlPoint(0, colorFrom.getGreen());
            this.blue.setControlPoint(0, colorFrom.getBlue());
            this.gray.setControlPoint(0, ColorUtil.getGrayMix(colorFrom));
            this.alpha.setControlPoint(0, colorFrom.getAlpha());
            this.red.setControlPoint(255, colorTo.getRed());
            this.green.setControlPoint(255, colorTo.getGreen());
            this.blue.setControlPoint(255, colorTo.getBlue());
            this.gray.setControlPoint(255, ColorUtil.getGrayMix(colorTo));
            this.alpha.setControlPoint(255, colorTo.getAlpha());
        }
        finally {
            this.endUpdate();
        }
    }
}

