/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.examples;

import java.io.IOException;
import mdbtools.publicapi.RandomAccess;

public class MemoryRandomAccess
implements RandomAccess {
    private byte[] data;
    private long position;

    public MemoryRandomAccess(byte[] data) {
        this.data = data;
        this.position = 0L;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public long length() throws IOException {
        return this.data.length;
    }

    @Override
    public void seek(long l) throws IOException {
        this.position = l;
    }

    @Override
    public long read(byte[] ba, int offset, int length) throws IOException {
        if (this.position == (long)this.data.length) {
            return -1L;
        }
        if (this.position + (long)length > (long)this.data.length) {
            length -= (int)this.position;
        }
        System.arraycopy(this.data, (int)this.position, ba, offset, length);
        this.position += (long)length;
        return length;
    }
}

