/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.expressions;

import java.util.SortedSet;
import java.util.TreeSet;
import plugins.ylemontag.mathoperations.Expression;
import plugins.ylemontag.mathoperations.Functor;

public class ExpressionVariable
extends Expression {
    private String _name;

    public ExpressionVariable(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public boolean equals(Expression expr) {
        return expr instanceof ExpressionVariable && this._name.equals(((ExpressionVariable)expr)._name);
    }

    @Override
    public String getRepresentation(boolean smartParenthesis) {
        return this._name;
    }

    @Override
    public SortedSet<String> getVariables() {
        TreeSet<String> retVal = new TreeSet<String>();
        retVal.add(this._name);
        return retVal;
    }

    @Override
    public boolean isValidFunctor(String[] variables) {
        if (variables == null) {
            return true;
        }
        for (String v : variables) {
            if (!this._name.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Functor getFunctor(String[] variables) {
        final int index = this.searchVariableIndex(variables);
        String pattern = "%" + Integer.toString(1 + index) + "$s";
        return new Functor(variables.length, pattern, new Functor.FunPtr(){

            @Override
            public double apply(double[] in) {
                return in[index];
            }
        });
    }

    private int searchVariableIndex(String[] variables) {
        for (int k = 0; k < variables.length; ++k) {
            if (!this._name.equals(variables[k])) continue;
            return k;
        }
        throw new Expression.BadFunctor("Cannot find '" + this._name + "' in the variable table.");
    }
}

