/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.measure;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.type.rectangle.Rectangle5D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.kernel.roi.descriptor.measure.ROIAreaDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIContourDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIInteriorDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIPerimeterDescriptor;
import plugins.kernel.roi.descriptor.measure.ROISurfaceAreaDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIVolumeDescriptor;

public class ROIBasicMeasureDescriptorsPlugin
extends Plugin
implements PluginROIDescriptor {
    public static final String ID_CONTOUR = "Contour";
    public static final String ID_INTERIOR = "Interior";
    public static final String ID_PERIMETER = "Perimeter";
    public static final String ID_AREA = "Area";
    public static final String ID_SURFACE_AREA = "Surface area";
    public static final String ID_VOLUME = "Volume";
    public static final ROIContourDescriptor contourDescriptor = new ROIContourDescriptor();
    public static final ROIInteriorDescriptor interiorDescriptor = new ROIInteriorDescriptor();
    public static final ROIPerimeterDescriptor perimeterDescriptor = new ROIPerimeterDescriptor();
    public static final ROIAreaDescriptor areaDescriptor = new ROIAreaDescriptor();
    public static final ROISurfaceAreaDescriptor surfaceAreaDescriptor = new ROISurfaceAreaDescriptor();
    public static final ROIVolumeDescriptor volumeDescriptor = new ROIVolumeDescriptor();

    public static double getMultiplierFactor(Sequence sequence, ROI roi, int dim) {
        int dimRoi = roi.getDimension();
        if (dimRoi > dim) {
            return 0.0;
        }
        Rectangle5D boundsRoi = roi.getBounds5D();
        double mul = 1.0;
        switch (dim) {
            case 5: {
                if (dimRoi == 4) {
                    int sizeC = sequence.getSizeC();
                    mul = boundsRoi.getSizeC() == Double.POSITIVE_INFINITY && sizeC > 1 ? (mul *= (double)sizeC) : 0.0;
                }
            }
            case 4: {
                if (dimRoi == 3) {
                    int sizeT = sequence.getSizeT();
                    mul = boundsRoi.getSizeT() == Double.POSITIVE_INFINITY && sizeT > 1 ? (mul *= (double)sizeT) : 0.0;
                }
            }
            case 3: {
                if (dimRoi == 2) {
                    int sizeZ = sequence.getSizeZ();
                    mul = boundsRoi.getSizeZ() == Double.POSITIVE_INFINITY && sizeZ > 1 ? (mul *= (double)sizeZ) : 0.0;
                }
            }
            case 2: {
                if (dimRoi != 1) break;
                int sizeY = sequence.getSizeY();
                if (boundsRoi.getSizeY() == Double.POSITIVE_INFINITY && sizeY > 1) {
                    mul *= (double)sizeY;
                    break;
                }
                mul = 0.0;
            }
        }
        return mul;
    }

    @Override
    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> result = new ArrayList<ROIDescriptor>();
        result.add(contourDescriptor);
        result.add(interiorDescriptor);
        result.add(perimeterDescriptor);
        result.add(areaDescriptor);
        result.add(surfaceAreaDescriptor);
        result.add(volumeDescriptor);
        return result;
    }

    @Override
    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        HashMap<ROIDescriptor, Object> result = new HashMap<ROIDescriptor, Object>();
        double contour = ROIContourDescriptor.computeContour(roi);
        double interior = ROIInteriorDescriptor.computeInterior(roi);
        result.put(contourDescriptor, contour);
        result.put(interiorDescriptor, interior);
        int notComputed = 0;
        try {
            result.put(perimeterDescriptor, ROIPerimeterDescriptor.computePerimeter(roi, sequence));
        }
        catch (UnsupportedOperationException e) {
            result.put(perimeterDescriptor, null);
            ++notComputed;
        }
        try {
            result.put(areaDescriptor, ROIAreaDescriptor.computeArea(interior, roi, sequence));
        }
        catch (UnsupportedOperationException e) {
            result.put(areaDescriptor, null);
            ++notComputed;
        }
        try {
            result.put(surfaceAreaDescriptor, ROISurfaceAreaDescriptor.computeSurfaceArea(roi, sequence));
        }
        catch (UnsupportedOperationException e) {
            result.put(surfaceAreaDescriptor, null);
            ++notComputed;
        }
        try {
            result.put(volumeDescriptor, ROIVolumeDescriptor.computeVolume(interior, roi, sequence));
        }
        catch (UnsupportedOperationException e) {
            result.put(volumeDescriptor, null);
            ++notComputed;
        }
        if (notComputed == 4) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": cannot compute any of the descriptors for '" + roi.getName() + "'");
        }
        return result;
    }
}

