/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.action.IcyAbstractAction;
import icy.file.FileUtil;
import icy.gui.component.button.IcyButton;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.OpenDialog;
import icy.main.Icy;
import icy.preferences.PluginsPreferences;
import icy.preferences.XMLPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;
import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicromanagerPlugin;

public class LoadFrame
extends JDialog {
    private static final long serialVersionUID = 1195697437027678195L;
    private static final String FILE = "cfgfile";
    private static final String NB_FILES = "nbfiles";
    private XMLPreferences _prefs = PluginsPreferences.root(MicromanagerPlugin.class).node("CFGFiles");
    String sysConfigFile;
    DefaultListModel _CFGFiles = new DefaultListModel();
    File _actualfile = null;
    int _retval;
    JList _list_files;
    private JTextArea _list_devices;
    private JScrollPane _scroll_devices;
    private JTextArea _list_configs;
    private JTextArea _list_resume;
    final IcyAbstractAction openAction;
    final IcyAbstractAction cancelAction;
    final IcyAbstractAction addAction;
    final IcyAbstractAction removeAction;
    IcyButton openButton;
    private IcyButton cancelButton;
    private IcyButton removeButton;
    private IcyButton addButton;

    public LoadFrame() {
        super((Frame)Icy.getMainInterface().getMainFrame(), "Please choose your configuration file", true);
        this.loadPrefs();
        this.openAction = new IcyAbstractAction("Open", new IcyIcon(ResourceUtil.ICON_OPEN), "Open currently selected file", 10){

            protected boolean doAction(ActionEvent e) {
                LoadFrame.this._retval = 0;
                LoadFrame.this.savePrefs();
                LoadFrame.this.setVisible(false);
                return true;
            }
        };
        this.cancelAction = new IcyAbstractAction("Cancel", new IcyIcon(ResourceUtil.ICON_DELETE), "Cancel and close Micro Manager", 27){

            protected boolean doAction(ActionEvent e) {
                LoadFrame.this._retval = 1;
                LoadFrame.this.dispose();
                return true;
            }
        };
        this.addAction = new IcyAbstractAction("", new IcyIcon(ResourceUtil.ICON_PLUS), "Add a new file to the list."){

            protected boolean doAction(ActionEvent e) {
                LoadFrame.this.loadConfig();
                return true;
            }
        };
        this.removeAction = new IcyAbstractAction("", new IcyIcon(ResourceUtil.ICON_MINUS), "Remove current file from the list."){

            protected boolean doAction(ActionEvent e) {
                if (!LoadFrame.this._list_files.isSelectionEmpty()) {
                    LoadFrame.this._CFGFiles.remove(LoadFrame.this._list_files.getSelectedIndex());
                }
                LoadFrame.this.savePrefs();
                LoadFrame.this.repaint();
                return true;
            }
        };
        this.initialize();
        this._list_files.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!LoadFrame.this._list_files.isSelectionEmpty()) {
                    LoadFrame.this.sysConfigFile = (String)LoadFrame.this._list_files.getSelectedValue();
                    LoadFrame.this._actualfile = new File(LoadFrame.this.sysConfigFile);
                    LoadFrame.this._list_files.setToolTipText("Selected = " + LoadFrame.this.sysConfigFile);
                    try {
                        LoadFrame.this.loadFileAttribs();
                        LoadFrame.this.openButton.setEnabled(true);
                    }
                    catch (IOException e1) {
                        MessageDialog.showDialog((String)"Error", (String)e1.getMessage(), (int)0);
                        e1.printStackTrace();
                    }
                } else {
                    LoadFrame.this._list_files.setToolTipText("Double click on a file or select it then click on 'Open File' to open it.");
                }
            }
        });
        this._list_files.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseevent) {
                if (mouseevent.getClickCount() >= 2 && LoadFrame.this.openButton.isEnabled()) {
                    LoadFrame.this.openButton.doClick();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoadFrame.this._retval = 1;
                LoadFrame.this.savePrefs();
            }
        });
        this._retval = -1;
    }

    private void initialize() {
        JSplitPane rightPanel = new JSplitPane();
        rightPanel.setContinuousLayout(true);
        rightPanel.setResizeWeight(0.5);
        this.getContentPane().add((Component)rightPanel, "Center");
        this._list_devices = new JTextArea();
        this._list_devices.setEditable(false);
        this._list_devices.setToolTipText("Devices in the current file.");
        this._scroll_devices = new JScrollPane(this._list_devices);
        JPanel _panel_devices = new JPanel();
        _panel_devices.setPreferredSize(new Dimension(120, 10));
        rightPanel.setLeftComponent(_panel_devices);
        _panel_devices.setLayout(new BorderLayout());
        _panel_devices.add(this._scroll_devices);
        JLabel lbl_devices = new JLabel("Devices");
        _panel_devices.add((Component)lbl_devices, "North");
        lbl_devices.setHorizontalAlignment(0);
        JLabel lbl_config_presets = new JLabel("Config / Main Presets");
        lbl_config_presets.setHorizontalAlignment(0);
        JScrollPane _scroll_configs = new JScrollPane();
        JPanel _panel_configs = new JPanel();
        _panel_configs.setPreferredSize(new Dimension(120, 10));
        rightPanel.setRightComponent(_panel_configs);
        _panel_configs.setLayout(new BorderLayout());
        _panel_configs.add((Component)lbl_config_presets, "North");
        _panel_configs.add(_scroll_configs);
        this._list_configs = new JTextArea();
        _scroll_configs.setViewportView(this._list_configs);
        this._list_configs.setEditable(false);
        this._list_configs.setToolTipText("Configurations and Presets for the current file.");
        JPanel leftPanel = new JPanel();
        this.getContentPane().add((Component)leftPanel, "West");
        leftPanel.setLayout(new BorderLayout(0, 0));
        this._list_resume = new JTextArea("Nb Devices:\r\nNb Groups: \r\nNb Presets: ");
        this._list_resume.setEditable(false);
        this._list_resume.setToolTipText("Basic information on the current file");
        JLabel _lbl_resume = new JLabel("Resume : ");
        _lbl_resume.setHorizontalAlignment(0);
        JPanel _panel_resume = new JPanel();
        leftPanel.add((Component)_panel_resume, "South");
        _panel_resume.setLayout(new BoxLayout(_panel_resume, 1));
        _panel_resume.add(_lbl_resume);
        _panel_resume.add(this._list_resume);
        JLabel lbl_files = new JLabel("Files");
        lbl_files.setHorizontalAlignment(0);
        lbl_files.setFont(lbl_files.getFont().deriveFont(1, 12.0f));
        this._list_files = new JList(this._CFGFiles);
        this._list_files.setSelectionMode(1);
        this._list_files.setLayoutOrientation(0);
        this._list_files.setToolTipText("Double click on a file or select it then click on 'Open File' to open it.");
        JScrollPane _scroll_files = new JScrollPane(this._list_files);
        JPanel _panel_files = new JPanel();
        _panel_files.setPreferredSize(new Dimension(400, 80));
        _panel_files.setMinimumSize(new Dimension(400, 10));
        leftPanel.add((Component)_panel_files, "Center");
        _panel_files.setLayout(new BorderLayout());
        _panel_files.add((Component)lbl_files, "North");
        _panel_files.add(_scroll_files);
        lbl_devices.setFont(lbl_files.getFont().deriveFont(1, 12.0f));
        lbl_config_presets.setFont(lbl_files.getFont().deriveFont(1, 12.0f));
        this.openButton = new IcyButton(this.openAction);
        this.openButton.setEnabled(false);
        this.cancelButton = new IcyButton(this.cancelAction);
        this.addButton = new IcyButton(this.addAction);
        this.removeButton = new IcyButton(this.removeAction);
        JPanel buttonPanel = new JPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        buttonPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add((Component)this.addButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add((Component)this.removeButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add((Component)this.openButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add((Component)this.cancelButton);
        this.setPreferredSize(new Dimension(720, 320));
        this.validate();
    }

    public int showDialog() {
        this.pack();
        this.setLocationRelativeTo((Component)Icy.getMainInterface().getDesktopPane());
        this.setVisible(true);
        this.removeAll();
        return this._retval;
    }

    public String getConfigFilePath() {
        return this.sysConfigFile;
    }

    void savePrefs() {
        this._prefs.putInt(NB_FILES, this._CFGFiles.getSize());
        for (int i = 0; i < this._CFGFiles.getSize(); ++i) {
            this._prefs.put(FILE + i, this._CFGFiles.getElementAt(i).toString());
        }
    }

    private void loadPrefs() {
        this._CFGFiles.removeAllElements();
        for (int i = 0; i < this._prefs.getInt(NB_FILES, 0); ++i) {
            String file = this._prefs.get(FILE + i, "");
            if (!FileUtil.exists((String)file)) continue;
            this._CFGFiles.addElement(file);
        }
        if (this._CFGFiles.isEmpty() && MMUtils.demoConfigFile != null) {
            this.loadFile(MMUtils.demoConfigFile.getAbsolutePath());
        }
    }

    void loadConfig() {
        String path = OpenDialog.chooseFile((String)"Launch Configuration", (String)MMUtils.getMicroManagerFolder(), (String)"*.cfg");
        if (path != null) {
            this.sysConfigFile = path;
            this.loadFile(this.sysConfigFile);
        }
    }

    private void loadFile(String path) {
        if (!this._CFGFiles.contains(path) && FileUtil.exists((String)path)) {
            this._CFGFiles.addElement(path);
        } else {
            this._list_files.setSelectedValue(path, true);
        }
        this.savePrefs();
        this.repaint();
    }

    void loadFileAttribs() throws IOException {
        int nb_devices = 0;
        int nb_groups = 0;
        int nb_presets = 0;
        String slist_devices = "";
        String slist_configs = "";
        BufferedReader in = new BufferedReader(new FileReader(this._actualfile));
        if (this._actualfile != null) {
            String actual_line = "";
            while ((actual_line = in.readLine()) != null) {
                int coma_index;
                if (actual_line.isEmpty()) continue;
                if (actual_line.charAt(0) == '#') {
                    if (actual_line.contains("Group:")) {
                        slist_configs = slist_configs + actual_line.substring(9) + "\n";
                        ++nb_groups;
                        continue;
                    }
                    if (!actual_line.contains("Preset:")) continue;
                    slist_configs = slist_configs + "   " + actual_line.substring(10) + "\n";
                    ++nb_presets;
                    continue;
                }
                if (!actual_line.startsWith("Device")) continue;
                actual_line = actual_line.substring(7);
                while ((coma_index = actual_line.indexOf(44)) != -1) {
                    actual_line = actual_line.substring(coma_index + 1);
                }
                slist_devices = slist_devices + actual_line + "\n";
                ++nb_devices;
            }
        }
        in.close();
        String slist_resume = "Nb Devices: " + nb_devices;
        slist_resume = slist_resume + "\nNb Groups: " + nb_groups;
        slist_resume = slist_resume + "\nNb Presets: " + nb_presets;
        this._list_devices.setText(slist_devices);
        this._list_configs.setText(slist_configs);
        this._list_resume.setText(slist_resume);
        this._list_devices.setCaretPosition(0);
        this._list_configs.setCaretPosition(0);
        this._list_resume.setCaretPosition(0);
    }
}

