/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.image.ImageUtil;
import icy.resource.ResourceUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageComponent
extends JPanel {
    private static final long serialVersionUID = 1448746815524070306L;
    private Image image;
    private BufferedImage cachedImage;
    protected boolean forceUpdateCache;

    @Deprecated
    public ImageComponent(Image image, Dimension d) {
        this(image);
    }

    @Deprecated
    public ImageComponent(Image image, int width, int height) {
        this(image);
    }

    public ImageComponent(Image image) {
        super(true);
        this.image = image;
        if (image != null) {
            ImageUtil.waitImageReady(image);
            this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
        }
        this.forceUpdateCache = true;
    }

    public ImageComponent() {
        this((Image)null);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image != image) {
            this.image = image;
            this.forceUpdateCache = true;
            this.repaint();
        }
    }

    protected void updateCache() {
        this.cachedImage = null;
        if (this.image == null) {
            return;
        }
        ImageUtil.waitImageReady(this.image);
        float ix = this.image.getWidth(null);
        float iy = this.image.getHeight(null);
        if (ix <= 0.0f || iy <= 0.0f) {
            this.image = ResourceUtil.ICON_DELETE;
            ix = this.image.getWidth(null);
            iy = this.image.getHeight(null);
        }
        float w = Math.max(this.getWidth(), 100);
        float h = Math.max(this.getHeight(), 100);
        if (w > 0.0f && h > 0.0f) {
            float sx = w / ix;
            float sy = h / iy;
            float s = Math.min(sx, sy);
            int nix = (int)(ix * s);
            int niy = (int)(iy * s);
            if (nix > 0 && niy > 0 && (this.forceUpdateCache || this.cachedImage == null || nix != this.cachedImage.getWidth() || niy != this.cachedImage.getHeight())) {
                this.cachedImage = ImageUtil.scaleQuality(this.image, nix, niy);
                this.forceUpdateCache = false;
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.updateCache();
        if (this.cachedImage != null) {
            g.drawImage(this.cachedImage, (this.getWidth() - this.cachedImage.getWidth()) / 2, (this.getHeight() - this.cachedImage.getHeight()) / 2, null);
        }
    }
}

