/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble2D;
import mitiv.array.impl.StriddenDouble1D;
import mitiv.array.impl.StriddenDouble2D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.DoubleGenerator;

public class FlatDouble2D
extends Double2D {
    static final int order = 1;
    final double[] data;

    public FlatDouble2D(int dim1, int dim2) {
        super(dim1, dim2);
        this.data = new double[this.number];
    }

    public FlatDouble2D(int[] dims) {
        super(dims);
        this.data = new double[this.number];
    }

    public FlatDouble2D(Shape shape) {
        super(shape);
        this.data = new double[this.number];
    }

    public FlatDouble2D(double[] arr, int dim1, int dim2) {
        super(dim1, dim2);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatDouble2D(double[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatDouble2D(double[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(double[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int i1, int i2) {
        return this.dim1 * i2 + i1;
    }

    @Override
    public final double get(int i1, int i2) {
        return this.data[this.dim1 * i2 + i1];
    }

    @Override
    public final void set(int i1, int i2, double value) {
        this.data[this.dim1 * i2 + i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(double value) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = value;
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = generator.nextDouble();
        }
    }

    @Override
    public void increment(double value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(double value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(double value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(DoubleFunction function) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = function.apply(this.data[j]);
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        scanner.initialize(this.data[0]);
        for (int j = 1; j < this.number; ++j) {
            scanner.update(this.data[j]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        if (forceCopy) {
            double[] result = new double[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public Double1D slice(int idx) {
        if ((idx = Helper.fixIndex(idx, this.dim2)) == 0) {
            return new FlatDouble1D(this.data, this.dim1);
        }
        return new StriddenDouble1D(this.data, this.dim1 * idx, 1, this.dim1);
    }

    @Override
    public Double1D slice(int idx, int dim) {
        int sliceDim1;
        int sliceStride1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 2)) == 0) {
            sliceOffset = Helper.fixIndex(idx, this.dim1);
            sliceStride1 = this.dim1;
            sliceDim1 = this.dim2;
        } else {
            sliceOffset = this.dim1 * Helper.fixIndex(idx, this.dim2);
            sliceStride1 = 1;
            sliceDim1 = this.dim1;
        }
        return new StriddenDouble1D(this.data, sliceOffset, sliceStride1, sliceDim1);
    }

    @Override
    public Double2D view(Range rng1, Range rng2) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.dim1);
        if (cr1.doesNothing() && cr2.doesNothing()) {
            return this;
        }
        return new StriddenDouble2D(this.data, cr1.getOffset() + cr2.getOffset(), cr1.getStride(), cr2.getStride(), cr1.getNumber(), cr2.getNumber());
    }

    @Override
    public Double2D view(int[] sel1, int[] sel2) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.dim1, this.dim2, sel2);
        return new SelectedDouble2D(this.data, idx1, idx2);
    }

    @Override
    public Double1D as1D() {
        return new FlatDouble1D(this.data, this.number);
    }
}

