/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.filtering;

import icy.gui.component.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.roi.ROI;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.Point3D;
import plugins.fab.spotDetector.filtering.FilteringDetectionAbstract;
import plugins.fab.spotDetector.filtering.IntervalSliderValue;

public class deClusterFiltering
extends FilteringDetectionAbstract {
    IntervalSliderValue intervalSize = new IntervalSliderValue(0, 300, 0, 300, "Range of accepted objects (in pixels) (not used)");
    JTextField spotRaySizeTextBox = new JTextField("4");
    int nbSplitDetection = 0;

    public deClusterFiltering() {
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        ComponentUtil.setFixedHeight((Component)this.intervalSize, (int)40);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("spot ray:"), this.spotRaySizeTextBox}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(50)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
    }

    private double getSurfaceOfOneSpot(double spotRay) {
        int bound = (int)Math.ceil(spotRay + 1.0);
        int surface = 0;
        for (int x = -bound; x <= bound; ++x) {
            for (int y = -bound; y <= bound; ++y) {
                Point2D.Double p = new Point2D.Double(x, y);
                if (!(p.distance(0.0, 0.0) < spotRay)) continue;
                ++surface;
            }
        }
        return surface;
    }

    private double getSurfaceOfTwoContiguousSpot(double spotRay) {
        int bound = (int)Math.ceil(spotRay + 1.0) + 1;
        int surface = 0;
        for (int x = -bound; x <= bound; ++x) {
            for (int y = -bound; y <= bound; ++y) {
                Point2D.Double p = new Point2D.Double(x, y);
                if (!(p.distance(0.0, 0.0) < spotRay) && !(p.distance(1.0, 0.0) < spotRay)) continue;
                ++surface;
            }
        }
        return surface;
    }

    private void fit(DetectionSpot detectionSpot, ArrayList<DetectionSpot> detectionList) {
        detectionSpot.points.get(0);
    }

    private void filterTest(DetectionSpot detectionSpot, ArrayList<DetectionSpot> detectionList, GlobalDetectionToken gdt) {
        double max = 0.0;
        detectionSpot.getT();
        for (Point3D p : detectionSpot.points) {
            double value = gdt.inputComputationSequence.getImage(detectionSpot.getT(), (int)p.z).getData((int)p.x, (int)p.y, 0);
            if (!(value > max)) continue;
            max = value;
        }
        if (max > 80.0) {
            ++this.nbSplitDetection;
            DetectionSpot newSpot = new DetectionSpot();
            newSpot.points.add(new Point3D(detectionSpot.getMassCenter().x + 1.0, detectionSpot.getMassCenter().y + 1.0, detectionSpot.getMassCenter().z));
            newSpot.setT(detectionSpot.getT());
            newSpot.computeMassCenter();
            detectionList.add(newSpot);
        }
    }

    private void filterTest2(DetectionSpot detectionSpot, ArrayList<DetectionSpot> detectionList, int surfaceOfOneSpot, int diffSurface) {
        if (detectionSpot.points.size() < 2) {
            detectionList.remove(detectionSpot);
        }
        if (detectionSpot.points.size() > surfaceOfOneSpot) {
            ++this.nbSplitDetection;
            Point3D massCenter = new Point3D(detectionSpot.getMassCenter().x, detectionSpot.getMassCenter().x);
            detectionSpot.points.clear();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    detectionSpot.points.add(new Point3D((double)x + massCenter.x, (double)y + massCenter.x));
                }
            }
            massCenter.x += 1.0;
            massCenter.y += 1.0;
            DetectionSpot newSpot = new DetectionSpot();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    newSpot.points.add(new Point3D((double)x + massCenter.x, (double)y + massCenter.x));
                }
            }
            detectionList.add(newSpot);
        }
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        System.out.println("Cluster filtering...");
        double spotRay = Double.parseDouble(this.spotRaySizeTextBox.getText());
        int surfaceOfOneSpot = (int)this.getSurfaceOfOneSpot(spotRay);
        int surfaceOfTwoContiguousSpot = (int)this.getSurfaceOfTwoContiguousSpot(spotRay);
        System.out.println("surface of one spot: " + surfaceOfOneSpot);
        System.out.println("surface of 2 glued spots: " + surfaceOfTwoContiguousSpot);
        System.out.println("difference between the 2:" + (surfaceOfTwoContiguousSpot - surfaceOfOneSpot));
        int highValue = surfaceOfOneSpot;
        int lowValue = 2;
        this.nbSplitDetection = 0;
        for (ROI roi : gdt.roi2detection.keySet()) {
            ArrayList<DetectionSpot> detectionList = gdt.roi2detection.get(roi);
            ArrayList<DetectionSpot> detectionListCopy = new ArrayList<DetectionSpot>(detectionList);
            for (DetectionSpot detectionSpot : detectionListCopy) {
                this.filterTest(detectionSpot, detectionList, gdt);
            }
        }
        System.out.println("Nombre de split phase 1: " + this.nbSplitDetection);
        this.nbSplitDetection = 0;
        ArrayList<DetectionSpot> detectionList = gdt.detectionResult;
        ArrayList<DetectionSpot> detectionListCopy = new ArrayList<DetectionSpot>(detectionList);
        for (DetectionSpot detectionSpot : detectionListCopy) {
            this.filterTest(detectionSpot, detectionList, gdt);
        }
        System.out.println("Nombre de split phase 2: " + this.nbSplitDetection);
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
    }
}

