/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonRootPaneUI;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;

public class SubstanceRibbonFrameTitlePane
extends SubstanceTitlePane {
    protected Map<RibbonContextualTaskGroup, SubstanceContextualGroupComponent> taskComponentMap = new HashMap<RibbonContextualTaskGroup, SubstanceContextualGroupComponent>();
    protected ChangeListener ribbonFrameChangeListener;
    protected TaskbarPanel taskbarPanel = new TaskbarPanel();

    public SubstanceRibbonFrameTitlePane(JRootPane root, SubstanceRootPaneUI ui) {
        super(root, ui);
        this.markExtraComponent(this.taskbarPanel, SubstanceTitlePane.ExtraComponentKind.LEADING);
        this.add(this.taskbarPanel);
    }

    @Override
    protected LayoutManager createLayout() {
        return new RibbonFrameTitlePaneLayout();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JRibbon ribbon = this.getRibbon();
        ribbon.putClientProperty("ribbon.internal.isUsingTitlePane", Boolean.TRUE);
        this.syncRibbonState();
        this.ribbonFrameChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SubstanceRibbonFrameTitlePane.this.syncRibbonState();
            }
        };
        ribbon.addChangeListener(this.ribbonFrameChangeListener);
    }

    @Override
    public void removeNotify() {
        JRibbon ribbon = this.getRibbon();
        ribbon.putClientProperty("ribbon.internal.isUsingTitlePane", null);
        for (SubstanceContextualGroupComponent groupComp : this.taskComponentMap.values()) {
            this.remove(groupComp);
        }
        ribbon.removeChangeListener(this.ribbonFrameChangeListener);
        this.ribbonFrameChangeListener = null;
        super.removeNotify();
    }

    protected void syncRibbonState() {
        for (SubstanceContextualGroupComponent groupComp : this.taskComponentMap.values()) {
            this.remove(groupComp);
        }
        this.taskComponentMap.clear();
        JRibbon ribbon = this.getRibbon();
        for (int i = 0; i < ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup group = ribbon.getContextualTaskGroup(i);
            if (!ribbon.isVisible(group)) continue;
            SubstanceContextualGroupComponent taskGroupComponent = new SubstanceContextualGroupComponent(group);
            taskGroupComponent.applyComponentOrientation(this.getRibbon().getComponentOrientation());
            this.add(taskGroupComponent);
            this.taskComponentMap.put(group, taskGroupComponent);
            this.markExtraComponent(taskGroupComponent, SubstanceTitlePane.ExtraComponentKind.MIDDLING);
        }
        this.taskbarPanel.removeAll();
        this.taskbarPanel.setPreferredSize(null);
        for (Component taskbarComp : ribbon.getTaskbarComponents()) {
            this.taskbarPanel.add(taskbarComp);
        }
    }

    private JRibbon getRibbon() {
        JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor(this);
        JRibbon ribbon = ribbonFrame.getRibbon();
        return ribbon;
    }

    private int getTaskBarLayoutGap(Container c) {
        return SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(c), 1, 6, 1, false);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.taskbarPanel.getWidth() != 0) {
            g2d.translate(this.taskbarPanel.getX(), this.taskbarPanel.getY());
            SubstanceRibbonFrameTitlePane.paintTaskBarPanelOutline(g2d, this.taskbarPanel);
            g2d.translate(-this.taskbarPanel.getX(), -this.taskbarPanel.getY());
        }
        if (SubstanceLookAndFeel.getCurrentSkin(this).getOverlayPainters(DecorationAreaType.PRIMARY_TITLE_PANE).isEmpty()) {
            SubstanceColorScheme compScheme = SubstanceColorSchemeUtilities.getColorScheme(this, ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
            Color sepColor = compScheme.isDark() ? SeparatorPainterUtils.getSeparatorShadowColor(compScheme) : SeparatorPainterUtils.getSeparatorDarkColor(compScheme);
            g2d.setColor(sepColor);
            g2d.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        }
        g2d.dispose();
    }

    protected static void paintTaskBarPanelOutline(Graphics g, TaskbarPanel taskbarPanel) {
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(taskbarPanel)) / 2.0);
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(taskbarPanel));
        Shape contour = taskbarPanel.getOutline(borderDelta);
        Shape contourInner = taskbarPanel.getOutline(borderDelta + borderThickness);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(taskbarPanel, ComponentState.ENABLED);
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(taskbarPanel, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(taskbarPanel);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.6f));
        if (contour != null) {
            Shape clip = g2d.getClip();
            g2d.clip(contour);
            DecorationPainterUtils.paintDecorationBackground(g2d, taskbarPanel, true);
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite(taskbarPanel, 0.3f, g));
            MatteFillPainter.INSTANCE.paintContourBackground(g2d, taskbarPanel, taskbarPanel.getWidth(), taskbarPanel.getHeight(), contour.getBounds(), false, colorScheme, false);
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite(taskbarPanel, 1.0f, g));
            g2d.setClip(clip);
        }
        borderPainter.paintBorder(g2d, taskbarPanel, taskbarPanel.getWidth(), taskbarPanel.getHeight(), contour, contourInner, borderScheme);
        g2d.dispose();
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int pw = 0;
            int gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(c);
            for (Component regComp : SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                if (!regComp.isVisible()) continue;
                pw += regComp.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, c.getParent().getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(c);
            boolean ltr = SubstanceRibbonFrameTitlePane.this.getComponentOrientation().isLeftToRight();
            int x = ltr ? ins.left : c.getWidth() - ins.right;
            for (Component regComp : SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                if (!regComp.isVisible()) continue;
                int pw = regComp.getPreferredSize().width;
                if (ltr) {
                    regComp.setBounds(x, ins.top, pw, c.getHeight() - ins.top - ins.bottom);
                    x += pw + gap;
                    continue;
                }
                regComp.setBounds(x - pw, ins.top, pw, c.getHeight() - ins.top - ins.bottom);
                x -= pw + gap;
            }
        }
    }

    protected class RibbonFrameTitlePaneLayout
    extends SubstanceTitlePane.TitlePaneLayout {
        protected RibbonFrameTitlePaneLayout() {
            super(SubstanceRibbonFrameTitlePane.this);
        }

        @Override
        public void layoutContainer(Container c) {
            super.layoutContainer(c);
            JRibbon ribbon = SubstanceRibbonFrameTitlePane.this.getRibbon();
            boolean ltr = ribbon.getComponentOrientation().isLeftToRight();
            RibbonUI ribbonUI = ribbon.getUI();
            if (ltr) {
                for (Map.Entry<RibbonContextualTaskGroup, SubstanceContextualGroupComponent> entry : SubstanceRibbonFrameTitlePane.this.taskComponentMap.entrySet()) {
                    Rectangle taskGroupBounds = ribbonUI.getContextualTaskGroupBounds(entry.getKey());
                    int minTrailingX = c.getWidth();
                    for (int i = 0; i < c.getComponentCount(); ++i) {
                        SubstanceTitlePane.ExtraComponentKind kind;
                        Component child = c.getComponent(i);
                        if (!child.isVisible() || !(child instanceof JComponent) || (kind = (SubstanceTitlePane.ExtraComponentKind)((Object)((JComponent)child).getClientProperty("substancelaf.internal.titlePane.extraComponentKind"))) == SubstanceTitlePane.ExtraComponentKind.LEADING || child instanceof SubstanceContextualGroupComponent) continue;
                        minTrailingX = Math.min(child.getX(), minTrailingX);
                    }
                    int width = taskGroupBounds.width;
                    if (taskGroupBounds.x + width > minTrailingX - 5) {
                        width = minTrailingX - 5 - taskGroupBounds.x;
                    }
                    entry.getValue().setBounds(new Rectangle(taskGroupBounds.x, 0, width, c.getHeight()));
                    entry.getValue().setVisible(!ribbonUI.isShowingScrollsForTaskToggleButtons());
                }
                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setVisible(true);
                Dimension pref = SubstanceRibbonFrameTitlePane.this.taskbarPanel.getPreferredSize();
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.getComponentCount() == 0) {
                    pref.width = 0;
                }
                SubstanceRibbonRootPaneUI rootPaneUI = (SubstanceRibbonRootPaneUI)SubstanceRibbonFrameTitlePane.this.getRootPane().getUI();
                JRibbonApplicationMenuButton menuButton = rootPaneUI.applicationMenuButton;
                if (menuButton != null) {
                    if (menuButton.isVisible()) {
                        int maxLeadingX = menuButton.getX() + menuButton.getWidth() + 2 * SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(SubstanceRibbonFrameTitlePane.this.taskbarPanel);
                        if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                            SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(maxLeadingX, 0, pref.width, c.getHeight());
                        }
                        SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(false);
                    } else {
                        if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                            if (pref.width == 0) {
                                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() + SubstanceRibbonFrameTitlePane.this.menuBar.getWidth(), 0, pref.width, c.getHeight());
                            } else {
                                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() + SubstanceRibbonFrameTitlePane.this.menuBar.getWidth() + 5, 0, pref.width, c.getHeight());
                            }
                        }
                        SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(true);
                    }
                } else {
                    SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(true);
                }
            } else {
                for (Map.Entry<RibbonContextualTaskGroup, SubstanceContextualGroupComponent> entry : SubstanceRibbonFrameTitlePane.this.taskComponentMap.entrySet()) {
                    Rectangle taskGroupBounds = ribbonUI.getContextualTaskGroupBounds(entry.getKey());
                    int maxTrailingX = 0;
                    for (int i = 0; i < c.getComponentCount(); ++i) {
                        SubstanceTitlePane.ExtraComponentKind kind;
                        Component child = c.getComponent(i);
                        if (!child.isVisible() || !(child instanceof JComponent) || (kind = (SubstanceTitlePane.ExtraComponentKind)((Object)((JComponent)child).getClientProperty("substancelaf.internal.titlePane.extraComponentKind"))) == SubstanceTitlePane.ExtraComponentKind.LEADING || child instanceof SubstanceContextualGroupComponent) continue;
                        maxTrailingX = Math.max(child.getX() + child.getWidth(), maxTrailingX);
                    }
                    int width = taskGroupBounds.width;
                    int x = taskGroupBounds.x;
                    if (taskGroupBounds.x < maxTrailingX + 5) {
                        int diff = maxTrailingX + 5 - taskGroupBounds.x;
                        x += diff;
                        width -= diff;
                    }
                    entry.getValue().setBounds(new Rectangle(x, 0, width, c.getHeight()));
                    entry.getValue().setVisible(!ribbonUI.isShowingScrollsForTaskToggleButtons());
                }
                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setVisible(true);
                Dimension pref = SubstanceRibbonFrameTitlePane.this.taskbarPanel.getPreferredSize();
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.getComponentCount() == 0) {
                    pref.width = 0;
                }
                SubstanceRibbonRootPaneUI rootPaneUI = (SubstanceRibbonRootPaneUI)SubstanceRibbonFrameTitlePane.this.getRootPane().getUI();
                JRibbonApplicationMenuButton menuButton = rootPaneUI.applicationMenuButton;
                if (menuButton != null) {
                    if (menuButton.isVisible()) {
                        int maxLeadingX = menuButton.getX() - 2 * SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(SubstanceRibbonFrameTitlePane.this.taskbarPanel);
                        if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                            SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(maxLeadingX - pref.width, 0, pref.width, c.getHeight());
                        }
                        SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(false);
                    } else {
                        if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                            if (pref.width == 0) {
                                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX(), 0, pref.width, c.getHeight());
                            } else {
                                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() - 5 - pref.width, 0, pref.width, c.getHeight());
                            }
                        }
                        SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(true);
                    }
                } else {
                    SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(true);
                }
            }
        }
    }

    private class TaskbarPanel
    extends JPanel {
        public TaskbarPanel() {
            super(new TaskbarLayout());
            this.setOpaque(false);
            int insets = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this), 2, 3, 1, false);
            this.setBorder(new EmptyBorder(insets, insets, insets, insets));
        }

        @Override
        protected void paintComponent(Graphics g) {
        }

        protected Shape getOutline(double insets) {
            double width = (double)this.getWidth() - 2.0 * insets - 1.0;
            double height = (double)this.getHeight() - 2.0 * insets - 1.0;
            float radius = (float)height;
            if (this.getComponentCount() == 0) {
                return null;
            }
            GeneralPath outline = new GeneralPath();
            JRibbonApplicationMenuButton menuButton = FlamingoUtilities.getApplicationMenuButton(SwingUtilities.getWindowAncestor(this));
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            double alpha = Math.asin(((double)radius - insets / 2.0) / ((double)radius + insets / 2.0));
            if (ltr) {
                outline.moveTo(insets + width - height / 2.0, insets);
                outline.append(new Arc2D.Double(insets + width - height, insets, height, height, 90.0, -180.0, 0), true);
                outline.lineTo(insets, insets + height);
                if (menuButton != null) {
                    double arcSpan = 90.0;
                    if (insets != 0.0) {
                        arcSpan = 180.0 * alpha / Math.PI;
                    }
                    outline.append(new Arc2D.Double(insets - 2.0 * height, insets, 2.0 * height, 2.0 * height, 0.0, arcSpan, 0), true);
                } else {
                    outline.lineTo(insets, insets);
                }
            } else {
                outline.moveTo(insets + height / 2.0, 0.0);
                outline.append(new Arc2D.Double(insets, 0.0, height, height, 90.0, 180.0, 0), true);
                outline.lineTo(width - 1.0, insets + height);
                if (menuButton != null) {
                    double arcSpan = -90.0;
                    if (insets != 0.0) {
                        arcSpan = -180.0 * alpha / Math.PI;
                    }
                    outline.append(new Arc2D.Double(width - 1.0, 0.0, 2.0 * height, 2.0 * height, 180.0, arcSpan, 0), true);
                } else {
                    outline.lineTo(width - 1.0, 0.0);
                }
            }
            outline.closePath();
            return outline;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            return new Dimension(result.width + result.height / 2, result.height);
        }
    }

    private class SubstanceContextualGroupComponent
    extends JComponent {
        RibbonContextualTaskGroup taskGroup;

        public SubstanceContextualGroupComponent(RibbonContextualTaskGroup taskGroup) {
            this.taskGroup = taskGroup;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Color hueColor = this.taskGroup.getHueColor();
            Graphics2D g2d = (Graphics2D)g.create();
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(hueColor, 0), 0.0f, height, SubstanceColorUtilities.getAlphaColor(hueColor, 63));
            g2d = (Graphics2D)g.create();
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width, height);
            g2d.setColor(hueColor);
            g2d.drawLine(1, height - 1, width, height - 1);
            JRibbon ribbon = SubstanceRibbonFrameTitlePane.this.getRibbon();
            SubstanceColorScheme scheme = SubstanceCoreUtilities.getSkin(SubstanceRibbonFrameTitlePane.this.rootPane).getEnabledColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE);
            FontMetrics fm = this.getFontMetrics(ribbon.getFont());
            int yOffset = (height - fm.getHeight()) / 2;
            RenderingUtils.installDesktopHints(g2d, this);
            int offset = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this), 5, 2, 1, false);
            if (this.getComponentOrientation().isLeftToRight()) {
                SubstanceTextUtilities.paintText(g2d, this, new Rectangle(offset, yOffset, width, height - yOffset), this.taskGroup.getTitle(), -1, ribbon.getFont(), SubstanceColorUtilities.getForegroundColor(scheme), null);
            } else {
                SubstanceTextUtilities.paintText(g2d, this, new Rectangle(width - offset - g2d.getFontMetrics().stringWidth(this.taskGroup.getTitle()), yOffset, width, height - yOffset), this.taskGroup.getTitle(), -1, ribbon.getFont(), SubstanceColorUtilities.getForegroundColor(scheme), null);
            }
            SeparatorPainterUtils.paintSeparator(ribbon, g2d, 2, height, 1, false, height / 3, 0, true);
            g2d.translate(width - 1, 0);
            SeparatorPainterUtils.paintSeparator(ribbon, g2d, 2, height, 1, false, height / 3, 0, true);
            g2d.dispose();
        }
    }
}

