/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    VTKACCELERATORSVTKM("vtkAcceleratorsVTKmJava", false),
    VTKCHARTSCORE("vtkChartsCoreJava", true),
    VTKCOMMONCOLOR("vtkCommonColorJava", true),
    VTKCOMMONCOMPUTATIONALGEOMETRY("vtkCommonComputationalGeometryJava", true),
    VTKCOMMONCORE("vtkCommonCoreJava", true),
    VTKCOMMONDATAMODEL("vtkCommonDataModelJava", true),
    VTKCOMMONEXECUTIONMODEL("vtkCommonExecutionModelJava", true),
    VTKCOMMONMATH("vtkCommonMathJava", true),
    VTKCOMMONMISC("vtkCommonMiscJava", true),
    VTKCOMMONSYSTEM("vtkCommonSystemJava", true),
    VTKCOMMONTRANSFORMS("vtkCommonTransformsJava", true),
    VTKDOMAINSCHEMISTRY("vtkDomainsChemistryJava", true),
    VTKDOMAINSCHEMISTRYOPENGL2("vtkDomainsChemistryOpenGL2Java", true),
    VTKDOMAINSMICROSCOPY("vtkDomainsMicroscopyJava", false),
    VTKFILTERSAMR("vtkFiltersAMRJava", true),
    VTKFILTERSCORE("vtkFiltersCoreJava", true),
    VTKFILTERSEXTRACTION("vtkFiltersExtractionJava", true),
    VTKFILTERSFLOWPATHS("vtkFiltersFlowPathsJava", true),
    VTKFILTERSGENERAL("vtkFiltersGeneralJava", true),
    VTKFILTERSGENERIC("vtkFiltersGenericJava", true),
    VTKFILTERSGEOMETRY("vtkFiltersGeometryJava", true),
    VTKFILTERSHYBRID("vtkFiltersHybridJava", true),
    VTKFILTERSHYPERTREE("vtkFiltersHyperTreeJava", true),
    VTKFILTERSIMAGING("vtkFiltersImagingJava", true),
    VTKFILTERSMODELING("vtkFiltersModelingJava", true),
    VTKFILTERSPARALLEL("vtkFiltersParallelJava", true),
    VTKFILTERSPARALLELFLOWPATHS("vtkFiltersParallelFlowPathsJava", false),
    VTKFILTERSPARALLELGEOMETRY("vtkFiltersParallelGeometryJava", false),
    VTKFILTERSPARALLELIMAGING("vtkFiltersParallelImagingJava", true),
    VTKFILTERSPARALLELMPI("vtkFiltersParallelMPIJava", false),
    VTKFILTERSPARALLELSTATISTICS("vtkFiltersParallelStatisticsJava", false),
    VTKFILTERSPOINTS("vtkFiltersPointsJava", true),
    VTKFILTERSPROGRAMMABLE("vtkFiltersProgrammableJava", true),
    VTKFILTERSREEBGRAPH("vtkFiltersReebGraphJava", false),
    VTKFILTERSSMP("vtkFiltersSMPJava", true),
    VTKFILTERSSELECTION("vtkFiltersSelectionJava", true),
    VTKFILTERSSOURCES("vtkFiltersSourcesJava", true),
    VTKFILTERSSTATISTICS("vtkFiltersStatisticsJava", true),
    VTKFILTERSSTATISTICSGNUR("vtkFiltersStatisticsGnuRJava", false),
    VTKFILTERSTEXTURE("vtkFiltersTextureJava", true),
    VTKFILTERSTOPOLOGY("vtkFiltersTopologyJava", true),
    VTKFILTERSVERDICT("vtkFiltersVerdictJava", true),
    VTKGEOVISCORE("vtkGeovisCoreJava", true),
    VTKIOADIOS("vtkIOADIOSJava", false),
    VTKIOAMR("vtkIOAMRJava", true),
    VTKIOCORE("vtkIOCoreJava", true),
    VTKIOENSIGHT("vtkIOEnSightJava", true),
    VTKIOEXODUS("vtkIOExodusJava", true),
    VTKIOEXPORT("vtkIOExportJava", true),
    VTKIOEXPORTOPENGL("vtkIOExportOpenGLJava", false),
    VTKIOEXPORTOPENGL2("vtkIOExportOpenGL2Java", true),
    VTKIOFFMPEG("vtkIOFFMPEGJava", false),
    VTKIOGDAL("vtkIOGDALJava", false),
    VTKIOGEOJSON("vtkIOGeoJSONJava", false),
    VTKIOGEOMETRY("vtkIOGeometryJava", true),
    VTKIOIMAGE("vtkIOImageJava", true),
    VTKIOIMPORT("vtkIOImportJava", true),
    VTKIOINFOVIS("vtkIOInfovisJava", true),
    VTKIOLSDYNA("vtkIOLSDynaJava", true),
    VTKIOLEGACY("vtkIOLegacyJava", true),
    VTKIOMINC("vtkIOMINCJava", true),
    VTKIOMPIIMAGE("vtkIOMPIImageJava", false),
    VTKIOMPIPARALLEL("vtkIOMPIParallelJava", false),
    VTKIOMOVIE("vtkIOMovieJava", true),
    VTKIOMYSQL("vtkIOMySQLJava", false),
    VTKIONETCDF("vtkIONetCDFJava", true),
    VTKIOODBC("vtkIOODBCJava", false),
    VTKIOPLY("vtkIOPLYJava", true),
    VTKIOPARALLEL("vtkIOParallelJava", true),
    VTKIOPARALLELEXODUS("vtkIOParallelExodusJava", false),
    VTKIOPARALLELLSDYNA("vtkIOParallelLSDynaJava", false),
    VTKIOPARALLELNETCDF("vtkIOParallelNetCDFJava", false),
    VTKIOPARALLELXML("vtkIOParallelXMLJava", true),
    VTKIOPOSTGRESQL("vtkIOPostgreSQLJava", false),
    VTKIOSQL("vtkIOSQLJava", true),
    VTKIOTRUCHAS("vtkIOTRUCHASJava", false),
    VTKIOTECPLOTTABLE("vtkIOTecplotTableJava", true),
    VTKIOVPIC("vtkIOVPICJava", false),
    VTKIOVIDEO("vtkIOVideoJava", true),
    VTKIOXML("vtkIOXMLJava", true),
    VTKIOXMLPARSER("vtkIOXMLParserJava", true),
    VTKIOXDMF2("vtkIOXdmf2Java", false),
    VTKIOXDMF3("vtkIOXdmf3Java", false),
    VTKIMAGINGCOLOR("vtkImagingColorJava", true),
    VTKIMAGINGCORE("vtkImagingCoreJava", true),
    VTKIMAGINGFOURIER("vtkImagingFourierJava", true),
    VTKIMAGINGGENERAL("vtkImagingGeneralJava", true),
    VTKIMAGINGHYBRID("vtkImagingHybridJava", true),
    VTKIMAGINGMATH("vtkImagingMathJava", true),
    VTKIMAGINGMORPHOLOGICAL("vtkImagingMorphologicalJava", true),
    VTKIMAGINGOPENGL2("vtkImagingOpenGL2Java", false),
    VTKIMAGINGSOURCES("vtkImagingSourcesJava", true),
    VTKIMAGINGSTATISTICS("vtkImagingStatisticsJava", true),
    VTKIMAGINGSTENCIL("vtkImagingStencilJava", true),
    VTKINFOVISBOOSTGRAPHALGORITHMS("vtkInfovisBoostGraphAlgorithmsJava", false),
    VTKINFOVISCORE("vtkInfovisCoreJava", true),
    VTKINFOVISLAYOUT("vtkInfovisLayoutJava", true),
    VTKINFOVISPARALLEL("vtkInfovisParallelJava", false),
    VTKINTERACTIONIMAGE("vtkInteractionImageJava", true),
    VTKINTERACTIONSTYLE("vtkInteractionStyleJava", true),
    VTKINTERACTIONWIDGETS("vtkInteractionWidgetsJava", true),
    VTKPARALLELCORE("vtkParallelCoreJava", true),
    VTKPARALLELMPI("vtkParallelMPIJava", false),
    VTKRENDERINGANNOTATION("vtkRenderingAnnotationJava", true),
    VTKRENDERINGCONTEXT2D("vtkRenderingContext2DJava", true),
    VTKRENDERINGCONTEXTOPENGL("vtkRenderingContextOpenGLJava", false),
    VTKRENDERINGCONTEXTOPENGL2("vtkRenderingContextOpenGL2Java", true),
    VTKRENDERINGCORE("vtkRenderingCoreJava", true),
    VTKRENDERINGEXTERNAL("vtkRenderingExternalJava", false),
    VTKRENDERINGFREETYPE("vtkRenderingFreeTypeJava", true),
    VTKRENDERINGGL2PS("vtkRenderingGL2PSJava", false),
    VTKRENDERINGGL2PSOPENGL2("vtkRenderingGL2PSOpenGL2Java", true),
    VTKRENDERINGIMAGE("vtkRenderingImageJava", true),
    VTKRENDERINGLIC("vtkRenderingLICJava", false),
    VTKRENDERINGLICOPENGL2("vtkRenderingLICOpenGL2Java", false),
    VTKRENDERINGLOD("vtkRenderingLODJava", true),
    VTKRENDERINGLABEL("vtkRenderingLabelJava", true),
    VTKRENDERINGMATPLOTLIB("vtkRenderingMatplotlibJava", false),
    VTKRENDERINGOSPRAY("vtkRenderingOSPRayJava", false),
    VTKRENDERINGOCULUS("vtkRenderingOculusJava", false),
    VTKRENDERINGOPENGL("vtkRenderingOpenGLJava", false),
    VTKRENDERINGOPENGL2("vtkRenderingOpenGL2Java", true),
    VTKRENDERINGOPENVR("vtkRenderingOpenVRJava", false),
    VTKRENDERINGPARALLEL("vtkRenderingParallelJava", false),
    VTKRENDERINGPARALLELLIC("vtkRenderingParallelLICJava", false),
    VTKRENDERINGQT("vtkRenderingQtJava", false),
    VTKRENDERINGSCENEGRAPH("vtkRenderingSceneGraphJava", false),
    VTKRENDERINGVOLUME("vtkRenderingVolumeJava", true),
    VTKRENDERINGVOLUMEAMR("vtkRenderingVolumeAMRJava", false),
    VTKRENDERINGVOLUMEOPENGL("vtkRenderingVolumeOpenGLJava", false),
    VTKRENDERINGVOLUMEOPENGL2("vtkRenderingVolumeOpenGL2Java", true),
    VTKTESTINGRENDERING("vtkTestingRenderingJava", false),
    VTKPYTHONINTERPRETER("vtkPythonInterpreterJava", false),
    VTKVIEWSCONTEXT2D("vtkViewsContext2DJava", true),
    VTKVIEWSCORE("vtkViewsCoreJava", true),
    VTKVIEWSGEOVIS("vtkViewsGeovisJava", false),
    VTKVIEWSINFOVIS("vtkViewsInfovisJava", true),
    VTKWEBCORE("vtkWebCoreJava", false),
    VTKWEBGLEXPORTER("vtkWebGLExporterJava", false);

    private String nativeLibraryName;
    private boolean loaded;
    private boolean built;

    public static boolean LoadAllNativeLibraries() {
        boolean bl = true;
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
            try {
                if (!vtkNativeLibrary2.IsBuilt()) continue;
                vtkNativeLibrary2.LoadLibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return bl;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... vtkNativeLibraryArray) {
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibraryArray) {
            vtkNativeLibrary2.LoadLibrary();
        }
    }

    public static void DisableOutputWindow(File file) {
        if (file == null) {
            file = new File("vtkError.txt");
        }
        vtkFileOutputWindow vtkFileOutputWindow2 = new vtkFileOutputWindow();
        vtkFileOutputWindow2.SetFileName(file.getAbsolutePath());
        vtkFileOutputWindow2.SetInstance(vtkFileOutputWindow2);
    }

    private vtkNativeLibrary(String string2, boolean bl) {
        this.nativeLibraryName = string2;
        this.loaded = false;
        this.built = bl;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File file = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(file.getAbsolutePath());
                File file2 = new File(file, System.mapLibraryName(this.nativeLibraryName));
                if (file2.exists()) {
                    try {
                        Runtime.getRuntime().load(file2.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        unsatisfiedLinkError.printStackTrace();
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public boolean IsBuilt() {
        return this.built;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String string) {
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            String string3 = System.getProperty("java.library.path");
            if (!string3.contains(string)) {
                string3 = string3 + string2 + string;
                System.setProperty("java.library.path", string3);
            }
        }
    }
}

