/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.util.Properties;

public class ProxySettings
implements PlugIn {
    private Properties props = System.getProperties();
    private String proxyhost = Prefs.get("proxy.server", "");
    private int proxyport = (int)Prefs.get("proxy.port", 8080.0);

    @Override
    public void run(String arg) {
        double portNumber;
        double portNumber2;
        String port;
        if (IJ.getApplet() != null) {
            return;
        }
        String host = System.getProperty("http.proxyHost");
        if (host != null) {
            this.proxyhost = host;
        }
        if ((port = System.getProperty("http.proxyPort")) != null && !Double.isNaN(portNumber2 = Tools.parseDouble(port))) {
            this.proxyport = (int)portNumber2;
        }
        if (!this.showDialog()) {
            return;
        }
        if (!this.proxyhost.equals("")) {
            this.props.put("proxySet", "true");
        } else {
            this.props.put("proxySet", "false");
        }
        this.props.put("http.proxyHost", this.proxyhost);
        this.props.put("http.proxyPort", "" + this.proxyport);
        Prefs.set("proxy.server", this.proxyhost);
        Prefs.set("proxy.port", this.proxyport);
        String httpsHost = System.getProperty("https.proxyHost");
        if (httpsHost == null) {
            httpsHost = this.proxyhost;
        }
        int httpsPort = this.proxyport;
        String httpsSystemPort = System.getProperty("https.proxyPort");
        if (httpsSystemPort != null && !Double.isNaN(portNumber = Tools.parseDouble(httpsSystemPort))) {
            httpsPort = (int)portNumber;
        }
        this.props.put("https.proxyHost", httpsHost);
        this.props.put("https.proxyPort", "" + httpsPort);
        try {
            System.setProperty("java.net.useSystemProxies", Prefs.useSystemProxies ? "true" : "false");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (IJ.debugMode) {
            this.logProperties();
        }
    }

    public void logProperties() {
        IJ.log("proxy set: " + System.getProperty("proxySet"));
        IJ.log("http proxy host: " + System.getProperty("http.proxyHost"));
        IJ.log("http proxy port: " + System.getProperty("http.proxyPort"));
        IJ.log("https proxy host: " + System.getProperty("https.proxyHost"));
        IJ.log("https proxy port: " + System.getProperty("https.proxyPort"));
        IJ.log("java.net.useSystemProxies: " + System.getProperty("java.net.useSystemProxies"));
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("Proxy Settings");
        gd.addStringField("Proxy server:", this.proxyhost, 15);
        gd.addNumericField("Port:", this.proxyport, 0);
        gd.addCheckbox("Or, use system proxy settings", Prefs.useSystemProxies);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#proxy");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.proxyhost = gd.getNextString();
        this.proxyport = (int)gd.getNextNumber();
        Prefs.useSystemProxies = gd.getNextBoolean();
        return true;
    }
}

