/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array4D;
import mitiv.array.Byte4D;
import mitiv.array.Double1D;
import mitiv.array.Double3D;
import mitiv.array.DoubleArray;
import mitiv.array.Float4D;
import mitiv.array.Int4D;
import mitiv.array.Long4D;
import mitiv.array.ShapedArray;
import mitiv.array.Short4D;
import mitiv.array.impl.FlatDouble4D;
import mitiv.array.impl.StriddenDouble4D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double4D
extends Array4D
implements DoubleArray {
    protected Double4D(int dim1, int dim2, int dim3, int dim4) {
        super(dim1, dim2, dim3, dim4);
    }

    protected Double4D(int[] dims) {
        super(dims);
    }

    protected Double4D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4);

    public abstract void set(int var1, int var2, int var3, int var4, double var5);

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, value);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, value);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) + value);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) + value);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) - value);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) - value);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) * value);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, this.get(i1, i2, i3, i4) * value);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, function.apply(this.get(i1, i2, i3, i4)));
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, function.apply(this.get(i1, i2, i3, i4)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, generator.nextDouble());
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, generator.nextDouble());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            if (initialized) {
                                scanner.update(this.get(i1, i2, i3, i4));
                                continue;
                            }
                            scanner.initialize(this.get(i1, i2, i3, i4));
                            initialized = true;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            if (initialized) {
                                scanner.update(this.get(i1, i2, i3, i4));
                                continue;
                            }
                            scanner.initialize(this.get(i1, i2, i3, i4));
                            initialized = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double minValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            double value = this.get(i1, i2, i3, i4);
                            if (!(value < minValue)) continue;
                            minValue = value;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            double value = this.get(i1, i2, i3, i4);
                            if (!(value < minValue)) continue;
                            minValue = value;
                        }
                    }
                }
            }
        }
        return minValue;
    }

    @Override
    public double max() {
        double maxValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            double value = this.get(i1, i2, i3, i4);
                            if (!(value > maxValue)) continue;
                            maxValue = value;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            double value = this.get(i1, i2, i3, i4);
                            if (!(value > maxValue)) continue;
                            maxValue = value;
                        }
                    }
                }
            }
        }
        return maxValue;
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double minValue;
        double maxValue = minValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            double value = this.get(i1, i2, i3, i4);
                            if (value < minValue) {
                                minValue = value;
                            }
                            if (!(value > maxValue)) continue;
                            maxValue = value;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            if (skip) {
                                skip = false;
                                continue;
                            }
                            double value = this.get(i1, i2, i3, i4);
                            if (value < minValue) {
                                minValue = value;
                            }
                            if (!(value > maxValue)) continue;
                            maxValue = value;
                        }
                    }
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public double sum() {
        double totalValue = 0.0;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            totalValue += this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            totalValue += this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte4D toByte() {
        byte[] out = new byte[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (byte)inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = (byte)this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Byte4D.wrap(out, this.getShape());
    }

    @Override
    public Short4D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = (short)this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Short4D.wrap(out, this.getShape());
    }

    @Override
    public Int4D toInt() {
        int[] out = new int[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (int)inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = (int)this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Int4D.wrap(out, this.getShape());
    }

    @Override
    public Long4D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (long)inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = (long)this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Long4D.wrap(out, this.getShape());
    }

    @Override
    public Float4D toFloat() {
        float[] out = new float[this.number];
        if (this.isFlat()) {
            double[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (float)inp[i];
            }
        } else {
            int i = -1;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            out[++i] = (float)this.get(i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        return Float4D.wrap(out, this.getShape());
    }

    @Override
    public Double4D toDouble() {
        return this;
    }

    @Override
    public Double4D copy() {
        return new FlatDouble4D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double4D src = arr.getType() == 5 ? (Double4D)arr : (Double4D)arr.toDouble();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            this.set(i1, i2, i3, i4, src.get(i1, i2, i3, i4));
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, src.get(i1, i2, i3, i4));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, src.get(++i));
                        }
                    }
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i4 = 0; i4 < this.dim4; ++i4) {
                for (int i3 = 0; i3 < this.dim3; ++i3) {
                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                            this.set(i1, i2, i3, i4, src.get(++i));
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double4D create() {
        return new FlatDouble4D(this.getShape());
    }

    public static Double4D create(int dim1, int dim2, int dim3, int dim4) {
        return new FlatDouble4D(dim1, dim2, dim3, dim4);
    }

    public static Double4D create(int[] dims) {
        return new FlatDouble4D(dims);
    }

    public static Double4D create(Shape shape) {
        return new FlatDouble4D(shape);
    }

    public static Double4D wrap(double[] data, int dim1, int dim2, int dim3, int dim4) {
        return new FlatDouble4D(data, dim1, dim2, dim3, dim4);
    }

    public static Double4D wrap(double[] data, int[] dims) {
        return new FlatDouble4D(data, dims);
    }

    public static Double4D wrap(double[] data, Shape shape) {
        return new FlatDouble4D(data, shape);
    }

    public static Double4D wrap(double[] data, int offset, int stride1, int stride2, int stride3, int stride4, int dim1, int dim2, int dim3, int dim4) {
        return new StriddenDouble4D(data, offset, stride1, stride2, stride3, stride4, dim1, dim2, dim3, dim4);
    }

    @Override
    public abstract Double3D slice(int var1);

    @Override
    public abstract Double3D slice(int var1, int var2);

    @Override
    public abstract Double4D view(Range var1, Range var2, Range var3, Range var4);

    @Override
    public abstract Double4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Double1D as1D();
}

