/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.BoundProjector;
import mitiv.optim.LBFGSOperator;
import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.QuasiNewton;

public class VMLMB
extends QuasiNewton {
    private LBFGSOperator H = null;
    protected double pnorm;
    private final boolean saveMemory = true;
    protected Vector x0 = null;
    protected double f0 = 0.0;
    protected Vector g0 = null;
    protected Vector tmp = null;
    protected Vector p = null;
    protected double alpha;
    protected double dg0 = 0.0;
    protected double gnorm = 0.0;
    protected double g0norm = 0.0;
    protected final BoundProjector projector;

    public VMLMB(VectorSpace vsp, BoundProjector bp, int m, LineSearch ls) {
        this(new LBFGSOperator(vsp, m), bp, ls);
    }

    public VMLMB(LinearEndomorphism H0, BoundProjector bp, int m, LineSearch ls) {
        this(new LBFGSOperator(H0, m), bp, ls);
    }

    private VMLMB(LBFGSOperator H, BoundProjector bp, LineSearch ls) {
        super(H.getSpace(), ls);
        this.H = H;
        this.projector = bp;
        this.p = H.getSpace().create();
        this.getClass();
        this.lnsrch = ls;
    }

    @Override
    public OptimTask start() {
        this.evaluations = 0;
        this.iterations = 0;
        this.restarts = 0;
        return this.begin();
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.begin();
    }

    private OptimTask begin() {
        this.H.reset();
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector x, double f, Vector g) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                double gtest;
                if (this.projector != null) {
                    this.projector.projectDirection(x, g, true, g);
                }
                ++this.evaluations;
                if (this.evaluations > 1) {
                    LineSearchTask lnsrchTask = this.lnsrch.iterate(f, -this.p.dot(g));
                    if (lnsrchTask == LineSearchTask.SEARCH) {
                        return this.nextStep(x);
                    }
                    if (lnsrchTask != LineSearchTask.CONVERGENCE) {
                        OptimStatus lnsrchStatus = this.lnsrch.getStatus();
                        if (lnsrchTask != LineSearchTask.WARNING || lnsrchStatus != OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS) {
                            return this.failure(lnsrchStatus);
                        }
                    }
                    ++this.iterations;
                }
                this.gnorm = g.norm2();
                if (this.evaluations == 1) {
                    this.ginit = this.gnorm;
                }
                return this.success(this.gnorm <= (gtest = this.getGradientThreshold(this.ginit)) ? OptimTask.FINAL_X : OptimTask.NEW_X);
            }
            case NEW_X: {
                if (this.evaluations > 1) {
                    this.H.update(x, this.x0, g, this.g0);
                }
            }
            case FINAL_X: {
                double amax;
                double amin;
                double pg;
                while (true) {
                    this.H.apply(this.p, g);
                    this.pnorm = this.p.norm2();
                    pg = this.p.dot(g);
                    if (pg >= this.epsilon * this.pnorm * this.gnorm) break;
                    if (this.H.mp < 1) {
                        return this.failure(OptimStatus.BAD_PRECONDITIONER);
                    }
                    this.H.reset();
                    ++this.restarts;
                }
                this.dg0 = -pg;
                this.x0 = this.H.s(0);
                this.g0 = this.H.y(0);
                if (this.H.mp == this.H.m) {
                    --this.H.mp;
                }
                this.x0.copy(x);
                this.g0.copy(g);
                this.g0norm = this.gnorm;
                this.f0 = f;
                this.alpha = this.H.mp >= 1 || this.H.rule == 0 ? 1.0 : this.initialStep(this.x0, this.p);
                x.combine(1.0, this.x0, -this.alpha, this.p);
                if (this.projector == null) {
                    amin = this.stpmin * this.alpha;
                    amax = this.stpmax * this.alpha;
                } else {
                    if (this.tmp == null) {
                        this.tmp = x.getOwner().create();
                    }
                    while (true) {
                        this.projector.projectVariables(x, x);
                        this.tmp.combine(1.0, this.x0, -1.0, x);
                        this.dg0 = -this.tmp.dot(this.g0);
                        if (this.dg0 < 0.0) break;
                        if (this.dg0 == 0.0 && this.H.mp < 1) {
                            return this.success(OptimTask.FINAL_X);
                        }
                        if (this.H.mp >= 1) {
                            this.H.reset();
                            ++this.restarts;
                            this.H.apply(this.p, g);
                            this.pnorm = this.p.norm2();
                            this.alpha = this.initialStep(this.x0, this.p);
                        } else {
                            this.alpha *= 0.5;
                        }
                        x.combine(1.0, this.x0, -this.alpha, this.p);
                    }
                    this.p.copy(this.tmp);
                    this.alpha = 1.0;
                    amin = this.stpmin;
                    amax = 1.0;
                }
                LineSearchTask lnsrchTask = this.lnsrch.start(this.f0, this.dg0, this.alpha, amin, amax);
                if (lnsrchTask != LineSearchTask.SEARCH) {
                    return this.failure(this.lnsrch.getStatus());
                }
                return this.success(OptimTask.COMPUTE_FG);
            }
        }
        return this.getTask();
    }

    protected double initialStep(Vector x, Vector d) {
        double xnorm;
        double dnorm = d.norm2();
        if (0.0 < this.delta && this.delta < 1.0 && (xnorm = x.norm2()) > 0.0) {
            return xnorm / dnorm * this.delta;
        }
        return 1.0 / dnorm;
    }

    private OptimTask nextStep(Vector x) {
        this.alpha = this.lnsrch.getStep();
        x.combine(1.0, this.x0, -this.alpha, this.p);
        if (this.projector != null) {
            this.projector.projectVariables(x, x);
        }
        return this.success(OptimTask.COMPUTE_FG);
    }
}

