/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.component.IcyTextField;
import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.network.NetworkUtil;
import icy.preferences.NetworkPreferences;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NetworkPreferencePanel
extends PreferencePanel
implements ActionListener,
IcyTextField.TextChangeListener,
ChangeListener,
DocumentListener {
    private static final long serialVersionUID = -2311019090865779672L;
    public static final String NODE_NAME = "Network";
    private JComboBox proxySettingComboBox;
    private IcyTextField httpHostField;
    private JSpinner httpPortField;
    private IcyTextField httpsHostField;
    private IcyTextField ftpHostField;
    private JSpinner httpsPortField;
    private JSpinner ftpPortField;
    private IcyTextField socksHostField;
    private JSpinner socksPortField;
    private JCheckBox useAuthenticationChkBox;
    private JLabel lblLogin;
    private JLabel lblPassword;
    private IcyTextField userField;
    private JPasswordField passwordField;

    public NetworkPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Preferences");
        this.initialize();
        this.validate();
        this.load();
        this.updateComponentsState();
        this.proxySettingComboBox.addActionListener(this);
        this.httpHostField.addTextChangeListener(this);
        this.httpPortField.addChangeListener(this);
        this.httpsHostField.addTextChangeListener(this);
        this.httpsPortField.addChangeListener(this);
        this.ftpHostField.addTextChangeListener(this);
        this.ftpPortField.addChangeListener(this);
        this.socksHostField.addTextChangeListener(this);
        this.socksPortField.addChangeListener(this);
        this.userField.addTextChangeListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
        this.useAuthenticationChkBox.addActionListener(this);
    }

    void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[5];
        nArray[0] = 69;
        nArray[1] = 239;
        nArray[2] = 97;
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = new int[10];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gridBagLayout);
        JLabel lblProxy = new JLabel("Proxy");
        GridBagConstraints gbc_lblProxy = new GridBagConstraints();
        gbc_lblProxy.anchor = 13;
        gbc_lblProxy.insets = new Insets(0, 0, 5, 5);
        gbc_lblProxy.gridx = 0;
        gbc_lblProxy.gridy = 0;
        this.mainPanel.add((Component)lblProxy, gbc_lblProxy);
        this.proxySettingComboBox = new JComboBox();
        this.proxySettingComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"No proxy", "System proxy", "Manual proxy"}));
        this.proxySettingComboBox.setToolTipText("Proxy setting");
        GridBagConstraints gbc_proxySettingComboBox = new GridBagConstraints();
        gbc_proxySettingComboBox.insets = new Insets(0, 0, 5, 5);
        gbc_proxySettingComboBox.fill = 2;
        gbc_proxySettingComboBox.gridx = 1;
        gbc_proxySettingComboBox.gridy = 0;
        this.mainPanel.add((Component)this.proxySettingComboBox, gbc_proxySettingComboBox);
        JLabel lblNewLabel = new JLabel("HTTP");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 13;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 1;
        this.mainPanel.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.httpHostField = new IcyTextField();
        this.httpHostField.setToolTipText("HTTP proxy host");
        GridBagConstraints gbc_httpHostField = new GridBagConstraints();
        gbc_httpHostField.insets = new Insets(0, 0, 5, 5);
        gbc_httpHostField.fill = 2;
        gbc_httpHostField.gridx = 1;
        gbc_httpHostField.gridy = 1;
        this.mainPanel.add((Component)this.httpHostField, gbc_httpHostField);
        this.httpHostField.setColumns(10);
        this.httpPortField = new JSpinner();
        this.httpPortField.setModel(new SpinnerNumberModel(80, 0, 65535, 1));
        this.httpPortField.setToolTipText("HTTPS proxy port");
        GridBagConstraints gbc_httpPortField = new GridBagConstraints();
        gbc_httpPortField.fill = 2;
        gbc_httpPortField.insets = new Insets(0, 0, 5, 5);
        gbc_httpPortField.gridx = 2;
        gbc_httpPortField.gridy = 1;
        this.mainPanel.add((Component)this.httpPortField, gbc_httpPortField);
        JLabel lblNewLabel_1 = new JLabel("HTTPS");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 13;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 2;
        this.mainPanel.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        this.httpsHostField = new IcyTextField();
        this.httpsHostField.setToolTipText("HTTPS proxy host");
        GridBagConstraints gbc_httpsHostField = new GridBagConstraints();
        gbc_httpsHostField.insets = new Insets(0, 0, 5, 5);
        gbc_httpsHostField.fill = 2;
        gbc_httpsHostField.gridx = 1;
        gbc_httpsHostField.gridy = 2;
        this.mainPanel.add((Component)this.httpsHostField, gbc_httpsHostField);
        this.httpsHostField.setColumns(10);
        this.httpsPortField = new JSpinner();
        this.httpsPortField.setModel(new SpinnerNumberModel(443, 0, 65535, 1));
        this.httpsPortField.setToolTipText("HTTPS proxy port");
        GridBagConstraints gbc_httpsPortField = new GridBagConstraints();
        gbc_httpsPortField.insets = new Insets(0, 0, 5, 5);
        gbc_httpsPortField.fill = 2;
        gbc_httpsPortField.gridx = 2;
        gbc_httpsPortField.gridy = 2;
        this.mainPanel.add((Component)this.httpsPortField, gbc_httpsPortField);
        JLabel lblNewLabel_2 = new JLabel("FTP");
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.anchor = 13;
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_2.gridx = 0;
        gbc_lblNewLabel_2.gridy = 3;
        this.mainPanel.add((Component)lblNewLabel_2, gbc_lblNewLabel_2);
        this.ftpHostField = new IcyTextField();
        this.ftpHostField.setToolTipText("FTP proxy host");
        GridBagConstraints gbc_ftpHostField = new GridBagConstraints();
        gbc_ftpHostField.insets = new Insets(0, 0, 5, 5);
        gbc_ftpHostField.fill = 2;
        gbc_ftpHostField.gridx = 1;
        gbc_ftpHostField.gridy = 3;
        this.mainPanel.add((Component)this.ftpHostField, gbc_ftpHostField);
        this.ftpHostField.setColumns(10);
        this.ftpPortField = new JSpinner();
        this.ftpPortField.setModel(new SpinnerNumberModel(21, 0, 65535, 1));
        this.ftpPortField.setToolTipText("FTP proxy port");
        GridBagConstraints gbc_ftpPortField = new GridBagConstraints();
        gbc_ftpPortField.insets = new Insets(0, 0, 5, 5);
        gbc_ftpPortField.fill = 2;
        gbc_ftpPortField.gridx = 2;
        gbc_ftpPortField.gridy = 3;
        this.mainPanel.add((Component)this.ftpPortField, gbc_ftpPortField);
        JLabel lblNewLabel_3 = new JLabel("SOCKS");
        GridBagConstraints gbc_lblNewLabel_3 = new GridBagConstraints();
        gbc_lblNewLabel_3.anchor = 13;
        gbc_lblNewLabel_3.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_3.gridx = 0;
        gbc_lblNewLabel_3.gridy = 4;
        this.mainPanel.add((Component)lblNewLabel_3, gbc_lblNewLabel_3);
        this.socksHostField = new IcyTextField();
        this.socksHostField.setToolTipText("SOCKS host");
        GridBagConstraints gbc_socksHostField = new GridBagConstraints();
        gbc_socksHostField.insets = new Insets(0, 0, 5, 5);
        gbc_socksHostField.fill = 2;
        gbc_socksHostField.gridx = 1;
        gbc_socksHostField.gridy = 4;
        this.mainPanel.add((Component)this.socksHostField, gbc_socksHostField);
        this.socksHostField.setColumns(10);
        this.socksPortField = new JSpinner();
        this.socksPortField.setModel(new SpinnerNumberModel(1080, 0, 65535, 1));
        this.socksPortField.setToolTipText("SOCKS port");
        GridBagConstraints gbc_socksPortField = new GridBagConstraints();
        gbc_socksPortField.insets = new Insets(0, 0, 5, 5);
        gbc_socksPortField.fill = 2;
        gbc_socksPortField.gridx = 2;
        gbc_socksPortField.gridy = 4;
        this.mainPanel.add((Component)this.socksPortField, gbc_socksPortField);
        this.useAuthenticationChkBox = new JCheckBox("Use authentication");
        GridBagConstraints gbc_chckbxUseAuthentication = new GridBagConstraints();
        gbc_chckbxUseAuthentication.anchor = 17;
        gbc_chckbxUseAuthentication.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxUseAuthentication.gridx = 1;
        gbc_chckbxUseAuthentication.gridy = 5;
        this.mainPanel.add((Component)this.useAuthenticationChkBox, gbc_chckbxUseAuthentication);
        this.lblLogin = new JLabel("User");
        GridBagConstraints gbc_lblLogin = new GridBagConstraints();
        gbc_lblLogin.anchor = 13;
        gbc_lblLogin.insets = new Insets(0, 0, 5, 5);
        gbc_lblLogin.gridx = 0;
        gbc_lblLogin.gridy = 6;
        this.mainPanel.add((Component)this.lblLogin, gbc_lblLogin);
        this.userField = new IcyTextField();
        GridBagConstraints gbc_userField = new GridBagConstraints();
        gbc_userField.insets = new Insets(0, 0, 5, 5);
        gbc_userField.fill = 2;
        gbc_userField.gridx = 1;
        gbc_userField.gridy = 6;
        this.mainPanel.add((Component)this.userField, gbc_userField);
        this.userField.setColumns(10);
        this.lblPassword = new JLabel("Password");
        GridBagConstraints gbc_lblPassword = new GridBagConstraints();
        gbc_lblPassword.anchor = 13;
        gbc_lblPassword.insets = new Insets(0, 0, 5, 5);
        gbc_lblPassword.gridx = 0;
        gbc_lblPassword.gridy = 7;
        this.mainPanel.add((Component)this.lblPassword, gbc_lblPassword);
        this.passwordField = new JPasswordField();
        GridBagConstraints gbc_passwordField = new GridBagConstraints();
        gbc_passwordField.insets = new Insets(0, 0, 5, 5);
        gbc_passwordField.fill = 2;
        gbc_passwordField.gridx = 1;
        gbc_passwordField.gridy = 7;
        this.mainPanel.add((Component)this.passwordField, gbc_passwordField);
    }

    private void updateComponentsState() {
        boolean enabled = this.proxySettingComboBox.getSelectedIndex() == 2;
        this.httpHostField.setEnabled(enabled);
        this.httpPortField.setEnabled(enabled);
        this.httpsHostField.setEnabled(enabled);
        this.httpsPortField.setEnabled(enabled);
        this.ftpHostField.setEnabled(enabled);
        this.ftpPortField.setEnabled(enabled);
        this.socksHostField.setEnabled(enabled);
        this.socksPortField.setEnabled(enabled);
        this.useAuthenticationChkBox.setEnabled(enabled);
        boolean authEnabled = enabled && this.useAuthenticationChkBox.isSelected();
        this.userField.setEnabled(authEnabled);
        this.passwordField.setEnabled(authEnabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.proxySettingComboBox || source == this.useAuthenticationChkBox) {
            this.updateComponentsState();
        }
        this.getPreferenceFrame().setNeedRestart();
    }

    @Override
    public void textChanged(IcyTextField source, boolean validate) {
        if (validate) {
            this.getPreferenceFrame().setNeedRestart();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.getPreferenceFrame().setNeedRestart();
    }

    @Override
    protected void load() {
        this.proxySettingComboBox.setSelectedIndex(NetworkPreferences.getProxySetting());
        this.httpHostField.setText(NetworkPreferences.getProxyHTTPHost());
        this.httpPortField.setValue(NetworkPreferences.getProxyHTTPPort());
        this.httpsHostField.setText(NetworkPreferences.getProxyHTTPSHost());
        this.httpsPortField.setValue(NetworkPreferences.getProxyHTTPSPort());
        this.ftpHostField.setText(NetworkPreferences.getProxyFTPHost());
        this.ftpPortField.setValue(NetworkPreferences.getProxyFTPPort());
        this.socksHostField.setText(NetworkPreferences.getProxySOCKSHost());
        this.socksPortField.setValue(NetworkPreferences.getProxySOCKSPort());
        this.useAuthenticationChkBox.setSelected(NetworkPreferences.getProxyAuthentication());
        this.userField.setText(NetworkPreferences.getProxyUser());
        this.passwordField.setText(NetworkPreferences.getProxyPassword());
    }

    @Override
    protected void save() {
        NetworkPreferences.setProxySetting(this.proxySettingComboBox.getSelectedIndex());
        NetworkPreferences.setProxyHTTPHost(this.httpHostField.getText());
        NetworkPreferences.setProxyHTTPPort((Integer)this.httpPortField.getValue());
        NetworkPreferences.setProxyHTTPSHost(this.httpsHostField.getText());
        NetworkPreferences.setProxyHTTPSPort((Integer)this.httpsPortField.getValue());
        NetworkPreferences.setProxyFTPHost(this.ftpHostField.getText());
        NetworkPreferences.setProxyFTPPort((Integer)this.ftpPortField.getValue());
        NetworkPreferences.setProxySOCKSHost(this.socksHostField.getText());
        NetworkPreferences.setProxySOCKSPort((Integer)this.socksPortField.getValue());
        NetworkPreferences.setProxyAuthentication(this.useAuthenticationChkBox.isSelected());
        NetworkPreferences.setProxyUser(this.userField.getText());
        NetworkPreferences.setProxyPassword(new String(this.passwordField.getPassword()));
        NetworkUtil.updateNetworkSetting();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.getPreferenceFrame().setNeedRestart();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.getPreferenceFrame().setNeedRestart();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.getPreferenceFrame().setNeedRestart();
    }
}

