/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin.classloader;

import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.plugin.classloader.Configuration;
import icy.plugin.classloader.exception.JclException;
import icy.system.IcyExceptionHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarResources {
    protected Map<String, byte[]> entryContents = new HashMap<String, byte[]>();
    protected Map<String, URL> entryUrls = new HashMap<String, URL>();
    protected boolean collisionAllowed = Configuration.suppressCollisionException();
    protected int loadedSize = 0;
    private static Logger logger = Logger.getLogger(JarResources.class.getName());

    public URL getResource(String name) {
        return this.entryUrls.get(name);
    }

    public byte[] getResourceContent(String name) throws IOException {
        URL url;
        byte[] content = this.entryContents.get(name);
        if (content == null && (url = this.entryUrls.get(name)) != null) {
            this.loadContent(name, url);
            content = this.entryContents.get(name);
        }
        return content;
    }

    protected void loadContent(String name, URL url) throws IOException {
        byte[] content = this.loadJarContent(url);
        this.setResourceContent(name, content);
    }

    public Set<String> getResourcesName() {
        return Collections.unmodifiableSet(this.entryUrls.keySet());
    }

    public Map<String, URL> getResources() {
        return Collections.unmodifiableMap(this.entryUrls);
    }

    public Map<String, byte[]> getLoadedResources() {
        return Collections.unmodifiableMap(this.entryContents);
    }

    public void loadJar(File file) throws IOException {
        String filePath = file.getAbsolutePath();
        String urlPrefix = "jar:" + file.toURI().toString() + "!/";
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Loading jar: " + filePath);
        }
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || (name = entry.getName()).equals("META-INF/MANIFEST.MF")) continue;
                if (this.entryUrls.containsKey(name)) {
                    if (!this.collisionAllowed) {
                        throw new JclException("Class/Resource " + name + " already loaded");
                    }
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.finest("Class/Resource " + name + " already loaded; ignoring entry...");
                    continue;
                }
                this.entryUrls.put(name, new URL(String.valueOf(urlPrefix) + name));
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                System.err.println("JarResources.loadJar(" + filePath + ") error:");
                IcyExceptionHandler.showErrorMessage(e, false, true);
            }
        }
    }

    public void loadJar(URL url) throws IOException {
        if (URLUtil.isFileURL(url)) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(url.getPath());
            }
            this.loadJar(f);
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Loading jar: " + url.toString());
        }
        String urlPrefix = "jar:" + url.toString() + "!/";
        BufferedInputStream bis = null;
        ZipInputStream zis = null;
        try {
            InputStream in = url.openStream();
            bis = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
            zis = new ZipInputStream(bis);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String name;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.dump(entry));
                }
                if (entry.isDirectory() || (name = entry.getName()).equals("META-INF/MANIFEST.MF")) continue;
                if (this.entryUrls.containsKey(name)) {
                    if (!this.collisionAllowed) {
                        throw new JclException("Class/Resource " + name + " already loaded");
                    }
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.finest("Class/Resource " + name + " already loaded; ignoring entry...");
                    continue;
                }
                this.entryUrls.put(name, new URL(String.valueOf(urlPrefix) + name));
            }
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    System.err.println("JarResources.loadJar(" + url + ") error:");
                    IcyExceptionHandler.showErrorMessage(e, false, true);
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    System.err.println("JarResources.loadJar(" + url + ") error:");
                    IcyExceptionHandler.showErrorMessage(e, false, true);
                }
            }
        }
    }

    protected byte[] loadJarContent(URL url) throws IOException {
        JarURLConnection uc = (JarURLConnection)url.openConnection();
        JarEntry jarEntry = uc.getJarEntry();
        if (jarEntry != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.dump(jarEntry));
            }
            return NetworkUtil.download(uc.getInputStream(), jarEntry.getSize(), null);
        }
        throw new IOException("JarResources.loadJarContent(" + url.toString() + ") error:\nEntry not found !");
    }

    protected void setResourceContent(String name, byte[] content) {
        if (this.entryContents.containsKey(name)) {
            if (!this.collisionAllowed) {
                throw new JclException("Class/Resource " + name + " already loaded");
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Class/Resource " + name + " already loaded; ignoring entry...");
            }
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Entry Name: " + name + ", " + "Entry Size: " + content.length);
        }
        this.entryContents.put(name, content);
    }

    private String dump(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("deflated ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }
}

