/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology.skeletonization;

import icy.image.IcyBufferedImage;
import icy.image.ImageDataIterator;
import icy.sequence.Sequence;
import icy.sequence.SequenceCursor;
import icy.sequence.SequenceDataIterator;
import icy.type.DataType;
import icy.type.dimension.Dimension3D;
import icy.type.point.Point3D;
import java.util.PriorityQueue;

public class MinimumSpanningTreeCalculator {
    private Sequence distanceMap;
    private Dimension3D pixelSize;
    private Sequence tree;
    private Sequence costs;
    private Sequence visited;
    private Point3D seedPoint;
    private PriorityQueue<CostElement> queue;
    private double[] directionalCosts;
    private SequenceCursor visitedCursor;
    private SequenceCursor costsCursor;
    private SequenceCursor treeCursor;
    private SequenceCursor distanceMapCursor;

    public MinimumSpanningTreeCalculator(Sequence distanceMap, Dimension3D pixelSize) {
        this.distanceMap = distanceMap;
        this.pixelSize = pixelSize;
    }

    public Sequence getTree() throws InterruptedException {
        if (this.tree == null) {
            this.compute();
        }
        return this.tree;
    }

    public Sequence getCosts() throws InterruptedException {
        if (this.costs == null) {
            this.compute();
        }
        return this.costs;
    }

    public Sequence getVisitedPixels() throws InterruptedException {
        if (this.visited == null) {
            this.compute();
        }
        return this.visited;
    }

    public void compute() throws InterruptedException {
        this.seedPoint = this.findSeed();
        if (this.seedPoint != null) {
            this.initializeResult();
            this.initializePriorityQueue();
            this.queue.add(new CostElement(0.0, this.seedPoint));
            this.setCost(this.seedPoint, 0.0);
            this.setTreeParent(this.seedPoint, this.seedPoint);
            while (!this.queue.isEmpty()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                CostElement currentElement = this.queue.poll();
                this.visitPosition(currentElement.getPosition());
                this.checkNeighbors(currentElement);
            }
            this.commitChanges();
        }
    }

    private Point3D findSeed() {
        Point3D.Double seedPoint = new Point3D.Double(-1.0, -1.0, -1.0);
        double maxValue = Double.NEGATIVE_INFINITY;
        SequenceDataIterator it = new SequenceDataIterator(this.distanceMap);
        while (!it.done()) {
            if (it.get() > maxValue) {
                seedPoint.setLocation(it.getPositionX(), it.getPositionY(), it.getPositionZ());
                maxValue = it.get();
            }
            it.next();
        }
        if (maxValue <= 0.0) {
            seedPoint = null;
        }
        return seedPoint;
    }

    private void initializeResult() {
        this.tree = new Sequence("MinimumSpanningTree");
        this.costs = new Sequence("Costs");
        this.visited = new Sequence("Visited");
        int z = 0;
        while (z < this.distanceMap.getSizeZ()) {
            IcyBufferedImage treeImage = new IcyBufferedImage(this.distanceMap.getSizeX(), this.distanceMap.getSizeY(), 3, DataType.INT);
            this.fillImage(treeImage, 0, -1.0);
            this.fillImage(treeImage, 1, -1.0);
            this.fillImage(treeImage, 2, -1.0);
            this.tree.addImage(treeImage);
            IcyBufferedImage costImage = new IcyBufferedImage(this.distanceMap.getSizeX(), this.distanceMap.getSizeY(), 1, DataType.DOUBLE);
            this.fillImage(costImage, 0, Double.POSITIVE_INFINITY);
            this.costs.addImage(costImage);
            IcyBufferedImage visitedImage = new IcyBufferedImage(this.distanceMap.getSizeX(), this.distanceMap.getSizeY(), 1, DataType.BYTE);
            this.visited.addImage(visitedImage);
            ++z;
        }
        this.directionalCosts = new double[27];
        int k = -1;
        while (k < 2) {
            double kSq = (double)k * this.pixelSize.getSizeZ();
            kSq *= kSq;
            int j = -1;
            while (j < 2) {
                double jSq = (double)j * this.pixelSize.getSizeY();
                jSq *= jSq;
                int i = -1;
                while (i < 2) {
                    if (i != 0 || j != 0 || k != 0) {
                        double iSq = (double)i * this.pixelSize.getSizeX();
                        iSq *= iSq;
                        this.directionalCosts[(k + 1) * 9 + (j + 1) * 3 + (i + 1)] = Math.sqrt(kSq + jSq + iSq);
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    private void fillImage(IcyBufferedImage image, int channel, double value) {
        ImageDataIterator it = new ImageDataIterator(image, channel);
        while (!it.done()) {
            it.set(value);
            it.next();
        }
        it.flush();
    }

    private void initializePriorityQueue() {
        this.queue = new PriorityQueue();
    }

    private void visitPosition(Point3D position) {
        this.getVisitedCursor().set((int)position.getX(), (int)position.getY(), (int)position.getZ(), 0, 0, 1.0);
    }

    private void checkNeighbors(CostElement currentElement) {
        Point3D.Double candidatePosition = new Point3D.Double();
        int k = -1;
        while (k < 2) {
            int z = (int)currentElement.getPosition().getZ() + k;
            if (z >= 0 && z < this.tree.getSizeZ()) {
                int j = -1;
                while (j < 2) {
                    int y = (int)currentElement.getPosition().getY() + j;
                    if (y >= 0 && y < this.tree.getSizeY()) {
                        int i = -1;
                        while (i < 2) {
                            int x;
                            if ((k != 0 || j != 0 || i != 0) && (x = (int)currentElement.getPosition().getX() + i) >= 0 && x < this.tree.getSizeX()) {
                                double candidateCost;
                                candidatePosition.setLocation(currentElement.getPosition().getX() + (double)i, currentElement.getPosition().getY() + (double)j, currentElement.getPosition().getZ() + (double)k);
                                if (!this.isPositionVisited(candidatePosition) && (candidateCost = currentElement.getCost() + this.getInvSqDistance(candidatePosition) * this.getDirectionalCost(i, j, k)) < this.getCost(candidatePosition)) {
                                    this.setCost(candidatePosition, candidateCost);
                                    this.setTreeParent(candidatePosition, currentElement.getPosition());
                                    CostElement candidateElement = new CostElement(candidateCost, (Point3D)candidatePosition.clone());
                                    this.queue.add(candidateElement);
                                }
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
            }
            ++k;
        }
    }

    private boolean isPositionVisited(Point3D position) {
        return this.getVisitedCursor().get((int)position.getX(), (int)position.getY(), (int)position.getZ(), 0, 0) != 0.0;
    }

    private SequenceCursor getVisitedCursor() {
        if (this.visitedCursor == null) {
            this.visitedCursor = new SequenceCursor(this.visited);
        }
        return this.visitedCursor;
    }

    private double getDirectionalCost(int i, int j, int k) {
        return this.directionalCosts[i + 1 + (j + 1) * 3 + (k + 1) * 9];
    }

    private void setCost(Point3D position, double value) {
        this.getCostsCursor().set((int)position.getX(), (int)position.getY(), (int)position.getZ(), 0, 0, value);
    }

    private SequenceCursor getCostsCursor() {
        if (this.costsCursor == null) {
            this.costsCursor = new SequenceCursor(this.costs);
        }
        return this.costsCursor;
    }

    private void setTreeParent(Point3D position, Point3D parent) {
        this.getTreeCursor().set((int)position.getX(), (int)position.getY(), (int)position.getZ(), 0, 0, parent.getX());
        this.getTreeCursor().set((int)position.getX(), (int)position.getY(), (int)position.getZ(), 0, 1, parent.getY());
        this.getTreeCursor().set((int)position.getX(), (int)position.getY(), (int)position.getZ(), 0, 2, parent.getZ());
    }

    private SequenceCursor getTreeCursor() {
        if (this.treeCursor == null) {
            this.treeCursor = new SequenceCursor(this.tree);
        }
        return this.treeCursor;
    }

    private double getInvSqDistance(Point3D position) {
        return this.getInvSquared(this.getDistanceMapCursor().get((int)position.getX(), (int)position.getY(), (int)position.getZ(), 0, 0));
    }

    private double getInvSquared(double distance) {
        return distance <= 0.0 ? Double.POSITIVE_INFINITY : 1.0 / (distance * distance);
    }

    private SequenceCursor getDistanceMapCursor() {
        if (this.distanceMapCursor == null) {
            this.distanceMapCursor = new SequenceCursor(this.distanceMap);
        }
        return this.distanceMapCursor;
    }

    private double getCost(Point3D position) {
        return this.getCostsCursor().get((int)position.getX(), (int)position.getY(), (int)position.getZ(), 0, 0);
    }

    private void commitChanges() {
        this.getCostsCursor().commitChanges();
        this.getTreeCursor().commitChanges();
        this.getVisitedCursor().commitChanges();
    }

    private static class CostElement
    implements Comparable<CostElement> {
        private final double cost;
        private final Point3D position;

        public CostElement(double cost, Point3D position) {
            this.cost = cost;
            this.position = position;
        }

        public double getCost() {
            return this.cost;
        }

        public Point3D getPosition() {
            return this.position;
        }

        @Override
        public int compareTo(CostElement o) {
            if (this.cost < o.cost) {
                return -1;
            }
            if (this.cost > o.cost) {
                return 1;
            }
            return 0;
        }
    }
}

