/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.Future;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class FloatFFT_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private FloatFFT_1D fftColumns;
    private FloatFFT_1D fftRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_2D(long l, long l2) {
        if (l <= 1L || l2 <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)l;
        this.columns = (int)l2;
        this.rowsl = l;
        this.columnsl = l2;
        if (l * l2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2)) {
            this.isPowerOfTwo = true;
        }
        long l3 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(l, l2));
        }
        this.fftRows = new FloatFFT_1D(l);
        this.fftColumns = l == l2 ? this.fftRows : new FloatFFT_1D(l2);
        ConcurrencyUtils.setLargeArraysBeginN(l3);
    }

    public void complexForward(final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, fArray, true);
                this.cdft2d_subth(-1, fArray, true);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(fArray, i * this.columns);
                }
                this.cdft2d_sub(-1, fArray, true);
            }
            this.columns /= 2;
        } else {
            final int n2 = 2 * this.columns;
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray, i * n2);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.columns / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.columns : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_2D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n;
                                int n22;
                                int n32;
                                int n42 = 2 * i;
                                for (n32 = 0; n32 < FloatFFT_2D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n = n32 * n2 + n42;
                                    fArray2[n22] = fArray[n];
                                    fArray2[n22 + 1] = fArray[n + 1];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(fArray2);
                                for (n32 = 0; n32 < FloatFFT_2D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n = n32 * n2 + n42;
                                    fArray[n] = fArray2[n22];
                                    fArray[n + 1] = fArray2[n22 + 1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(fArray, i * n2);
                }
                float[] fArray2 = new float[2 * this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n7;
                    int n8;
                    int n9;
                    int n10 = 2 * i;
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        n8 = 2 * n9;
                        n7 = n9 * n2 + n10;
                        fArray2[n8] = fArray[n7];
                        fArray2[n8 + 1] = fArray[n7 + 1];
                    }
                    this.fftRows.complexForward(fArray2);
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        n8 = 2 * n9;
                        n7 = n9 * n2 + n10;
                        fArray[n7] = fArray2[n8];
                        fArray[n7 + 1] = fArray2[n8 + 1];
                    }
                }
            }
        }
    }

    public void complexForward(final FloatLargeArray floatLargeArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columnsl = 2L * this.columnsl;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0L, -1, floatLargeArray, true);
                this.cdft2d_subth(-1, floatLargeArray, true);
            } else {
                int n2 = 0;
                while ((long)n2 < this.rowsl) {
                    this.fftColumns.complexForward(floatLargeArray, (long)n2 * this.columnsl);
                    ++n2;
                }
                this.cdft2d_sub(-1, floatLargeArray, true);
            }
            this.columnsl /= 2L;
        } else {
            final long l = 2L * this.columnsl;
            if (n > 1 && this.useThreads && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l2;
                long l3;
                int n3;
                Future[] futureArray = new Future[n];
                long l4 = this.rowsl / (long)n;
                for (n3 = 0; n3 < n; ++n3) {
                    l3 = (long)n3 * l4;
                    l2 = n3 == n - 1 ? this.rowsl : l3 + l4;
                    futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l3; i < l2; ++i) {
                                FloatFFT_2D.this.fftColumns.complexForward(floatLargeArray, i * l);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l4 = this.columnsl / (long)n;
                for (n3 = 0; n3 < n; ++n3) {
                    l3 = (long)n3 * l4;
                    l2 = n3 == n - 1 ? this.columnsl : l3 + l4;
                    futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_2D.this.rowsl, false);
                            for (long i = l3; i < l2; ++i) {
                                long l5;
                                long l22;
                                long l32;
                                long l4 = 2L * i;
                                for (l32 = 0L; l32 < FloatFFT_2D.this.rowsl; ++l32) {
                                    l22 = 2L * l32;
                                    l5 = l32 * l + l4;
                                    floatLargeArray2.setDouble(l22, floatLargeArray.getFloat(l5));
                                    floatLargeArray2.setDouble(l22 + 1L, floatLargeArray.getFloat(l5 + 1L));
                                }
                                FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2);
                                for (l32 = 0L; l32 < FloatFFT_2D.this.rowsl; ++l32) {
                                    l22 = 2L * l32;
                                    l5 = l32 * l + l4;
                                    floatLargeArray.setDouble(l5, floatLargeArray2.getFloat(l22));
                                    floatLargeArray.setDouble(l5 + 1L, floatLargeArray2.getFloat(l22 + 1L));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.complexForward(floatLargeArray, i * l);
                }
                FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * this.rowsl, false);
                for (long i = 0L; i < this.columnsl; ++i) {
                    long l5;
                    long l6;
                    long l7;
                    long l8 = 2L * i;
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = 2L * l7;
                        l5 = l7 * l + l8;
                        floatLargeArray2.setDouble(l6, floatLargeArray.getFloat(l5));
                        floatLargeArray2.setDouble(l6 + 1L, floatLargeArray.getFloat(l5 + 1L));
                    }
                    this.fftRows.complexForward(floatLargeArray2);
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = 2L * l7;
                        l5 = l7 * l + l8;
                        floatLargeArray.setDouble(l5, floatLargeArray2.getFloat(l6));
                        floatLargeArray.setDouble(l5 + 1L, floatLargeArray2.getFloat(l6 + 1L));
                    }
                }
            }
        }
    }

    public void complexForward(final float[][] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, fArray, true);
                this.cdft2d_subth(-1, fArray, true);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(fArray[i]);
                }
                this.cdft2d_sub(-1, fArray, true);
            }
            this.columns /= 2;
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            FloatFFT_2D.this.fftColumns.complexForward(fArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            int n22;
                            int n32 = 2 * i;
                            for (n22 = 0; n22 < FloatFFT_2D.this.rows; ++n22) {
                                n = 2 * n22;
                                fArray2[n] = fArray[n22][n32];
                                fArray2[n + 1] = fArray[n22][n32 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(fArray2);
                            for (n22 = 0; n22 < FloatFFT_2D.this.rows; ++n22) {
                                n = 2 * n22;
                                fArray[n22][n32] = fArray2[n];
                                fArray[n22][n32 + 1] = fArray2[n + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.complexForward(fArray[i]);
            }
            float[] fArray2 = new float[2 * this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                int n7;
                int n8 = 2 * i;
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = 2 * n7;
                    fArray2[n6] = fArray[n7][n8];
                    fArray2[n6 + 1] = fArray[n7][n8 + 1];
                }
                this.fftRows.complexForward(fArray2);
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = 2 * n7;
                    fArray[n7][n8] = fArray2[n6];
                    fArray[n7][n8 + 1] = fArray2[n6 + 1];
                }
            }
        }
    }

    public void complexInverse(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, fArray, bl);
                this.cdft2d_subth(1, fArray, bl);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(fArray, i * this.columns, bl);
                }
                this.cdft2d_sub(1, fArray, bl);
            }
            this.columns /= 2;
        } else {
            final int n2 = 2 * this.columns;
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray, i * n2, bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.columns / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.columns : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_2D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n;
                                int n22;
                                int n32;
                                int n42 = 2 * i;
                                for (n32 = 0; n32 < FloatFFT_2D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n = n32 * n2 + n42;
                                    fArray2[n22] = fArray[n];
                                    fArray2[n22 + 1] = fArray[n + 1];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, bl);
                                for (n32 = 0; n32 < FloatFFT_2D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n = n32 * n2 + n42;
                                    fArray[n] = fArray2[n22];
                                    fArray[n + 1] = fArray2[n22 + 1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(fArray, i * n2, bl);
                }
                float[] fArray2 = new float[2 * this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n7;
                    int n8;
                    int n9;
                    int n10 = 2 * i;
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        n8 = 2 * n9;
                        n7 = n9 * n2 + n10;
                        fArray2[n8] = fArray[n7];
                        fArray2[n8 + 1] = fArray[n7 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, bl);
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        n8 = 2 * n9;
                        n7 = n9 * n2 + n10;
                        fArray[n7] = fArray2[n8];
                        fArray[n7 + 1] = fArray2[n8 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final FloatLargeArray floatLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columnsl = 2L * this.columnsl;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0L, 1, floatLargeArray, bl);
                this.cdft2d_subth(1, floatLargeArray, bl);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.complexInverse(floatLargeArray, i * this.columnsl, bl);
                }
                this.cdft2d_sub(1, floatLargeArray, bl);
            }
            this.columnsl /= 2L;
        } else {
            final long l = 2L * this.columnsl;
            if (n > 1 && this.useThreads && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l2;
                long l3;
                int n2;
                Future[] futureArray = new Future[n];
                long l4 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l3 = (long)n2 * l4;
                    l2 = n2 == n - 1 ? this.rowsl : l3 + l4;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l3; i < l2; ++i) {
                                FloatFFT_2D.this.fftColumns.complexInverse(floatLargeArray, i * l, bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l4 = this.columnsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l3 = (long)n2 * l4;
                    l2 = n2 == n - 1 ? this.columnsl : l3 + l4;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * FloatFFT_2D.this.rowsl, false);
                            for (long i = l3; i < l2; ++i) {
                                long l5;
                                long l22;
                                long l32;
                                long l4 = 2L * i;
                                for (l32 = 0L; l32 < FloatFFT_2D.this.rowsl; ++l32) {
                                    l22 = 2L * l32;
                                    l5 = l32 * l + l4;
                                    floatLargeArray2.setDouble(l22, floatLargeArray.getFloat(l5));
                                    floatLargeArray2.setDouble(l22 + 1L, floatLargeArray.getFloat(l5 + 1L));
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, bl);
                                for (l32 = 0L; l32 < FloatFFT_2D.this.rowsl; ++l32) {
                                    l22 = 2L * l32;
                                    l5 = l32 * l + l4;
                                    floatLargeArray.setDouble(l5, floatLargeArray2.getFloat(l22));
                                    floatLargeArray.setDouble(l5 + 1L, floatLargeArray2.getFloat(l22 + 1L));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.complexInverse(floatLargeArray, i * l, bl);
                }
                FloatLargeArray floatLargeArray2 = new FloatLargeArray(2L * this.rowsl, false);
                for (long i = 0L; i < this.columnsl; ++i) {
                    long l5;
                    long l6;
                    long l7;
                    long l8 = 2L * i;
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = 2L * l7;
                        l5 = l7 * l + l8;
                        floatLargeArray2.setDouble(l6, floatLargeArray.getFloat(l5));
                        floatLargeArray2.setDouble(l6 + 1L, floatLargeArray.getFloat(l5 + 1L));
                    }
                    this.fftRows.complexInverse(floatLargeArray2, bl);
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = 2L * l7;
                        l5 = l7 * l + l8;
                        floatLargeArray.setDouble(l5, floatLargeArray2.getFloat(l6));
                        floatLargeArray.setDouble(l5 + 1L, floatLargeArray2.getFloat(l6 + 1L));
                    }
                }
            }
        }
    }

    public void complexInverse(final float[][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, fArray, bl);
                this.cdft2d_subth(1, fArray, bl);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(fArray[i], bl);
                }
                this.cdft2d_sub(1, fArray, bl);
            }
            this.columns /= 2;
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            FloatFFT_2D.this.fftColumns.complexInverse(fArray[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            int n22;
                            int n32 = 2 * i;
                            for (n22 = 0; n22 < FloatFFT_2D.this.rows; ++n22) {
                                n = 2 * n22;
                                fArray2[n] = fArray[n22][n32];
                                fArray2[n + 1] = fArray[n22][n32 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2, bl);
                            for (n22 = 0; n22 < FloatFFT_2D.this.rows; ++n22) {
                                n = 2 * n22;
                                fArray[n22][n32] = fArray2[n];
                                fArray[n22][n32 + 1] = fArray2[n + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.complexInverse(fArray[i], bl);
            }
            float[] fArray2 = new float[2 * this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                int n7;
                int n8 = 2 * i;
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = 2 * n7;
                    fArray2[n6] = fArray[n7][n8];
                    fArray2[n6 + 1] = fArray[n7][n8 + 1];
                }
                this.fftRows.complexInverse(fArray2, bl);
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = 2 * n7;
                    fArray[n7][n8] = fArray2[n6];
                    fArray[n7][n8 + 1] = fArray2[n6 + 1];
                }
            }
        }
    }

    public void realForward(float[] fArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realForward(fArray, i * this.columns);
            }
            this.cdft2d_sub(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        }
    }

    public void realForward(FloatLargeArray floatLargeArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft2d0_subth1(1L, 1, floatLargeArray, true);
            this.cdft2d_subth(-1, floatLargeArray, true);
            this.rdft2d_sub(1, floatLargeArray);
        } else {
            for (long i = 0L; i < this.rowsl; ++i) {
                this.fftColumns.realForward(floatLargeArray, i * this.columnsl);
            }
            this.cdft2d_sub(-1, floatLargeArray, true);
            this.rdft2d_sub(1, floatLargeArray);
        }
    }

    public void realForward(float[][] fArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realForward(fArray[i]);
            }
            this.cdft2d_sub(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        }
    }

    public void realForwardFull(float[] fArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, fArray, true);
                this.cdft2d_subth(-1, fArray, true);
                this.rdft2d_sub(1, fArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realForward(fArray, i * this.columns);
                }
                this.cdft2d_sub(-1, fArray, true);
                this.rdft2d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealForwardFull(fArray);
        }
    }

    public void realForwardFull(FloatLargeArray floatLargeArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(1L, 1, floatLargeArray, true);
                this.cdft2d_subth(-1, floatLargeArray, true);
                this.rdft2d_sub(1, floatLargeArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.realForward(floatLargeArray, i * this.columnsl);
                }
                this.cdft2d_sub(-1, floatLargeArray, true);
                this.rdft2d_sub(1, floatLargeArray);
            }
            this.fillSymmetric(floatLargeArray);
        } else {
            this.mixedRadixRealForwardFull(floatLargeArray);
        }
    }

    public void realForwardFull(float[][] fArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, fArray, true);
                this.cdft2d_subth(-1, fArray, true);
                this.rdft2d_sub(1, fArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realForward(fArray[i]);
                }
                this.cdft2d_sub(-1, fArray, true);
                this.rdft2d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealForwardFull(fArray);
        }
    }

    public void realInverse(float[] fArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_subth(1, fArray, bl);
            this.xdft2d0_subth1(1, -1, fArray, bl);
        } else {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_sub(1, fArray, bl);
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realInverse(fArray, i * this.columns, bl);
            }
        }
    }

    public void realInverse(FloatLargeArray floatLargeArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft2d_sub(-1, floatLargeArray);
            this.cdft2d_subth(1, floatLargeArray, bl);
            this.xdft2d0_subth1(1L, -1, floatLargeArray, bl);
        } else {
            this.rdft2d_sub(-1, floatLargeArray);
            this.cdft2d_sub(1, floatLargeArray, bl);
            for (long i = 0L; i < this.rowsl; ++i) {
                this.fftColumns.realInverse(floatLargeArray, i * this.columnsl, bl);
            }
        }
    }

    public void realInverse(float[][] fArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_subth(1, fArray, bl);
            this.xdft2d0_subth1(1, -1, fArray, bl);
        } else {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_sub(1, fArray, bl);
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realInverse(fArray[i], bl);
            }
        }
    }

    public void realInverseFull(float[] fArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, fArray, bl);
                this.cdft2d_subth(1, fArray, bl);
                this.rdft2d_sub(1, fArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realInverse2(fArray, i * this.columns, bl);
                }
                this.cdft2d_sub(1, fArray, bl);
                this.rdft2d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealInverseFull(fArray, bl);
        }
    }

    public void realInverseFull(FloatLargeArray floatLargeArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth2(1L, -1, floatLargeArray, bl);
                this.cdft2d_subth(1, floatLargeArray, bl);
                this.rdft2d_sub(1, floatLargeArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.realInverse2(floatLargeArray, i * this.columnsl, bl);
                }
                this.cdft2d_sub(1, floatLargeArray, bl);
                this.rdft2d_sub(1, floatLargeArray);
            }
            this.fillSymmetric(floatLargeArray);
        } else {
            this.mixedRadixRealInverseFull(floatLargeArray, bl);
        }
    }

    public void realInverseFull(float[][] fArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, fArray, bl);
                this.cdft2d_subth(1, fArray, bl);
                this.rdft2d_sub(1, fArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realInverse2(fArray[i], 0, bl);
                }
                this.cdft2d_sub(1, fArray, bl);
                this.rdft2d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealInverseFull(fArray, bl);
        }
    }

    private void mixedRadixRealForwardFull(final float[][] fArray) {
        final int n = this.columns / 2 + 1;
        final float[][] fArray2 = new float[n][2 * this.rows];
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.useThreads && this.rows >= n2 && n - 2 >= n2) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n2];
            int n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < this.rows; ++n5) {
                fArray2[0][n5] = fArray[n5][0];
            }
            this.fftRows.realForwardFull(fArray2[0]);
            n6 = (n - 2) / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? n - 1 : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < FloatFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                fArray2[i][n2] = fArray[j][n];
                                fArray2[i][n2 + 1] = fArray[j][n + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(fArray2[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    fArray2[n - 1][n5] = fArray[n5][1];
                }
                this.fftRows.realForwardFull(fArray2[n - 1]);
            } else {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    n3 = n - 1;
                    fArray2[n3][n4] = fArray[n5][2 * n3];
                    fArray2[n3][n4 + 1] = fArray[n5][1];
                }
                this.fftRows.complexForward(fArray2[n - 1]);
            }
            n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = 2 * i;
                            for (int j = 0; j < n; ++j) {
                                int n2 = 2 * j;
                                fArray[i][n2] = fArray2[j][n5];
                                fArray[i][n2 + 1] = fArray2[j][n5 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = FloatFFT_2D.this.rows - i;
                            for (int j = n; j < FloatFFT_2D.this.columns; ++j) {
                                int n2 = 2 * j;
                                int n32 = 2 * (FloatFFT_2D.this.columns - j);
                                fArray[0][n2] = fArray[0][n32];
                                fArray[0][n2 + 1] = -fArray[0][n32 + 1];
                                fArray[i][n2] = fArray[n5][n32];
                                fArray[i][n2 + 1] = -fArray[n5][n32 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            for (n10 = 0; n10 < this.rows; ++n10) {
                this.fftColumns.realForward(fArray[n10]);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                fArray2[0][n10] = fArray[n10][0];
            }
            this.fftRows.realForwardFull(fArray2[0]);
            for (n10 = 1; n10 < n - 1; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    fArray2[n10][n7] = fArray[n8][n9];
                    fArray2[n10][n7 + 1] = fArray[n8][n9 + 1];
                }
                this.fftRows.complexForward(fArray2[n10]);
            }
            if (this.columns % 2 == 0) {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    fArray2[n - 1][n10] = fArray[n10][1];
                }
                this.fftRows.realForwardFull(fArray2[n - 1]);
            } else {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    n9 = 2 * n10;
                    n8 = n - 1;
                    fArray2[n8][n9] = fArray[n10][2 * n8];
                    fArray2[n8][n9 + 1] = fArray[n10][1];
                }
                this.fftRows.complexForward(fArray2[n - 1]);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < n; ++n8) {
                    n7 = 2 * n8;
                    fArray[n10][n7] = fArray2[n8][n9];
                    fArray[n10][n7 + 1] = fArray2[n8][n9 + 1];
                }
            }
            for (n10 = 1; n10 < this.rows; ++n10) {
                n9 = this.rows - n10;
                for (n8 = n; n8 < this.columns; ++n8) {
                    n7 = 2 * n8;
                    int n11 = 2 * (this.columns - n8);
                    fArray[0][n7] = fArray[0][n11];
                    fArray[0][n7 + 1] = -fArray[0][n11 + 1];
                    fArray[n10][n7] = fArray[n9][n11];
                    fArray[n10][n7 + 1] = -fArray[n9][n11 + 1];
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] fArray) {
        final int n = 2 * this.columns;
        final int n2 = this.columns / 2 + 1;
        final float[][] fArray2 = new float[n2][2 * this.rows];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && this.rows >= n3 && n2 - 2 >= n3) {
            int n4;
            int n5;
            int n6;
            Future[] futureArray = new Future[n3];
            int n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray, i * FloatFFT_2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < this.rows; ++n6) {
                fArray2[0][n6] = fArray[n6 * this.columns];
            }
            this.fftRows.realForwardFull(fArray2[0]);
            n7 = (n2 - 2) / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? n2 - 1 : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < FloatFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                int n3 = j * FloatFFT_2D.this.columns + n;
                                fArray2[i][n2] = fArray[n3];
                                fArray2[i][n2 + 1] = fArray[n3 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(fArray2[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n2 - 1][n6] = fArray[n6 * this.columns + 1];
                }
                this.fftRows.realForwardFull(fArray2[n2 - 1]);
            } else {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    n4 = n6 * this.columns;
                    int n8 = n2 - 1;
                    fArray2[n8][n5] = fArray[n4 + 2 * n8];
                    fArray2[n8][n5 + 1] = fArray[n4 + 1];
                }
                this.fftRows.complexForward(fArray2[n2 - 1]);
            }
            n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n6 = 2 * i;
                            for (int j = 0; j < n2; ++j) {
                                int n22 = 2 * j;
                                int n3 = i * n + n22;
                                fArray[n3] = fArray2[j][n6];
                                fArray[n3 + 1] = fArray2[j][n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n7 = i * n;
                            int n22 = (FloatFFT_2D.this.rows - i + 1) * n;
                            for (int j = n2; j < FloatFFT_2D.this.columns; ++j) {
                                int n3 = 2 * j;
                                int n42 = 2 * (FloatFFT_2D.this.columns - j);
                                fArray[n3] = fArray[n42];
                                fArray[n3 + 1] = -fArray[n42 + 1];
                                int n52 = n7 + n3;
                                int n6 = n22 - n3;
                                fArray[n52] = fArray[n6];
                                fArray[n52 + 1] = -fArray[n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.rows; ++n13) {
                this.fftColumns.realForward(fArray, n13 * this.columns);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                fArray2[0][n13] = fArray[n13 * this.columns];
            }
            this.fftRows.realForwardFull(fArray2[0]);
            for (n13 = 1; n13 < n2 - 1; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    n9 = n11 * this.columns + n12;
                    fArray2[n13][n10] = fArray[n9];
                    fArray2[n13][n10 + 1] = fArray[n9 + 1];
                }
                this.fftRows.complexForward(fArray2[n13]);
            }
            if (this.columns % 2 == 0) {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    fArray2[n2 - 1][n13] = fArray[n13 * this.columns + 1];
                }
                this.fftRows.realForwardFull(fArray2[n2 - 1]);
            } else {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = 2 * n13;
                    n11 = n13 * this.columns;
                    n10 = n2 - 1;
                    fArray2[n10][n12] = fArray[n11 + 2 * n10];
                    fArray2[n10][n12 + 1] = fArray[n11 + 1];
                }
                this.fftRows.complexForward(fArray2[n2 - 1]);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = 2 * n11;
                    n9 = n13 * n + n10;
                    fArray[n9] = fArray2[n11][n12];
                    fArray[n9 + 1] = fArray2[n11][n12 + 1];
                }
            }
            for (n13 = 1; n13 < this.rows; ++n13) {
                n12 = n13 * n;
                n11 = (this.rows - n13 + 1) * n;
                for (n10 = n2; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    int n14 = 2 * (this.columns - n10);
                    fArray[n9] = fArray[n14];
                    fArray[n9 + 1] = -fArray[n14 + 1];
                    int n15 = n12 + n9;
                    int n16 = n11 - n9;
                    fArray[n15] = fArray[n16];
                    fArray[n15 + 1] = -fArray[n16 + 1];
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final FloatLargeArray floatLargeArray) {
        final long l = 2L * this.columnsl;
        final long l2 = this.columnsl / 2L + 1L;
        final FloatLargeArray floatLargeArray2 = new FloatLargeArray(l2 * 2L * this.rowsl, false);
        final long l3 = 2L * this.rowsl;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && this.rowsl >= (long)n && l2 - 2L >= (long)n) {
            int n2;
            long l4;
            long l5;
            long l6;
            Future[] futureArray = new Future[n];
            long l7 = this.rowsl / (long)n;
            for (int i = 0; i < n; ++i) {
                l6 = (long)i * l7;
                l5 = i == n - 1 ? this.rowsl : l6 + l7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            FloatFFT_2D.this.fftColumns.realForward(floatLargeArray, i * FloatFFT_2D.this.columnsl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (long i = 0L; i < this.rowsl; ++i) {
                floatLargeArray2.setDouble(i, floatLargeArray.getFloat(i * this.columnsl));
            }
            this.fftRows.realForwardFull(floatLargeArray2);
            l7 = (l2 - 2L) / (long)n;
            for (int i = 0; i < n; ++i) {
                l6 = 1L + (long)i * l7;
                l5 = i == n - 1 ? l2 - 1L : l6 + l7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l = 2L * i;
                            for (long j = 0L; j < FloatFFT_2D.this.rowsl; ++j) {
                                long l2 = 2L * j;
                                long l32 = j * FloatFFT_2D.this.columnsl + l;
                                floatLargeArray2.setDouble(i * l3 + l2, floatLargeArray.getFloat(l32));
                                floatLargeArray2.setDouble(i * l3 + l2 + 1L, floatLargeArray.getFloat(l32 + 1L));
                            }
                            FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2, i * l3);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columnsl % 2L == 0L) {
                for (l4 = 0L; l4 < this.rowsl; ++l4) {
                    floatLargeArray2.setDouble((l2 - 1L) * l3 + l4, floatLargeArray.getFloat(l4 * this.columnsl + 1L));
                }
                this.fftRows.realForwardFull(floatLargeArray2, (l2 - 1L) * l3);
            } else {
                for (l4 = 0L; l4 < this.rowsl; ++l4) {
                    long l8 = 2L * l4;
                    long l9 = l4 * this.columnsl;
                    long l10 = l2 - 1L;
                    floatLargeArray2.setDouble(l10 * l3 + l8, floatLargeArray.getFloat(l9 + 2L * l10));
                    floatLargeArray2.setDouble(l10 * l3 + l8 + 1L, floatLargeArray.getFloat(l9 + 1L));
                }
                this.fftRows.complexForward(floatLargeArray2, (l2 - 1L) * l3);
            }
            l7 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l6 = (long)n2 * l7;
                l5 = n2 == n - 1 ? this.rowsl : l6 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l4 = 2L * i;
                            for (long j = 0L; j < l2; ++j) {
                                long l22 = 2L * j;
                                long l32 = i * l + l22;
                                floatLargeArray.setDouble(l32, floatLargeArray2.getFloat(j * l3 + l4));
                                floatLargeArray.setDouble(l32 + 1L, floatLargeArray2.getFloat(j * l3 + l4 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l6 = 1L + (long)n2 * l7;
                l5 = n2 == n - 1 ? this.rowsl : l6 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l7 = i * l;
                            long l22 = (FloatFFT_2D.this.rowsl - i + 1L) * l;
                            for (long j = l2; j < FloatFFT_2D.this.columnsl; ++j) {
                                long l3 = 2L * j;
                                long l4 = 2L * (FloatFFT_2D.this.columnsl - j);
                                floatLargeArray.setDouble(l3, floatLargeArray.getFloat(l4));
                                floatLargeArray.setDouble(l3 + 1L, -floatLargeArray.getFloat(l4 + 1L));
                                long l52 = l7 + l3;
                                long l62 = l22 - l3;
                                floatLargeArray.setDouble(l52, floatLargeArray.getFloat(l62));
                                floatLargeArray.setDouble(l52 + 1L, -floatLargeArray.getFloat(l62 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l11;
            long l12;
            long l13;
            long l14;
            long l15;
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                this.fftColumns.realForward(floatLargeArray, l15 * this.columnsl);
            }
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                floatLargeArray2.setDouble(l15, floatLargeArray.getFloat(l15 * this.columnsl));
            }
            this.fftRows.realForwardFull(floatLargeArray2);
            for (l15 = 1L; l15 < l2 - 1L; ++l15) {
                l14 = 2L * l15;
                for (l13 = 0L; l13 < this.rowsl; ++l13) {
                    l12 = 2L * l13;
                    l11 = l13 * this.columnsl + l14;
                    floatLargeArray2.setDouble(l15 * l3 + l12, floatLargeArray.getFloat(l11));
                    floatLargeArray2.setDouble(l15 * l3 + l12 + 1L, floatLargeArray.getFloat(l11 + 1L));
                }
                this.fftRows.complexForward(floatLargeArray2, l15 * l3);
            }
            if (this.columnsl % 2L == 0L) {
                for (l15 = 0L; l15 < this.rowsl; ++l15) {
                    floatLargeArray2.setDouble((l2 - 1L) * l3 + l15, floatLargeArray.getFloat(l15 * this.columnsl + 1L));
                }
                this.fftRows.realForwardFull(floatLargeArray2, (l2 - 1L) * l3);
            } else {
                for (l15 = 0L; l15 < this.rowsl; ++l15) {
                    l14 = 2L * l15;
                    l13 = l15 * this.columnsl;
                    l12 = l2 - 1L;
                    floatLargeArray2.setDouble(l12 * l3 + l14, floatLargeArray.getFloat(l13 + 2L * l12));
                    floatLargeArray2.setDouble(l12 * l3 + l14 + 1L, floatLargeArray.getFloat(l13 + 1L));
                }
                this.fftRows.complexForward(floatLargeArray2, (l2 - 1L) * l3);
            }
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                l14 = 2L * l15;
                for (l13 = 0L; l13 < l2; ++l13) {
                    l12 = 2L * l13;
                    l11 = l15 * l + l12;
                    floatLargeArray.setDouble(l11, floatLargeArray2.getFloat(l13 * l3 + l14));
                    floatLargeArray.setDouble(l11 + 1L, floatLargeArray2.getFloat(l13 * l3 + l14 + 1L));
                }
            }
            for (l15 = 1L; l15 < this.rowsl; ++l15) {
                l14 = l15 * l;
                l13 = (this.rowsl - l15 + 1L) * l;
                for (l12 = l2; l12 < this.columnsl; ++l12) {
                    l11 = 2L * l12;
                    long l16 = 2L * (this.columnsl - l12);
                    floatLargeArray.setDouble(l11, floatLargeArray.getFloat(l16));
                    floatLargeArray.setDouble(l11 + 1L, -floatLargeArray.getFloat(l16 + 1L));
                    long l17 = l14 + l11;
                    long l18 = l13 - l11;
                    floatLargeArray.setDouble(l17, floatLargeArray.getFloat(l18));
                    floatLargeArray.setDouble(l17 + 1L, -floatLargeArray.getFloat(l18 + 1L));
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][] fArray, final boolean bl) {
        final int n = this.columns / 2 + 1;
        final float[][] fArray2 = new float[n][2 * this.rows];
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.useThreads && this.rows >= n2 && n - 2 >= n2) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n2];
            int n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            FloatFFT_2D.this.fftColumns.realInverse2(fArray[i], 0, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < this.rows; ++n5) {
                fArray2[0][n5] = fArray[n5][0];
            }
            this.fftRows.realInverseFull(fArray2[0], bl);
            n6 = (n - 2) / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? n - 1 : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < FloatFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                fArray2[i][n2] = fArray[j][n];
                                fArray2[i][n2 + 1] = fArray[j][n + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    fArray2[n - 1][n5] = fArray[n5][1];
                }
                this.fftRows.realInverseFull(fArray2[n - 1], bl);
            } else {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    n3 = n - 1;
                    fArray2[n3][n4] = fArray[n5][2 * n3];
                    fArray2[n3][n4 + 1] = fArray[n5][1];
                }
                this.fftRows.complexInverse(fArray2[n - 1], bl);
            }
            n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = 2 * i;
                            for (int j = 0; j < n; ++j) {
                                int n2 = 2 * j;
                                fArray[i][n2] = fArray2[j][n5];
                                fArray[i][n2 + 1] = fArray2[j][n5 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = FloatFFT_2D.this.rows - i;
                            for (int j = n; j < FloatFFT_2D.this.columns; ++j) {
                                int n2 = 2 * j;
                                int n32 = 2 * (FloatFFT_2D.this.columns - j);
                                fArray[0][n2] = fArray[0][n32];
                                fArray[0][n2 + 1] = -fArray[0][n32 + 1];
                                fArray[i][n2] = fArray[n5][n32];
                                fArray[i][n2 + 1] = -fArray[n5][n32 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            for (n10 = 0; n10 < this.rows; ++n10) {
                this.fftColumns.realInverse2(fArray[n10], 0, bl);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                fArray2[0][n10] = fArray[n10][0];
            }
            this.fftRows.realInverseFull(fArray2[0], bl);
            for (n10 = 1; n10 < n - 1; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    fArray2[n10][n7] = fArray[n8][n9];
                    fArray2[n10][n7 + 1] = fArray[n8][n9 + 1];
                }
                this.fftRows.complexInverse(fArray2[n10], bl);
            }
            if (this.columns % 2 == 0) {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    fArray2[n - 1][n10] = fArray[n10][1];
                }
                this.fftRows.realInverseFull(fArray2[n - 1], bl);
            } else {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    n9 = 2 * n10;
                    n8 = n - 1;
                    fArray2[n8][n9] = fArray[n10][2 * n8];
                    fArray2[n8][n9 + 1] = fArray[n10][1];
                }
                this.fftRows.complexInverse(fArray2[n - 1], bl);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < n; ++n8) {
                    n7 = 2 * n8;
                    fArray[n10][n7] = fArray2[n8][n9];
                    fArray[n10][n7 + 1] = fArray2[n8][n9 + 1];
                }
            }
            for (n10 = 1; n10 < this.rows; ++n10) {
                n9 = this.rows - n10;
                for (n8 = n; n8 < this.columns; ++n8) {
                    n7 = 2 * n8;
                    int n11 = 2 * (this.columns - n8);
                    fArray[0][n7] = fArray[0][n11];
                    fArray[0][n7 + 1] = -fArray[0][n11 + 1];
                    fArray[n10][n7] = fArray[n9][n11];
                    fArray[n10][n7 + 1] = -fArray[n9][n11 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] fArray, final boolean bl) {
        final int n = 2 * this.columns;
        final int n2 = this.columns / 2 + 1;
        final float[][] fArray2 = new float[n2][2 * this.rows];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && this.rows >= n3 && n2 - 2 >= n3) {
            int n4;
            int n5;
            int n6;
            Future[] futureArray = new Future[n3];
            int n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            FloatFFT_2D.this.fftColumns.realInverse2(fArray, i * FloatFFT_2D.this.columns, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < this.rows; ++n6) {
                fArray2[0][n6] = fArray[n6 * this.columns];
            }
            this.fftRows.realInverseFull(fArray2[0], bl);
            n7 = (n2 - 2) / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? n2 - 1 : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < FloatFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                int n3 = j * FloatFFT_2D.this.columns + n;
                                fArray2[i][n2] = fArray[n3];
                                fArray2[i][n2 + 1] = fArray[n3 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n2 - 1][n6] = fArray[n6 * this.columns + 1];
                }
                this.fftRows.realInverseFull(fArray2[n2 - 1], bl);
            } else {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    n4 = n6 * this.columns;
                    int n8 = n2 - 1;
                    fArray2[n8][n5] = fArray[n4 + 2 * n8];
                    fArray2[n8][n5 + 1] = fArray[n4 + 1];
                }
                this.fftRows.complexInverse(fArray2[n2 - 1], bl);
            }
            n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n6 = 2 * i;
                            for (int j = 0; j < n2; ++j) {
                                int n22 = 2 * j;
                                int n3 = i * n + n22;
                                fArray[n3] = fArray2[j][n6];
                                fArray[n3 + 1] = fArray2[j][n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n7 = i * n;
                            int n22 = (FloatFFT_2D.this.rows - i + 1) * n;
                            for (int j = n2; j < FloatFFT_2D.this.columns; ++j) {
                                int n3 = 2 * j;
                                int n42 = 2 * (FloatFFT_2D.this.columns - j);
                                fArray[n3] = fArray[n42];
                                fArray[n3 + 1] = -fArray[n42 + 1];
                                int n52 = n7 + n3;
                                int n6 = n22 - n3;
                                fArray[n52] = fArray[n6];
                                fArray[n52 + 1] = -fArray[n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.rows; ++n13) {
                this.fftColumns.realInverse2(fArray, n13 * this.columns, bl);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                fArray2[0][n13] = fArray[n13 * this.columns];
            }
            this.fftRows.realInverseFull(fArray2[0], bl);
            for (n13 = 1; n13 < n2 - 1; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    n9 = n11 * this.columns + n12;
                    fArray2[n13][n10] = fArray[n9];
                    fArray2[n13][n10 + 1] = fArray[n9 + 1];
                }
                this.fftRows.complexInverse(fArray2[n13], bl);
            }
            if (this.columns % 2 == 0) {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    fArray2[n2 - 1][n13] = fArray[n13 * this.columns + 1];
                }
                this.fftRows.realInverseFull(fArray2[n2 - 1], bl);
            } else {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = 2 * n13;
                    n11 = n13 * this.columns;
                    n10 = n2 - 1;
                    fArray2[n10][n12] = fArray[n11 + 2 * n10];
                    fArray2[n10][n12 + 1] = fArray[n11 + 1];
                }
                this.fftRows.complexInverse(fArray2[n2 - 1], bl);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = 2 * n11;
                    n9 = n13 * n + n10;
                    fArray[n9] = fArray2[n11][n12];
                    fArray[n9 + 1] = fArray2[n11][n12 + 1];
                }
            }
            for (n13 = 1; n13 < this.rows; ++n13) {
                n12 = n13 * n;
                n11 = (this.rows - n13 + 1) * n;
                for (n10 = n2; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    int n14 = 2 * (this.columns - n10);
                    fArray[n9] = fArray[n14];
                    fArray[n9 + 1] = -fArray[n14 + 1];
                    int n15 = n12 + n9;
                    int n16 = n11 - n9;
                    fArray[n15] = fArray[n16];
                    fArray[n15 + 1] = -fArray[n16 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final FloatLargeArray floatLargeArray, final boolean bl) {
        final long l = 2L * this.columnsl;
        final long l2 = this.columnsl / 2L + 1L;
        final FloatLargeArray floatLargeArray2 = new FloatLargeArray(l2 * 2L * this.rowsl, false);
        final long l3 = 2L * this.rowsl;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && this.rowsl >= (long)n && l2 - 2L >= (long)n) {
            int n2;
            long l4;
            long l5;
            long l6;
            Future[] futureArray = new Future[n];
            long l7 = this.rowsl / (long)n;
            for (int i = 0; i < n; ++i) {
                l6 = (long)i * l7;
                l5 = i == n - 1 ? this.rowsl : l6 + l7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            FloatFFT_2D.this.fftColumns.realInverse2(floatLargeArray, i * FloatFFT_2D.this.columnsl, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (long i = 0L; i < this.rowsl; ++i) {
                floatLargeArray2.setDouble(i, floatLargeArray.getFloat(i * this.columnsl));
            }
            this.fftRows.realInverseFull(floatLargeArray2, bl);
            l7 = (l2 - 2L) / (long)n;
            for (int i = 0; i < n; ++i) {
                l6 = 1L + (long)i * l7;
                l5 = i == n - 1 ? l2 - 1L : l6 + l7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l = 2L * i;
                            for (long j = 0L; j < FloatFFT_2D.this.rowsl; ++j) {
                                long l2 = 2L * j;
                                long l32 = j * FloatFFT_2D.this.columnsl + l;
                                floatLargeArray2.setDouble(i * l3 + l2, floatLargeArray.getFloat(l32));
                                floatLargeArray2.setDouble(i * l3 + l2 + 1L, floatLargeArray.getFloat(l32 + 1L));
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, i * l3, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columnsl % 2L == 0L) {
                for (l4 = 0L; l4 < this.rowsl; ++l4) {
                    floatLargeArray2.setDouble((l2 - 1L) * l3 + l4, floatLargeArray.getFloat(l4 * this.columnsl + 1L));
                }
                this.fftRows.realInverseFull(floatLargeArray2, (l2 - 1L) * l3, bl);
            } else {
                for (l4 = 0L; l4 < this.rowsl; ++l4) {
                    long l8 = 2L * l4;
                    long l9 = l4 * this.columnsl;
                    long l10 = l2 - 1L;
                    floatLargeArray2.setDouble(l10 * l3 + l8, floatLargeArray.getFloat(l9 + 2L * l10));
                    floatLargeArray2.setDouble(l10 * l3 + l8 + 1L, floatLargeArray.getFloat(l9 + 1L));
                }
                this.fftRows.complexInverse(floatLargeArray2, (l2 - 1L) * l3, bl);
            }
            l7 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l6 = (long)n2 * l7;
                l5 = n2 == n - 1 ? this.rowsl : l6 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l4 = 2L * i;
                            for (long j = 0L; j < l2; ++j) {
                                long l22 = 2L * j;
                                long l32 = i * l + l22;
                                floatLargeArray.setDouble(l32, floatLargeArray2.getFloat(j * l3 + l4));
                                floatLargeArray.setDouble(l32 + 1L, floatLargeArray2.getFloat(j * l3 + l4 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l6 = 1L + (long)n2 * l7;
                l5 = n2 == n - 1 ? this.rowsl : l6 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l7 = i * l;
                            long l22 = (FloatFFT_2D.this.rowsl - i + 1L) * l;
                            for (long j = l2; j < FloatFFT_2D.this.columnsl; ++j) {
                                long l3 = 2L * j;
                                long l4 = 2L * (FloatFFT_2D.this.columnsl - j);
                                floatLargeArray.setDouble(l3, floatLargeArray.getFloat(l4));
                                floatLargeArray.setDouble(l3 + 1L, -floatLargeArray.getFloat(l4 + 1L));
                                long l52 = l7 + l3;
                                long l62 = l22 - l3;
                                floatLargeArray.setDouble(l52, floatLargeArray.getFloat(l62));
                                floatLargeArray.setDouble(l52 + 1L, -floatLargeArray.getFloat(l62 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l11;
            long l12;
            long l13;
            long l14;
            long l15;
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                this.fftColumns.realInverse2(floatLargeArray, l15 * this.columnsl, bl);
            }
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                floatLargeArray2.setDouble(l15, floatLargeArray.getFloat(l15 * this.columnsl));
            }
            this.fftRows.realInverseFull(floatLargeArray2, bl);
            for (l15 = 1L; l15 < l2 - 1L; ++l15) {
                l14 = 2L * l15;
                for (l13 = 0L; l13 < this.rowsl; ++l13) {
                    l12 = 2L * l13;
                    l11 = l13 * this.columnsl + l14;
                    floatLargeArray2.setDouble(l15 * l3 + l12, floatLargeArray.getFloat(l11));
                    floatLargeArray2.setDouble(l15 * l3 + l12 + 1L, floatLargeArray.getFloat(l11 + 1L));
                }
                this.fftRows.complexInverse(floatLargeArray2, l15 * l3, bl);
            }
            if (this.columnsl % 2L == 0L) {
                for (l15 = 0L; l15 < this.rowsl; ++l15) {
                    floatLargeArray2.setDouble((l2 - 1L) * l3 + l15, floatLargeArray.getFloat(l15 * this.columnsl + 1L));
                }
                this.fftRows.realInverseFull(floatLargeArray2, (l2 - 1L) * l3, bl);
            } else {
                for (l15 = 0L; l15 < this.rowsl; ++l15) {
                    l14 = 2L * l15;
                    l13 = l15 * this.columnsl;
                    l12 = l2 - 1L;
                    floatLargeArray2.setDouble(l12 * l3 + l14, floatLargeArray.getFloat(l13 + 2L * l12));
                    floatLargeArray2.setDouble(l12 * l3 + l14 + 1L, floatLargeArray.getFloat(l13 + 1L));
                }
                this.fftRows.complexInverse(floatLargeArray2, (l2 - 1L) * l3, bl);
            }
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                l14 = 2L * l15;
                for (l13 = 0L; l13 < l2; ++l13) {
                    l12 = 2L * l13;
                    l11 = l15 * l + l12;
                    floatLargeArray.setDouble(l11, floatLargeArray2.getFloat(l13 * l3 + l14));
                    floatLargeArray.setDouble(l11 + 1L, floatLargeArray2.getFloat(l13 * l3 + l14 + 1L));
                }
            }
            for (l15 = 1L; l15 < this.rowsl; ++l15) {
                l14 = l15 * l;
                l13 = (this.rowsl - l15 + 1L) * l;
                for (l12 = l2; l12 < this.columnsl; ++l12) {
                    l11 = 2L * l12;
                    long l16 = 2L * (this.columnsl - l12);
                    floatLargeArray.setDouble(l11, floatLargeArray.getFloat(l16));
                    floatLargeArray.setDouble(l11 + 1L, -floatLargeArray.getFloat(l16 + 1L));
                    long l17 = l14 + l11;
                    long l18 = l13 - l11;
                    floatLargeArray.setDouble(l17, floatLargeArray.getFloat(l18));
                    floatLargeArray.setDouble(l17 + 1L, -floatLargeArray.getFloat(l18 + 1L));
                }
            }
        }
    }

    private void rdft2d_sub(int n, float[] fArray) {
        int n2 = this.rows >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.rows - i;
                int n4 = i * this.columns;
                int n5 = n3 * this.columns;
                float f = fArray[n4] - fArray[n5];
                int n6 = n4;
                fArray[n6] = fArray[n6] + fArray[n5];
                fArray[n5] = f;
                f = fArray[n5 + 1] - fArray[n4 + 1];
                int n7 = n4 + 1;
                fArray[n7] = fArray[n7] + fArray[n5 + 1];
                fArray[n5 + 1] = f;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n8 = this.rows - i;
                int n9 = i * this.columns;
                int n10 = n8 * this.columns;
                fArray[n10] = 0.5f * (fArray[n9] - fArray[n10]);
                int n11 = n9;
                fArray[n11] = fArray[n11] - fArray[n10];
                fArray[n10 + 1] = 0.5f * (fArray[n9 + 1] + fArray[n10 + 1]);
                int n12 = n9 + 1;
                fArray[n12] = fArray[n12] - fArray[n10 + 1];
            }
        }
    }

    private void rdft2d_sub(int n, FloatLargeArray floatLargeArray) {
        long l = this.rowsl >> 1;
        if (n < 0) {
            for (long i = 1L; i < l; ++i) {
                long l2 = this.rowsl - i;
                long l3 = i * this.columnsl;
                long l4 = l2 * this.columnsl;
                float f = floatLargeArray.getFloat(l3) - floatLargeArray.getFloat(l4);
                floatLargeArray.setDouble(l3, floatLargeArray.getFloat(l3) + floatLargeArray.getFloat(l4));
                floatLargeArray.setDouble(l4, f);
                f = floatLargeArray.getFloat(l4 + 1L) - floatLargeArray.getFloat(l3 + 1L);
                floatLargeArray.setDouble(l3 + 1L, floatLargeArray.getFloat(l3 + 1L) + floatLargeArray.getFloat(l4 + 1L));
                floatLargeArray.setDouble(l4 + 1L, f);
            }
        } else {
            for (long i = 1L; i < l; ++i) {
                long l5 = this.rowsl - i;
                long l6 = i * this.columnsl;
                long l7 = l5 * this.columnsl;
                floatLargeArray.setDouble(l7, 0.5f * (floatLargeArray.getFloat(l6) - floatLargeArray.getFloat(l7)));
                floatLargeArray.setDouble(l6, floatLargeArray.getFloat(l6) - floatLargeArray.getFloat(l7));
                floatLargeArray.setDouble(l7 + 1L, 0.5f * (floatLargeArray.getFloat(l6 + 1L) + floatLargeArray.getFloat(l7 + 1L)));
                floatLargeArray.setDouble(l6 + 1L, floatLargeArray.getFloat(l6 + 1L) - floatLargeArray.getFloat(l7 + 1L));
            }
        }
    }

    private void rdft2d_sub(int n, float[][] fArray) {
        int n2 = this.rows >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.rows - i;
                float f = fArray[i][0] - fArray[n3][0];
                float[] fArray2 = fArray[i];
                fArray2[0] = fArray2[0] + fArray[n3][0];
                fArray[n3][0] = f;
                f = fArray[n3][1] - fArray[i][1];
                float[] fArray3 = fArray[i];
                fArray3[1] = fArray3[1] + fArray[n3][1];
                fArray[n3][1] = f;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n4 = this.rows - i;
                fArray[n4][0] = 0.5f * (fArray[i][0] - fArray[n4][0]);
                float[] fArray4 = fArray[i];
                fArray4[0] = fArray4[0] - fArray[n4][0];
                fArray[n4][1] = 0.5f * (fArray[i][1] + fArray[n4][1]);
                float[] fArray5 = fArray[i];
                fArray5[1] = fArray5[1] - fArray[n4][1];
            }
        }
    }

    private void cdft2d_sub(int n, float[] fArray, boolean bl) {
        block24: {
            float[] fArray2;
            block22: {
                int n2;
                int n3;
                int n4;
                block25: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    block23: {
                        int n9 = 8 * this.rows;
                        if (this.columns == 4) {
                            n9 >>= 1;
                        } else if (this.columns < 4) {
                            n9 >>= 2;
                        }
                        fArray2 = new float[n9];
                        if (n != -1) break block22;
                        if (this.columns <= 4) break block23;
                        for (int i = 0; i < this.columns; i += 8) {
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            int n15;
                            for (n15 = 0; n15 < this.rows; ++n15) {
                                n14 = n15 * this.columns + i;
                                n13 = 2 * n15;
                                n12 = 2 * this.rows + 2 * n15;
                                n11 = n12 + 2 * this.rows;
                                n10 = n11 + 2 * this.rows;
                                fArray2[n13] = fArray[n14];
                                fArray2[n13 + 1] = fArray[n14 + 1];
                                fArray2[n12] = fArray[n14 + 2];
                                fArray2[n12 + 1] = fArray[n14 + 3];
                                fArray2[n11] = fArray[n14 + 4];
                                fArray2[n11 + 1] = fArray[n14 + 5];
                                fArray2[n10] = fArray[n14 + 6];
                                fArray2[n10 + 1] = fArray[n14 + 7];
                            }
                            this.fftRows.complexForward(fArray2, 0);
                            this.fftRows.complexForward(fArray2, 2 * this.rows);
                            this.fftRows.complexForward(fArray2, 4 * this.rows);
                            this.fftRows.complexForward(fArray2, 6 * this.rows);
                            for (n15 = 0; n15 < this.rows; ++n15) {
                                n14 = n15 * this.columns + i;
                                n13 = 2 * n15;
                                n12 = 2 * this.rows + 2 * n15;
                                n11 = n12 + 2 * this.rows;
                                n10 = n11 + 2 * this.rows;
                                fArray[n14] = fArray2[n13];
                                fArray[n14 + 1] = fArray2[n13 + 1];
                                fArray[n14 + 2] = fArray2[n12];
                                fArray[n14 + 3] = fArray2[n12 + 1];
                                fArray[n14 + 4] = fArray2[n11];
                                fArray[n14 + 5] = fArray2[n11 + 1];
                                fArray[n14 + 6] = fArray2[n10];
                                fArray[n14 + 7] = fArray2[n10 + 1];
                            }
                        }
                        break block24;
                    }
                    if (this.columns != 4) break block25;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = n8 * this.columns;
                        n6 = 2 * n8;
                        n5 = 2 * this.rows + 2 * n8;
                        fArray2[n6] = fArray[n7];
                        fArray2[n6 + 1] = fArray[n7 + 1];
                        fArray2[n5] = fArray[n7 + 2];
                        fArray2[n5 + 1] = fArray[n7 + 3];
                    }
                    this.fftRows.complexForward(fArray2, 0);
                    this.fftRows.complexForward(fArray2, 2 * this.rows);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = n8 * this.columns;
                        n6 = 2 * n8;
                        n5 = 2 * this.rows + 2 * n8;
                        fArray[n7] = fArray2[n6];
                        fArray[n7 + 1] = fArray2[n6 + 1];
                        fArray[n7 + 2] = fArray2[n5];
                        fArray[n7 + 3] = fArray2[n5 + 1];
                    }
                    break block24;
                }
                if (this.columns != 2) break block24;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n4 * this.columns;
                    n2 = 2 * n4;
                    fArray2[n2] = fArray[n3];
                    fArray2[n2 + 1] = fArray[n3 + 1];
                }
                this.fftRows.complexForward(fArray2, 0);
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n4 * this.columns;
                    n2 = 2 * n4;
                    fArray[n3] = fArray2[n2];
                    fArray[n3 + 1] = fArray2[n2 + 1];
                }
                break block24;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.columns; i += 8) {
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    for (n21 = 0; n21 < this.rows; ++n21) {
                        n20 = n21 * this.columns + i;
                        n19 = 2 * n21;
                        n18 = 2 * this.rows + 2 * n21;
                        n17 = n18 + 2 * this.rows;
                        n16 = n17 + 2 * this.rows;
                        fArray2[n19] = fArray[n20];
                        fArray2[n19 + 1] = fArray[n20 + 1];
                        fArray2[n18] = fArray[n20 + 2];
                        fArray2[n18 + 1] = fArray[n20 + 3];
                        fArray2[n17] = fArray[n20 + 4];
                        fArray2[n17 + 1] = fArray[n20 + 5];
                        fArray2[n16] = fArray[n20 + 6];
                        fArray2[n16 + 1] = fArray[n20 + 7];
                    }
                    this.fftRows.complexInverse(fArray2, 0, bl);
                    this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                    this.fftRows.complexInverse(fArray2, 4 * this.rows, bl);
                    this.fftRows.complexInverse(fArray2, 6 * this.rows, bl);
                    for (n21 = 0; n21 < this.rows; ++n21) {
                        n20 = n21 * this.columns + i;
                        n19 = 2 * n21;
                        n18 = 2 * this.rows + 2 * n21;
                        n17 = n18 + 2 * this.rows;
                        n16 = n17 + 2 * this.rows;
                        fArray[n20] = fArray2[n19];
                        fArray[n20 + 1] = fArray2[n19 + 1];
                        fArray[n20 + 2] = fArray2[n18];
                        fArray[n20 + 3] = fArray2[n18 + 1];
                        fArray[n20 + 4] = fArray2[n17];
                        fArray[n20 + 5] = fArray2[n17 + 1];
                        fArray[n20 + 6] = fArray2[n16];
                        fArray[n20 + 7] = fArray2[n16 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int n22;
                int n23;
                int n24;
                int n25;
                for (n25 = 0; n25 < this.rows; ++n25) {
                    n24 = n25 * this.columns;
                    n23 = 2 * n25;
                    n22 = 2 * this.rows + 2 * n25;
                    fArray2[n23] = fArray[n24];
                    fArray2[n23 + 1] = fArray[n24 + 1];
                    fArray2[n22] = fArray[n24 + 2];
                    fArray2[n22 + 1] = fArray[n24 + 3];
                }
                this.fftRows.complexInverse(fArray2, 0, bl);
                this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                for (n25 = 0; n25 < this.rows; ++n25) {
                    n24 = n25 * this.columns;
                    n23 = 2 * n25;
                    n22 = 2 * this.rows + 2 * n25;
                    fArray[n24] = fArray2[n23];
                    fArray[n24 + 1] = fArray2[n23 + 1];
                    fArray[n24 + 2] = fArray2[n22];
                    fArray[n24 + 3] = fArray2[n22 + 1];
                }
            } else if (this.columns == 2) {
                int n26;
                int n27;
                int n28;
                for (n28 = 0; n28 < this.rows; ++n28) {
                    n27 = n28 * this.columns;
                    n26 = 2 * n28;
                    fArray2[n26] = fArray[n27];
                    fArray2[n26 + 1] = fArray[n27 + 1];
                }
                this.fftRows.complexInverse(fArray2, 0, bl);
                for (n28 = 0; n28 < this.rows; ++n28) {
                    n27 = n28 * this.columns;
                    n26 = 2 * n28;
                    fArray[n27] = fArray2[n26];
                    fArray[n27 + 1] = fArray2[n26 + 1];
                }
            }
        }
    }

    private void cdft2d_sub(int n, FloatLargeArray floatLargeArray, boolean bl) {
        block24: {
            FloatLargeArray floatLargeArray2;
            block22: {
                long l;
                long l2;
                long l3;
                block25: {
                    long l4;
                    long l5;
                    long l6;
                    long l7;
                    block23: {
                        long l8 = 8L * this.rowsl;
                        if (this.columnsl == 4L) {
                            l8 >>= 1;
                        } else if (this.columnsl < 4L) {
                            l8 >>= 2;
                        }
                        floatLargeArray2 = new FloatLargeArray(l8, false);
                        if (n != -1) break block22;
                        if (this.columnsl <= 4L) break block23;
                        for (long i = 0L; i < this.columnsl; i += 8L) {
                            long l9;
                            long l10;
                            long l11;
                            long l12;
                            long l13;
                            long l14;
                            for (l14 = 0L; l14 < this.rowsl; ++l14) {
                                l13 = l14 * this.columnsl + i;
                                l12 = 2L * l14;
                                l11 = 2L * this.rowsl + 2L * l14;
                                l10 = l11 + 2L * this.rowsl;
                                l9 = l10 + 2L * this.rowsl;
                                floatLargeArray2.setDouble(l12, floatLargeArray.getFloat(l13));
                                floatLargeArray2.setDouble(l12 + 1L, floatLargeArray.getFloat(l13 + 1L));
                                floatLargeArray2.setDouble(l11, floatLargeArray.getFloat(l13 + 2L));
                                floatLargeArray2.setDouble(l11 + 1L, floatLargeArray.getFloat(l13 + 3L));
                                floatLargeArray2.setDouble(l10, floatLargeArray.getFloat(l13 + 4L));
                                floatLargeArray2.setDouble(l10 + 1L, floatLargeArray.getFloat(l13 + 5L));
                                floatLargeArray2.setDouble(l9, floatLargeArray.getFloat(l13 + 6L));
                                floatLargeArray2.setDouble(l9 + 1L, floatLargeArray.getFloat(l13 + 7L));
                            }
                            this.fftRows.complexForward(floatLargeArray2, 0L);
                            this.fftRows.complexForward(floatLargeArray2, 2L * this.rowsl);
                            this.fftRows.complexForward(floatLargeArray2, 4L * this.rowsl);
                            this.fftRows.complexForward(floatLargeArray2, 6L * this.rowsl);
                            for (l14 = 0L; l14 < this.rowsl; ++l14) {
                                l13 = l14 * this.columnsl + i;
                                l12 = 2L * l14;
                                l11 = 2L * this.rowsl + 2L * l14;
                                l10 = l11 + 2L * this.rowsl;
                                l9 = l10 + 2L * this.rowsl;
                                floatLargeArray.setDouble(l13, floatLargeArray2.getFloat(l12));
                                floatLargeArray.setDouble(l13 + 1L, floatLargeArray2.getFloat(l12 + 1L));
                                floatLargeArray.setDouble(l13 + 2L, floatLargeArray2.getFloat(l11));
                                floatLargeArray.setDouble(l13 + 3L, floatLargeArray2.getFloat(l11 + 1L));
                                floatLargeArray.setDouble(l13 + 4L, floatLargeArray2.getFloat(l10));
                                floatLargeArray.setDouble(l13 + 5L, floatLargeArray2.getFloat(l10 + 1L));
                                floatLargeArray.setDouble(l13 + 6L, floatLargeArray2.getFloat(l9));
                                floatLargeArray.setDouble(l13 + 7L, floatLargeArray2.getFloat(l9 + 1L));
                            }
                        }
                        break block24;
                    }
                    if (this.columnsl != 4L) break block25;
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = l7 * this.columnsl;
                        l5 = 2L * l7;
                        l4 = 2L * this.rowsl + 2L * l7;
                        floatLargeArray2.setDouble(l5, floatLargeArray.getFloat(l6));
                        floatLargeArray2.setDouble(l5 + 1L, floatLargeArray.getFloat(l6 + 1L));
                        floatLargeArray2.setDouble(l4, floatLargeArray.getFloat(l6 + 2L));
                        floatLargeArray2.setDouble(l4 + 1L, floatLargeArray.getFloat(l6 + 3L));
                    }
                    this.fftRows.complexForward(floatLargeArray2, 0L);
                    this.fftRows.complexForward(floatLargeArray2, 2L * this.rowsl);
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = l7 * this.columnsl;
                        l5 = 2L * l7;
                        l4 = 2L * this.rowsl + 2L * l7;
                        floatLargeArray.setDouble(l6, floatLargeArray2.getFloat(l5));
                        floatLargeArray.setDouble(l6 + 1L, floatLargeArray2.getFloat(l5 + 1L));
                        floatLargeArray.setDouble(l6 + 2L, floatLargeArray2.getFloat(l4));
                        floatLargeArray.setDouble(l6 + 3L, floatLargeArray2.getFloat(l4 + 1L));
                    }
                    break block24;
                }
                if (this.columnsl != 2L) break block24;
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l3 * this.columnsl;
                    l = 2L * l3;
                    floatLargeArray2.setDouble(l, floatLargeArray.getFloat(l2));
                    floatLargeArray2.setDouble(l + 1L, floatLargeArray.getFloat(l2 + 1L));
                }
                this.fftRows.complexForward(floatLargeArray2, 0L);
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l3 * this.columnsl;
                    l = 2L * l3;
                    floatLargeArray.setDouble(l2, floatLargeArray2.getFloat(l));
                    floatLargeArray.setDouble(l2 + 1L, floatLargeArray2.getFloat(l + 1L));
                }
                break block24;
            }
            if (this.columnsl > 4L) {
                for (long i = 0L; i < this.columnsl; i += 8L) {
                    long l;
                    long l15;
                    long l16;
                    long l17;
                    long l18;
                    long l19;
                    for (l19 = 0L; l19 < this.rowsl; ++l19) {
                        l18 = l19 * this.columnsl + i;
                        l17 = 2L * l19;
                        l16 = 2L * this.rowsl + 2L * l19;
                        l15 = l16 + 2L * this.rowsl;
                        l = l15 + 2L * this.rowsl;
                        floatLargeArray2.setDouble(l17, floatLargeArray.getFloat(l18));
                        floatLargeArray2.setDouble(l17 + 1L, floatLargeArray.getFloat(l18 + 1L));
                        floatLargeArray2.setDouble(l16, floatLargeArray.getFloat(l18 + 2L));
                        floatLargeArray2.setDouble(l16 + 1L, floatLargeArray.getFloat(l18 + 3L));
                        floatLargeArray2.setDouble(l15, floatLargeArray.getFloat(l18 + 4L));
                        floatLargeArray2.setDouble(l15 + 1L, floatLargeArray.getFloat(l18 + 5L));
                        floatLargeArray2.setDouble(l, floatLargeArray.getFloat(l18 + 6L));
                        floatLargeArray2.setDouble(l + 1L, floatLargeArray.getFloat(l18 + 7L));
                    }
                    this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                    this.fftRows.complexInverse(floatLargeArray2, 2L * this.rowsl, bl);
                    this.fftRows.complexInverse(floatLargeArray2, 4L * this.rowsl, bl);
                    this.fftRows.complexInverse(floatLargeArray2, 6L * this.rowsl, bl);
                    for (l19 = 0L; l19 < this.rowsl; ++l19) {
                        l18 = l19 * this.columnsl + i;
                        l17 = 2L * l19;
                        l16 = 2L * this.rowsl + 2L * l19;
                        l15 = l16 + 2L * this.rowsl;
                        l = l15 + 2L * this.rowsl;
                        floatLargeArray.setDouble(l18, floatLargeArray2.getFloat(l17));
                        floatLargeArray.setDouble(l18 + 1L, floatLargeArray2.getFloat(l17 + 1L));
                        floatLargeArray.setDouble(l18 + 2L, floatLargeArray2.getFloat(l16));
                        floatLargeArray.setDouble(l18 + 3L, floatLargeArray2.getFloat(l16 + 1L));
                        floatLargeArray.setDouble(l18 + 4L, floatLargeArray2.getFloat(l15));
                        floatLargeArray.setDouble(l18 + 5L, floatLargeArray2.getFloat(l15 + 1L));
                        floatLargeArray.setDouble(l18 + 6L, floatLargeArray2.getFloat(l));
                        floatLargeArray.setDouble(l18 + 7L, floatLargeArray2.getFloat(l + 1L));
                    }
                }
            } else if (this.columnsl == 4L) {
                long l;
                long l20;
                long l21;
                long l22;
                for (l22 = 0L; l22 < this.rowsl; ++l22) {
                    l21 = l22 * this.columnsl;
                    l20 = 2L * l22;
                    l = 2L * this.rowsl + 2L * l22;
                    floatLargeArray2.setDouble(l20, floatLargeArray.getFloat(l21));
                    floatLargeArray2.setDouble(l20 + 1L, floatLargeArray.getFloat(l21 + 1L));
                    floatLargeArray2.setDouble(l, floatLargeArray.getFloat(l21 + 2L));
                    floatLargeArray2.setDouble(l + 1L, floatLargeArray.getFloat(l21 + 3L));
                }
                this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                this.fftRows.complexInverse(floatLargeArray2, 2L * this.rowsl, bl);
                for (l22 = 0L; l22 < this.rowsl; ++l22) {
                    l21 = l22 * this.columnsl;
                    l20 = 2L * l22;
                    l = 2L * this.rowsl + 2L * l22;
                    floatLargeArray.setDouble(l21, floatLargeArray2.getFloat(l20));
                    floatLargeArray.setDouble(l21 + 1L, floatLargeArray2.getFloat(l20 + 1L));
                    floatLargeArray.setDouble(l21 + 2L, floatLargeArray2.getFloat(l));
                    floatLargeArray.setDouble(l21 + 3L, floatLargeArray2.getFloat(l + 1L));
                }
            } else if (this.columnsl == 2L) {
                long l;
                long l23;
                long l24;
                for (l24 = 0L; l24 < this.rowsl; ++l24) {
                    l23 = l24 * this.columnsl;
                    l = 2L * l24;
                    floatLargeArray2.setDouble(l, floatLargeArray.getFloat(l23));
                    floatLargeArray2.setDouble(l + 1L, floatLargeArray.getFloat(l23 + 1L));
                }
                this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                for (l24 = 0L; l24 < this.rowsl; ++l24) {
                    l23 = l24 * this.columnsl;
                    l = 2L * l24;
                    floatLargeArray.setDouble(l23, floatLargeArray2.getFloat(l));
                    floatLargeArray.setDouble(l23 + 1L, floatLargeArray2.getFloat(l + 1L));
                }
            }
        }
    }

    private void cdft2d_sub(int n, float[][] fArray, boolean bl) {
        block24: {
            float[] fArray2;
            block22: {
                int n2;
                int n3;
                block25: {
                    int n4;
                    int n5;
                    int n6;
                    block23: {
                        int n7 = 8 * this.rows;
                        if (this.columns == 4) {
                            n7 >>= 1;
                        } else if (this.columns < 4) {
                            n7 >>= 2;
                        }
                        fArray2 = new float[n7];
                        if (n != -1) break block22;
                        if (this.columns <= 4) break block23;
                        for (int i = 0; i < this.columns; i += 8) {
                            int n8;
                            int n9;
                            int n10;
                            int n11;
                            int n12;
                            for (n12 = 0; n12 < this.rows; ++n12) {
                                n11 = 2 * n12;
                                n10 = 2 * this.rows + 2 * n12;
                                n9 = n10 + 2 * this.rows;
                                n8 = n9 + 2 * this.rows;
                                fArray2[n11] = fArray[n12][i];
                                fArray2[n11 + 1] = fArray[n12][i + 1];
                                fArray2[n10] = fArray[n12][i + 2];
                                fArray2[n10 + 1] = fArray[n12][i + 3];
                                fArray2[n9] = fArray[n12][i + 4];
                                fArray2[n9 + 1] = fArray[n12][i + 5];
                                fArray2[n8] = fArray[n12][i + 6];
                                fArray2[n8 + 1] = fArray[n12][i + 7];
                            }
                            this.fftRows.complexForward(fArray2, 0);
                            this.fftRows.complexForward(fArray2, 2 * this.rows);
                            this.fftRows.complexForward(fArray2, 4 * this.rows);
                            this.fftRows.complexForward(fArray2, 6 * this.rows);
                            for (n12 = 0; n12 < this.rows; ++n12) {
                                n11 = 2 * n12;
                                n10 = 2 * this.rows + 2 * n12;
                                n9 = n10 + 2 * this.rows;
                                n8 = n9 + 2 * this.rows;
                                fArray[n12][i] = fArray2[n11];
                                fArray[n12][i + 1] = fArray2[n11 + 1];
                                fArray[n12][i + 2] = fArray2[n10];
                                fArray[n12][i + 3] = fArray2[n10 + 1];
                                fArray[n12][i + 4] = fArray2[n9];
                                fArray[n12][i + 5] = fArray2[n9 + 1];
                                fArray[n12][i + 6] = fArray2[n8];
                                fArray[n12][i + 7] = fArray2[n8 + 1];
                            }
                        }
                        break block24;
                    }
                    if (this.columns != 4) break block25;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        fArray2[n5] = fArray[n6][0];
                        fArray2[n5 + 1] = fArray[n6][1];
                        fArray2[n4] = fArray[n6][2];
                        fArray2[n4 + 1] = fArray[n6][3];
                    }
                    this.fftRows.complexForward(fArray2, 0);
                    this.fftRows.complexForward(fArray2, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        fArray[n6][0] = fArray2[n5];
                        fArray[n6][1] = fArray2[n5 + 1];
                        fArray[n6][2] = fArray2[n4];
                        fArray[n6][3] = fArray2[n4 + 1];
                    }
                    break block24;
                }
                if (this.columns != 2) break block24;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = 2 * n3;
                    fArray2[n2] = fArray[n3][0];
                    fArray2[n2 + 1] = fArray[n3][1];
                }
                this.fftRows.complexForward(fArray2, 0);
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = 2 * n3;
                    fArray[n3][0] = fArray2[n2];
                    fArray[n3][1] = fArray2[n2 + 1];
                }
                break block24;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.columns; i += 8) {
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    for (n17 = 0; n17 < this.rows; ++n17) {
                        n16 = 2 * n17;
                        n15 = 2 * this.rows + 2 * n17;
                        n14 = n15 + 2 * this.rows;
                        n13 = n14 + 2 * this.rows;
                        fArray2[n16] = fArray[n17][i];
                        fArray2[n16 + 1] = fArray[n17][i + 1];
                        fArray2[n15] = fArray[n17][i + 2];
                        fArray2[n15 + 1] = fArray[n17][i + 3];
                        fArray2[n14] = fArray[n17][i + 4];
                        fArray2[n14 + 1] = fArray[n17][i + 5];
                        fArray2[n13] = fArray[n17][i + 6];
                        fArray2[n13 + 1] = fArray[n17][i + 7];
                    }
                    this.fftRows.complexInverse(fArray2, 0, bl);
                    this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                    this.fftRows.complexInverse(fArray2, 4 * this.rows, bl);
                    this.fftRows.complexInverse(fArray2, 6 * this.rows, bl);
                    for (n17 = 0; n17 < this.rows; ++n17) {
                        n16 = 2 * n17;
                        n15 = 2 * this.rows + 2 * n17;
                        n14 = n15 + 2 * this.rows;
                        n13 = n14 + 2 * this.rows;
                        fArray[n17][i] = fArray2[n16];
                        fArray[n17][i + 1] = fArray2[n16 + 1];
                        fArray[n17][i + 2] = fArray2[n15];
                        fArray[n17][i + 3] = fArray2[n15 + 1];
                        fArray[n17][i + 4] = fArray2[n14];
                        fArray[n17][i + 5] = fArray2[n14 + 1];
                        fArray[n17][i + 6] = fArray2[n13];
                        fArray[n17][i + 7] = fArray2[n13 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int n18;
                int n19;
                int n20;
                for (n20 = 0; n20 < this.rows; ++n20) {
                    n19 = 2 * n20;
                    n18 = 2 * this.rows + 2 * n20;
                    fArray2[n19] = fArray[n20][0];
                    fArray2[n19 + 1] = fArray[n20][1];
                    fArray2[n18] = fArray[n20][2];
                    fArray2[n18 + 1] = fArray[n20][3];
                }
                this.fftRows.complexInverse(fArray2, 0, bl);
                this.fftRows.complexInverse(fArray2, 2 * this.rows, bl);
                for (n20 = 0; n20 < this.rows; ++n20) {
                    n19 = 2 * n20;
                    n18 = 2 * this.rows + 2 * n20;
                    fArray[n20][0] = fArray2[n19];
                    fArray[n20][1] = fArray2[n19 + 1];
                    fArray[n20][2] = fArray2[n18];
                    fArray[n20][3] = fArray2[n18 + 1];
                }
            } else if (this.columns == 2) {
                int n21;
                int n22;
                for (n22 = 0; n22 < this.rows; ++n22) {
                    n21 = 2 * n22;
                    fArray2[n21] = fArray[n22][0];
                    fArray2[n21 + 1] = fArray[n22][1];
                }
                this.fftRows.complexInverse(fArray2, 0, bl);
                for (n22 = 0; n22 < this.rows; ++n22) {
                    n21 = 2 * n22;
                    fArray[n22][0] = fArray2[n21];
                    fArray[n22][1] = fArray2[n21 + 1];
                }
            }
        }
    }

    private void xdft2d0_subth1(final int n, final int n2, final float[] fArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray, i * FloatFFT_2D.this.columns);
                            }
                        } else {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray, i * FloatFFT_2D.this.columns, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray, i * FloatFFT_2D.this.columns);
                        }
                    } else {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realInverse(fArray, i * FloatFFT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth1(final long l, final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (l == 0L) {
                        if (n == -1) {
                            for (long i = (long)n3; i < FloatFFT_2D.this.rowsl; i += (long)n2) {
                                FloatFFT_2D.this.fftColumns.complexForward(floatLargeArray, i * FloatFFT_2D.this.columnsl);
                            }
                        } else {
                            for (long i = (long)n3; i < FloatFFT_2D.this.rowsl; i += (long)n2) {
                                FloatFFT_2D.this.fftColumns.complexInverse(floatLargeArray, i * FloatFFT_2D.this.columnsl, bl);
                            }
                        }
                    } else if (n == 1) {
                        for (long i = (long)n3; i < FloatFFT_2D.this.rowsl; i += (long)n2) {
                            FloatFFT_2D.this.fftColumns.realForward(floatLargeArray, i * FloatFFT_2D.this.columnsl);
                        }
                    } else {
                        for (long i = (long)n3; i < FloatFFT_2D.this.rowsl; i += (long)n2) {
                            FloatFFT_2D.this.fftColumns.realInverse(floatLargeArray, i * FloatFFT_2D.this.columnsl, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth2(final int n, final int n2, final float[] fArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray, i * FloatFFT_2D.this.columns);
                            }
                        } else {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray, i * FloatFFT_2D.this.columns, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray, i * FloatFFT_2D.this.columns);
                        }
                    } else {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realInverse2(fArray, i * FloatFFT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth2(final long l, final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l2 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (l == 0L) {
                        if (n == -1) {
                            for (long i = l2; i < FloatFFT_2D.this.rowsl; i += (long)n2) {
                                FloatFFT_2D.this.fftColumns.complexForward(floatLargeArray, i * FloatFFT_2D.this.columnsl);
                            }
                        } else {
                            for (long i = l2; i < FloatFFT_2D.this.rowsl; i += (long)n2) {
                                FloatFFT_2D.this.fftColumns.complexInverse(floatLargeArray, i * FloatFFT_2D.this.columnsl, bl);
                            }
                        }
                    } else if (n == 1) {
                        for (long i = l2; i < FloatFFT_2D.this.rowsl; i += (long)n2) {
                            FloatFFT_2D.this.fftColumns.realForward(floatLargeArray, i * FloatFFT_2D.this.columnsl);
                        }
                    } else {
                        for (long i = l2; i < FloatFFT_2D.this.rowsl; i += (long)n2) {
                            FloatFFT_2D.this.fftColumns.realInverse2(floatLargeArray, i * FloatFFT_2D.this.columnsl, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth1(final int n, final int n2, final float[][] fArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray[i]);
                            }
                        } else {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray[i]);
                        }
                    } else {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realInverse(fArray[i], bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth2(final int n, final int n2, final float[][] fArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray[i]);
                            }
                        } else {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray[i]);
                        }
                    } else {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realInverse2(fArray[i], 0, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft2d_subth(final int n, final float[] fArray, final boolean bl) {
        int n2 = Math.min(this.columns / 2, ConcurrencyUtils.getNumberOfThreads());
        int n3 = 8 * this.rows;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        final int n5 = n2;
        for (int i = 0; i < n2; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        float[] fArray2;
                        block19: {
                            int n24;
                            int n2;
                            int n3;
                            block22: {
                                int n42;
                                int n52;
                                int n62;
                                int n7;
                                block20: {
                                    fArray2 = new float[n4];
                                    if (n != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * n5) break block20;
                                    for (int i = 8 * n6; i < FloatFFT_2D.this.columns; i += 8 * n5) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        int n11;
                                        int n12;
                                        int n13;
                                        for (n13 = 0; n13 < FloatFFT_2D.this.rows; ++n13) {
                                            n12 = n13 * FloatFFT_2D.this.columns + i;
                                            n11 = 2 * n13;
                                            n10 = 2 * FloatFFT_2D.this.rows + 2 * n13;
                                            n9 = n10 + 2 * FloatFFT_2D.this.rows;
                                            n8 = n9 + 2 * FloatFFT_2D.this.rows;
                                            fArray2[n11] = fArray[n12];
                                            fArray2[n11 + 1] = fArray[n12 + 1];
                                            fArray2[n10] = fArray[n12 + 2];
                                            fArray2[n10 + 1] = fArray[n12 + 3];
                                            fArray2[n9] = fArray[n12 + 4];
                                            fArray2[n9 + 1] = fArray[n12 + 5];
                                            fArray2[n8] = fArray[n12 + 6];
                                            fArray2[n8 + 1] = fArray[n12 + 7];
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(fArray2, 0);
                                        FloatFFT_2D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(fArray2, 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(fArray2, 6 * FloatFFT_2D.this.rows);
                                        for (n13 = 0; n13 < FloatFFT_2D.this.rows; ++n13) {
                                            n12 = n13 * FloatFFT_2D.this.columns + i;
                                            n11 = 2 * n13;
                                            n10 = 2 * FloatFFT_2D.this.rows + 2 * n13;
                                            n9 = n10 + 2 * FloatFFT_2D.this.rows;
                                            n8 = n9 + 2 * FloatFFT_2D.this.rows;
                                            fArray[n12] = fArray2[n11];
                                            fArray[n12 + 1] = fArray2[n11 + 1];
                                            fArray[n12 + 2] = fArray2[n10];
                                            fArray[n12 + 3] = fArray2[n10 + 1];
                                            fArray[n12 + 4] = fArray2[n9];
                                            fArray[n12 + 5] = fArray2[n9 + 1];
                                            fArray[n12 + 6] = fArray2[n8];
                                            fArray[n12 + 7] = fArray2[n8 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * n5) break block22;
                                for (n7 = 0; n7 < FloatFFT_2D.this.rows; ++n7) {
                                    n62 = n7 * FloatFFT_2D.this.columns + 4 * n6;
                                    n52 = 2 * n7;
                                    n42 = 2 * FloatFFT_2D.this.rows + 2 * n7;
                                    fArray2[n52] = fArray[n62];
                                    fArray2[n52 + 1] = fArray[n62 + 1];
                                    fArray2[n42] = fArray[n62 + 2];
                                    fArray2[n42 + 1] = fArray[n62 + 3];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(fArray2, 0);
                                FloatFFT_2D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_2D.this.rows);
                                for (n7 = 0; n7 < FloatFFT_2D.this.rows; ++n7) {
                                    n62 = n7 * FloatFFT_2D.this.columns + 4 * n6;
                                    n52 = 2 * n7;
                                    n42 = 2 * FloatFFT_2D.this.rows + 2 * n7;
                                    fArray[n62] = fArray2[n52];
                                    fArray[n62 + 1] = fArray2[n52 + 1];
                                    fArray[n62 + 2] = fArray2[n42];
                                    fArray[n62 + 3] = fArray2[n42 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * n5) break block21;
                            for (n3 = 0; n3 < FloatFFT_2D.this.rows; ++n3) {
                                n2 = n3 * FloatFFT_2D.this.columns + 2 * n6;
                                n24 = 2 * n3;
                                fArray2[n24] = fArray[n2];
                                fArray2[n24 + 1] = fArray[n2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(fArray2, 0);
                            for (n3 = 0; n3 < FloatFFT_2D.this.rows; ++n3) {
                                n2 = n3 * FloatFFT_2D.this.columns + 2 * n6;
                                n24 = 2 * n3;
                                fArray[n2] = fArray2[n24];
                                fArray[n2 + 1] = fArray2[n24 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * n5) {
                            for (int i = 8 * n6; i < FloatFFT_2D.this.columns; i += 8 * n5) {
                                int n25;
                                int n14;
                                int n15;
                                int n16;
                                int n17;
                                int n18;
                                for (n18 = 0; n18 < FloatFFT_2D.this.rows; ++n18) {
                                    n17 = n18 * FloatFFT_2D.this.columns + i;
                                    n16 = 2 * n18;
                                    n15 = 2 * FloatFFT_2D.this.rows + 2 * n18;
                                    n14 = n15 + 2 * FloatFFT_2D.this.rows;
                                    n25 = n14 + 2 * FloatFFT_2D.this.rows;
                                    fArray2[n16] = fArray[n17];
                                    fArray2[n16 + 1] = fArray[n17 + 1];
                                    fArray2[n15] = fArray[n17 + 2];
                                    fArray2[n15 + 1] = fArray[n17 + 3];
                                    fArray2[n14] = fArray[n17 + 4];
                                    fArray2[n14 + 1] = fArray[n17 + 5];
                                    fArray2[n25] = fArray[n17 + 6];
                                    fArray2[n25 + 1] = fArray[n17 + 7];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, 0, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_2D.this.rows, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, 4 * FloatFFT_2D.this.rows, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, 6 * FloatFFT_2D.this.rows, bl);
                                for (n18 = 0; n18 < FloatFFT_2D.this.rows; ++n18) {
                                    n17 = n18 * FloatFFT_2D.this.columns + i;
                                    n16 = 2 * n18;
                                    n15 = 2 * FloatFFT_2D.this.rows + 2 * n18;
                                    n14 = n15 + 2 * FloatFFT_2D.this.rows;
                                    n25 = n14 + 2 * FloatFFT_2D.this.rows;
                                    fArray[n17] = fArray2[n16];
                                    fArray[n17 + 1] = fArray2[n16 + 1];
                                    fArray[n17 + 2] = fArray2[n15];
                                    fArray[n17 + 3] = fArray2[n15 + 1];
                                    fArray[n17 + 4] = fArray2[n14];
                                    fArray[n17 + 5] = fArray2[n14 + 1];
                                    fArray[n17 + 6] = fArray2[n25];
                                    fArray[n17 + 7] = fArray2[n25 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * n5) {
                            int n26;
                            int n19;
                            int n20;
                            int n21;
                            for (n21 = 0; n21 < FloatFFT_2D.this.rows; ++n21) {
                                n20 = n21 * FloatFFT_2D.this.columns + 4 * n6;
                                n19 = 2 * n21;
                                n26 = 2 * FloatFFT_2D.this.rows + 2 * n21;
                                fArray2[n19] = fArray[n20];
                                fArray2[n19 + 1] = fArray[n20 + 1];
                                fArray2[n26] = fArray[n20 + 2];
                                fArray2[n26 + 1] = fArray[n20 + 3];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2, 0, bl);
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_2D.this.rows, bl);
                            for (n21 = 0; n21 < FloatFFT_2D.this.rows; ++n21) {
                                n20 = n21 * FloatFFT_2D.this.columns + 4 * n6;
                                n19 = 2 * n21;
                                n26 = 2 * FloatFFT_2D.this.rows + 2 * n21;
                                fArray[n20] = fArray2[n19];
                                fArray[n20 + 1] = fArray2[n19 + 1];
                                fArray[n20 + 2] = fArray2[n26];
                                fArray[n20 + 3] = fArray2[n26 + 1];
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * n5) {
                            int n27;
                            int n22;
                            int n23;
                            for (n23 = 0; n23 < FloatFFT_2D.this.rows; ++n23) {
                                n22 = n23 * FloatFFT_2D.this.columns + 2 * n6;
                                n27 = 2 * n23;
                                fArray2[n27] = fArray[n22];
                                fArray2[n27 + 1] = fArray[n22 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2, 0, bl);
                            for (n23 = 0; n23 < FloatFFT_2D.this.rows; ++n23) {
                                n22 = n23 * FloatFFT_2D.this.columns + 2 * n6;
                                n27 = 2 * n23;
                                fArray[n22] = fArray2[n27];
                                fArray[n22 + 1] = fArray2[n27 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft2d_subth(final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        int n2 = (int)Math.min(this.columnsl / 2L, (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 8L * this.rowsl;
        if (this.columnsl == 4L) {
            l >>= 1;
        } else if (this.columnsl < 4L) {
            l >>= 2;
        }
        final long l2 = l;
        Future[] futureArray = new Future[n2];
        final int n3 = n2;
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        FloatLargeArray floatLargeArray2;
                        block19: {
                            long l;
                            long l24;
                            long l32;
                            block22: {
                                long l4;
                                long l5;
                                long l6;
                                long l7;
                                block20: {
                                    floatLargeArray2 = new FloatLargeArray(l2, false);
                                    if (n != -1) break block19;
                                    if (FloatFFT_2D.this.columnsl <= (long)(4 * n3)) break block20;
                                    for (long i = 8L * l3; i < FloatFFT_2D.this.columnsl; i += (long)(8 * n3)) {
                                        long l8;
                                        long l9;
                                        long l10;
                                        long l11;
                                        long l12;
                                        long l13;
                                        for (l13 = 0L; l13 < FloatFFT_2D.this.rowsl; ++l13) {
                                            l12 = l13 * FloatFFT_2D.this.columnsl + i;
                                            l11 = 2L * l13;
                                            l10 = 2L * FloatFFT_2D.this.rowsl + 2L * l13;
                                            l9 = l10 + 2L * FloatFFT_2D.this.rowsl;
                                            l8 = l9 + 2L * FloatFFT_2D.this.rowsl;
                                            floatLargeArray2.setDouble(l11, floatLargeArray.getFloat(l12));
                                            floatLargeArray2.setDouble(l11 + 1L, floatLargeArray.getFloat(l12 + 1L));
                                            floatLargeArray2.setDouble(l10, floatLargeArray.getFloat(l12 + 2L));
                                            floatLargeArray2.setDouble(l10 + 1L, floatLargeArray.getFloat(l12 + 3L));
                                            floatLargeArray2.setDouble(l9, floatLargeArray.getFloat(l12 + 4L));
                                            floatLargeArray2.setDouble(l9 + 1L, floatLargeArray.getFloat(l12 + 5L));
                                            floatLargeArray2.setDouble(l8, floatLargeArray.getFloat(l12 + 6L));
                                            floatLargeArray2.setDouble(l8 + 1L, floatLargeArray.getFloat(l12 + 7L));
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2, 0L);
                                        FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2, 2L * FloatFFT_2D.this.rowsl);
                                        FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2, 4L * FloatFFT_2D.this.rowsl);
                                        FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2, 6L * FloatFFT_2D.this.rowsl);
                                        for (l13 = 0L; l13 < FloatFFT_2D.this.rowsl; ++l13) {
                                            l12 = l13 * FloatFFT_2D.this.columnsl + i;
                                            l11 = 2L * l13;
                                            l10 = 2L * FloatFFT_2D.this.rowsl + 2L * l13;
                                            l9 = l10 + 2L * FloatFFT_2D.this.rowsl;
                                            l8 = l9 + 2L * FloatFFT_2D.this.rowsl;
                                            floatLargeArray.setDouble(l12, floatLargeArray2.getFloat(l11));
                                            floatLargeArray.setDouble(l12 + 1L, floatLargeArray2.getFloat(l11 + 1L));
                                            floatLargeArray.setDouble(l12 + 2L, floatLargeArray2.getFloat(l10));
                                            floatLargeArray.setDouble(l12 + 3L, floatLargeArray2.getFloat(l10 + 1L));
                                            floatLargeArray.setDouble(l12 + 4L, floatLargeArray2.getFloat(l9));
                                            floatLargeArray.setDouble(l12 + 5L, floatLargeArray2.getFloat(l9 + 1L));
                                            floatLargeArray.setDouble(l12 + 6L, floatLargeArray2.getFloat(l8));
                                            floatLargeArray.setDouble(l12 + 7L, floatLargeArray2.getFloat(l8 + 1L));
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columnsl != (long)(4 * n3)) break block22;
                                for (l7 = 0L; l7 < FloatFFT_2D.this.rowsl; ++l7) {
                                    l6 = l7 * FloatFFT_2D.this.columnsl + 4L * l3;
                                    l5 = 2L * l7;
                                    l4 = 2L * FloatFFT_2D.this.rowsl + 2L * l7;
                                    floatLargeArray2.setDouble(l5, floatLargeArray.getFloat(l6));
                                    floatLargeArray2.setDouble(l5 + 1L, floatLargeArray.getFloat(l6 + 1L));
                                    floatLargeArray2.setDouble(l4, floatLargeArray.getFloat(l6 + 2L));
                                    floatLargeArray2.setDouble(l4 + 1L, floatLargeArray.getFloat(l6 + 3L));
                                }
                                FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2, 0L);
                                FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2, 2L * FloatFFT_2D.this.rowsl);
                                for (l7 = 0L; l7 < FloatFFT_2D.this.rowsl; ++l7) {
                                    l6 = l7 * FloatFFT_2D.this.columnsl + 4L * l3;
                                    l5 = 2L * l7;
                                    l4 = 2L * FloatFFT_2D.this.rowsl + 2L * l7;
                                    floatLargeArray.setDouble(l6, floatLargeArray2.getFloat(l5));
                                    floatLargeArray.setDouble(l6 + 1L, floatLargeArray2.getFloat(l5 + 1L));
                                    floatLargeArray.setDouble(l6 + 2L, floatLargeArray2.getFloat(l4));
                                    floatLargeArray.setDouble(l6 + 3L, floatLargeArray2.getFloat(l4 + 1L));
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columnsl != (long)(2 * n3)) break block21;
                            for (l32 = 0L; l32 < FloatFFT_2D.this.rowsl; ++l32) {
                                l24 = l32 * FloatFFT_2D.this.columnsl + 2L * l3;
                                l = 2L * l32;
                                floatLargeArray2.setDouble(l, floatLargeArray.getFloat(l24));
                                floatLargeArray2.setDouble(l + 1L, floatLargeArray.getFloat(l24 + 1L));
                            }
                            FloatFFT_2D.this.fftRows.complexForward(floatLargeArray2, 0L);
                            for (l32 = 0L; l32 < FloatFFT_2D.this.rowsl; ++l32) {
                                l24 = l32 * FloatFFT_2D.this.columnsl + 2L * l3;
                                l = 2L * l32;
                                floatLargeArray.setDouble(l24, floatLargeArray2.getFloat(l));
                                floatLargeArray.setDouble(l24 + 1L, floatLargeArray2.getFloat(l + 1L));
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columnsl > (long)(4 * n3)) {
                            for (long i = 8L * l3; i < FloatFFT_2D.this.columnsl; i += (long)(8 * n3)) {
                                long l;
                                long l14;
                                long l15;
                                long l16;
                                long l17;
                                long l18;
                                for (l18 = 0L; l18 < FloatFFT_2D.this.rowsl; ++l18) {
                                    l17 = l18 * FloatFFT_2D.this.columnsl + i;
                                    l16 = 2L * l18;
                                    l15 = 2L * FloatFFT_2D.this.rowsl + 2L * l18;
                                    l14 = l15 + 2L * FloatFFT_2D.this.rowsl;
                                    l = l14 + 2L * FloatFFT_2D.this.rowsl;
                                    floatLargeArray2.setDouble(l16, floatLargeArray.getFloat(l17));
                                    floatLargeArray2.setDouble(l16 + 1L, floatLargeArray.getFloat(l17 + 1L));
                                    floatLargeArray2.setDouble(l15, floatLargeArray.getFloat(l17 + 2L));
                                    floatLargeArray2.setDouble(l15 + 1L, floatLargeArray.getFloat(l17 + 3L));
                                    floatLargeArray2.setDouble(l14, floatLargeArray.getFloat(l17 + 4L));
                                    floatLargeArray2.setDouble(l14 + 1L, floatLargeArray.getFloat(l17 + 5L));
                                    floatLargeArray2.setDouble(l, floatLargeArray.getFloat(l17 + 6L));
                                    floatLargeArray2.setDouble(l + 1L, floatLargeArray.getFloat(l17 + 7L));
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, 2L * FloatFFT_2D.this.rowsl, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, 4L * FloatFFT_2D.this.rowsl, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, 6L * FloatFFT_2D.this.rowsl, bl);
                                for (l18 = 0L; l18 < FloatFFT_2D.this.rowsl; ++l18) {
                                    l17 = l18 * FloatFFT_2D.this.columnsl + i;
                                    l16 = 2L * l18;
                                    l15 = 2L * FloatFFT_2D.this.rowsl + 2L * l18;
                                    l14 = l15 + 2L * FloatFFT_2D.this.rowsl;
                                    l = l14 + 2L * FloatFFT_2D.this.rowsl;
                                    floatLargeArray.setDouble(l17, floatLargeArray2.getFloat(l16));
                                    floatLargeArray.setDouble(l17 + 1L, floatLargeArray2.getFloat(l16 + 1L));
                                    floatLargeArray.setDouble(l17 + 2L, floatLargeArray2.getFloat(l15));
                                    floatLargeArray.setDouble(l17 + 3L, floatLargeArray2.getFloat(l15 + 1L));
                                    floatLargeArray.setDouble(l17 + 4L, floatLargeArray2.getFloat(l14));
                                    floatLargeArray.setDouble(l17 + 5L, floatLargeArray2.getFloat(l14 + 1L));
                                    floatLargeArray.setDouble(l17 + 6L, floatLargeArray2.getFloat(l));
                                    floatLargeArray.setDouble(l17 + 7L, floatLargeArray2.getFloat(l + 1L));
                                }
                            }
                        } else if (FloatFFT_2D.this.columnsl == (long)(4 * n3)) {
                            long l;
                            long l19;
                            long l20;
                            long l21;
                            for (l21 = 0L; l21 < FloatFFT_2D.this.rowsl; ++l21) {
                                l20 = l21 * FloatFFT_2D.this.columnsl + 4L * l3;
                                l19 = 2L * l21;
                                l = 2L * FloatFFT_2D.this.rowsl + 2L * l21;
                                floatLargeArray2.setDouble(l19, floatLargeArray.getFloat(l20));
                                floatLargeArray2.setDouble(l19 + 1L, floatLargeArray.getFloat(l20 + 1L));
                                floatLargeArray2.setDouble(l, floatLargeArray.getFloat(l20 + 2L));
                                floatLargeArray2.setDouble(l + 1L, floatLargeArray.getFloat(l20 + 3L));
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                            FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, 2L * FloatFFT_2D.this.rowsl, bl);
                            for (l21 = 0L; l21 < FloatFFT_2D.this.rowsl; ++l21) {
                                l20 = l21 * FloatFFT_2D.this.columnsl + 4L * l3;
                                l19 = 2L * l21;
                                l = 2L * FloatFFT_2D.this.rowsl + 2L * l21;
                                floatLargeArray.setDouble(l20, floatLargeArray2.getFloat(l19));
                                floatLargeArray.setDouble(l20 + 1L, floatLargeArray2.getFloat(l19 + 1L));
                                floatLargeArray.setDouble(l20 + 2L, floatLargeArray2.getFloat(l));
                                floatLargeArray.setDouble(l20 + 3L, floatLargeArray2.getFloat(l + 1L));
                            }
                        } else if (FloatFFT_2D.this.columnsl == (long)(2 * n3)) {
                            long l;
                            long l22;
                            long l23;
                            for (l23 = 0L; l23 < FloatFFT_2D.this.rowsl; ++l23) {
                                l22 = l23 * FloatFFT_2D.this.columnsl + 2L * l3;
                                l = 2L * l23;
                                floatLargeArray2.setDouble(l, floatLargeArray.getFloat(l22));
                                floatLargeArray2.setDouble(l + 1L, floatLargeArray.getFloat(l22 + 1L));
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(floatLargeArray2, 0L, bl);
                            for (l23 = 0L; l23 < FloatFFT_2D.this.rowsl; ++l23) {
                                l22 = l23 * FloatFFT_2D.this.columnsl + 2L * l3;
                                l = 2L * l23;
                                floatLargeArray.setDouble(l22, floatLargeArray2.getFloat(l));
                                floatLargeArray.setDouble(l22 + 1L, floatLargeArray2.getFloat(l + 1L));
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft2d_subth(final int n, final float[][] fArray, final boolean bl) {
        int n2 = Math.min(this.columns / 2, ConcurrencyUtils.getNumberOfThreads());
        int n3 = 8 * this.rows;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        final int n5 = n2;
        for (int i = 0; i < n5; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        float[] fArray2;
                        block19: {
                            int n18;
                            int n2;
                            block22: {
                                int n3;
                                int n42;
                                int n52;
                                block20: {
                                    fArray2 = new float[n4];
                                    if (n != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * n5) break block20;
                                    for (int i = 8 * n6; i < FloatFFT_2D.this.columns; i += 8 * n5) {
                                        int n62;
                                        int n7;
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < FloatFFT_2D.this.rows; ++n10) {
                                            n9 = 2 * n10;
                                            n8 = 2 * FloatFFT_2D.this.rows + 2 * n10;
                                            n7 = n8 + 2 * FloatFFT_2D.this.rows;
                                            n62 = n7 + 2 * FloatFFT_2D.this.rows;
                                            fArray2[n9] = fArray[n10][i];
                                            fArray2[n9 + 1] = fArray[n10][i + 1];
                                            fArray2[n8] = fArray[n10][i + 2];
                                            fArray2[n8 + 1] = fArray[n10][i + 3];
                                            fArray2[n7] = fArray[n10][i + 4];
                                            fArray2[n7 + 1] = fArray[n10][i + 5];
                                            fArray2[n62] = fArray[n10][i + 6];
                                            fArray2[n62 + 1] = fArray[n10][i + 7];
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(fArray2, 0);
                                        FloatFFT_2D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(fArray2, 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(fArray2, 6 * FloatFFT_2D.this.rows);
                                        for (n10 = 0; n10 < FloatFFT_2D.this.rows; ++n10) {
                                            n9 = 2 * n10;
                                            n8 = 2 * FloatFFT_2D.this.rows + 2 * n10;
                                            n7 = n8 + 2 * FloatFFT_2D.this.rows;
                                            n62 = n7 + 2 * FloatFFT_2D.this.rows;
                                            fArray[n10][i] = fArray2[n9];
                                            fArray[n10][i + 1] = fArray2[n9 + 1];
                                            fArray[n10][i + 2] = fArray2[n8];
                                            fArray[n10][i + 3] = fArray2[n8 + 1];
                                            fArray[n10][i + 4] = fArray2[n7];
                                            fArray[n10][i + 5] = fArray2[n7 + 1];
                                            fArray[n10][i + 6] = fArray2[n62];
                                            fArray[n10][i + 7] = fArray2[n62 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * n5) break block22;
                                for (n52 = 0; n52 < FloatFFT_2D.this.rows; ++n52) {
                                    n42 = 2 * n52;
                                    n3 = 2 * FloatFFT_2D.this.rows + 2 * n52;
                                    fArray2[n42] = fArray[n52][4 * n6];
                                    fArray2[n42 + 1] = fArray[n52][4 * n6 + 1];
                                    fArray2[n3] = fArray[n52][4 * n6 + 2];
                                    fArray2[n3 + 1] = fArray[n52][4 * n6 + 3];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(fArray2, 0);
                                FloatFFT_2D.this.fftRows.complexForward(fArray2, 2 * FloatFFT_2D.this.rows);
                                for (n52 = 0; n52 < FloatFFT_2D.this.rows; ++n52) {
                                    n42 = 2 * n52;
                                    n3 = 2 * FloatFFT_2D.this.rows + 2 * n52;
                                    fArray[n52][4 * n6] = fArray2[n42];
                                    fArray[n52][4 * n6 + 1] = fArray2[n42 + 1];
                                    fArray[n52][4 * n6 + 2] = fArray2[n3];
                                    fArray[n52][4 * n6 + 3] = fArray2[n3 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * n5) break block21;
                            for (n2 = 0; n2 < FloatFFT_2D.this.rows; ++n2) {
                                n18 = 2 * n2;
                                fArray2[n18] = fArray[n2][2 * n6];
                                fArray2[n18 + 1] = fArray[n2][2 * n6 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(fArray2, 0);
                            for (n2 = 0; n2 < FloatFFT_2D.this.rows; ++n2) {
                                n18 = 2 * n2;
                                fArray[n2][2 * n6] = fArray2[n18];
                                fArray[n2][2 * n6 + 1] = fArray2[n18 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * n5) {
                            for (int i = 8 * n6; i < FloatFFT_2D.this.columns; i += 8 * n5) {
                                int n19;
                                int n11;
                                int n12;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < FloatFFT_2D.this.rows; ++n14) {
                                    n13 = 2 * n14;
                                    n12 = 2 * FloatFFT_2D.this.rows + 2 * n14;
                                    n11 = n12 + 2 * FloatFFT_2D.this.rows;
                                    n19 = n11 + 2 * FloatFFT_2D.this.rows;
                                    fArray2[n13] = fArray[n14][i];
                                    fArray2[n13 + 1] = fArray[n14][i + 1];
                                    fArray2[n12] = fArray[n14][i + 2];
                                    fArray2[n12 + 1] = fArray[n14][i + 3];
                                    fArray2[n11] = fArray[n14][i + 4];
                                    fArray2[n11 + 1] = fArray[n14][i + 5];
                                    fArray2[n19] = fArray[n14][i + 6];
                                    fArray2[n19 + 1] = fArray[n14][i + 7];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, 0, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_2D.this.rows, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, 4 * FloatFFT_2D.this.rows, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, 6 * FloatFFT_2D.this.rows, bl);
                                for (n14 = 0; n14 < FloatFFT_2D.this.rows; ++n14) {
                                    n13 = 2 * n14;
                                    n12 = 2 * FloatFFT_2D.this.rows + 2 * n14;
                                    n11 = n12 + 2 * FloatFFT_2D.this.rows;
                                    n19 = n11 + 2 * FloatFFT_2D.this.rows;
                                    fArray[n14][i] = fArray2[n13];
                                    fArray[n14][i + 1] = fArray2[n13 + 1];
                                    fArray[n14][i + 2] = fArray2[n12];
                                    fArray[n14][i + 3] = fArray2[n12 + 1];
                                    fArray[n14][i + 4] = fArray2[n11];
                                    fArray[n14][i + 5] = fArray2[n11 + 1];
                                    fArray[n14][i + 6] = fArray2[n19];
                                    fArray[n14][i + 7] = fArray2[n19 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * n5) {
                            int n20;
                            int n15;
                            int n16;
                            for (n16 = 0; n16 < FloatFFT_2D.this.rows; ++n16) {
                                n15 = 2 * n16;
                                n20 = 2 * FloatFFT_2D.this.rows + 2 * n16;
                                fArray2[n15] = fArray[n16][4 * n6];
                                fArray2[n15 + 1] = fArray[n16][4 * n6 + 1];
                                fArray2[n20] = fArray[n16][4 * n6 + 2];
                                fArray2[n20 + 1] = fArray[n16][4 * n6 + 3];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2, 0, bl);
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2, 2 * FloatFFT_2D.this.rows, bl);
                            for (n16 = 0; n16 < FloatFFT_2D.this.rows; ++n16) {
                                n15 = 2 * n16;
                                n20 = 2 * FloatFFT_2D.this.rows + 2 * n16;
                                fArray[n16][4 * n6] = fArray2[n15];
                                fArray[n16][4 * n6 + 1] = fArray2[n15 + 1];
                                fArray[n16][4 * n6 + 2] = fArray2[n20];
                                fArray[n16][4 * n6 + 3] = fArray2[n20 + 1];
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * n5) {
                            int n21;
                            int n17;
                            for (n17 = 0; n17 < FloatFFT_2D.this.rows; ++n17) {
                                n21 = 2 * n17;
                                fArray2[n21] = fArray[n17][2 * n6];
                                fArray2[n21 + 1] = fArray[n17][2 * n6 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2, 0, bl);
                            for (n17 = 0; n17 < FloatFFT_2D.this.rows; ++n17) {
                                n21 = 2 * n17;
                                fArray[n17][2 * n6] = fArray2[n21];
                                fArray[n17][2 * n6 + 1] = fArray2[n21 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void fillSymmetric(final float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 2 * this.columns;
        int n6 = this.rows / 2;
        for (n4 = this.rows - 1; n4 >= 1; --n4) {
            n3 = n4 * this.columns;
            n2 = 2 * n3;
            for (n = 0; n < this.columns; n += 2) {
                fArray[n2 + n] = fArray[n3 + n];
                fArray[n3 + n] = 0.0f;
                fArray[n2 + n + 1] = fArray[n3 + n + 1];
                fArray[n3 + n + 1] = 0.0f;
            }
        }
        n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && n6 >= n4) {
            Future[] futureArray = new Future[n4];
            int n7 = n6 / n4;
            final int n8 = 2 * this.columns;
            for (int i = 0; i < n4; ++i) {
                final int n9 = i == 0 ? i * n7 + 1 : i * n7;
                final int n10 = i * n7 + n7;
                final int n11 = i * n7;
                final int n12 = i == n4 - 1 ? i * n7 + n7 + 1 : i * n7 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        for (n6 = n9; n6 < n10; ++n6) {
                            n5 = n6 * n8;
                            n4 = (FloatFFT_2D.this.rows - n6) * n8;
                            n3 = n5 + FloatFFT_2D.this.columns;
                            fArray[n3] = fArray[n4 + 1];
                            fArray[n3 + 1] = -fArray[n4];
                        }
                        for (n6 = n9; n6 < n10; ++n6) {
                            n5 = n6 * n8;
                            n3 = (FloatFFT_2D.this.rows - n6 + 1) * n8;
                            for (n2 = FloatFFT_2D.this.columns + 2; n2 < n8; n2 += 2) {
                                n4 = n3 - n2;
                                n = n5 + n2;
                                fArray[n] = fArray[n4];
                                fArray[n + 1] = -fArray[n4 + 1];
                            }
                        }
                        for (n6 = n11; n6 < n12; ++n6) {
                            n3 = (FloatFFT_2D.this.rows - n6) % FloatFFT_2D.this.rows * n8;
                            n = n6 * n8;
                            for (n2 = 0; n2 < n8; n2 += 2) {
                                n5 = n3 + (n8 - n2) % n8;
                                n4 = n + n2;
                                fArray[n5] = fArray[n4];
                                fArray[n5 + 1] = -fArray[n4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n13;
            int n14;
            for (n = 1; n < n6; ++n) {
                n2 = n * n5;
                n14 = (this.rows - n) * n5;
                fArray[n2 + this.columns] = fArray[n14 + 1];
                fArray[n2 + this.columns + 1] = -fArray[n14];
            }
            for (n = 1; n < n6; ++n) {
                n2 = n * n5;
                n14 = (this.rows - n + 1) * n5;
                for (n13 = this.columns + 2; n13 < n5; n13 += 2) {
                    fArray[n2 + n13] = fArray[n14 - n13];
                    fArray[n2 + n13 + 1] = -fArray[n14 - n13 + 1];
                }
            }
            for (n = 0; n <= this.rows / 2; ++n) {
                n3 = n * n5;
                int n15 = (this.rows - n) % this.rows * n5;
                for (n13 = 0; n13 < n5; n13 += 2) {
                    n2 = n3 + n13;
                    n14 = n15 + (n5 - n13) % n5;
                    fArray[n14] = fArray[n2];
                    fArray[n14 + 1] = -fArray[n2 + 1];
                }
            }
        }
        fArray[this.columns] = -fArray[1];
        fArray[1] = 0.0f;
        n3 = n6 * n5;
        fArray[n3 + this.columns] = -fArray[n3 + 1];
        fArray[n3 + 1] = 0.0f;
        fArray[n3 + this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final FloatLargeArray floatLargeArray) {
        long l;
        long l2;
        long l3;
        long l4 = 2L * this.columnsl;
        long l5 = this.rowsl / 2L;
        for (long i = this.rowsl - 1L; i >= 1L; --i) {
            l3 = i * this.columnsl;
            l2 = 2L * l3;
            for (l = 0L; l < this.columnsl; l += 2L) {
                floatLargeArray.setDouble(l2 + l, floatLargeArray.getFloat(l3 + l));
                floatLargeArray.setDouble(l3 + l, 0.0);
                floatLargeArray.setDouble(l2 + l + 1L, floatLargeArray.getFloat(l3 + l + 1L));
                floatLargeArray.setDouble(l3 + l + 1L, 0.0);
            }
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && l5 >= (long)n) {
            Future[] futureArray = new Future[n];
            l = l5 / (long)n;
            final long l6 = 2L * this.columnsl;
            for (int i = 0; i < n; ++i) {
                final long l7 = i == 0 ? (long)i * l + 1L : (long)i * l;
                final long l8 = (long)i * l + l;
                final long l9 = (long)i * l;
                final long l10 = i == n - 1 ? (long)i * l + l + 1L : (long)i * l + l;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        long l;
                        long l2;
                        long l3;
                        long l4;
                        long l5;
                        long l62;
                        for (l62 = l7; l62 < l8; ++l62) {
                            l5 = l62 * l6;
                            l4 = (FloatFFT_2D.this.rowsl - l62) * l6;
                            l3 = l5 + FloatFFT_2D.this.columnsl;
                            floatLargeArray.setDouble(l3, floatLargeArray.getFloat(l4 + 1L));
                            floatLargeArray.setDouble(l3 + 1L, -floatLargeArray.getFloat(l4));
                        }
                        for (l62 = l7; l62 < l8; ++l62) {
                            l5 = l62 * l6;
                            l3 = (FloatFFT_2D.this.rowsl - l62 + 1L) * l6;
                            for (l2 = FloatFFT_2D.this.columnsl + 2L; l2 < l6; l2 += 2L) {
                                l4 = l3 - l2;
                                l = l5 + l2;
                                floatLargeArray.setDouble(l, floatLargeArray.getFloat(l4));
                                floatLargeArray.setDouble(l + 1L, -floatLargeArray.getFloat(l4 + 1L));
                            }
                        }
                        for (l62 = l9; l62 < l10; ++l62) {
                            l3 = (FloatFFT_2D.this.rowsl - l62) % FloatFFT_2D.this.rowsl * l6;
                            l = l62 * l6;
                            for (l2 = 0L; l2 < l6; l2 += 2L) {
                                l5 = l3 + (l6 - l2) % l6;
                                l4 = l + l2;
                                floatLargeArray.setDouble(l5, floatLargeArray.getFloat(l4));
                                floatLargeArray.setDouble(l5 + 1L, -floatLargeArray.getFloat(l4 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l11;
            long l12;
            long l13;
            for (l13 = 1L; l13 < l5; ++l13) {
                l2 = l13 * l4;
                l12 = (this.rowsl - l13) * l4;
                floatLargeArray.setDouble(l2 + this.columnsl, floatLargeArray.getFloat(l12 + 1L));
                floatLargeArray.setDouble(l2 + this.columnsl + 1L, -floatLargeArray.getFloat(l12));
            }
            for (l13 = 1L; l13 < l5; ++l13) {
                l2 = l13 * l4;
                l12 = (this.rowsl - l13 + 1L) * l4;
                for (l11 = this.columnsl + 2L; l11 < l4; l11 += 2L) {
                    floatLargeArray.setDouble(l2 + l11, floatLargeArray.getFloat(l12 - l11));
                    floatLargeArray.setDouble(l2 + l11 + 1L, -floatLargeArray.getFloat(l12 - l11 + 1L));
                }
            }
            for (l13 = 0L; l13 <= this.rowsl / 2L; ++l13) {
                l3 = l13 * l4;
                long l14 = (this.rowsl - l13) % this.rowsl * l4;
                for (l11 = 0L; l11 < l4; l11 += 2L) {
                    l2 = l3 + l11;
                    l12 = l14 + (l4 - l11) % l4;
                    floatLargeArray.setDouble(l12, floatLargeArray.getFloat(l2));
                    floatLargeArray.setDouble(l12 + 1L, -floatLargeArray.getFloat(l2 + 1L));
                }
            }
        }
        floatLargeArray.setDouble(this.columnsl, -floatLargeArray.getFloat(1L));
        floatLargeArray.setDouble(1L, 0.0);
        l3 = l5 * l4;
        floatLargeArray.setDouble(l3 + this.columnsl, -floatLargeArray.getFloat(l3 + 1L));
        floatLargeArray.setDouble(l3 + 1L, 0.0);
        floatLargeArray.setDouble(l3 + this.columnsl + 1L, 0.0);
    }

    private void fillSymmetric(final float[][] fArray) {
        final int n = 2 * this.columns;
        int n2 = this.rows / 2;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && n2 >= n3) {
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i == 0 ? i * n4 + 1 : i * n4;
                final int n6 = i * n4 + n4;
                final int n7 = i * n4;
                final int n8 = i == n3 - 1 ? i * n4 + n4 + 1 : i * n4 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int n9;
                        int n2;
                        int n3;
                        int n4;
                        for (n4 = n5; n4 < n6; ++n4) {
                            n3 = FloatFFT_2D.this.rows - n4;
                            fArray[n4][((FloatFFT_2D)FloatFFT_2D.this).columns] = fArray[n3][1];
                            fArray[n4][((FloatFFT_2D)FloatFFT_2D.this).columns + 1] = -fArray[n3][0];
                        }
                        for (n4 = n5; n4 < n6; ++n4) {
                            n3 = FloatFFT_2D.this.rows - n4;
                            for (n2 = FloatFFT_2D.this.columns + 2; n2 < n; n2 += 2) {
                                n9 = n - n2;
                                fArray[n4][n2] = fArray[n3][n9];
                                fArray[n4][n2 + 1] = -fArray[n3][n9 + 1];
                            }
                        }
                        for (n4 = n7; n4 < n8; ++n4) {
                            n3 = (FloatFFT_2D.this.rows - n4) % FloatFFT_2D.this.rows;
                            for (n2 = 0; n2 < n; n2 += 2) {
                                n9 = (n - n2) % n;
                                fArray[n3][n9] = fArray[n4][n2];
                                fArray[n3][n9 + 1] = -fArray[n4][n2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            for (n12 = 1; n12 < n2; ++n12) {
                n11 = this.rows - n12;
                fArray[n12][this.columns] = fArray[n11][1];
                fArray[n12][this.columns + 1] = -fArray[n11][0];
            }
            for (n12 = 1; n12 < n2; ++n12) {
                n11 = this.rows - n12;
                for (n10 = this.columns + 2; n10 < n; n10 += 2) {
                    n9 = n - n10;
                    fArray[n12][n10] = fArray[n11][n9];
                    fArray[n12][n10 + 1] = -fArray[n11][n9 + 1];
                }
            }
            for (n12 = 0; n12 <= this.rows / 2; ++n12) {
                n11 = (this.rows - n12) % this.rows;
                for (n10 = 0; n10 < n; n10 += 2) {
                    n9 = (n - n10) % n;
                    fArray[n11][n9] = fArray[n12][n10];
                    fArray[n11][n9 + 1] = -fArray[n12][n10 + 1];
                }
            }
        }
        fArray[0][this.columns] = -fArray[0][1];
        fArray[0][1] = 0.0f;
        fArray[n2][this.columns] = -fArray[n2][1];
        fArray[n2][1] = 0.0f;
        fArray[n2][this.columns + 1] = 0.0f;
    }
}

