/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin;

import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginImageAnalysis;
import icy.plugin.interface_.PluginNoEDTConstructor;
import icy.plugin.interface_.PluginStartAsThread;
import icy.plugin.interface_.PluginThreaded;
import icy.system.IcyExceptionHandler;
import icy.system.audit.Audit;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import java.util.concurrent.Callable;

public class PluginLauncher {
    private static void internalExecute(Plugin plugin) throws Exception {
        if (plugin instanceof PluginThreaded) {
            if (Icy.getMainInterface().isHeadLess()) {
                ((PluginThreaded)((Object)plugin)).run();
            } else {
                new Thread((Runnable)((PluginThreaded)((Object)plugin)), plugin.getName()).start();
            }
        } else {
            PluginExecutor executor = new PluginExecutor(plugin);
            if (Icy.getMainInterface().isHeadLess()) {
                executor.call();
            } else if (plugin instanceof PluginStartAsThread) {
                new Thread((Runnable)executor, plugin.getName()).start();
            } else {
                ThreadUtil.invokeNow(executor);
            }
        }
    }

    public static Plugin create(PluginDescriptor plugin, boolean register) throws Exception {
        final Class<? extends Plugin> clazz = plugin.getPluginClass();
        Plugin result = ClassUtil.isSubClass(clazz, PluginNoEDTConstructor.class) || Icy.getMainInterface().isHeadLess() ? clazz.newInstance() : ThreadUtil.invokeNow(new Callable<Plugin>(){

            @Override
            public Plugin call() throws Exception {
                return (Plugin)clazz.newInstance();
            }
        });
        if (register) {
            Icy.getMainInterface().registerPlugin(result);
        }
        return result;
    }

    public static Plugin create(PluginDescriptor plugin) throws Exception {
        return PluginLauncher.create(plugin, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Plugin start(PluginDescriptor plugin) {
        try {
            Plugin result;
            try {
                result = PluginLauncher.create(plugin);
            }
            catch (IllegalAccessException e) {
                System.err.println("Cannot start plugin " + plugin.getName() + " :");
                System.err.println(e.getMessage());
                return null;
            }
            catch (InstantiationException e) {
                System.err.println("Cannot start plugin " + plugin.getName() + " :");
                System.err.println(e.getMessage());
                return null;
            }
            Audit.pluginLaunched(result);
            if (!(result instanceof PluginImageAnalysis)) return result;
            PluginLauncher.internalExecute(result);
            return result;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (Throwable t) {
            IcyExceptionHandler.handleException(plugin, t, true);
        }
        return null;
    }

    @Deprecated
    public static Plugin start(String pluginClassName) {
        PluginDescriptor plugin = PluginLoader.getPlugin(pluginClassName);
        if (plugin != null) {
            return PluginLauncher.start(plugin);
        }
        return null;
    }

    public static Plugin startSafe(PluginDescriptor plugin) throws Exception {
        Plugin result = PluginLauncher.create(plugin);
        Audit.pluginLaunched(result);
        if (result instanceof PluginImageAnalysis) {
            PluginLauncher.internalExecute(result);
        }
        return result;
    }

    @Deprecated
    public static Plugin startSafe(String pluginClassName) throws Exception {
        PluginDescriptor plugin = PluginLoader.getPlugin(pluginClassName);
        if (plugin != null) {
            return PluginLauncher.startSafe(plugin);
        }
        return null;
    }

    @Deprecated
    public static synchronized void launch(PluginDescriptor descriptor) {
        PluginLauncher.start(descriptor);
    }

    protected static class PluginExecutor
    implements Callable<Boolean>,
    Runnable {
        final Plugin plugin;

        public PluginExecutor(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public Boolean call() throws Exception {
            if (this.plugin instanceof PluginImageAnalysis) {
                ((PluginImageAnalysis)((Object)this.plugin)).compute();
            }
            return Boolean.TRUE;
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException(this.plugin.getDescriptor(), t, true);
            }
        }
    }
}

