/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnake.rsc;

import icy.image.ImageUtil;

import java.awt.Image;

import plugins.big.bigsnake.rsc.icon.SnakeIcons;

/**
 * Manager the interaction with the resourced embedded in the jar.
 * 
 * @version May 3, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class ResourceUtil {

	/** The unique instance of ResourceUtil (Singleton design pattern). */
	private static ResourceUtil instance_ = null;

	// ============================================================================
	// PUBLIC METHODS

	/** Get Settings instance */
	static public ResourceUtil getInstance() {
		if (instance_ == null) {
			instance_ = new ResourceUtil();
		}
		return instance_;
	}

	// ----------------------------------------------------------------------------

	/** Returns an image with the banner of the plug-in. */
	public Image getAboutBanner() {
		return ImageUtil.load(this.getClass().getResourceAsStream(
				"snakes_about.png"));
	}

	// ----------------------------------------------------------------------------

	/** Returns an image the icon of the plug-in. */
	public Image getIcon(SnakeIcons icon) {
		switch (icon) {
		case OUROBOROS16:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/ouroboros16.png"));
		case OUROBOROS24:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/ouroboros24.png"));
		case OUROBOROS32:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/ouroboros32.png"));
		case OUROBOROS48:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/ouroboros48.png"));
		case OUROBOROS64:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/ouroboros64.png"));
		case OUROBOROS128:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/ouroboros128.png"));
		case OUROBOROS256:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/ouroboros256.png"));
		default:
			return null;
		}
	}
}
