/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.painter.OverlayEvent;
import icy.painter.OverlayListener;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ROI3DStack<R extends ROI2D>
extends ROI3D
implements ROIListener,
OverlayListener,
Iterable<R> {
    @Deprecated
    public static final String PROPERTY_USECHILDCOLOR = "useChildColor";
    protected final TreeMap<Integer, R> slices = new TreeMap();
    protected final Class<? extends R> roiClass;
    protected Semaphore modifyingSlice;
    protected double translateZ;

    public ROI3DStack(Class<? extends R> roiClass) {
        this.roiClass = roiClass;
        this.modifyingSlice = new Semaphore(1);
        this.translateZ = 0.0;
    }

    @Override
    public String getDefaultName() {
        return "ROI2D stack";
    }

    @Override
    protected ROI.ROIPainter createPainter() {
        return new ROI3DStackPainter();
    }

    protected R createSlice() {
        try {
            return (R)((ROI2D)this.roiClass.newInstance());
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, true, true);
            return null;
        }
    }

    public boolean getUseChildColor() {
        return ((ROI3DStackPainter)this.getOverlay()).getUseChildColor();
    }

    public void setUseChildColor(boolean value) {
        ((ROI3DStackPainter)this.getOverlay()).setUseChildColor(value);
    }

    public void setColor(int z, Color value) {
        ((ROI3DStackPainter)this.getOverlay()).setColor(z, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCreating(boolean value) {
        this.beginUpdate();
        try {
            super.setCreating(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.setCreating(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean value) {
        this.beginUpdate();
        try {
            super.setReadOnly(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.setReadOnly(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocused(boolean value) {
        this.beginUpdate();
        try {
            super.setFocused(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.setFocused(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelected(boolean value) {
        this.beginUpdate();
        try {
            super.setSelected(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.setSelected(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        this.beginUpdate();
        try {
            super.setName(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.setName(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setT(int value) {
        this.beginUpdate();
        try {
            super.setT(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.setT(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setC(int value) {
        this.beginUpdate();
        try {
            super.setC(value);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.setC(value);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.slices.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSizeZ() {
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            block4: {
                if (!this.slices.isEmpty()) break block4;
                return 0;
            }
            return this.slices.lastKey() - this.slices.firstKey() + 1;
        }
    }

    public R getSlice(int z) {
        return (R)((ROI2D)this.slices.get(z));
    }

    public R getSlice(int z, boolean createIfNull) {
        R result = this.getSlice(z);
        if (result == null && createIfNull && (result = this.createSlice()) != null) {
            this.setSlice(z, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlice(int z, R roi2d) {
        if (this.getSlice(z) == roi2d) {
            return;
        }
        this.removeSlice(z);
        if (roi2d != null) {
            ((ROI)roi2d).beginUpdate();
            try {
                ((ROI2D)roi2d).setZ(z);
                ((ROI2D)roi2d).setT(this.getT());
                ((ROI2D)roi2d).setC(this.getC());
            }
            finally {
                ((ROI)roi2d).endUpdate();
            }
            ((ROI)roi2d).addListener(this);
            ((ROI)roi2d).getOverlay().addOverlayListener(this);
            TreeMap<Integer, R> treeMap = this.slices;
            synchronized (treeMap) {
                this.slices.put(z, roi2d);
            }
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R removeSlice(int z) {
        ROI2D result;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            result = (ROI2D)this.slices.remove(z);
        }
        if (result != null) {
            result.removeListener(this);
            result.getOverlay().removeOverlayListener(this);
            this.roiChanged(true);
        }
        return (R)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            for (ROI2D slice : this.slices.values()) {
                slice.removeListener(this);
                slice.getOverlay().removeOverlayListener(this);
            }
            this.slices.clear();
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ROI3DStack<R> roi) throws UnsupportedOperationException {
        this.beginUpdate();
        try {
            TreeMap<Integer, R> treeMap = this.slices;
            synchronized (treeMap) {
                for (Map.Entry<Integer, R> entry : roi.slices.entrySet()) {
                    this.add(entry.getKey(), (ROI2D)entry.getValue());
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveAdd(ROI3DStack<R> roi) throws UnsupportedOperationException {
        this.beginUpdate();
        try {
            TreeMap<Integer, R> treeMap = this.slices;
            synchronized (treeMap) {
                for (Map.Entry<Integer, R> entry : roi.slices.entrySet()) {
                    this.exclusiveAdd(entry.getKey(), (ROI2D)entry.getValue());
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(ROI3DStack<R> roi) throws UnsupportedOperationException {
        this.beginUpdate();
        try {
            TreeMap<Integer, R> treeMap = this.slices;
            synchronized (treeMap) {
                Set<Integer> keys = roi.slices.keySet();
                HashSet<Integer> toRemove = new HashSet<Integer>();
                for (Integer n : this.slices.keySet()) {
                    if (keys.contains(n)) continue;
                    toRemove.add(n);
                }
                for (Integer n : toRemove) {
                    this.removeSlice(n);
                }
                for (Map.Entry entry : roi.slices.entrySet()) {
                    this.intersect((Integer)entry.getKey(), (ROI2D)entry.getValue());
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(ROI3DStack<R> roi) throws UnsupportedOperationException {
        this.beginUpdate();
        try {
            TreeMap<Integer, R> treeMap = this.slices;
            synchronized (treeMap) {
                for (Map.Entry<Integer, R> entry : roi.slices.entrySet()) {
                    this.subtract(entry.getKey(), (ROI2D)entry.getValue());
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public ROI add(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        ROI2D roi2d;
        if (roi instanceof ROI3D) {
            ROI3D roi3d = (ROI3D)roi;
            if (this.getT() == roi3d.getT() && this.getC() == roi3d.getC() && this.getClass().isInstance(roi3d)) {
                this.add((ROI3DStack)roi3d);
                return this;
            }
        } else if (this.roiClass.isInstance(roi) && (roi2d = (ROI2D)roi).getZ() != -1 && this.getT() == roi2d.getT() && this.getC() == roi2d.getC()) {
            try {
                this.add(roi2d.getZ(), roi2d);
                return this;
            }
            catch (UnsupportedOperationException e) {
                return super.add(roi, allowCreate);
            }
        }
        return super.add(roi, allowCreate);
    }

    @Override
    public ROI intersect(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI3D) {
            ROI2D roi2d;
            ROI3D roi3d = (ROI3D)roi;
            if (this.getT() == roi3d.getT() && this.getC() == roi3d.getC()) {
                if (this.getClass().isInstance(roi3d)) {
                    this.intersect((ROI3DStack)roi3d);
                    return this;
                }
            } else if (this.roiClass.isInstance(roi) && (roi2d = (ROI2D)roi).getZ() != -1 && this.getT() == roi2d.getT() && this.getC() == roi2d.getC()) {
                try {
                    this.intersect(roi2d.getZ(), roi2d);
                    return this;
                }
                catch (UnsupportedOperationException e) {
                    return super.intersect(roi, allowCreate);
                }
            }
        }
        return super.intersect(roi, allowCreate);
    }

    @Override
    public ROI exclusiveAdd(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI3D) {
            ROI2D roi2d;
            ROI3D roi3d = (ROI3D)roi;
            if (this.getT() == roi3d.getT() && this.getC() == roi3d.getC()) {
                if (this.getClass().isInstance(roi3d)) {
                    this.exclusiveAdd((ROI3DStack)roi3d);
                    return this;
                }
            } else if (this.roiClass.isInstance(roi) && (roi2d = (ROI2D)roi).getZ() != -1 && this.getT() == roi2d.getT() && this.getC() == roi2d.getC()) {
                try {
                    this.exclusiveAdd(roi2d.getZ(), roi2d);
                    return this;
                }
                catch (UnsupportedOperationException e) {
                    return super.add(roi, allowCreate);
                }
            }
        }
        return super.add(roi, allowCreate);
    }

    @Override
    public ROI subtract(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI3D) {
            ROI2D roi2d;
            ROI3D roi3d = (ROI3D)roi;
            if (this.getT() == roi3d.getT() && this.getC() == roi3d.getC()) {
                if (this.getClass().isInstance(roi3d)) {
                    this.subtract((ROI3DStack)roi3d);
                    return this;
                }
            } else if (this.roiClass.isInstance(roi) && (roi2d = (ROI2D)roi).getZ() != -1 && this.getT() == roi2d.getT() && this.getC() == roi2d.getC()) {
                try {
                    this.subtract(roi2d.getZ(), roi2d);
                    return this;
                }
                catch (UnsupportedOperationException e) {
                    return super.subtract(roi, allowCreate);
                }
            }
        }
        return super.subtract(roi, allowCreate);
    }

    public void add(int z, R roiSlice) {
        ROI newSlice;
        if (roiSlice == null) {
            return;
        }
        R currentSlice = this.getSlice(z);
        if (currentSlice != null) {
            ((ROI2D)roiSlice).setZ(z);
            ((ROI2D)roiSlice).setT(this.getT());
            ((ROI2D)roiSlice).setC(this.getC());
            newSlice = ((ROI)currentSlice).add((ROI)roiSlice, true);
            if (!newSlice.getClass().isInstance(currentSlice)) {
                throw new UnsupportedOperationException("Can't add the result of the merge operation on 2D slice " + z + ": " + newSlice.getClassName());
            }
        } else {
            newSlice = ((ROI)roiSlice).getCopy();
        }
        this.setSlice(z, (ROI2D)newSlice);
    }

    public void exclusiveAdd(int z, R roiSlice) {
        ROI newSlice;
        if (roiSlice == null) {
            return;
        }
        R currentSlice = this.getSlice(z);
        if (currentSlice != null) {
            ((ROI2D)roiSlice).setZ(z);
            ((ROI2D)roiSlice).setT(this.getT());
            ((ROI2D)roiSlice).setC(this.getC());
            newSlice = ((ROI)currentSlice).exclusiveAdd((ROI)roiSlice, true);
            if (!newSlice.getClass().isInstance(currentSlice)) {
                throw new UnsupportedOperationException("Can't add the result of the merge operation on 2D slice " + z + ": " + newSlice.getClassName());
            }
        } else {
            newSlice = ((ROI)roiSlice).getCopy();
        }
        if (newSlice.isEmpty()) {
            this.removeSlice(z);
        } else {
            this.setSlice(z, (ROI2D)newSlice);
        }
    }

    public void intersect(int z, R roiSlice) {
        if (roiSlice == null) {
            throw new IllegalArgumentException("Cannot intersect an empty slice in a 3D ROI");
        }
        R currentSlice = this.getSlice(z);
        if (currentSlice != null) {
            ((ROI2D)roiSlice).setZ(z);
            ((ROI2D)roiSlice).setT(this.getT());
            ((ROI2D)roiSlice).setC(this.getC());
            ROI newSlice = ((ROI)currentSlice).intersect((ROI)roiSlice, true);
            if (!newSlice.getClass().isInstance(currentSlice)) {
                throw new UnsupportedOperationException("Can't add the result of the merge operation on 2D slice " + z + ": " + newSlice.getClassName());
            }
            if (newSlice.isEmpty()) {
                this.removeSlice(z);
            } else {
                this.setSlice(z, (ROI2D)newSlice);
            }
        }
    }

    public void subtract(int z, R roiSlice) throws UnsupportedOperationException {
        if (roiSlice == null) {
            return;
        }
        R currentSlice = this.getSlice(z);
        if (currentSlice != null) {
            ((ROI2D)roiSlice).setZ(z);
            ((ROI2D)roiSlice).setT(this.getT());
            ((ROI2D)roiSlice).setC(this.getC());
            ROI newSlice = ((ROI)currentSlice).subtract((ROI)roiSlice, true);
            if (!newSlice.getClass().isInstance(currentSlice)) {
                throw new UnsupportedOperationException("Can't add the result of the merge operation on 2D slice " + z + ": " + newSlice.getClassName());
            }
            if (newSlice.isEmpty()) {
                this.removeSlice(z);
            } else {
                this.setSlice(z, (ROI2D)newSlice);
            }
        }
    }

    protected void sliceChanged(ROIEvent event) {
        if (this.modifyingSlice.availablePermits() <= 0) {
            return;
        }
        ROI source = event.getSource();
        switch (event.getType()) {
            case ROI_CHANGED: {
                this.roiChanged(true);
                break;
            }
            case FOCUS_CHANGED: {
                this.setFocused(source.isFocused());
                break;
            }
            case SELECTION_CHANGED: {
                this.setSelected(source.isSelected());
                break;
            }
            case PROPERTY_CHANGED: {
                String propertyName = event.getPropertyName();
                if (propertyName == null || propertyName.equals("readOnly")) {
                    this.setReadOnly(source.isReadOnly());
                }
                if (propertyName != null && !propertyName.equals("creating")) break;
                this.setCreating(source.isCreating());
            }
        }
    }

    protected void sliceOverlayChanged(OverlayEvent event) {
        switch (event.getType()) {
            case PAINTER_CHANGED: {
                this.getOverlay().painterChanged();
                break;
            }
            case PROPERTY_CHANGED: {
                this.getOverlay().propertyChanged(event.getPropertyName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle3D computeBounds3D() {
        int sizeZ;
        int z;
        Rectangle2D xyBounds = null;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            for (ROI2D slice : this.slices.values()) {
                Rectangle2D bnd2d = slice.getBounds2D();
                if (bnd2d.isEmpty()) continue;
                if (xyBounds == null) {
                    xyBounds = (Rectangle2D)bnd2d.clone();
                    continue;
                }
                xyBounds.add(bnd2d);
            }
        }
        if (xyBounds == null) {
            xyBounds = new Rectangle2D.Double();
        }
        if (!this.slices.isEmpty()) {
            z = this.slices.firstKey();
            sizeZ = this.getSizeZ();
        } else {
            z = 0;
            sizeZ = 0;
        }
        return new Rectangle3D.Double(xyBounds.getX(), xyBounds.getY(), z, xyBounds.getWidth(), xyBounds.getHeight(), sizeZ);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        R roi2d = this.getSlice((int)Math.floor(z));
        if (roi2d != null) {
            return ((ROI2D)roi2d).contains(x, y);
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        Rectangle3D bounds = this.getBounds3D();
        if (!bounds.contains(x, y, z, sizeX, sizeY, sizeZ)) {
            return false;
        }
        int lim = (int)Math.floor(z + sizeZ);
        int zc = (int)Math.floor(z);
        while (zc < lim) {
            R roi2d = this.getSlice(zc);
            if (roi2d == null || !((ROI2D)roi2d).contains(x, y, sizeX, sizeY)) {
                return false;
            }
            ++zc;
        }
        return true;
    }

    @Override
    public boolean intersects(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        Rectangle3D bounds = this.getBounds3D();
        if (!bounds.intersects(x, y, z, sizeX, sizeY, sizeZ)) {
            return false;
        }
        int lim = (int)Math.floor(z + sizeZ);
        int zc = (int)Math.floor(z);
        while (zc < lim) {
            R roi2d = this.getSlice(zc);
            if (roi2d != null && ((ROI2D)roi2d).intersects(x, y, sizeX, sizeY)) {
                return true;
            }
            ++zc;
        }
        return false;
    }

    @Override
    public boolean hasSelectedPoint() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unselectAllPoints() {
        this.beginUpdate();
        try {
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.unselectAllPoints();
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeSurfaceArea(Sequence sequence) throws UnsupportedOperationException {
        double result = 0.0;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            if (!this.slices.isEmpty()) {
                double psx = sequence.getPixelSizeX();
                double psy = sequence.getPixelSizeY();
                double psz = sequence.getPixelSizeZ();
                result = ((ROI2D)this.slices.firstEntry().getValue()).getNumberOfPoints() * psx * psy;
                result += ((ROI2D)this.slices.lastEntry().getValue()).getNumberOfPoints() * psx * psy;
                for (ROI2D slice : this.slices.values()) {
                    result += slice.getLength(sequence) * psz;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeNumberOfContourPoints() {
        double result = 0.0;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            if (this.slices.size() <= 2) {
                for (ROI2D slice : this.slices.values()) {
                    result += slice.getNumberOfPoints();
                }
            } else {
                Map.Entry<Integer, R> firstEntry = this.slices.firstEntry();
                Map.Entry<Integer, R> lastEntry = this.slices.lastEntry();
                Integer firstKey = firstEntry.getKey();
                Integer lastKey = lastEntry.getKey();
                result = ((ROI2D)firstEntry.getValue()).getNumberOfPoints();
                for (ROI2D slice : this.slices.subMap(firstKey, false, lastKey, false).values()) {
                    result += slice.getNumberOfContourPoints();
                }
                result += ((ROI2D)lastEntry.getValue()).getNumberOfPoints();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeNumberOfPoints() {
        double volume = 0.0;
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            for (ROI2D slice : this.slices.values()) {
                volume += slice.getNumberOfPoints();
            }
        }
        return volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canTranslate() {
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            if (!this.slices.isEmpty()) {
                return ((ROI2D)this.slices.firstEntry().getValue()).canTranslate();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(int z) {
        if (z == 0 || this.isEmpty()) {
            return;
        }
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            HashMap<Integer, R> map = new HashMap<Integer, R>(this.slices);
            this.slices.clear();
            for (Map.Entry entry : map.entrySet()) {
                ROI2D roi = (ROI2D)entry.getValue();
                int newZ = roi.getZ() + z;
                roi.setZ(newZ);
                this.slices.put(newZ, roi);
            }
        }
        this.roiChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(double dx, double dy, double dz) {
        this.beginUpdate();
        try {
            this.translateZ += dz;
            int dzi = (int)this.translateZ;
            this.translateZ -= (double)dzi;
            this.translate(dzi);
            this.modifyingSlice.acquireUninterruptibly();
            try {
                TreeMap<Integer, R> treeMap = this.slices;
                synchronized (treeMap) {
                    for (ROI2D slice : this.slices.values()) {
                        slice.translate(dx, dy);
                    }
                }
            }
            finally {
                this.modifyingSlice.release();
            }
            if (dx != 0.0 || dy != 0.0) {
                this.roiChanged(false);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, boolean inclusive) {
        R roi2d = this.getSlice(z);
        if (roi2d != null) {
            return ((ROI2D)roi2d).getBooleanMask(x, y, width, height, inclusive);
        }
        return new boolean[width * height];
    }

    @Override
    public BooleanMask2D getBooleanMask2D(int z, boolean inclusive) {
        R roi2d = this.getSlice(z);
        if (roi2d != null) {
            return ((ROI2D)roi2d).getBooleanMask(inclusive);
        }
        return new BooleanMask2D(new Rectangle(), new boolean[0]);
    }

    @Override
    public void roiChanged(ROIEvent event) {
        this.sliceChanged(event);
    }

    @Override
    public void overlayChanged(OverlayEvent event) {
        this.sliceOverlayChanged(event);
    }

    @Override
    public Iterator<R> iterator() {
        return this.slices.values().iterator();
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.clear();
            for (Element e : XMLUtil.getElements(node, "slice")) {
                R slice = this.createSlice();
                if (slice == null || !((ROI2D)slice).loadFromXML(e)) {
                    return false;
                }
                this.setSlice(((ROI2D)slice).getZ(), slice);
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        TreeMap<Integer, R> treeMap = this.slices;
        synchronized (treeMap) {
            Element sliceNode;
            ROI2D slice;
            Iterator<R> iterator = this.slices.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((slice = (ROI2D)iterator.next()).saveToXML(sliceNode = XMLUtil.addElement(node, "slice")));
            return false;
        }
    }

    public class ROI3DStackPainter
    extends ROI3D.ROI3DPainter {
        protected ROI.ROIPainter getSliceOverlayForCanvas(IcyCanvas canvas) {
            int z = canvas.getPositionZ();
            if (z >= 0) {
                return this.getSliceOverlay(z);
            }
            return null;
        }

        protected ROI.ROIPainter getSliceOverlay(int z) {
            Object roi = ROI3DStack.this.getSlice(z);
            if (roi != null) {
                return ((ROI)roi).getOverlay();
            }
            return null;
        }

        @Deprecated
        public boolean getUseChildColor() {
            return false;
        }

        @Deprecated
        public void setUseChildColor(boolean value) {
        }

        public void setColor(int z, Color value) {
            ROI.ROIPainter sliceOverlay = this.getSliceOverlay(z);
            if (sliceOverlay != null) {
                ROI3DStack.this.modifyingSlice.acquireUninterruptibly();
                try {
                    sliceOverlay.setColor(value);
                }
                finally {
                    ROI3DStack.this.modifyingSlice.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setColor(Color value) {
            block10: {
                this.beginUpdate();
                try {
                    super.setColor(value);
                    if (this.getUseChildColor()) break block10;
                    ROI3DStack.this.modifyingSlice.acquireUninterruptibly();
                    try {
                        TreeMap treeMap = ROI3DStack.this.slices;
                        synchronized (treeMap) {
                            for (ROI2D slice : ROI3DStack.this.slices.values()) {
                                slice.getOverlay().setColor(value);
                            }
                        }
                    }
                    finally {
                        ROI3DStack.this.modifyingSlice.release();
                    }
                }
                finally {
                    this.endUpdate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOpacity(float value) {
            this.beginUpdate();
            try {
                super.setOpacity(value);
                ROI3DStack.this.modifyingSlice.acquireUninterruptibly();
                try {
                    TreeMap treeMap = ROI3DStack.this.slices;
                    synchronized (treeMap) {
                        for (ROI2D slice : ROI3DStack.this.slices.values()) {
                            slice.getOverlay().setOpacity(value);
                        }
                    }
                }
                finally {
                    ROI3DStack.this.modifyingSlice.release();
                }
            }
            finally {
                this.endUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStroke(double value) {
            this.beginUpdate();
            try {
                super.setStroke(value);
                ROI3DStack.this.modifyingSlice.acquireUninterruptibly();
                try {
                    TreeMap treeMap = ROI3DStack.this.slices;
                    synchronized (treeMap) {
                        for (ROI2D slice : ROI3DStack.this.slices.values()) {
                            slice.getOverlay().setStroke(value);
                        }
                    }
                }
                finally {
                    ROI3DStack.this.modifyingSlice.release();
                }
            }
            finally {
                this.endUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setShowName(boolean value) {
            this.beginUpdate();
            try {
                super.setShowName(value);
                ROI3DStack.this.modifyingSlice.acquireUninterruptibly();
                try {
                    TreeMap treeMap = ROI3DStack.this.slices;
                    synchronized (treeMap) {
                        for (ROI2D slice : ROI3DStack.this.slices.values()) {
                            slice.getOverlay().setShowName(value);
                        }
                    }
                }
                finally {
                    ROI3DStack.this.modifyingSlice.release();
                }
            }
            finally {
                this.endUpdate();
            }
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.paint(g, sequence, canvas);
                }
            } else {
                super.paint(g, sequence, canvas);
            }
        }

        @Override
        public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.keyPressed(e, imagePoint, canvas);
                }
            } else {
                super.keyPressed(e, imagePoint, canvas);
            }
        }

        @Override
        public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.keyReleased(e, imagePoint, canvas);
                }
            } else {
                super.keyReleased(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.mouseEntered(e, imagePoint, canvas);
                }
            } else {
                super.mouseEntered(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseExited(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.mouseExited(e, imagePoint, canvas);
                }
            } else {
                super.mouseExited(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.mouseMove(e, imagePoint, canvas);
                }
            } else {
                super.mouseMove(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.mouseDrag(e, imagePoint, canvas);
                }
            } else {
                super.mouseDrag(e, imagePoint, canvas);
            }
        }

        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.mousePressed(e, imagePoint, canvas);
                }
            } else {
                super.mousePressed(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.mouseReleased(e, imagePoint, canvas);
                }
            } else {
                super.mouseReleased(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.mouseClick(e, imagePoint, canvas);
                }
            } else {
                super.mouseClick(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas)) {
                ROI.ROIPainter sliceOverlay = this.getSliceOverlayForCanvas(canvas);
                if (sliceOverlay != null) {
                    sliceOverlay.mouseWheelMoved(e, imagePoint, canvas);
                }
            } else {
                super.mouseWheelMoved(e, imagePoint, canvas);
            }
        }

        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            ROI.ROIPainter sliceOverlay;
            if (canvas.getPositionZ() >= 0 && ROI3DStack.this.isActiveFor(canvas) && (sliceOverlay = this.getSliceOverlayForCanvas(canvas)) instanceof ROI2D.ROI2DPainter) {
                ((ROI2D.ROI2DPainter)sliceOverlay).drawROI(g, sequence, canvas);
            }
        }
    }
}

